package com.taobao.weex.bridge;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import androidx.collection.ArrayMap;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.Script;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXConfigAdapter;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.adapter.IWXJsFileLoaderAdapter;
import com.taobao.weex.adapter.IWXJscProcessManager;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.bridge.WXValidateProcessor;
import com.taobao.weex.common.Constants;
import com.taobao.weex.common.IWXBridge;
import com.taobao.weex.common.IWXDebugConfig;
import com.taobao.weex.common.WXConfig;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXJSExceptionInfo;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.performance.WXInstanceApm;
import com.taobao.weex.performance.WXStateRecord;
import com.taobao.weex.ui.WXComponentRegistry;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.ui.action.ActionReloadPage;
import com.taobao.weex.ui.action.GraphicActionAddChildToRichtext;
import com.taobao.weex.ui.action.GraphicActionAddElement;
import com.taobao.weex.ui.action.GraphicActionAddEvent;
import com.taobao.weex.ui.action.GraphicActionAppendTreeCreateFinish;
import com.taobao.weex.ui.action.GraphicActionBatchBegin;
import com.taobao.weex.ui.action.GraphicActionBatchEnd;
import com.taobao.weex.ui.action.GraphicActionCreateBody;
import com.taobao.weex.ui.action.GraphicActionCreateFinish;
import com.taobao.weex.ui.action.GraphicActionLayout;
import com.taobao.weex.ui.action.GraphicActionMoveElement;
import com.taobao.weex.ui.action.GraphicActionRefreshFinish;
import com.taobao.weex.ui.action.GraphicActionRemoveChildFromRichtext;
import com.taobao.weex.ui.action.GraphicActionRemoveElement;
import com.taobao.weex.ui.action.GraphicActionRemoveEvent;
import com.taobao.weex.ui.action.GraphicActionRenderSuccess;
import com.taobao.weex.ui.action.GraphicActionUpdateAttr;
import com.taobao.weex.ui.action.GraphicActionUpdateRichtextAttr;
import com.taobao.weex.ui.action.GraphicActionUpdateRichtextStyle;
import com.taobao.weex.ui.action.GraphicActionUpdateStyle;
import com.taobao.weex.ui.action.GraphicPosition;
import com.taobao.weex.ui.action.GraphicSize;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.module.WXDomModule;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import com.taobao.weex.utils.WXWsonJSONSwitch;
import com.taobao.weex.utils.batch.BactchExecutor;
import com.taobao.weex.utils.batch.Interceptor;
import com.taobao.weex.utils.tools.LogDetail;
import io.dcloud.common.adapter.ui.webview.WebLoadEvent;
import io.dcloud.common.adapter.util.UEH;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.ExifInterface;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.RuningAcitvityUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.weex.WXDotDataUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class WXBridgeManager implements Handler.Callback, BactchExecutor {
    public static final String ARGS = "args";
    private static final boolean BRIDGE_LOG_SWITCH = false;
    private static final String BUNDLE_TYPE = "bundleType";
    public static final String COMPONENT = "component";
    private static final int CRASHREINIT = 50;
    private static String GLOBAL_CONFIG_KEY = "global_switch_config";
    public static final String INITLOGFILE = "/jsserver_start.log";
    private static final int INIT_FRAMEWORK_OK = 1;
    public static final String KEY_ARGS = "args";
    public static final String KEY_METHOD = "method";
    public static final String KEY_PARAMS = "params";
    private static long LOW_MEM_VALUE = 120;
    public static final String METHD_COMPONENT_HOOK_SYNC = "componentHook";
    public static final String METHD_FIRE_EVENT_SYNC = "fireEventSync";
    public static final String METHOD = "method";
    public static final String METHOD_CALLBACK = "callback";
    public static final String METHOD_CALL_JS = "callJS";
    public static final String METHOD_CHECK_APPKEY = "dc_checkappkey";
    public static final String METHOD_CREATE_INSTANCE = "createInstance";
    public static final String METHOD_CREATE_INSTANCE_CONTEXT = "createInstanceContext";
    public static final String METHOD_CREATE_PAGE_WITH_CONTENT = "CreatePageWithContent";
    public static final String METHOD_DESTROY_INSTANCE = "destroyInstance";
    public static final String METHOD_FIRE_EVENT = "fireEvent";
    public static final String METHOD_FIRE_EVENT_ON_DATA_RENDER_NODE = "fireEventOnDataRenderNode";
    private static final String METHOD_JSFM_NOT_INIT_IN_EAGLE_MODE = "JsfmNotInitInEagleMode";
    public static final String METHOD_NOTIFY_SERIALIZE_CODE_CACHE = "notifySerializeCodeCache";
    public static final String METHOD_NOTIFY_TRIM_MEMORY = "notifyTrimMemory";
    private static final String METHOD_POST_TASK_TO_MSG_LOOP = "PostTaskToMsgLoop";
    public static final String METHOD_REFRESH_INSTANCE = "refreshInstance";
    public static final String METHOD_REGISTER_COMPONENTS = "registerComponents";
    public static final String METHOD_REGISTER_MODULES = "registerModules";
    public static final String METHOD_SET_TIMEOUT = "setTimeoutCallback";
    public static final String METHOD_UPDATE_COMPONENT_WITH_DATA = "UpdateComponentData";
    public static final String MODULE = "module";
    private static final String NON_CALLBACK = "-1";
    public static final String OPTIONS = "options";
    public static final String REF = "ref";
    private static final String RENDER_STRATEGY = "renderStrategy";
    private static final String UNDEFINED = "undefined";
    private static Class clazz_debugProxy = null;
    private static String crashUrl = null;
    private static String globalConfig = "none";
    private static volatile boolean isJsEngineMultiThreadEnable = false;
    private static volatile boolean isSandBoxContext = true;
    private static boolean isUseSingleProcess = false;
    private static long lastCrashTime = 0;
    static volatile WXBridgeManager mBridgeManager = null;
    private static volatile boolean mInit = false;
    private static String mRaxApi = null;
    private static Map<String, String> mWeexCoreEnvOptions = new HashMap();
    public static volatile int reInitCount = 1;
    public static StringBuilder sInitFrameWorkMsg = new StringBuilder();
    public static long sInitFrameWorkTimeOrigin;
    private HashSet<String> mDestroyedInstanceId = new HashSet<>();
    private WXParams mInitParams;
    private Interceptor mInterceptor;
    Handler mJSHandler;
    private WXThread mJSThread;
    private StringBuilder mLodBuilder = new StringBuilder(50);
    private boolean mMock = false;
    private WXHashMap<String, ArrayList<WXHashMap<String, Object>>> mNextTickTasks = new WXHashMap<>();
    private List<Map<String, Object>> mRegisterComponentFailList = new ArrayList(8);
    private List<Map<String, Object>> mRegisterModuleFailList = new ArrayList(8);
    private List<String> mRegisterServiceFailList = new ArrayList(8);
    private IWXBridge mWXBridge;
    private Object mWxDebugProxy;

    public enum BundType {
        Vue,
        Rax,
        Others
    }

    public static class TimerInfo {
        public String callbackId;
        public String instanceId;
        public long time;
    }

    private void mock(String str) {
    }

    @Deprecated
    public void notifyTrimMemory() {
    }

    private WXBridgeManager() {
        initWXBridge(WXEnvironment.sRemoteDebugMode);
        WXThread wXThread = new WXThread("WeexJSBridgeThread", this);
        this.mJSThread = wXThread;
        this.mJSHandler = wXThread.getHandler();
    }

    public static WXBridgeManager getInstance() {
        if (mBridgeManager == null) {
            synchronized (WXBridgeManager.class) {
                if (mBridgeManager == null) {
                    mBridgeManager = new WXBridgeManager();
                }
            }
        }
        return mBridgeManager;
    }

    public void setUseSingleProcess(boolean z) {
        if (z != isUseSingleProcess) {
            isUseSingleProcess = z;
        }
    }

    public void onInteractionTimeUpdate(final String str) {
        post(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass1 */

            public void run() {
                if (WXBridgeManager.this.mWXBridge instanceof WXBridge) {
                    ((WXBridge) WXBridgeManager.this.mWXBridge).nativeOnInteractionTimeUpdate(str);
                }
            }
        });
    }

    public boolean jsEngineMultiThreadEnable() {
        return isJsEngineMultiThreadEnable;
    }

    public void checkJsEngineMultiThread() {
        IWXJscProcessManager wXJscProcessManager = WXSDKManager.getInstance().getWXJscProcessManager();
        boolean enableBackupThread = wXJscProcessManager != null ? wXJscProcessManager.enableBackupThread() : false;
        if (enableBackupThread != isJsEngineMultiThreadEnable) {
            isJsEngineMultiThreadEnable = enableBackupThread;
            if (!isJSFrameworkInit()) {
                return;
            }
            if (isJSThread()) {
                WXSDKEngine.reload();
            } else {
                post(new Runnable() {
                    /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass2 */

                    public void run() {
                        WXSDKEngine.reload();
                    }
                });
            }
        }
    }

    public void setSandBoxContext(boolean z) {
        String str;
        if (z != isSandBoxContext) {
            isSandBoxContext = z;
            if (isJSThread()) {
                setJSFrameworkInit(false);
                WXModuleManager.resetAllModuleState();
                if (!isSandBoxContext) {
                    str = WXFileUtils.loadAsset("main.js", WXEnvironment.getApplication());
                } else {
                    str = WXFileUtils.loadAsset("weex-main-jsfm.js", WXEnvironment.getApplication());
                }
                initFramework(str);
                WXServiceManager.reload();
                WXModuleManager.reload();
                WXComponentRegistry.reload();
                return;
            }
            post(new Runnable() {
                /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass3 */

                public void run() {
                    String str;
                    WXBridgeManager.this.setJSFrameworkInit(false);
                    WXModuleManager.resetAllModuleState();
                    if (!WXBridgeManager.isSandBoxContext) {
                        str = WXFileUtils.loadAsset("main.js", WXEnvironment.getApplication());
                    } else {
                        str = WXFileUtils.loadAsset("weex-main-jsfm.js", WXEnvironment.getApplication());
                    }
                    WXBridgeManager.this.initFramework(str);
                    WXServiceManager.reload();
                    WXModuleManager.reload();
                    WXComponentRegistry.reload();
                }
            });
        }
    }

    public boolean isJSFrameworkInit() {
        return mInit;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void setJSFrameworkInit(boolean z) {
        mInit = z;
        if (z) {
            onJsFrameWorkInitSuccees();
        }
    }

    private void initWXBridge(boolean z) {
        Method method;
        boolean z2;
        Constructor constructor;
        Method method2;
        if (z && WXEnvironment.isApkDebugable()) {
            WXEnvironment.sDebugServerConnectable = true;
        }
        if (WXEnvironment.sDebugServerConnectable) {
            WXEnvironment.isApkDebugable();
            if (WXEnvironment.getApplication() != null) {
                try {
                    if (clazz_debugProxy == null) {
                        clazz_debugProxy = Class.forName("com.taobao.weex.devtools.debug.DebugServerProxy");
                    }
                    Class cls = clazz_debugProxy;
                    if (cls != null) {
                        if (this.mWxDebugProxy != null) {
                            Method method3 = cls.getMethod("isActive", new Class[0]);
                            if (method3 != null ? ((Boolean) method3.invoke(this.mWxDebugProxy, new Object[0])).booleanValue() : false) {
                                z2 = false;
                                if (z2 && (constructor = clazz_debugProxy.getConstructor(Context.class, IWXDebugConfig.class)) != null) {
                                    Object newInstance = constructor.newInstance(WXEnvironment.getApplication(), new IWXDebugConfig() {
                                        /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass4 */

                                        @Override // com.taobao.weex.common.IWXDebugConfig
                                        public WXBridgeManager getWXJSManager() {
                                            return WXBridgeManager.this;
                                        }

                                        @Override // com.taobao.weex.common.IWXDebugConfig
                                        public WXDebugJsBridge getWXDebugJsBridge() {
                                            return new WXDebugJsBridge();
                                        }
                                    });
                                    this.mWxDebugProxy = newInstance;
                                    if (!(newInstance == null || (method2 = clazz_debugProxy.getMethod("start", new Class[0])) == null)) {
                                        method2.invoke(this.mWxDebugProxy, new Object[0]);
                                    }
                                }
                            }
                        }
                        z2 = true;
                        Object newInstance2 = constructor.newInstance(WXEnvironment.getApplication(), new IWXDebugConfig() {
                            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass4 */

                            @Override // com.taobao.weex.common.IWXDebugConfig
                            public WXBridgeManager getWXJSManager() {
                                return WXBridgeManager.this;
                            }

                            @Override // com.taobao.weex.common.IWXDebugConfig
                            public WXDebugJsBridge getWXDebugJsBridge() {
                                return new WXDebugJsBridge();
                            }
                        });
                        this.mWxDebugProxy = newInstance2;
                        method2.invoke(this.mWxDebugProxy, new Object[0]);
                    }
                } catch (Throwable unused) {
                }
                WXServiceManager.execAllCacheJsService();
            } else {
                WXLogUtils.e("WXBridgeManager", "WXEnvironment.sApplication is null, skip init Inspector");
            }
        }
        if (!z || this.mWxDebugProxy == null) {
            this.mWXBridge = new WXBridge();
            return;
        }
        try {
            if (clazz_debugProxy == null) {
                clazz_debugProxy = Class.forName("com.taobao.weex.devtools.debug.DebugServerProxy");
            }
            Class cls2 = clazz_debugProxy;
            if (cls2 != null && (method = cls2.getMethod("getWXBridge", new Class[0])) != null) {
                this.mWXBridge = (IWXBridge) method.invoke(this.mWxDebugProxy, new Object[0]);
            }
        } catch (Throwable unused2) {
        }
    }

    public String dumpIpcPageInfo() {
        IWXBridge iWXBridge = this.mWXBridge;
        return iWXBridge instanceof WXBridge ? ((WXBridge) iWXBridge).nativeDumpIpcPageQueueInfo() : "";
    }

    public void stopRemoteDebug() {
        Method method;
        if (this.mWxDebugProxy != null) {
            try {
                if (clazz_debugProxy == null) {
                    clazz_debugProxy = Class.forName("com.taobao.weex.devtools.debug.DebugServerProxy");
                }
                Class cls = clazz_debugProxy;
                if (cls != null && (method = cls.getMethod(Constants.Value.STOP, Boolean.TYPE)) != null) {
                    method.invoke(this.mWxDebugProxy, false);
                    this.mWxDebugProxy = null;
                }
            } catch (Throwable unused) {
            }
        }
    }

    public Object callModuleMethod(String str, String str2, String str3, JSONArray jSONArray) {
        return callModuleMethod(str, str2, str3, jSONArray, null);
    }

    public Object callModuleMethod(String str, String str2, String str3, JSONArray jSONArray, JSONObject jSONObject) {
        WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
        if (sDKInstance == null) {
            return null;
        }
        if (!sDKInstance.isNeedValidate() || WXSDKManager.getInstance().getValidateProcessor() == null) {
            try {
                return WXModuleManager.callModuleMethod(str, str2, str3, jSONArray);
            } catch (NumberFormatException unused) {
                ArrayMap arrayMap = new ArrayMap();
                arrayMap.put("moduleName", str2);
                arrayMap.put("methodName", str3);
                arrayMap.put("args", jSONArray.toJSONString());
                WXLogUtils.e("[WXBridgeManager] callNative : numberFormatException when parsing string to numbers in args", arrayMap.toString());
                return null;
            }
        } else {
            WXValidateProcessor.WXModuleValidateResult onModuleValidate = WXSDKManager.getInstance().getValidateProcessor().onModuleValidate(sDKInstance, str2, str3, jSONArray, jSONObject);
            if (onModuleValidate == null) {
                return null;
            }
            if (onModuleValidate.isSuccess) {
                return WXModuleManager.callModuleMethod(str, str2, str3, jSONArray);
            }
            JSONObject jSONObject2 = onModuleValidate.validateInfo;
            if (jSONObject2 != null) {
                WXLogUtils.e("[WXBridgeManager] module validate fail. >>> " + jSONObject2.toJSONString());
            }
            return jSONObject2;
        }
    }

    public void restart() {
        setJSFrameworkInit(false);
        WXModuleManager.resetAllModuleState();
        initWXBridge(WXEnvironment.sRemoteDebugMode);
        this.mWXBridge.resetWXBridge(WXEnvironment.sRemoteDebugMode);
    }

    public synchronized void setStackTopInstance(final String str) {
        post(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass5 */

            public void run() {
                WXBridgeManager.this.mNextTickTasks.setStackTopInstance(str);
            }
        }, str, null, null);
    }

    @Override // com.taobao.weex.utils.batch.BactchExecutor
    public void post(Runnable runnable) {
        postWithName(runnable, null, null);
    }

    public void postWithName(Runnable runnable, WXSDKInstance wXSDKInstance, String str) {
        Handler handler;
        Runnable secure = WXThread.secure(runnable, wXSDKInstance, str);
        Interceptor interceptor = this.mInterceptor;
        if ((interceptor == null || !interceptor.take(secure)) && (handler = this.mJSHandler) != null) {
            handler.post(secure);
        }
    }

    @Override // com.taobao.weex.utils.batch.BactchExecutor
    public void setInterceptor(Interceptor interceptor) {
        this.mInterceptor = interceptor;
    }

    public void post(Runnable runnable, Object obj, WXSDKInstance wXSDKInstance, String str) {
        Handler handler = this.mJSHandler;
        if (handler != null) {
            Message obtain = Message.obtain(handler, WXThread.secure(runnable, wXSDKInstance, str));
            obtain.obj = obj;
            obtain.sendToTarget();
        }
    }

    public void post(Runnable runnable, Object obj) {
        post(runnable, obj, null, null);
    }

    public void postDelay(Runnable runnable, long j) {
        Handler handler = this.mJSHandler;
        if (handler != null) {
            handler.postDelayed(WXThread.secure(runnable), j);
        }
    }

    public void setLogLevel(final int i, final boolean z) {
        post(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass6 */

            public void run() {
                if (WXBridgeManager.this.mWXBridge != null) {
                    WXBridgeManager.this.mWXBridge.setLogType((float) i, z);
                }
            }
        });
    }

    /* access modifiers changed from: package-private */
    public void setTimeout(String str, String str2) {
        Message obtain = Message.obtain();
        obtain.what = 1;
        TimerInfo timerInfo = new TimerInfo();
        timerInfo.callbackId = str;
        timerInfo.time = (long) Float.parseFloat(str2);
        obtain.obj = timerInfo;
        this.mJSHandler.sendMessageDelayed(obtain, timerInfo.time);
    }

    public void sendMessageDelayed(Message message, long j) {
        WXThread wXThread;
        if (message != null && this.mJSHandler != null && (wXThread = this.mJSThread) != null && wXThread.isWXThreadAlive() && this.mJSThread.getLooper() != null) {
            this.mJSHandler.sendMessageDelayed(message, j);
        }
    }

    public void removeMessage(int i, Object obj) {
        WXThread wXThread;
        if (this.mJSHandler != null && (wXThread = this.mJSThread) != null && wXThread.isWXThreadAlive() && this.mJSThread.getLooper() != null) {
            this.mJSHandler.removeMessages(i, obj);
        }
    }

    public Object callNativeModule(String str, String str2, String str3, JSONArray jSONArray, Object obj) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2) || TextUtils.isEmpty(str3)) {
            WXLogUtils.d("[WXBridgeManager] call callNativeModule arguments is null");
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callNativeModule", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        try {
            if (WXDomModule.WXDOM.equals(str2)) {
                return WXModuleManager.getDomModule(str).callDomMethod(str3, jSONArray, new long[0]);
            }
            return callModuleMethod(str, str2, str3, jSONArray);
        } catch (Exception e) {
            String str4 = "[WXBridgeManager] callNative exception: " + WXLogUtils.getStackTrace(e);
            WXLogUtils.e(str4);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callNativeModule", str4, null);
            return null;
        }
    }

    public Object callNativeModule(String str, String str2, String str3, JSONArray jSONArray, JSONObject jSONObject) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2) || TextUtils.isEmpty(str3)) {
            WXLogUtils.d("[WXBridgeManager] call callNativeModule arguments is null");
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callNativeModule", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXStateRecord instance = WXStateRecord.getInstance();
        instance.recordAction(str, "callNativeModule:" + str2 + Operators.DOT_STR + str3);
        WXEnvironment.isApkDebugable();
        try {
            if (!WXDomModule.WXDOM.equals(str2)) {
                return callModuleMethod(str, str2, str3, jSONArray, jSONObject);
            }
            WXDomModule domModule = WXModuleManager.getDomModule(str);
            if (domModule != null) {
                return domModule.callDomMethod(str3, jSONArray, new long[0]);
            }
            WXModuleManager.createDomModule(WXSDKManager.getInstance().getSDKInstance(str));
            return null;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callNativeModule exception: " + WXLogUtils.getStackTrace(e));
        }
    }

    public Object callNativeComponent(String str, String str2, String str3, JSONArray jSONArray, Object obj) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2) || TextUtils.isEmpty(str3)) {
            WXLogUtils.d("[WXBridgeManager] call callNativeComponent arguments is null");
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callNativeComponent", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        try {
            WXDomModule domModule = WXModuleManager.getDomModule(str);
            if (domModule != null) {
                domModule.invokeMethod(str2, str3, jSONArray);
            } else {
                WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
                if (sDKInstance == null || !sDKInstance.isDestroy()) {
                    WXLogUtils.e("WXBridgeManager", "callNativeComponent exception :null == dom ,method:" + str3);
                }
            }
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callNativeComponent exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callNativeComponent", WXLogUtils.getStackTrace(e), null);
        }
        return null;
    }

    public int callNative(String str, JSONArray jSONArray, String str2) {
        int i;
        int i2;
        if (TextUtils.isEmpty(str) || jSONArray == null) {
            WXLogUtils.d("[WXBridgeManager] call callNative arguments is null");
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callNative", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        long nanoTime = System.nanoTime() - System.nanoTime();
        if (jSONArray != null && jSONArray.size() > 0) {
            int size = jSONArray.size();
            int i3 = 0;
            while (i3 < size) {
                try {
                    JSONObject jSONObject = (JSONObject) jSONArray.get(i3);
                    if (!(jSONObject == null || WXSDKManager.getInstance().getSDKInstance(str) == null)) {
                        Object obj = jSONObject.get("module");
                        if (obj == null) {
                            i2 = i3;
                            i = size;
                            if (jSONObject.get(COMPONENT) != null) {
                                WXModuleManager.getDomModule(str).invokeMethod((String) jSONObject.get("ref"), (String) jSONObject.get("method"), (JSONArray) jSONObject.get("args"));
                            } else {
                                throw new IllegalArgumentException("unknown callNative");
                            }
                        } else if (WXDomModule.WXDOM.equals(obj)) {
                            WXModuleManager.getDomModule(str).callDomMethod(jSONObject, nanoTime);
                        } else {
                            i2 = i3;
                            i = size;
                            callModuleMethod(str, (String) obj, (String) jSONObject.get("method"), (JSONArray) jSONObject.get("args"), jSONObject.getJSONObject("options"));
                        }
                        i3 = i2 + 1;
                        size = i;
                    }
                    i2 = i3;
                    i = size;
                    i3 = i2 + 1;
                    size = i;
                } catch (Exception e) {
                    WXLogUtils.e("[WXBridgeManager] callNative exception: ", e);
                    WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callNative", WXLogUtils.getStackTrace(e), null);
                }
            }
        }
        if ("undefined".equals(str2) || NON_CALLBACK.equals(str2)) {
            return 0;
        }
        getNextTick(str, str2);
        return 1;
    }

    public int callUpdateFinish(String str, String str2) {
        if (TextUtils.isEmpty(str)) {
            WXLogUtils.d("[WXBridgeManager] call callUpdateFinish arguments is null");
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callUpdateFinish", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKManager.getInstance().getSDKInstance(str);
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callUpdateFinish exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callUpdateFinish", WXLogUtils.getStackTrace(e), null);
        }
        if (str2 == null || str2.isEmpty() || "undefined".equals(str2) || NON_CALLBACK.equals(str2)) {
            return 0;
        }
        getNextTick(str, str2);
        return 1;
    }

    public int callRefreshFinish(String str, String str2) {
        if (TextUtils.isEmpty(str)) {
            WXLogUtils.d("[WXBridgeManager] call callRefreshFinish arguments is null");
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callRefreshFinish", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance != null) {
                WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(str, new GraphicActionRefreshFinish(sDKInstance));
            }
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRefreshFinish exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callRefreshFinish", WXLogUtils.getStackTrace(e), null);
        }
        if ("undefined".equals(str2) || NON_CALLBACK.equals(str2)) {
            return 0;
        }
        getNextTick(str, str2);
        return 1;
    }

    public int callReportCrashReloadPage(String str, String str2) {
        String str3;
        boolean isEmpty = TextUtils.isEmpty(str2);
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance != null) {
                String bundleUrl = sDKInstance.getBundleUrl();
                sDKInstance.setHasException(true);
                str3 = bundleUrl;
            } else {
                str3 = null;
            }
            HashMap hashMap = new HashMap(2);
            hashMap.put("weexCoreThreadStackTrace:", getInstance().getWeexCoreThreadStackTrace());
            hashMap.put("wxStateInfo", WXStateRecord.getInstance().getStateInfo().toString());
            String str4 = "null";
            if (!isEmpty) {
                try {
                    if (WXEnvironment.getApplication() != null) {
                        str2 = this.mInitParams.getCrashFilePath() + str2;
                        Log.d("jsengine", "callReportCrashReloadPage crashFile:" + str2);
                    }
                } catch (Throwable th) {
                    WXLogUtils.e(WXLogUtils.getStackTrace(th));
                }
                WXStateRecord instance = WXStateRecord.getInstance();
                if (!TextUtils.isEmpty(str)) {
                    str4 = str;
                }
                instance.onJSCCrash(str4);
                callReportCrash(str2, str, str3, hashMap);
            } else {
                WXStateRecord instance2 = WXStateRecord.getInstance();
                if (!TextUtils.isEmpty(str)) {
                    str4 = str;
                }
                instance2.onJSEngineReload(str4);
                commitJscCrashAlarmMonitor(IWXUserTrackAdapter.JS_BRIDGE, WXErrorCode.WX_ERR_RELOAD_PAGE, "reboot jsc Engine", str, str3, hashMap);
            }
            if (reInitCount > 50) {
                WXExceptionUtils.commitCriticalExceptionRT("jsEngine", WXErrorCode.WX_ERR_RELOAD_PAGE_EXCEED_LIMIT, "callReportCrashReloadPage", "reInitCount:" + reInitCount, hashMap);
                return 0;
            }
            reInitCount++;
            setJSFrameworkInit(false);
            WXModuleManager.resetAllModuleState();
            initScriptsFramework("");
            HashSet<String> hashSet = this.mDestroyedInstanceId;
            if (hashSet != null && hashSet.contains(str)) {
                return -1;
            }
            try {
                if (WXSDKManager.getInstance().getSDKInstance(str) != null) {
                    new ActionReloadPage(str, shouldReloadCurrentInstance(WXSDKManager.getInstance().getSDKInstance(str).getBundleUrl())).executeAction();
                }
            } catch (Exception e) {
                WXLogUtils.e("[WXBridgeManager] callReloadPage exception: ", e);
                WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callReportCrashReloadPage", WXLogUtils.getStackTrace(e), null);
            }
            return 0;
        } catch (Exception e2) {
            WXLogUtils.e("[WXBridgeManager] callReportCrashReloadPage exception: ", e2);
        }
    }

    public boolean shouldReloadCurrentInstance(String str) {
        Uri parse;
        long currentTimeMillis = System.currentTimeMillis();
        IWXConfigAdapter wxConfigAdapter = WXSDKManager.getInstance().getWxConfigAdapter();
        if (wxConfigAdapter != null) {
            boolean parseBoolean = Boolean.parseBoolean(wxConfigAdapter.getConfig("android_weex_ext_config", "check_biz_url", AbsoluteConst.TRUE));
            WXLogUtils.e("check_biz_url : " + parseBoolean);
            if (parseBoolean && !TextUtils.isEmpty(str) && (parse = Uri.parse(str)) != null) {
                str = parse.buildUpon().clearQuery().build().toString();
            }
        }
        String str2 = crashUrl;
        if (str2 == null || ((str2 != null && !str2.equals(str)) || currentTimeMillis - lastCrashTime > 15000)) {
            crashUrl = str;
            lastCrashTime = currentTimeMillis;
            return true;
        }
        lastCrashTime = currentTimeMillis;
        return false;
    }

    public void callReportCrash(String str, final String str2, final String str3, final Map<String, String> map) {
        final String str4 = str + Operators.DOT_STR + new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format(new Date());
        File file = new File(str);
        File file2 = new File(str4);
        if (file.exists()) {
            file.renameTo(file2);
        }
        new Thread(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass7 */

            public void run() {
                try {
                    File file = new File(str4);
                    if (file.exists()) {
                        if (file.length() > 0) {
                            StringBuilder sb = new StringBuilder();
                            try {
                                BufferedReader bufferedReader = new BufferedReader(new FileReader(str4));
                                while (true) {
                                    String readLine = bufferedReader.readLine();
                                    if (readLine == null) {
                                        break;
                                    } else if (!"".equals(readLine)) {
                                        sb.append(readLine + "\n");
                                    }
                                }
                                WXBridgeManager.this.commitJscCrashAlarmMonitor(IWXUserTrackAdapter.JS_BRIDGE, WXErrorCode.WX_ERR_JSC_CRASH, sb.toString(), str2, str3, map);
                                bufferedReader.close();
                            } catch (Exception e) {
                                WXLogUtils.e(WXLogUtils.getStackTrace(e));
                            }
                        } else {
                            WXLogUtils.e("[WXBridgeManager] callReportCrash crash file is empty");
                        }
                        if (!WXEnvironment.isApkDebugable()) {
                            file.delete();
                        }
                    }
                } catch (Throwable th) {
                    WXLogUtils.e("[WXBridgeManager] callReportCrash exception: ", th);
                }
            }
        }).start();
    }

    private void getNextTick(String str, String str2) {
        addJSTask(METHOD_CALLBACK, str, str2, "{}");
        sendMessage(str, 6);
    }

    private void getNextTick(String str) {
        addJSTask(METHOD_CALLBACK, str, "", "{}");
        sendMessage(str, 6);
    }

    public String syncExecJsOnInstanceWithResult(String str, String str2, int i) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        AnonymousClass8 r2 = new EventResult() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass8 */

            @Override // com.taobao.weex.bridge.EventResult
            public void onCallback(Object obj) {
                super.onCallback(obj);
                countDownLatch.countDown();
            }
        };
        try {
            execJSOnInstance(r2, str, str2, i);
            countDownLatch.await(100, TimeUnit.MILLISECONDS);
            if (r2.getResult() != null) {
                return r2.getResult().toString();
            }
            return "";
        } catch (Throwable th) {
            WXLogUtils.e("syncCallExecJsOnInstance", th);
            return "";
        }
    }

    public void loadJsBundleInPreInitMode(final String str, final String str2) {
        post(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass9 */

            public void run() {
                WXBridgeManager.this.invokeExecJSOnInstance(str, str2, -1);
                WXSDKInstance wXSDKInstance = WXSDKManager.getInstance().getAllInstanceMap().get(str);
                if (wXSDKInstance != null && wXSDKInstance.isPreInitMode()) {
                    wXSDKInstance.getApmForInstance().onStage(WXInstanceApm.KEY_PAGE_STAGES_LOAD_BUNDLE_END);
                    wXSDKInstance.getApmForInstance().onStageWithTime(WXInstanceApm.KEY_PAGE_STAGES_END_EXCUTE_BUNDLE, WXUtils.getFixUnixTime() + 600);
                }
            }
        });
    }

    public EventResult syncCallJSEventWithResult(String str, String str2, List<Object> list, Object... objArr) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        AnonymousClass10 r1 = new EventResult() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass10 */

            @Override // com.taobao.weex.bridge.EventResult
            public void onCallback(Object obj) {
                super.onCallback(obj);
                countDownLatch.countDown();
            }
        };
        try {
            asyncCallJSEventWithResult(r1, str, str2, list, objArr);
            countDownLatch.await(100, TimeUnit.MILLISECONDS);
            return r1;
        } catch (Exception e) {
            WXLogUtils.e("syncCallJSEventWithResult", e);
            return r1;
        }
    }

    public void asyncCallJSEventVoidResult(final String str, final String str2, final List<Object> list, final Object... objArr) {
        post(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass11 */

            public void run() {
                try {
                    Object[] objArr = objArr;
                    if (objArr == null) {
                        return;
                    }
                    if (objArr.length != 0) {
                        ArrayList arrayList = new ArrayList();
                        for (Object obj : objArr) {
                            arrayList.add(obj);
                        }
                        if (list != null) {
                            ArrayMap arrayMap = new ArrayMap(4);
                            arrayMap.put("params", list);
                            arrayList.add(arrayMap);
                        }
                        WXHashMap wXHashMap = new WXHashMap();
                        wXHashMap.put("method", str);
                        wXHashMap.put("args", arrayList);
                        WXJSObject[] wXJSObjectArr = {new WXJSObject(2, str2), WXWsonJSONSwitch.toWsonOrJsonWXJSObject(new Object[]{wXHashMap})};
                        WXBridgeManager.this.invokeExecJS(String.valueOf(str2), null, WXBridgeManager.METHOD_CALL_JS, wXJSObjectArr, true);
                        wXJSObjectArr[0] = null;
                    }
                } catch (Exception e) {
                    WXLogUtils.e("asyncCallJSEventVoidResult", e);
                }
            }
        });
    }

    private void asyncCallJSEventWithResult(final EventResult eventResult, final String str, final String str2, final List<Object> list, final Object... objArr) {
        post(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass12 */

            public void run() {
                try {
                    Object[] objArr = objArr;
                    if (objArr == null) {
                        return;
                    }
                    if (objArr.length != 0) {
                        ArrayList arrayList = new ArrayList();
                        for (Object obj : objArr) {
                            arrayList.add(obj);
                        }
                        if (list != null) {
                            ArrayMap arrayMap = new ArrayMap(4);
                            arrayMap.put("params", list);
                            arrayList.add(arrayMap);
                        }
                        WXHashMap wXHashMap = new WXHashMap();
                        wXHashMap.put("method", str);
                        wXHashMap.put("args", arrayList);
                        WXJSObject[] wXJSObjectArr = {new WXJSObject(2, str2), WXWsonJSONSwitch.toWsonOrJsonWXJSObject(new Object[]{wXHashMap})};
                        WXBridgeManager.this.invokeExecJSWithCallback(String.valueOf(str2), null, WXBridgeManager.METHOD_CALL_JS, wXJSObjectArr, eventResult != null ? new ResultCallback<byte[]>() {
                            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass12.AnonymousClass1 */

                            public void onReceiveResult(byte[] bArr) {
                                JSONArray jSONArray = (JSONArray) WXWsonJSONSwitch.parseWsonOrJSON(bArr);
                                if (jSONArray != null && jSONArray.size() > 0) {
                                    eventResult.onCallback(jSONArray.get(0));
                                }
                            }
                        } : null, true);
                        wXJSObjectArr[0] = null;
                    }
                } catch (Exception e) {
                    WXLogUtils.e("asyncCallJSEventWithResult", e);
                }
            }
        });
    }

    private void addJSEventTask(final String str, final String str2, final List<Object> list, final Object... objArr) {
        post(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass13 */

            public void run() {
                Object[] objArr = objArr;
                if (!(objArr == null || objArr.length == 0)) {
                    ArrayList arrayList = new ArrayList();
                    for (Object obj : objArr) {
                        arrayList.add(obj);
                    }
                    if (list != null) {
                        ArrayMap arrayMap = new ArrayMap(4);
                        arrayMap.put("params", list);
                        arrayList.add(arrayMap);
                    }
                    WXHashMap wXHashMap = new WXHashMap();
                    wXHashMap.put("method", str);
                    wXHashMap.put("args", arrayList);
                    if (WXBridgeManager.this.mNextTickTasks.get(str2) == null) {
                        ArrayList arrayList2 = new ArrayList();
                        arrayList2.add(wXHashMap);
                        WXBridgeManager.this.mNextTickTasks.put(str2, arrayList2);
                        return;
                    }
                    ((ArrayList) WXBridgeManager.this.mNextTickTasks.get(str2)).add(wXHashMap);
                }
            }
        });
    }

    private void addJSTask(String str, String str2, Object... objArr) {
        addJSEventTask(str, str2, null, objArr);
    }

    private void sendMessage(String str, int i) {
        Message obtain = Message.obtain(this.mJSHandler);
        obtain.obj = str;
        obtain.what = i;
        obtain.sendToTarget();
    }

    public synchronized void initScriptsFramework(String str) {
        Message obtainMessage = this.mJSHandler.obtainMessage();
        obtainMessage.obj = str;
        obtainMessage.what = 7;
        obtainMessage.setTarget(this.mJSHandler);
        obtainMessage.sendToTarget();
    }

    @Deprecated
    public void fireEvent(String str, String str2, String str3, Map<String, Object> map) {
        fireEvent(str, str2, str3, map, null);
    }

    @Deprecated
    public void fireEvent(String str, String str2, String str3, Map<String, Object> map, Map<String, Object> map2) {
        fireEventOnNode(str, str2, str3, map, map2);
    }

    public void fireEventOnNode(String str, String str2, String str3, Map<String, Object> map, Map<String, Object> map2) {
        fireEventOnNode(str, str2, str3, map, map2, null, null);
    }

    public void fireEventOnNode(String str, String str2, String str3, Map<String, Object> map, Map<String, Object> map2, List<Object> list) {
        fireEventOnNode(str, str2, str3, map, map2, list, null);
    }

    public void fireEventOnNode(String str, String str2, String str3, Map<String, Object> map, Map<String, Object> map2, List<Object> list, EventResult eventResult) {
        if (!TextUtils.isEmpty(str) && !TextUtils.isEmpty(str2) && !TextUtils.isEmpty(str3) && this.mJSHandler != null) {
            if (checkMainThread()) {
                WXSDKInstance wXSDKInstance = WXSDKManager.getInstance().getAllInstanceMap().get(str);
                if (wXSDKInstance != null && (wXSDKInstance.getRenderStrategy() == WXRenderStrategy.DATA_RENDER || wXSDKInstance.getRenderStrategy() == WXRenderStrategy.DATA_RENDER_BINARY)) {
                    fireEventOnDataRenderNode(str, str2, str3, map, map2);
                } else if (eventResult == null) {
                    addJSEventTask(METHOD_FIRE_EVENT, str, list, str2, str3, map, map2);
                    sendMessage(str, 6);
                } else {
                    asyncCallJSEventWithResult(eventResult, METHD_FIRE_EVENT_SYNC, str, list, str2, str3, map, map2);
                }
            } else {
                throw new WXRuntimeException("fireEvent must be called by main thread");
            }
        }
    }

    private void fireEventOnDataRenderNode(final String str, final String str2, final String str3, final Map<String, Object> map, final Map<String, Object> map2) {
        this.mJSHandler.postDelayed(WXThread.secure(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass14 */

            public void run() {
                try {
                    WXSDKManager.getInstance().getSDKInstance(str);
                    long currentTimeMillis = System.currentTimeMillis();
                    if (WXEnvironment.isApkDebugable()) {
                        WXLogUtils.d("fireEventOnDataRenderNode >>>> instanceId:" + str + ", data:" + map);
                    }
                    if (WXBridgeManager.this.mWXBridge instanceof WXBridge) {
                        WXBridge wXBridge = (WXBridge) WXBridgeManager.this.mWXBridge;
                        String str = str;
                        String str2 = str2;
                        String str3 = str3;
                        Map map = map;
                        String str4 = "{}";
                        String jSONString = (map == null || map.isEmpty()) ? str4 : JSON.toJSONString(map);
                        Map map2 = map2;
                        if (map2 != null && !map2.isEmpty()) {
                            str4 = JSON.toJSONString(map2);
                        }
                        wXBridge.fireEventOnDataRenderNode(str, str2, str3, jSONString, str4);
                    }
                    WXLogUtils.renderPerformanceLog(WXBridgeManager.METHOD_FIRE_EVENT_ON_DATA_RENDER_NODE, System.currentTimeMillis() - currentTimeMillis);
                } catch (Throwable th) {
                    String str5 = "[WXBridgeManager] fireEventOnDataRenderNode " + WXLogUtils.getStackTrace(th);
                    WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, WXBridgeManager.METHOD_FIRE_EVENT_ON_DATA_RENDER_NODE, str5, null);
                    WXLogUtils.e(str5);
                }
            }
        }), 0);
    }

    private boolean checkMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    @Deprecated
    public void callback(String str, String str2, String str3) {
        callback(str, str2, str3, false);
    }

    @Deprecated
    public void callback(String str, String str2, Map<String, Object> map) {
        callback(str, str2, map, false);
    }

    @Deprecated
    public void callback(String str, String str2, Object obj, boolean z) {
        callbackJavascript(str, str2, obj, z);
    }

    /* access modifiers changed from: package-private */
    public void callbackJavascript(String str, String str2, Object obj, boolean z) {
        if (!TextUtils.isEmpty(str) && !TextUtils.isEmpty(str2) && this.mJSHandler != null && RuningAcitvityUtil.isRuningActivity) {
            WXSDKInstance wXSDKInstance = WXSDKManager.getInstance().getAllInstanceMap().get(str);
            if (wXSDKInstance == null || wXSDKInstance.getRenderStrategy() != WXRenderStrategy.DATA_RENDER_BINARY) {
                addJSTask(METHOD_CALLBACK, str, str2, obj, Boolean.valueOf(z));
                sendMessage(str, 6);
                return;
            }
            callbackJavascriptOnDataRender(str, str2, obj, z);
        }
    }

    /* access modifiers changed from: package-private */
    public void callbackJavascriptOnDataRender(final String str, final String str2, final Object obj, final boolean z) {
        this.mJSHandler.postDelayed(WXThread.secure(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass15 */

            public void run() {
                try {
                    long currentTimeMillis = System.currentTimeMillis();
                    String jSONString = JSON.toJSONString(obj);
                    if (WXEnvironment.isApkDebugable()) {
                        WXLogUtils.d("callbackJavascriptOnDataRender >>>> instanceId:" + str + ", data:" + jSONString);
                    }
                    if (WXBridgeManager.this.mWXBridge instanceof WXBridge) {
                        ((WXBridge) WXBridgeManager.this.mWXBridge).invokeCallbackOnDataRender(str, str2, jSONString, z);
                    }
                    WXLogUtils.renderPerformanceLog("callbackJavascriptOnDataRender", System.currentTimeMillis() - currentTimeMillis);
                } catch (Throwable th) {
                    String str = "[WXBridgeManager] callbackJavascriptOnDataRender " + WXLogUtils.getStackTrace(th);
                    WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callbackJavascriptOnDataRender", str, null);
                    WXLogUtils.e(str);
                }
            }
        }), 0);
    }

    public void refreshInstance(final String str, final WXRefreshData wXRefreshData) {
        if (!TextUtils.isEmpty(str) && wXRefreshData != null) {
            this.mJSHandler.postDelayed(WXThread.secure(new Runnable() {
                /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass16 */

                public void run() {
                    WXBridgeManager.this.invokeRefreshInstance(str, wXRefreshData);
                }
            }), 0);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void invokeRefreshInstance(String str, WXRefreshData wXRefreshData) {
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
                System.currentTimeMillis();
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("refreshInstance >>>> instanceId:" + str + ", data:" + wXRefreshData.data + ", isDirty:" + wXRefreshData.isDirty);
                }
                if (!wXRefreshData.isDirty) {
                    this.mWXBridge.refreshInstance(str, null, METHOD_REFRESH_INSTANCE, new WXJSObject[]{new WXJSObject(2, str), new WXJSObject(3, wXRefreshData.data == null ? "{}" : wXRefreshData.data)});
                    return;
                }
                return;
            }
            if (sDKInstance != null) {
                sDKInstance.onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg() + "invokeRefreshInstance FAILED for JSFrameworkInit FAILED, intance will invoke instance.onRenderError");
            }
            WXLogUtils.e("[WXBridgeManager] invokeRefreshInstance: framework.js uninitialized.");
        } catch (Throwable th) {
            String str2 = "[WXBridgeManager] invokeRefreshInstance " + WXLogUtils.getStackTrace(th);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "invokeRefreshInstance", str2, null);
            WXLogUtils.e(str2);
        }
    }

    public void commitJscCrashAlarmMonitor(String str, WXErrorCode wXErrorCode, String str2, String str3, String str4, Map<String, String> map) {
        if (!TextUtils.isEmpty(str) && wXErrorCode != null) {
            Log.d("ReportCrash", " commitJscCrashAlarmMonitor errMsg " + str2);
            HashMap hashMap = new HashMap();
            hashMap.put("jscCrashStack", str2);
            if (map != null) {
                hashMap.putAll(map);
            }
            IWXJSExceptionAdapter iWXJSExceptionAdapter = WXSDKManager.getInstance().getIWXJSExceptionAdapter();
            if (iWXJSExceptionAdapter != null) {
                WXJSExceptionInfo wXJSExceptionInfo = new WXJSExceptionInfo(str3, str4, wXErrorCode, "callReportCrash", "weex core process crash and restart exception", hashMap);
                iWXJSExceptionAdapter.onJSException(wXJSExceptionInfo);
                WXLogUtils.e(wXJSExceptionInfo.toString());
            }
        }
    }

    private boolean isSkipFrameworkInit(String str) {
        return isSkipFrameworkInit(WXSDKManager.getInstance().getSDKInstance(str));
    }

    private boolean isSkipFrameworkInit(WXSDKInstance wXSDKInstance) {
        if (wXSDKInstance == null) {
            return false;
        }
        return wXSDKInstance.skipFrameworkInit();
    }

    public void createInstance(String str, String str2, Map<String, Object> map, String str3) {
        createInstance(str, new Script(str2), map, str3);
    }

    public void createInstance(final String str, final Script script, final Map<String, Object> map, final String str2) {
        final WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
        if (sDKInstance == null) {
            WXLogUtils.e("WXBridgeManager", "createInstance failed, SDKInstance does not exist");
        } else if (TextUtils.isEmpty(str) || script == null || script.isEmpty() || this.mJSHandler == null) {
            String errorCode = WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode();
            sDKInstance.onRenderError(errorCode, WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg() + " instanceId==" + str + " template ==" + script + " mJSHandler== " + this.mJSHandler.toString());
        } else if (isSkipFrameworkInit(str) || isJSFrameworkInit() || reInitCount != 1 || WXEnvironment.sDebugServerConnectable) {
            WXModuleManager.createDomModule(sDKInstance);
            sDKInstance.getApmForInstance().onStage(WXInstanceApm.KEY_PAGE_STAGES_LOAD_BUNDLE_START);
            post(new Runnable() {
                /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass18 */

                public void run() {
                    long currentTimeMillis = System.currentTimeMillis();
                    WXBridgeManager.this.mWXBridge.setPageArgument(str, "renderTimeOrigin", String.valueOf(sDKInstance.getWXPerformance().renderTimeOrigin));
                    WXBridgeManager.this.mWXBridge.setInstanceRenderType(sDKInstance.getInstanceId(), sDKInstance.getRenderType());
                    WXBridgeManager.this.invokeCreateInstance(sDKInstance, script, map, str2);
                    sDKInstance.getWXPerformance().callCreateInstanceTime = System.currentTimeMillis() - currentTimeMillis;
                    sDKInstance.getWXPerformance().communicateTime = sDKInstance.getWXPerformance().callCreateInstanceTime;
                }
            }, str, sDKInstance, METHOD_CREATE_INSTANCE);
        } else {
            String errorCode2 = WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode();
            sDKInstance.onRenderError(errorCode2, WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg() + " isJSFrameworkInit==" + isJSFrameworkInit() + " reInitCount == 1");
            post(new Runnable() {
                /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass17 */

                public void run() {
                    WXBridgeManager.this.initFramework("");
                }
            }, str, sDKInstance, "initFrameworkInCreateInstance");
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    /* JADX WARNING: Removed duplicated region for block: B:53:0x010e  */
    /* JADX WARNING: Removed duplicated region for block: B:59:0x0124  */
    /* JADX WARNING: Removed duplicated region for block: B:60:0x0126  */
    /* JADX WARNING: Removed duplicated region for block: B:63:0x0132  */
    /* JADX WARNING: Removed duplicated region for block: B:64:0x0134  */
    /* JADX WARNING: Removed duplicated region for block: B:67:0x0146  */
    /* JADX WARNING: Removed duplicated region for block: B:70:0x014f  */
    /* JADX WARNING: Removed duplicated region for block: B:75:0x0162  */
    /* JADX WARNING: Removed duplicated region for block: B:84:0x0192  */
    /* JADX WARNING: Removed duplicated region for block: B:85:0x019e  */
    /* JADX WARNING: Removed duplicated region for block: B:93:0x01f5  */
    /* JADX WARNING: Removed duplicated region for block: B:95:0x0227  */
    private void invokeCreateInstance(WXSDKInstance wXSDKInstance, Script script, Map<String, Object> map, String str) {
        HashMap hashMap;
        Object obj;
        String str2;
        String str3;
        WXJSObject wXJSObject;
        Throwable th;
        if (!isSkipFrameworkInit(wXSDKInstance)) {
            initFramework("");
        }
        if (this.mMock) {
            mock(wXSDKInstance.getInstanceId());
        } else if (isSkipFrameworkInit(wXSDKInstance) || isJSFrameworkInit()) {
            WXModuleManager.registerWhenCreateInstance();
            try {
                BundType bundType = BundType.Others;
                try {
                    long currentTimeMillis = System.currentTimeMillis();
                    bundType = getBundleType(wXSDKInstance.getBundleUrl(), script.getContent());
                    if (WXEnvironment.isOpenDebugLog()) {
                        long currentTimeMillis2 = System.currentTimeMillis();
                        WXLogUtils.e("end getBundleType type:" + bundType.toString() + " time:" + (currentTimeMillis2 - currentTimeMillis));
                    }
                } catch (Throwable th2) {
                    WXLogUtils.e(WXLogUtils.getStackTrace(th2));
                }
                if (map == null) {
                    try {
                        hashMap = new HashMap();
                    } catch (Throwable th3) {
                        th = th3;
                        hashMap = map;
                        WXLogUtils.e(WXLogUtils.getStackTrace(th));
                        wXSDKInstance.bundleType = bundType;
                        WXEnvironment.isApkDebugable();
                        WXJSObject wXJSObject2 = new WXJSObject(2, wXSDKInstance.getInstanceId());
                        WXJSObject wXJSObject3 = new WXJSObject(2, script.getContent());
                        WXJSObject wXJSObject4 = null;
                        if (hashMap != null) {
                        }
                        obj = null;
                        String str4 = "{}";
                        if (obj == null) {
                        }
                        WXJSObject wXJSObject5 = new WXJSObject(3, str2);
                        if (hashMap == null) {
                        }
                        WXJSObject optionObjConvert = optionObjConvert(isSandBoxContext, bundType, new WXJSObject(3, str3));
                        if (str != null) {
                        }
                        WXJSObject wXJSObject6 = new WXJSObject(3, str4);
                        if (bundType != BundType.Rax) {
                        }
                        if (mRaxApi == null) {
                        }
                        wXJSObject = new WXJSObject(2, mRaxApi);
                        if (wXSDKInstance.getRenderStrategy() == WXRenderStrategy.DATA_RENDER) {
                        }
                        WXJSObject[] wXJSObjectArr = {wXJSObject2, wXJSObject3, optionObjConvert, wXJSObject6, wXJSObject, wXJSObject4, wXJSObject5};
                        wXSDKInstance.setTemplate(script.getContent());
                        wXSDKInstance.getApmForInstance().onStage(WXInstanceApm.KEY_PAGE_STAGES_LOAD_BUNDLE_END);
                        if (!isSandBoxContext) {
                        }
                    }
                } else {
                    hashMap = map;
                }
                try {
                    if (hashMap.get(BUNDLE_TYPE) == null) {
                        if (bundType == BundType.Vue) {
                            hashMap.put(BUNDLE_TYPE, "Vue");
                        } else if (bundType == BundType.Rax) {
                            hashMap.put(BUNDLE_TYPE, "Rax");
                        } else {
                            hashMap.put(BUNDLE_TYPE, "Others");
                        }
                        Object obj2 = hashMap.get(BUNDLE_TYPE);
                        if ((obj2 instanceof String) && "Others".equalsIgnoreCase((String) obj2)) {
                            obj2 = "other";
                        }
                        if (obj2 != null) {
                            wXSDKInstance.getApmForInstance().addProperty(WXInstanceApm.KEY_PAGE_PROPERTIES_BUNDLE_TYPE, obj2);
                        }
                    }
                    if (hashMap.get("env") == null) {
                        hashMap.put("env", this.mInitParams.toMap());
                    }
                } catch (Throwable th4) {
                    th = th4;
                    WXLogUtils.e(WXLogUtils.getStackTrace(th));
                    wXSDKInstance.bundleType = bundType;
                    WXEnvironment.isApkDebugable();
                    WXJSObject wXJSObject22 = new WXJSObject(2, wXSDKInstance.getInstanceId());
                    WXJSObject wXJSObject32 = new WXJSObject(2, script.getContent());
                    WXJSObject wXJSObject42 = null;
                    if (hashMap != null) {
                    }
                    obj = null;
                    String str42 = "{}";
                    if (obj == null) {
                    }
                    WXJSObject wXJSObject52 = new WXJSObject(3, str2);
                    if (hashMap == null) {
                    }
                    WXJSObject optionObjConvert2 = optionObjConvert(isSandBoxContext, bundType, new WXJSObject(3, str3));
                    if (str != null) {
                    }
                    WXJSObject wXJSObject62 = new WXJSObject(3, str42);
                    if (bundType != BundType.Rax) {
                    }
                    if (mRaxApi == null) {
                    }
                    wXJSObject = new WXJSObject(2, mRaxApi);
                    if (wXSDKInstance.getRenderStrategy() == WXRenderStrategy.DATA_RENDER) {
                    }
                    WXJSObject[] wXJSObjectArr2 = {wXJSObject22, wXJSObject32, optionObjConvert2, wXJSObject62, wXJSObject, wXJSObject42, wXJSObject52};
                    wXSDKInstance.setTemplate(script.getContent());
                    wXSDKInstance.getApmForInstance().onStage(WXInstanceApm.KEY_PAGE_STAGES_LOAD_BUNDLE_END);
                    if (!isSandBoxContext) {
                    }
                }
                wXSDKInstance.bundleType = bundType;
                WXEnvironment.isApkDebugable();
                WXJSObject wXJSObject222 = new WXJSObject(2, wXSDKInstance.getInstanceId());
                WXJSObject wXJSObject322 = new WXJSObject(2, script.getContent());
                WXJSObject wXJSObject422 = null;
                if (hashMap != null || !hashMap.containsKey("extraOption")) {
                    obj = null;
                } else {
                    obj = hashMap.get("extraOption");
                    hashMap.remove("extraOption");
                }
                String str422 = "{}";
                if (obj == null) {
                    str2 = str422;
                } else {
                    str2 = WXJsonUtils.fromObjectToJSONString(obj);
                }
                WXJSObject wXJSObject522 = new WXJSObject(3, str2);
                if (hashMap == null) {
                    str3 = str422;
                } else {
                    str3 = WXJsonUtils.fromObjectToJSONString(hashMap);
                }
                WXJSObject optionObjConvert22 = optionObjConvert(isSandBoxContext, bundType, new WXJSObject(3, str3));
                if (str != null) {
                    str422 = str;
                }
                WXJSObject wXJSObject622 = new WXJSObject(3, str422);
                if (bundType != BundType.Rax || wXSDKInstance.getRenderStrategy() == WXRenderStrategy.DATA_RENDER) {
                    if (mRaxApi == null) {
                        IWXJsFileLoaderAdapter iWXJsFileLoaderAdapter = WXSDKEngine.getIWXJsFileLoaderAdapter();
                        if (iWXJsFileLoaderAdapter != null) {
                            mRaxApi = iWXJsFileLoaderAdapter.loadRaxApi();
                        }
                        if (TextUtils.isEmpty(mRaxApi)) {
                            mRaxApi = WXFileUtils.loadAsset("weex-rax-api.js", WXEnvironment.getApplication());
                        }
                    }
                    wXJSObject = new WXJSObject(2, mRaxApi);
                } else {
                    wXJSObject = new WXJSObject(2, "");
                }
                if (wXSDKInstance.getRenderStrategy() == WXRenderStrategy.DATA_RENDER) {
                    wXJSObject422 = new WXJSObject(2, WXRenderStrategy.DATA_RENDER.getFlag());
                } else if (wXSDKInstance.getRenderStrategy() == WXRenderStrategy.DATA_RENDER_BINARY) {
                    wXJSObject422 = new WXJSObject(2, WXRenderStrategy.DATA_RENDER_BINARY.getFlag());
                    wXJSObject322.data = script.getBinary();
                } else if (wXSDKInstance.getRenderStrategy() == WXRenderStrategy.JSON_RENDER) {
                    wXJSObject422 = new WXJSObject(2, WXRenderStrategy.JSON_RENDER.getFlag());
                }
                WXJSObject[] wXJSObjectArr22 = {wXJSObject222, wXJSObject322, optionObjConvert22, wXJSObject622, wXJSObject, wXJSObject422, wXJSObject522};
                wXSDKInstance.setTemplate(script.getContent());
                wXSDKInstance.getApmForInstance().onStage(WXInstanceApm.KEY_PAGE_STAGES_LOAD_BUNDLE_END);
                if (!isSandBoxContext) {
                    wXSDKInstance.getApmForInstance().onStage("!isSandBoxContext,and excute");
                    WXLogUtils.e("Instance " + wXSDKInstance.getInstanceId() + " Did Not Render in SandBox Mode");
                    invokeExecJS(wXSDKInstance.getInstanceId(), null, METHOD_CREATE_INSTANCE, wXJSObjectArr22, false);
                } else if (bundType == BundType.Vue || bundType == BundType.Rax || wXSDKInstance.getRenderStrategy() == WXRenderStrategy.DATA_RENDER || wXSDKInstance.getRenderStrategy() == WXRenderStrategy.DATA_RENDER_BINARY || wXSDKInstance.getRenderStrategy() == WXRenderStrategy.JSON_RENDER) {
                    int invokeCreateInstanceContext = invokeCreateInstanceContext(wXSDKInstance.getInstanceId(), wXSDKInstance.getUniPagePath(), METHOD_CREATE_INSTANCE_CONTEXT, wXJSObjectArr22, false);
                    wXSDKInstance.getApmForInstance().onStage(WXInstanceApm.KEY_PAGE_STAGES_LOAD_BUNDLE_END);
                    if (invokeCreateInstanceContext == 0) {
                        String str5 = "[WXBridgeManager] invokeCreateInstance : " + wXSDKInstance.getTemplateInfo();
                        WXLogUtils.e("Instance " + wXSDKInstance.getInstanceId() + "Render error : " + str5);
                        String errorCode = WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode();
                        StringBuilder sb = new StringBuilder();
                        sb.append(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg());
                        sb.append(str5);
                        wXSDKInstance.onRenderError(errorCode, sb.toString());
                    }
                } else {
                    invokeExecJS(wXSDKInstance.getInstanceId(), null, METHOD_CREATE_INSTANCE, wXJSObjectArr22, false);
                    wXSDKInstance.getApmForInstance().onStage(WXInstanceApm.KEY_PAGE_STAGES_LOAD_BUNDLE_END);
                }
            } catch (Throwable th5) {
                String str6 = "[WXBridgeManager] invokeCreateInstance " + th5.getCause() + wXSDKInstance.getTemplateInfo();
                wXSDKInstance.onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg() + str6);
                WXLogUtils.e(str6);
            }
        } else {
            wXSDKInstance.onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg());
            WXLogUtils.e("[WXBridgeManager] invokeCreateInstance: framework.js uninitialized.");
        }
    }

    public WXJSObject optionObjConvert(boolean z, BundType bundType, WXJSObject wXJSObject) {
        JSONObject jSONObject;
        if (!z) {
            return wXJSObject;
        }
        try {
            JSONObject parseObject = JSON.parseObject(wXJSObject.data.toString());
            JSONObject jSONObject2 = parseObject.getJSONObject("env");
            if (!(jSONObject2 == null || (jSONObject = jSONObject2.getJSONObject("options")) == null)) {
                for (String str : jSONObject.keySet()) {
                    jSONObject2.put(str, (Object) jSONObject.getString(str));
                }
            }
            return new WXJSObject(3, parseObject.toString());
        } catch (Throwable th) {
            WXLogUtils.e(WXLogUtils.getStackTrace(th));
            return wXJSObject;
        }
    }

    public BundType getBundleType(String str, String str2) {
        if (str != null) {
            try {
                String queryParameter = Uri.parse(str).getQueryParameter(BUNDLE_TYPE);
                if (!"Vue".equals(queryParameter)) {
                    if (!"vue".equals(queryParameter)) {
                        if ("Rax".equals(queryParameter) || "rax".equals(queryParameter)) {
                            return BundType.Rax;
                        }
                    }
                }
                return BundType.Vue;
            } catch (Throwable th) {
                WXLogUtils.e(WXLogUtils.getStackTrace(th));
                return BundType.Others;
            }
        }
        if (str2 != null) {
            return BundType.Vue;
        }
        return BundType.Others;
    }

    public void destroyInstance(final String str) {
        if (this.mJSHandler != null && !TextUtils.isEmpty(str)) {
            HashSet<String> hashSet = this.mDestroyedInstanceId;
            if (hashSet != null) {
                hashSet.add(str);
            }
            this.mJSHandler.removeCallbacksAndMessages(str);
            post(new Runnable() {
                /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass19 */

                public void run() {
                    WXBridgeManager.this.removeTaskByInstance(str);
                    WXBridgeManager.this.invokeDestroyInstance(str);
                }
            }, str, null, METHOD_DESTROY_INSTANCE);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void removeTaskByInstance(String str) {
        this.mNextTickTasks.removeFromMapAndStack(str);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void invokeDestroyInstance(String str) {
        try {
            WXEnvironment.isApkDebugable();
            WXJSObject[] wXJSObjectArr = {new WXJSObject(2, str)};
            if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
                invokeDestoryInstance(str, null, METHOD_DESTROY_INSTANCE, wXJSObjectArr, true);
            }
        } catch (Throwable th) {
            String str2 = "[WXBridgeManager] invokeDestroyInstance " + th.getCause();
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "invokeDestroyInstance", str2, null);
            WXLogUtils.e(str2);
        }
    }

    public boolean handleMessage(Message message) {
        if (message == null) {
            return false;
        }
        int i = message.what;
        if (i == 1) {
            TimerInfo timerInfo = (TimerInfo) message.obj;
            if (timerInfo != null) {
                invokeExecJS("", null, METHOD_SET_TIMEOUT, new WXJSObject[]{new WXJSObject(2, timerInfo.callbackId)});
            }
        } else if (i != 13) {
            if (i == 6) {
                invokeCallJSBatch(message);
            } else if (i == 7) {
                invokeInitFramework(message);
            }
        } else if (message.obj != null) {
            this.mWXBridge.takeHeapSnapshot((String) message.obj);
        }
        return false;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void invokeExecJS(String str, String str2, String str3, WXJSObject[] wXJSObjectArr) {
        invokeExecJS(str, str2, str3, wXJSObjectArr, true);
    }

    public void invokeExecJS(final String str, final String str2, final String str3, final WXJSObject[] wXJSObjectArr, boolean z) {
        Pair<Pair<String, Object>, Boolean> extractCallbackArgs;
        WXEnvironment.isOpenDebugLog();
        if (RuningAcitvityUtil.isRuningActivity) {
            long currentTimeMillis = System.currentTimeMillis();
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null || sDKInstance.getRenderStrategy() != WXRenderStrategy.DATA_RENDER_BINARY) {
                WXThread.secure(new Runnable() {
                    /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass20 */

                    public void run() {
                        WXBridgeManager.this.mWXBridge.execJS(str, str2, str3, wXJSObjectArr);
                    }
                }, sDKInstance, "ExecJs").run();
            } else if (wXJSObjectArr.length != 2 || !(wXJSObjectArr[0].data instanceof String) || !(wXJSObjectArr[1].data instanceof String) || (extractCallbackArgs = extractCallbackArgs((String) wXJSObjectArr[1].data)) == null) {
                WXLogUtils.w("invokeExecJS on data render that is not a callback call");
                return;
            } else {
                callbackJavascriptOnDataRender(str, (String) ((Pair) extractCallbackArgs.first).first, ((Pair) extractCallbackArgs.first).second, ((Boolean) extractCallbackArgs.second).booleanValue());
            }
            if (sDKInstance != null) {
                long currentTimeMillis2 = System.currentTimeMillis() - currentTimeMillis;
                sDKInstance.getApmForInstance().updateFSDiffStats(WXInstanceApm.KEY_PAGE_STATS_FS_CALL_JS_NUM, 1.0d);
                sDKInstance.getApmForInstance().updateFSDiffStats(WXInstanceApm.KEY_PAGE_STATS_FS_CALL_JS_TIME, (double) currentTimeMillis2);
                sDKInstance.callJsTime(currentTimeMillis2);
            }
        }
    }

    private Pair<Pair<String, Object>, Boolean> extractCallbackArgs(String str) {
        try {
            JSONObject jSONObject = JSON.parseArray(str).getJSONObject(0);
            JSONArray jSONArray = jSONObject.getJSONArray("args");
            if (jSONArray.size() == 3 && METHOD_CALLBACK.equals(jSONObject.getString("method"))) {
                return new Pair<>(new Pair(jSONArray.getString(0), jSONArray.getJSONObject(1)), Boolean.valueOf(jSONArray.getBooleanValue(2)));
            }
            return null;
        } catch (Exception unused) {
            return null;
        }
    }

    public int invokeCreateInstanceContext(String str, String str2, String str3, WXJSObject[] wXJSObjectArr, boolean z) {
        WXLogUtils.d("invokeCreateInstanceContext instanceId:" + str + " function:" + str3 + StringUtil.format(" isJSFrameworkInit：%b", Boolean.valueOf(isJSFrameworkInit())));
        StringBuilder sb = this.mLodBuilder;
        sb.append("createInstanceContext >>>> instanceId:");
        sb.append(str);
        sb.append("function:");
        sb.append(str3);
        if (z) {
            StringBuilder sb2 = this.mLodBuilder;
            sb2.append(" tasks:");
            sb2.append(WXJsonUtils.fromObjectToJSONString(wXJSObjectArr));
        }
        WXLogUtils.d(this.mLodBuilder.substring(0));
        this.mLodBuilder.setLength(0);
        return this.mWXBridge.createInstanceContext(str, str2, str3, wXJSObjectArr);
    }

    public void invokeDestoryInstance(String str, String str2, String str3, WXJSObject[] wXJSObjectArr, boolean z) {
        StringBuilder sb = this.mLodBuilder;
        sb.append("callJS >>>> instanceId:");
        sb.append(str);
        sb.append("function:");
        sb.append(str3);
        if (z) {
            StringBuilder sb2 = this.mLodBuilder;
            sb2.append(" tasks:");
            sb2.append(WXJsonUtils.fromObjectToJSONString(wXJSObjectArr));
        }
        WXLogUtils.d(this.mLodBuilder.substring(0));
        this.mLodBuilder.setLength(0);
        this.mWXBridge.removeInstanceRenderType(str);
        this.mWXBridge.destoryInstance(str, str2, str3, wXJSObjectArr);
    }

    private void execJSOnInstance(final EventResult eventResult, final String str, final String str2, final int i) {
        post(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass21 */

            public void run() {
                eventResult.onCallback(WXBridgeManager.this.invokeExecJSOnInstance(str, str2, i));
            }
        });
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private String invokeExecJSOnInstance(String str, String str2, int i) {
        StringBuilder sb = this.mLodBuilder;
        sb.append("execJSOnInstance >>>> instanceId:");
        sb.append(str);
        WXLogUtils.d(this.mLodBuilder.substring(0));
        this.mLodBuilder.setLength(0);
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            return this.mWXBridge.execJSOnInstance(str, str2, i);
        }
        return null;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void invokeExecJSWithCallback(String str, String str2, String str3, WXJSObject[] wXJSObjectArr, ResultCallback resultCallback, boolean z) {
        WXEnvironment.isOpenDebugLog();
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.execJSWithCallback(str, str2, str3, wXJSObjectArr, resultCallback);
        }
    }

    public static String argsToJSON(WXJSObject[] wXJSObjectArr) {
        StringBuilder sb = new StringBuilder();
        sb.append(Operators.ARRAY_START_STR);
        for (WXJSObject wXJSObject : wXJSObjectArr) {
            sb.append(WXWsonJSONSwitch.fromObjectToJSONString(wXJSObject));
            sb.append(",");
        }
        sb.append(Operators.ARRAY_END_STR);
        return sb.toString();
    }

    private void invokeInitFramework(Message message) {
        String str = message.obj != null ? (String) message.obj : "";
        if (WXUtils.getAvailMemory(WXEnvironment.getApplication()) > LOW_MEM_VALUE) {
            initFramework(str);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    /* JADX WARNING: Code restructure failed: missing block: B:42:0x0122, code lost:
        if (android.os.Build.VERSION.SDK_INT < 16) goto L_0x012e;
     */
    private void initFramework(String str) {
        boolean z;
        long currentTimeMillis;
        String str2;
        LogDetail logDetail = new LogDetail();
        logDetail.name(IWXUserTrackAdapter.INIT_FRAMEWORK);
        logDetail.taskStart();
        if (WXSDKEngine.isSoInitialized() && !isJSFrameworkInit()) {
            sInitFrameWorkTimeOrigin = System.currentTimeMillis();
            if (TextUtils.isEmpty(str)) {
                WXLogUtils.d("weex JS framework from assets");
                LogDetail logDetail2 = new LogDetail();
                logDetail2.name("loadJSFramework");
                logDetail2.taskStart();
                IWXJsFileLoaderAdapter iWXJsFileLoaderAdapter = WXSDKEngine.getIWXJsFileLoaderAdapter();
                if (!isSandBoxContext) {
                    if (iWXJsFileLoaderAdapter != null) {
                        str = iWXJsFileLoaderAdapter.loadJsFramework();
                    }
                    if (TextUtils.isEmpty(str)) {
                        str = WXFileUtils.loadAsset("main.js", WXEnvironment.getApplication());
                    }
                } else {
                    if (iWXJsFileLoaderAdapter != null) {
                        str = iWXJsFileLoaderAdapter.loadJsFrameworkForSandBox();
                    }
                    if (TextUtils.isEmpty(str)) {
                        str = WXFileUtils.loadAsset("weex-main-jsfm.js", WXEnvironment.getApplication());
                    }
                }
                StringBuilder sb = sInitFrameWorkMsg;
                sb.append("| weex JS framework from assets, isSandBoxContext: ");
                sb.append(isSandBoxContext);
                logDetail2.taskEnd();
                WXDotDataUtil.setValue(logDetail2.info.taskName, Long.valueOf(logDetail2.time.execTime));
            }
            WXDotDataUtil.setValue("jsEngine", Constants.CodeCache.SAVE_PATH);
            z = false;
            if (TextUtils.isEmpty(str)) {
                setJSFrameworkInit(false);
                sInitFrameWorkMsg.append("| framework isEmpty ");
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_ERR_JS_FRAMEWORK, IWXUserTrackAdapter.INIT_FRAMEWORK, "framework is empty!! ", null);
                return;
            }
            try {
                if (WXSDKManager.getInstance().getWXStatisticsListener() != null) {
                    long currentTimeMillis2 = System.currentTimeMillis();
                    WXSDKManager.getInstance().getWXStatisticsListener().onJsFrameworkStart();
                    WXEnvironment.sJSFMStartListenerTime = System.currentTimeMillis() - currentTimeMillis2;
                    try {
                        IWXUserTrackAdapter iWXUserTrackAdapter = WXSDKManager.getInstance().getIWXUserTrackAdapter();
                        if (iWXUserTrackAdapter != null) {
                            HashMap hashMap = new HashMap(1);
                            hashMap.put(Constants.Value.TIME, String.valueOf(WXEnvironment.sJSFMStartListenerTime));
                            iWXUserTrackAdapter.commit(WXEnvironment.getApplication(), "sJSFMStartListener", IWXUserTrackAdapter.COUNTER, null, hashMap);
                        }
                    } catch (Exception e) {
                        WXLogUtils.e(WXLogUtils.getStackTrace(e));
                    }
                }
                currentTimeMillis = System.currentTimeMillis();
                str2 = "";
                try {
                    str2 = WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath();
                } catch (Exception e2) {
                    WXLogUtils.e(WXLogUtils.getStackTrace(e2));
                }
                try {
                } catch (Exception e3) {
                    WXLogUtils.e(WXLogUtils.getStackTrace(e3));
                }
            } catch (Throwable th) {
                StringBuilder sb2 = sInitFrameWorkMsg;
                sb2.append(" | invokeInitFramework exception ");
                sb2.append(th.toString());
                if (reInitCount > 1) {
                    WXLogUtils.e("[WXBridgeManager] invokeInitFramework ", th);
                    return;
                } else {
                    WXLogUtils.e("[WXBridgeManager] invokeInitFramework ", th);
                    return;
                }
            }
        } else {
            return;
        }
        z = true;
        StringBuilder sb3 = sInitFrameWorkMsg;
        sb3.append(" | pieSupport:");
        sb3.append(z);
        WXLogUtils.d("[WXBridgeManager] initFrameworkEnv crashFile:" + str2 + " pieSupport:" + z);
        LogDetail logDetail3 = new LogDetail();
        logDetail3.name("native initFrameworkEnv");
        logDetail3.taskStart();
        if (this.mWXBridge.initFrameworkEnv(str, assembleDefaultOptions(), str2, z) == 1) {
            logDetail3.taskEnd();
            WXDotDataUtil.setValue(logDetail3.info.taskName, Long.valueOf(logDetail3.time.execTime));
            WXEnvironment.sJSLibInitTime = System.currentTimeMillis() - currentTimeMillis;
            WXEnvironment.sSDKInitTime = System.currentTimeMillis() - WXEnvironment.sSDKInitStart;
            setJSFrameworkInit(true);
            logDetail.taskEnd();
            WXDotDataUtil.setValue(logDetail.info.taskName, Long.valueOf(logDetail.time.execTime));
            if (WXSDKManager.getInstance().getWXStatisticsListener() != null) {
                WXSDKManager.getInstance().getWXStatisticsListener().onJsFrameworkReady();
            }
            execRegisterFailTask();
            WXEnvironment.JsFrameworkInit = true;
            registerDomModule();
            trackComponentAndModulesTime();
            return;
        }
        StringBuilder sb4 = sInitFrameWorkMsg;
        sb4.append(" | ExecuteJavaScript fail, reInitCount");
        sb4.append(reInitCount);
        if (reInitCount > 1) {
            WXLogUtils.e("[WXBridgeManager] invokeReInitFramework  ExecuteJavaScript fail");
        } else {
            WXLogUtils.e("[WXBridgeManager] invokeInitFramework  ExecuteJavaScript fail");
        }
    }

    private void trackComponentAndModulesTime() {
        post(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass22 */

            public void run() {
                WXEnvironment.sComponentsAndModulesReadyTime = System.currentTimeMillis() - WXEnvironment.sSDKInitStart;
            }
        });
    }

    private void invokeCallJSBatch(Message message) {
        if (!this.mNextTickTasks.isEmpty() && isJSFrameworkInit()) {
            try {
                Object obj = message.obj;
                Stack<String> instanceStack = this.mNextTickTasks.getInstanceStack();
                int size = instanceStack.size() - 1;
                ArrayList<WXHashMap<String, Object>> arrayList = null;
                while (true) {
                    if (size >= 0) {
                        obj = instanceStack.get(size);
                        arrayList = this.mNextTickTasks.remove(obj);
                        if (arrayList != null && !arrayList.isEmpty()) {
                            break;
                        }
                        size--;
                    } else {
                        break;
                    }
                }
                if (arrayList != null) {
                    invokeExecJS(String.valueOf(obj), null, METHOD_CALL_JS, new WXJSObject[]{new WXJSObject(2, obj), WXWsonJSONSwitch.toWsonOrJsonWXJSObject(arrayList.toArray())});
                }
            } catch (Throwable th) {
                WXLogUtils.e("WXBridgeManager", th);
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_ERR_JS_FRAMEWORK, "invokeCallJSBatch", "invokeCallJSBatch#" + WXLogUtils.getStackTrace(th), null);
            }
            if (!this.mNextTickTasks.isEmpty()) {
                this.mJSHandler.sendEmptyMessage(6);
            }
        } else if (!isJSFrameworkInit()) {
            WXLogUtils.e("[WXBridgeManager] invokeCallJSBatch: framework.js uninitialized!!  message:" + message.toString());
        }
    }

    private WXParams assembleDefaultOptions() {
        checkJsEngineMultiThread();
        Map<String, String> config = WXEnvironment.getConfig();
        WXParams wXParams = new WXParams();
        wXParams.setPlatform(config.get(WXConfig.os));
        wXParams.setCacheDir(config.get(WXConfig.cacheDir));
        wXParams.setOsVersion(config.get(WXConfig.sysVersion));
        wXParams.setAppVersion(config.get(WXConfig.appVersion));
        wXParams.setWeexVersion(config.get(WXConfig.weexVersion));
        wXParams.setDeviceModel(config.get(WXConfig.sysModel));
        wXParams.setShouldInfoCollect(config.get("infoCollect"));
        wXParams.setLogLevel(config.get(WXConfig.logLevel));
        wXParams.setLayoutDirection(config.get(WXConfig.layoutDirection));
        wXParams.setUseSingleProcess(isUseSingleProcess ? AbsoluteConst.TRUE : AbsoluteConst.FALSE);
        wXParams.setCrashFilePath(WXEnvironment.getCrashFilePath(WXEnvironment.getApplication().getApplicationContext()));
        wXParams.setLibJsbPath(WXEnvironment.CORE_JSB_SO_PATH);
        wXParams.setLibJssPath(WXEnvironment.getLibJssRealPath());
        wXParams.setLibIcuPath(WXEnvironment.getLibJssIcuPath());
        wXParams.setLibLdPath(WXEnvironment.getLibLdPath());
        String libJScRealPath = WXEnvironment.getLibJScRealPath();
        wXParams.setLibJscPath(TextUtils.isEmpty(libJScRealPath) ? "" : new File(libJScRealPath).getParent());
        String str = config.get(WXConfig.appName);
        if (!TextUtils.isEmpty(str)) {
            wXParams.setAppName(str);
        }
        wXParams.setDeviceWidth(TextUtils.isEmpty(config.get(WXConfig.deviceWidth)) ? String.valueOf(WXViewUtils.getScreenWidth(WXEnvironment.sApplication)) : config.get(WXConfig.deviceWidth));
        wXParams.setDeviceHeight(TextUtils.isEmpty(config.get(WXConfig.deviceHeight)) ? String.valueOf(WXViewUtils.getScreenHeight(WXEnvironment.sApplication)) : config.get(WXConfig.deviceHeight));
        Map<String, String> customOptions = WXEnvironment.getCustomOptions();
        customOptions.put("enableBackupThread", String.valueOf(jsEngineMultiThreadEnable()));
        IWXJscProcessManager wXJscProcessManager = WXSDKManager.getInstance().getWXJscProcessManager();
        if (wXJscProcessManager != null) {
            customOptions.put("enableBackupThreadCache", String.valueOf(wXJscProcessManager.enableBackUpThreadCache()));
        }
        if (!WXEnvironment.sUseRunTimeApi) {
            customOptions.put("__enable_native_promise__", AbsoluteConst.TRUE);
        }
        wXParams.setOptions(customOptions);
        wXParams.setNeedInitV8(WXSDKManager.getInstance().needInitV8());
        this.mInitParams = wXParams;
        return wXParams;
    }

    public WXParams getInitParams() {
        return this.mInitParams;
    }

    private void execRegisterFailTask() {
        if (this.mRegisterModuleFailList.size() > 0) {
            ArrayList arrayList = new ArrayList();
            int size = this.mRegisterModuleFailList.size();
            for (int i = 0; i < size; i++) {
                invokeRegisterModules(this.mRegisterModuleFailList.get(i), arrayList);
            }
            this.mRegisterModuleFailList.clear();
            if (arrayList.size() > 0) {
                this.mRegisterModuleFailList.addAll(arrayList);
            }
        }
        if (this.mRegisterComponentFailList.size() > 0) {
            ArrayList arrayList2 = new ArrayList();
            invokeRegisterComponents(this.mRegisterComponentFailList, arrayList2);
            this.mRegisterComponentFailList.clear();
            if (arrayList2.size() > 0) {
                this.mRegisterComponentFailList.addAll(arrayList2);
            }
        }
        if (this.mRegisterServiceFailList.size() > 0) {
            ArrayList arrayList3 = new ArrayList();
            for (String str : this.mRegisterServiceFailList) {
                invokeExecJSService(str, arrayList3);
            }
            this.mRegisterServiceFailList.clear();
            if (arrayList3.size() > 0) {
                this.mRegisterServiceFailList.addAll(arrayList3);
            }
        }
    }

    public void registerModules(final Map<String, Object> map) {
        if (map != null && map.size() != 0) {
            if (isJSThread()) {
                invokeRegisterModules(map, this.mRegisterModuleFailList);
            } else {
                post(new Runnable() {
                    /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass23 */

                    public void run() {
                        WXBridgeManager wXBridgeManager = WXBridgeManager.this;
                        wXBridgeManager.invokeRegisterModules(map, wXBridgeManager.mRegisterModuleFailList);
                    }
                }, null);
            }
        }
    }

    public void registerComponents(final List<Map<String, Object>> list) {
        if (this.mJSHandler != null && list != null && list.size() != 0) {
            AnonymousClass24 r0 = new Runnable() {
                /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass24 */

                public void run() {
                    WXBridgeManager wXBridgeManager = WXBridgeManager.this;
                    wXBridgeManager.invokeRegisterComponents(list, wXBridgeManager.mRegisterComponentFailList);
                }
            };
            if (!isJSThread() || !isJSFrameworkInit()) {
                post(r0);
            } else {
                r0.run();
            }
        }
    }

    public void execJSService(final String str) {
        postWithName(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass25 */

            public void run() {
                WXBridgeManager wXBridgeManager = WXBridgeManager.this;
                wXBridgeManager.invokeExecJSService(str, wXBridgeManager.mRegisterServiceFailList);
            }
        }, null, "execJSService");
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void invokeExecJSService(String str, List<String> list) {
        try {
            if (!isJSFrameworkInit()) {
                WXLogUtils.e("[WXBridgeManager] invoke execJSService: framework.js uninitialized.");
                list.add(str);
                return;
            }
            this.mWXBridge.execJSService(str);
        } catch (Throwable th) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterService:", th);
            HashMap hashMap = new HashMap();
            hashMap.put("inputParams", str + Operators.OR + list.toString());
            WXErrorCode wXErrorCode = WXErrorCode.WX_KEY_EXCEPTION_INVOKE_JSSERVICE_EXECUTE;
            WXExceptionUtils.commitCriticalExceptionRT("invokeExecJSService", wXErrorCode, "invokeExecJSService", WXErrorCode.WX_KEY_EXCEPTION_INVOKE_JSSERVICE_EXECUTE.getErrorMsg() + "[WXBridgeManager] invokeRegisterService:" + WXLogUtils.getStackTrace(th), hashMap);
        }
    }

    public boolean isJSThread() {
        WXThread wXThread = this.mJSThread;
        return wXThread != null && wXThread.getId() == Thread.currentThread().getId();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void invokeRegisterModules(Map<String, Object> map, List<Map<String, Object>> list) {
        String str;
        if (map == null || !isJSFrameworkInit()) {
            if (!isJSFrameworkInit()) {
                WXLogUtils.d("[WXinvokeRegisterModulesBridgeManager] invokeRegisterModules: framework.js uninitialized.");
            }
            list.add(map);
            return;
        }
        WXJSObject[] wXJSObjectArr = {WXWsonJSONSwitch.toWsonOrJsonWXJSObject(map)};
        try {
            IWXBridge iWXBridge = this.mWXBridge;
            if (iWXBridge instanceof WXBridge) {
                ((WXBridge) iWXBridge).registerModuleOnDataRenderNode(WXJsonUtils.fromObjectToJSONString(map));
            }
        } catch (Throwable th) {
            WXLogUtils.e("Weex [data_render register err]", th);
        }
        try {
            str = this.mWXBridge.execJS("", null, METHOD_REGISTER_MODULES, wXJSObjectArr) == 0 ? "execJS error" : null;
            try {
                for (String str2 : map.keySet()) {
                    if (str2 != null) {
                        WXModuleManager.resetModuleState(str2, true);
                    }
                }
            } catch (Throwable th2) {
                WXLogUtils.e("Weex [invokeRegisterModules]", th2);
            }
        } catch (Throwable th3) {
            str = WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_MODULES.getErrorMsg() + " \n " + th3.getMessage() + map.entrySet().toString();
        }
        if (!TextUtils.isEmpty(str)) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterModules:", str);
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_MODULES, "invokeRegisterModules", str, null);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void invokeRegisterComponents(List<Map<String, Object>> list, List<Map<String, Object>> list2) {
        String str;
        if (list == list2) {
            throw new RuntimeException("Fail receiver should not use source.");
        } else if (!isJSFrameworkInit()) {
            for (Map<String, Object> map : list) {
                list2.add(map);
            }
        } else if (list != null) {
            try {
                IWXBridge iWXBridge = this.mWXBridge;
                if (iWXBridge instanceof WXBridge) {
                    ((WXBridge) iWXBridge).registerComponentOnDataRenderNode(WXJsonUtils.fromObjectToJSONString(list));
                }
            } catch (Throwable th) {
                WXLogUtils.e("Weex [data_render register err]", th);
            }
            WXJSObject[] wXJSObjectArr = {WXWsonJSONSwitch.toWsonOrJsonWXJSObject(list)};
            try {
                str = this.mWXBridge.execJS("", null, METHOD_REGISTER_COMPONENTS, wXJSObjectArr) == 0 ? "execJS error" : null;
            } catch (Throwable th2) {
                str = WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_COMPONENT + wXJSObjectArr.toString() + WXLogUtils.getStackTrace(th2);
            }
            if (!TextUtils.isEmpty(str)) {
                WXLogUtils.e("[WXBridgeManager] invokeRegisterComponents ", str);
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_COMPONENT, METHOD_REGISTER_COMPONENTS, str, null);
            }
        }
    }

    public void destroy() {
        WXThread wXThread = this.mJSThread;
        if (wXThread != null) {
            wXThread.quit();
        }
        mBridgeManager = null;
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null) {
            hashSet.clear();
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:28:0x0070, code lost:
        if (r6 == "app-service.js") goto L_0x0076;
     */
    public void reportJSException(String str, String str2, String str3) {
        WXSDKInstance sDKInstance;
        if (str2.startsWith("jsscope::")) {
            Context applicationContext = WXEnvironment.getApplication().getApplicationContext();
            if (applicationContext != null && !BaseInfo.isBase(applicationContext)) {
                str.hashCode();
                char c = 65535;
                int i = 4;
                String str4 = "uni-jsframework.js";
                boolean z = false;
                switch (str.hashCode()) {
                    case -2076326187:
                        if (str.equals("jsframework")) {
                            c = 0;
                            break;
                        }
                        break;
                    case -518688385:
                        if (str.equals(str4)) {
                            c = 1;
                            break;
                        }
                        break;
                    case 3271632:
                        if (str.equals("jsfm")) {
                            c = 2;
                            break;
                        }
                        break;
                    case 293174862:
                        if (str.equals("app-service.js")) {
                            c = 3;
                            break;
                        }
                        break;
                    case 1984153269:
                        if (str.equals("service")) {
                            c = 4;
                            break;
                        }
                        break;
                }
                switch (c) {
                    case 0:
                    case 1:
                    case 2:
                    case 4:
                        break;
                    case 3:
                        str4 = str;
                        i = 5;
                        break;
                    default:
                        i = 6;
                        WXSDKInstance sDKInstance2 = WXSDKManager.getInstance().getSDKInstance(str);
                        if (sDKInstance2 == null) {
                            str4 = str;
                            break;
                        } else {
                            str4 = sDKInstance2.getUniPagePath();
                            break;
                        }
                }
                org.json.JSONObject createJSONObject = JSONUtil.createJSONObject(AppRuntime.getUniStatistics());
                if (createJSONObject != null) {
                    String string = JSONUtil.getString(createJSONObject, "version");
                    boolean z2 = JSONUtil.getBoolean(createJSONObject, WebLoadEvent.ENABLE);
                    if (PdrUtil.isEquals(ExifInterface.GPS_MEASUREMENT_2D, string) && z2) {
                        z = true;
                    }
                }
                if (z) {
                    UEH.commitUncatchException(applicationContext, str4, str3, i);
                }
            }
            str2 = str2.substring(9);
        }
        WXLogUtils.e("reportJSException >>>> instanceId:" + str + ", exception function:" + str2 + ", exception:" + str3);
        WXErrorCode wXErrorCode = WXErrorCode.WX_ERR_JS_EXECUTE;
        if (!(str == null || (sDKInstance = WXSDKManager.getInstance().getSDKInstance(str)) == null)) {
            sDKInstance.setHasException(true);
            if (METHOD_CREATE_INSTANCE.equals(str2) || !sDKInstance.isContentMd5Match()) {
                try {
                    if (isSkipFrameworkInit(str) || !isJSFrameworkInit() || reInitCount <= 1 || reInitCount >= 10 || sDKInstance.isNeedReLoad()) {
                        sDKInstance.onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg() + ", reportJSException >>>> instanceId:" + str + ", exception function:" + str2 + ", exception:" + str3 + ", extInitTime:" + (System.currentTimeMillis() - sInitFrameWorkTimeOrigin) + "ms" + ", extInitErrorMsg:" + sInitFrameWorkMsg.toString());
                        if (!WXEnvironment.sInAliWeex) {
                            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_JS_CREATE_INSTANCE, str2, str3, null);
                            return;
                        }
                        return;
                    }
                    new ActionReloadPage(str, true).executeAction();
                    sDKInstance.setNeedLoad(true);
                    return;
                } catch (Exception e) {
                    WXLogUtils.e(WXLogUtils.getStackTrace(e));
                }
            }
            if (METHOD_CREATE_INSTANCE.equals(str2) && !sDKInstance.getApmForInstance().hasAddView) {
                wXErrorCode = WXErrorCode.WX_RENDER_ERR_JS_CREATE_INSTANCE;
            } else if (METHOD_CREATE_INSTANCE_CONTEXT.equals(str2) && !sDKInstance.getApmForInstance().hasAddView) {
                wXErrorCode = WXErrorCode.WX_RENDER_ERR_JS_CREATE_INSTANCE_CONTEXT;
            } else if ((METHOD_UPDATE_COMPONENT_WITH_DATA.equals(str2) || METHOD_CREATE_PAGE_WITH_CONTENT.equals(str2) || METHOD_POST_TASK_TO_MSG_LOOP.equals(str2) || METHOD_JSFM_NOT_INIT_IN_EAGLE_MODE.equals(str2)) && !sDKInstance.getApmForInstance().hasAddView) {
                wXErrorCode = WXErrorCode.WX_DEGRAD_EAGLE_RENDER_ERROR;
            } else if (METHOD_CHECK_APPKEY.equals(str2)) {
                wXErrorCode = WXErrorCode.WX_KEY_EXCEPTION_VALIDAPPKEY;
            }
            sDKInstance.onJSException(wXErrorCode.getErrorCode(), str2, str3);
        }
        doReportJSException(str, str2, wXErrorCode, str3);
    }

    private void doReportJSException(String str, String str2, WXErrorCode wXErrorCode, String str3) {
        String str4;
        String str5;
        Throwable th;
        Throwable th2;
        Exception e;
        WXSDKInstance wXSDKInstance = WXSDKManager.getInstance().getAllInstanceMap().get(str);
        if (WXSDKManager.getInstance().getIWXJSExceptionAdapter() != null) {
            if (TextUtils.isEmpty(str)) {
                str = "instanceIdisNull";
            }
            if (wXSDKInstance == null && IWXUserTrackAdapter.INIT_FRAMEWORK.equals(str2)) {
                try {
                    if (WXEnvironment.getApplication() != null) {
                        try {
                            File file = new File(WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath() + INITLOGFILE);
                            if (file.exists()) {
                                if (file.length() > 0) {
                                    StringBuilder sb = new StringBuilder();
                                    try {
                                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"));
                                        while (true) {
                                            String readLine = bufferedReader.readLine();
                                            if (readLine == null) {
                                                break;
                                            }
                                            sb.append(readLine + "\n");
                                        }
                                        str4 = sb.toString();
                                        try {
                                            bufferedReader.close();
                                        } catch (Exception e2) {
                                            str5 = str4;
                                            e = e2;
                                        }
                                    } catch (Exception e3) {
                                        e = e3;
                                        str5 = null;
                                        try {
                                            WXLogUtils.e(WXLogUtils.getStackTrace(e));
                                            str4 = str5;
                                            file.delete();
                                        } catch (Throwable th3) {
                                            th2 = th3;
                                            try {
                                                WXLogUtils.e(WXLogUtils.getStackTrace(th2));
                                            } catch (Throwable th4) {
                                                th = th4;
                                            }
                                            str4 = str5;
                                            str3 = str3 + "\n" + str4;
                                            WXLogUtils.e("reportJSException:" + str3);
                                            WXExceptionUtils.commitCriticalExceptionRT(str, wXErrorCode, str2, wXErrorCode.getErrorMsg() + str3, null);
                                        }
                                        str3 = str3 + "\n" + str4;
                                        WXLogUtils.e("reportJSException:" + str3);
                                        WXExceptionUtils.commitCriticalExceptionRT(str, wXErrorCode, str2, wXErrorCode.getErrorMsg() + str3, null);
                                    }
                                } else {
                                    str4 = null;
                                }
                                try {
                                    file.delete();
                                } catch (Throwable th5) {
                                    str5 = str4;
                                    th2 = th5;
                                }
                                str3 = str3 + "\n" + str4;
                                WXLogUtils.e("reportJSException:" + str3);
                            }
                        } catch (Throwable th6) {
                            th2 = th6;
                            str5 = null;
                            WXLogUtils.e(WXLogUtils.getStackTrace(th2));
                            str4 = str5;
                            str3 = str3 + "\n" + str4;
                            WXLogUtils.e("reportJSException:" + str3);
                            WXExceptionUtils.commitCriticalExceptionRT(str, wXErrorCode, str2, wXErrorCode.getErrorMsg() + str3, null);
                        }
                    }
                    str4 = null;
                } catch (Throwable th7) {
                    th = th7;
                    str5 = null;
                    WXLogUtils.e(WXLogUtils.getStackTrace(th));
                    str4 = str5;
                    str3 = str3 + "\n" + str4;
                    WXLogUtils.e("reportJSException:" + str3);
                    WXExceptionUtils.commitCriticalExceptionRT(str, wXErrorCode, str2, wXErrorCode.getErrorMsg() + str3, null);
                }
                str3 = str3 + "\n" + str4;
                WXLogUtils.e("reportJSException:" + str3);
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, wXErrorCode, str2, wXErrorCode.getErrorMsg() + str3, null);
        }
    }

    private void registerDomModule() throws WXException {
        HashMap hashMap = new HashMap();
        hashMap.put(WXDomModule.WXDOM, WXDomModule.METHODS);
        registerModules(hashMap);
    }

    public static void updateGlobalConfig(String str) {
        if (TextUtils.isEmpty(str)) {
            str = "none";
        }
        if (!TextUtils.equals(str, globalConfig)) {
            globalConfig = str;
            WXEnvironment.addCustomOptions(GLOBAL_CONFIG_KEY, str);
            AnonymousClass26 r1 = new Runnable() {
                /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass26 */

                public void run() {
                    if (WXBridgeManager.mBridgeManager != null && WXBridgeManager.mBridgeManager.isJSFrameworkInit() && (WXBridgeManager.mBridgeManager.mWXBridge instanceof WXBridge)) {
                        ((WXBridge) WXBridgeManager.mBridgeManager.mWXBridge).nativeUpdateGlobalConfig(WXBridgeManager.globalConfig);
                    }
                    if (WXBridgeManager.globalConfig.contains(WXWsonJSONSwitch.WSON_OFF)) {
                        WXWsonJSONSwitch.USE_WSON = false;
                    } else {
                        WXWsonJSONSwitch.USE_WSON = true;
                    }
                }
            };
            if (mBridgeManager == null || !mBridgeManager.isJSFrameworkInit()) {
                r1.run();
            } else {
                mBridgeManager.post(r1);
            }
        }
    }

    public Looper getJSLooper() {
        WXThread wXThread = this.mJSThread;
        if (wXThread != null) {
            return wXThread.getLooper();
        }
        return null;
    }

    public void notifySerializeCodeCache() {
        post(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass27 */

            public void run() {
                if (WXBridgeManager.this.isJSFrameworkInit()) {
                    WXBridgeManager.this.invokeExecJS("", null, WXBridgeManager.METHOD_NOTIFY_SERIALIZE_CODE_CACHE, new WXJSObject[0]);
                }
            }
        });
    }

    public void takeJSHeapSnapshot(String str) {
        Message obtainMessage = this.mJSHandler.obtainMessage();
        obtainMessage.obj = str;
        obtainMessage.what = 13;
        obtainMessage.setTarget(this.mJSHandler);
        obtainMessage.sendToTarget();
    }

    public int callCreateBody(String str, String str2, String str3, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashSet<String> hashSet, float[] fArr, float[] fArr2, float[] fArr3) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2) || TextUtils.isEmpty(str3)) {
            WXLogUtils.d("[WXBridgeManager] call callCreateBody arguments is null");
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callCreateBody", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet2 = this.mDestroyedInstanceId;
        if (hashSet2 != null && hashSet2.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            GraphicActionCreateBody graphicActionCreateBody = new GraphicActionCreateBody(sDKInstance, str3, str2, hashMap, hashMap2, hashSet, fArr, fArr2, fArr3);
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionCreateBody.getPageId(), graphicActionCreateBody);
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callCreateBody exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callCreateBody", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public int callAddElement(String str, String str2, String str3, int i, String str4, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashSet<String> hashSet, float[] fArr, float[] fArr2, float[] fArr3, boolean z) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2) || TextUtils.isEmpty(str3)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callAddElement arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callAddElement", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet2 = this.mDestroyedInstanceId;
        if (hashSet2 != null && hashSet2.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            GraphicActionAddElement graphicActionAddElement = new GraphicActionAddElement(sDKInstance, str3, str2, str4, i, hashMap, hashMap2, hashSet, fArr, fArr2, fArr3);
            if (z) {
                sDKInstance.addInActiveAddElementAction(str3, graphicActionAddElement);
                return 1;
            }
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(str, graphicActionAddElement);
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callAddElement exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callAddElement", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public int callRemoveElement(String str, String str2) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callRemoveElement arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callRemoveElement", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            GraphicActionRemoveElement graphicActionRemoveElement = new GraphicActionRemoveElement(sDKInstance, str2);
            if (sDKInstance.getInActiveAddElementAction(str2) != null) {
                sDKInstance.removeInActiveAddElmentAction(str2);
                return 1;
            }
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionRemoveElement.getPageId(), graphicActionRemoveElement);
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRemoveElement exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callRemoveElement", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public int callMoveElement(String str, String str2, String str3, int i) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2) || TextUtils.isEmpty(str3)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callMoveElement arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callMoveElement", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            GraphicActionMoveElement graphicActionMoveElement = new GraphicActionMoveElement(sDKInstance, str2, str3, i);
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionMoveElement.getPageId(), graphicActionMoveElement);
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callMoveElement exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callMoveElement", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public int callAddEvent(String str, String str2, String str3) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2) || TextUtils.isEmpty(str3)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callAddEvent arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callAddEvent", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance != null) {
                new GraphicActionAddEvent(sDKInstance, str2, str3).executeActionOnRender();
            }
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callAddEvent exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callAddEvent", WXLogUtils.getStackTrace(e), null);
        }
        getNextTick(str);
        return 1;
    }

    public int callRemoveEvent(String str, String str2, String str3) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2) || TextUtils.isEmpty(str3)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callRemoveEvent arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callRemoveEvent", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance != null) {
                new GraphicActionRemoveEvent(sDKInstance, str2, str3).executeActionOnRender();
            }
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRemoveEvent exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callRemoveEvent", WXLogUtils.getStackTrace(e), null);
        }
        getNextTick(str);
        return 1;
    }

    public int callUpdateStyle(String str, String str2, HashMap<String, Object> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callUpdateStyle arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callUpdateStyle", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            GraphicActionUpdateStyle graphicActionUpdateStyle = new GraphicActionUpdateStyle(sDKInstance, str2, hashMap, hashMap2, hashMap3, hashMap4);
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionUpdateStyle.getPageId(), graphicActionUpdateStyle);
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callUpdateStyle exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callUpdateStyle", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public int callUpdateAttrs(String str, String str2, HashMap<String, String> hashMap) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callUpdateAttrs arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callUpdateAttrs", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            GraphicActionUpdateAttr graphicActionUpdateAttr = new GraphicActionUpdateAttr(sDKInstance, str2, hashMap);
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionUpdateAttr.getPageId(), graphicActionUpdateAttr);
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callUpdateAttrs exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callUpdateAttrs", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    private void setExceedGPULimitComponentsInfo(String str, String str2, GraphicSize graphicSize) {
        float openGLRenderLimitValue = (float) WXRenderManager.getOpenGLRenderLimitValue();
        if (openGLRenderLimitValue <= 0.0f) {
            return;
        }
        if (graphicSize.getHeight() > openGLRenderLimitValue || graphicSize.getWidth() > openGLRenderLimitValue) {
            JSONObject jSONObject = new JSONObject();
            WXComponent wXComponent = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(str, str2);
            jSONObject.put("GPU limit", (Object) String.valueOf(openGLRenderLimitValue));
            jSONObject.put("component.width", (Object) String.valueOf(graphicSize.getWidth()));
            jSONObject.put("component.height", (Object) String.valueOf(graphicSize.getHeight()));
            if (wXComponent.getComponentType() != null && !wXComponent.getComponentType().isEmpty()) {
                jSONObject.put("component.type", (Object) wXComponent.getComponentType());
            }
            if (wXComponent.getStyles() != null && !wXComponent.getStyles().isEmpty()) {
                jSONObject.put("component.style", (Object) wXComponent.getStyles().toString());
            }
            if (wXComponent.getAttrs() != null && !wXComponent.getAttrs().isEmpty()) {
                jSONObject.put("component.attr", (Object) wXComponent.getAttrs().toString());
            }
            if (wXComponent.getEvents() != null && !wXComponent.getEvents().isEmpty()) {
                jSONObject.put("component.event", (Object) wXComponent.getEvents().toString());
            }
            if (wXComponent.getMargin() != null) {
                jSONObject.put("component.margin", (Object) wXComponent.getMargin().toString());
            }
            if (wXComponent.getPadding() != null) {
                jSONObject.put("component.padding", (Object) wXComponent.getPadding().toString());
            }
            if (wXComponent.getBorder() != null) {
                jSONObject.put("component.border", (Object) wXComponent.getBorder().toString());
            }
            WXSDKManager.getInstance().getSDKInstance(str).setComponentsInfoExceedGPULimit(jSONObject);
        }
    }

    public int callAddChildToRichtext(String str, String str2, String str3, String str4, String str5, HashMap<String, String> hashMap, HashMap<String, String> hashMap2) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str3)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callAddChildToRichtext arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callAddChildToRichtext", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            GraphicActionAddChildToRichtext graphicActionAddChildToRichtext = new GraphicActionAddChildToRichtext(sDKInstance, str2, str3, str4, str5, hashMap, hashMap2);
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionAddChildToRichtext.getPageId(), graphicActionAddChildToRichtext);
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callAddChildToRichtext exception: ", WXLogUtils.getStackTrace(e));
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callAddChildToRichtext", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public int callRemoveChildFromRichtext(String str, String str2, String str3, String str4) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callRemoveChildFromRichtext arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callRemoveChildFromRichtext", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            GraphicActionRemoveChildFromRichtext graphicActionRemoveChildFromRichtext = new GraphicActionRemoveChildFromRichtext(sDKInstance, str2, str3, str4);
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionRemoveChildFromRichtext.getPageId(), graphicActionRemoveChildFromRichtext);
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRemoveChildFromRichtext exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callRemoveChildFromRichtext", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public void callBacthStart(String str) {
        if (TextUtils.isEmpty(str)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callRemoveChildFromRichtext arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callRemoveChildFromRichtext", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance != null) {
                GraphicActionBatchBegin graphicActionBatchBegin = new GraphicActionBatchBegin(sDKInstance, "");
                WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionBatchBegin.getPageId(), graphicActionBatchBegin);
            }
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRemoveChildFromRichtext exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callRemoveChildFromRichtext", WXLogUtils.getStackTrace(e), null);
        }
    }

    public void callBacthEnd(String str) {
        if (TextUtils.isEmpty(str)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callRemoveChildFromRichtext arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callRemoveChildFromRichtext", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance != null) {
                GraphicActionBatchEnd graphicActionBatchEnd = new GraphicActionBatchEnd(sDKInstance, "");
                WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionBatchEnd.getPageId(), graphicActionBatchEnd);
            }
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRemoveChildFromRichtext exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callRemoveChildFromRichtext", WXLogUtils.getStackTrace(e), null);
        }
    }

    public int callUpdateRichtextStyle(String str, String str2, HashMap<String, String> hashMap, String str3, String str4) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callUpdateRichtextStyle arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callUpdateRichtextStyle", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            GraphicActionUpdateRichtextStyle graphicActionUpdateRichtextStyle = new GraphicActionUpdateRichtextStyle(sDKInstance, str2, hashMap, str3, str4);
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionUpdateRichtextStyle.getPageId(), graphicActionUpdateRichtextStyle);
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callUpdateRichtextStyle exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callUpdateRichtextStyle", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public int callUpdateRichtextChildAttr(String str, String str2, HashMap<String, String> hashMap, String str3, String str4) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callUpdateRichtextChildAttr arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callUpdateRichtextChildAttr", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            GraphicActionUpdateRichtextAttr graphicActionUpdateRichtextAttr = new GraphicActionUpdateRichtextAttr(sDKInstance, str2, hashMap, str3, str4);
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionUpdateRichtextAttr.getPageId(), graphicActionUpdateRichtextAttr);
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callUpdateRichtextChildAttr exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callUpdateRichtextChildAttr", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public int callLayout(String str, String str2, int i, int i2, int i3, int i4, int i5, int i6, boolean z, int i7) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("[WXBridgeManager] call callLayout arguments is null");
            }
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callLayout", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            GraphicSize graphicSize = new GraphicSize((float) i6, (float) i5);
            GraphicPosition graphicPosition = new GraphicPosition((float) i3, (float) i, (float) i4, (float) i2);
            setExceedGPULimitComponentsInfo(str, str2, graphicSize);
            GraphicActionAddElement inActiveAddElementAction = sDKInstance.getInActiveAddElementAction(str2);
            if (inActiveAddElementAction != null) {
                inActiveAddElementAction.setRTL(z);
                inActiveAddElementAction.setSize(graphicSize);
                inActiveAddElementAction.setPosition(graphicPosition);
                if (!TextUtils.equals(str2, WXComponent.ROOT)) {
                    inActiveAddElementAction.setIndex(i7);
                }
                WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(str, inActiveAddElementAction);
                sDKInstance.removeInActiveAddElmentAction(str2);
                return 1;
            }
            GraphicActionLayout graphicActionLayout = new GraphicActionLayout(sDKInstance, str2, graphicPosition, graphicSize, z);
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(graphicActionLayout.getPageId(), graphicActionLayout);
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callLayout exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callLayout", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public int callAppendTreeCreateFinish(String str, String str2) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2)) {
            WXLogUtils.d("[WXBridgeManager] call callAppendTreeCreateFinish arguments is null");
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callAppendTreeCreateFinish", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(str, new GraphicActionAppendTreeCreateFinish(WXSDKManager.getInstance().getSDKInstance(str), str2));
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callAppendTreeCreateFinish exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callAppendTreeCreateFinish", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public int callCreateFinish(String str) {
        if (TextUtils.isEmpty(str)) {
            WXLogUtils.d("[WXBridgeManager] call callCreateFinish arguments is null");
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callCreateFinish", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            long currentTimeMillis = System.currentTimeMillis();
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            sDKInstance.firstScreenCreateInstanceTime(currentTimeMillis);
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(str, new GraphicActionCreateFinish(sDKInstance));
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callCreateFinish exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callCreateFinish", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public int callRenderSuccess(String str) {
        if (TextUtils.isEmpty(str)) {
            WXLogUtils.d("[WXBridgeManager] call callRenderSuccess arguments is null");
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_RENDER_ERR_BRIDGE_ARG_NULL, "callRenderSuccess", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        WXEnvironment.isApkDebugable();
        HashSet<String> hashSet = this.mDestroyedInstanceId;
        if (hashSet != null && hashSet.contains(str)) {
            return -1;
        }
        try {
            WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
            if (sDKInstance == null) {
                return 1;
            }
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(str, new GraphicActionRenderSuccess(sDKInstance));
            return 1;
        } catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRenderSuccess exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(str, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_BRIDGE, "callRenderSuccess", WXLogUtils.getStackTrace(e), null);
            return 1;
        }
    }

    public ContentBoxMeasurement getMeasurementFunc(String str, long j) {
        WXSDKInstance sDKInstance = WXSDKManager.getInstance().getSDKInstance(str);
        if (sDKInstance != null) {
            return sDKInstance.getContentBoxMeasurement(j);
        }
        return null;
    }

    public void bindMeasurementToRenderObject(long j) {
        if (isJSFrameworkInit()) {
            this.mWXBridge.bindMeasurementToRenderObject(j);
        }
    }

    public boolean notifyLayout(String str) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            return this.mWXBridge.notifyLayout(str);
        }
        return false;
    }

    public void forceLayout(String str) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.forceLayout(str);
        }
    }

    public void onInstanceClose(String str) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.onInstanceClose(str);
        }
    }

    public void setDefaultRootSize(String str, float f, float f2, boolean z, boolean z2) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.setDefaultHeightAndWidthIntoRootDom(str, f, f2, z, z2);
        }
    }

    public void setRenderContentWrapContentToCore(boolean z, String str) {
        if (isJSFrameworkInit()) {
            this.mWXBridge.setRenderContainerWrapContent(z, str);
        }
    }

    public void setStyleWidth(String str, String str2, float f) {
        setStyleWidth(str, str2, f, false);
    }

    public void setStyleWidth(String str, String str2, float f, boolean z) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.setStyleWidth(str, str2, f, z);
        }
    }

    public void setStyleHeight(String str, String str2, float f) {
        setStyleHeight(str, str2, f, false);
    }

    public void setStyleHeight(String str, String str2, float f, boolean z) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.setStyleHeight(str, str2, f, z);
        }
    }

    public long[] getFirstScreenRenderTime(String str) {
        return isJSFrameworkInit() ? this.mWXBridge.getFirstScreenRenderTime(str) : new long[]{0, 0, 0};
    }

    public long[] getRenderFinishTime(String str) {
        return isJSFrameworkInit() ? this.mWXBridge.getRenderFinishTime(str) : new long[]{0, 0, 0};
    }

    public void setDeviceDisplay(final String str, final float f, final float f2, final float f3) {
        post(new Runnable() {
            /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass28 */

            public void run() {
                WXBridgeManager.this.mWXBridge.setDeviceDisplay(str, f, f2, f3);
            }
        });
    }

    public void updateInitDeviceParams(final String str, final String str2, final String str3, final String str4) {
        if (isJSFrameworkInit()) {
            post(new Runnable() {
                /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass29 */

                public void run() {
                    WXBridgeManager.this.mWXBridge.updateInitFrameworkParams(WXConfig.deviceWidth, str, WXConfig.deviceWidth);
                }
            });
            post(new Runnable() {
                /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass30 */

                public void run() {
                    WXBridgeManager.this.mWXBridge.updateInitFrameworkParams(WXConfig.deviceHeight, str2, WXConfig.deviceHeight);
                }
            });
            post(new Runnable() {
                /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass31 */

                public void run() {
                    WXBridgeManager.this.mWXBridge.updateInitFrameworkParams("scale", str3, "scale");
                }
            });
            if (str4 != null) {
                post(new Runnable() {
                    /* class com.taobao.weex.bridge.WXBridgeManager.AnonymousClass32 */

                    public void run() {
                        WXBridgeManager.this.mWXBridge.updateInitFrameworkParams(WXConfig.androidStatusBarHeight, str4, WXConfig.androidStatusBarHeight);
                    }
                });
            }
        }
    }

    public void setMargin(String str, String str2, CSSShorthand.EDGE edge, float f) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.setMargin(str, str2, edge, f);
        }
    }

    public void setPadding(String str, String str2, CSSShorthand.EDGE edge, float f) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.setPadding(str, str2, edge, f);
        }
    }

    public void setPosition(String str, String str2, CSSShorthand.EDGE edge, float f) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.setPosition(str, str2, edge, f);
        }
    }

    public void markDirty(String str, String str2, boolean z) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.markDirty(str, str2, z);
        }
    }

    public void setPageArgument(String str, String str2, String str3) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.setPageArgument(str, str2, str3);
        }
    }

    public void reloadPageLayout(String str) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.reloadPageLayout(str);
        }
    }

    public void setDeviceDisplayOfPage(String str, float f, float f2) {
        if (isSkipFrameworkInit(str) || isJSFrameworkInit()) {
            this.mWXBridge.setDeviceDisplayOfPage(str, f, f2);
        }
    }

    public int callHasTransitionPros(String str, String str2, HashMap<String, String> hashMap) {
        WXComponent wXComponent = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(str, str2);
        if (wXComponent == null || wXComponent.getTransition() == null || wXComponent.getTransition().getProperties() == null) {
            return -1;
        }
        for (String str3 : wXComponent.getTransition().getProperties()) {
            if (hashMap.containsKey(str3)) {
                return 1;
            }
        }
        return 0;
    }

    public void registerCoreEnv(String str, String str2) {
        if (isJSFrameworkInit()) {
            this.mWXBridge.registerCoreEnv(str, str2);
        } else {
            mWeexCoreEnvOptions.put(str, str2);
        }
    }

    private void onJsFrameWorkInitSuccees() {
        for (Map.Entry<String, String> entry : mWeexCoreEnvOptions.entrySet()) {
            this.mWXBridge.registerCoreEnv(entry.getKey(), entry.getValue());
        }
        mWeexCoreEnvOptions.clear();
    }

    public void setViewPortWidth(String str, float f) {
        if (isJSFrameworkInit()) {
            this.mWXBridge.setViewPortWidth(str, f);
        }
    }

    public void setFlexDirectionDef(String str) {
        if (isJSFrameworkInit()) {
            this.mWXBridge.setFlexDirectionDef(str);
        }
    }

    public String getWeexCoreThreadStackTrace() {
        if (this.mJSThread == null) {
            return "null == mJSThread";
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(StringUtil.format("Thread Name: '%s'\n", this.mJSThread.getName()));
            sb.append(String.format(Locale.ENGLISH, "\"%s\" prio=%d tid=%d %s\n", this.mJSThread.getName(), Integer.valueOf(this.mJSThread.getPriority()), Long.valueOf(this.mJSThread.getId()), this.mJSThread.getState()));
            StackTraceElement[] stackTrace = this.mJSThread.getStackTrace();
            int length = stackTrace.length;
            for (int i = 0; i < length; i++) {
                sb.append(StringUtil.format("\tat %s\n", stackTrace[i].toString()));
            }
        } catch (Exception e) {
            Log.e("weex", "getJSThreadStackTrace error:", e);
        }
        return sb.toString();
    }

    public String encryptGetClientKeyPayload(String str, String str2, String str3) {
        IWXBridge iWXBridge = this.mWXBridge;
        return iWXBridge instanceof WXBridge ? ((WXBridge) iWXBridge).encryptGetClientKeyPayload(str, str2, str3) : "";
    }

    public String encrypt(String str, String str2, String str3, String str4) {
        IWXBridge iWXBridge = this.mWXBridge;
        return iWXBridge instanceof WXBridge ? ((WXBridge) iWXBridge).encrypt(str, str2, str3, str4) : "";
    }

    public String decrypt(String str, String str2, String str3, String str4) {
        IWXBridge iWXBridge = this.mWXBridge;
        return iWXBridge instanceof WXBridge ? ((WXBridge) iWXBridge).decrypt(str, str2, str3, str4) : "";
    }

    public boolean verifyClientKeyPayload(String str, String str2, String str3) {
        IWXBridge iWXBridge = this.mWXBridge;
        if (iWXBridge instanceof WXBridge) {
            return ((WXBridge) iWXBridge).verifyClientKeyPayload(str, str2, str3);
        }
        return false;
    }
}
