package com.taobao.weex.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.io.Serializable;
import java.lang.reflect.Method;

public class SystemMessageHandler extends Handler implements Serializable {
    private static final int SCHEDULED_WORK = 1;
    private static final String TAG = "SystemMessageHandler";
    private Method mMessageMethodSetAsynchronous;
    private long mMessagePumpDelegateNative;

    private native void nativeRunWork(long j);

    /* JADX WARNING: Illegal instructions before constructor call */
    private SystemMessageHandler(long j, boolean z) {
        super(r6);
        Looper looper;
        if (z) {
            looper = Looper.getMainLooper();
        } else {
            looper = Looper.myLooper();
        }
        this.mMessagePumpDelegateNative = 0;
        this.mMessagePumpDelegateNative = j;
        try {
            this.mMessageMethodSetAsynchronous = Class.forName("android.os.Message").getMethod("setAsynchronous", Boolean.TYPE);
        } catch (ClassNotFoundException e) {
            Log.e(TAG, "Failed to find android.os.Message class:" + e);
        } catch (NoSuchMethodException e2) {
            Log.e(TAG, "Failed to load Message.setAsynchronous method:" + e2);
        } catch (RuntimeException e3) {
            Log.e(TAG, "Exception while loading Message.setAsynchronous method: " + e3);
        }
    }

    public static SystemMessageHandler create(long j, boolean z) {
        return new SystemMessageHandler(j, z);
    }

    private void scheduleWork() {
        sendMessage(obtainAsyncMessage(1));
    }

    private void scheduleDelayedWork(long j) {
        sendMessageDelayed(obtainAsyncMessage(1), j);
    }

    private void stop() {
        removeMessages(1);
    }

    private Message obtainAsyncMessage(int i) {
        Message obtain = Message.obtain();
        obtain.what = i;
        return obtain;
    }

    public void handleMessage(Message message) {
        nativeRunWork(this.mMessagePumpDelegateNative);
    }
}
