package com.taobao.weex.appfram.storage;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.taobao.weex.utils.WXLogUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class WXSQLiteOpenHelper extends SQLiteOpenHelper {
    static final String COLUMN_KEY = "key";
    static final String COLUMN_PERSISTENT = "persistent";
    static final String COLUMN_TIMESTAMP = "timestamp";
    static final String COLUMN_VALUE = "value";
    private static final String DATABASE_NAME = "WXStorage";
    private static final int DATABASE_VERSION = 2;
    private static final int SLEEP_TIME_MS = 30;
    private static final String STATEMENT_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS default_wx_storage (key TEXT PRIMARY KEY,value TEXT NOT NULL,timestamp TEXT NOT NULL,persistent INTEGER DEFAULT 0)";
    static final String TABLE_STORAGE = "default_wx_storage";
    static final String TAG_STORAGE = "weex_storage";
    static SimpleDateFormat sDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private Context mContext;
    private SQLiteDatabase mDb;
    private long mMaximumDatabaseSize = 52428800;

    public WXSQLiteOpenHelper(Context context) {
        super(context, DATABASE_NAME, (SQLiteDatabase.CursorFactory) null, 2);
        this.mContext = context;
    }

    public SQLiteDatabase getDatabase() {
        ensureDatabase();
        return this.mDb;
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL(STATEMENT_CREATE_TABLE);
    }

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int i, int i2) {
        if (i != i2) {
            if (i2 == 2) {
                boolean z = true;
                if (i == 1) {
                    WXLogUtils.d(TAG_STORAGE, "storage is updating from version " + i + " to version " + i2);
                    try {
                        long currentTimeMillis = System.currentTimeMillis();
                        sQLiteDatabase.beginTransaction();
                        WXLogUtils.d(TAG_STORAGE, "exec sql : " + "ALTER TABLE default_wx_storage ADD COLUMN timestamp TEXT;");
                        sQLiteDatabase.execSQL("ALTER TABLE default_wx_storage ADD COLUMN timestamp TEXT;");
                        WXLogUtils.d(TAG_STORAGE, "exec sql : " + "ALTER TABLE default_wx_storage ADD COLUMN persistent INTEGER;");
                        sQLiteDatabase.execSQL("ALTER TABLE default_wx_storage ADD COLUMN persistent INTEGER;");
                        String str = "UPDATE default_wx_storage SET timestamp = '" + sDateFormatter.format(new Date()) + "' , " + COLUMN_PERSISTENT + " = 0";
                        WXLogUtils.d(TAG_STORAGE, "exec sql : " + str);
                        sQLiteDatabase.execSQL(str);
                        sQLiteDatabase.setTransactionSuccessful();
                        WXLogUtils.d(TAG_STORAGE, "storage updated success (" + (System.currentTimeMillis() - currentTimeMillis) + "ms)");
                    } catch (Exception e) {
                        WXLogUtils.d(TAG_STORAGE, "storage updated failed from version " + i + " to version " + i2 + "," + e.getMessage());
                        z = false;
                    } catch (Throwable th) {
                        sQLiteDatabase.endTransaction();
                        throw th;
                    }
                    sQLiteDatabase.endTransaction();
                    if (!z) {
                        WXLogUtils.d(TAG_STORAGE, "storage is rollback,all data will be removed");
                        deleteDB();
                        onCreate(sQLiteDatabase);
                        return;
                    }
                    return;
                }
            }
            deleteDB();
            onCreate(sQLiteDatabase);
        }
    }

    /* access modifiers changed from: package-private */
    public synchronized void ensureDatabase() {
        SQLiteDatabase sQLiteDatabase = this.mDb;
        if (sQLiteDatabase == null || !sQLiteDatabase.isOpen()) {
            int i = 0;
            while (true) {
                if (i < 2) {
                    if (i <= 0) {
                        break;
                    }
                    try {
                        deleteDB();
                        break;
                    } catch (SQLiteException e) {
                        e.printStackTrace();
                        try {
                            Thread.sleep(30);
                        } catch (InterruptedException unused) {
                            Thread.currentThread().interrupt();
                        }
                        i++;
                    } catch (Throwable th) {
                        this.mDb = null;
                        WXLogUtils.d(TAG_STORAGE, "ensureDatabase failed, throwable = " + th.getMessage());
                    }
                } else {
                    break;
                }
            }
            this.mDb = getWritableDatabase();
            SQLiteDatabase sQLiteDatabase2 = this.mDb;
            if (sQLiteDatabase2 != null) {
                createTableIfNotExists(sQLiteDatabase2);
                this.mDb.setMaximumSize(this.mMaximumDatabaseSize);
            }
        }
    }

    public synchronized void setMaximumSize(long j) {
        this.mMaximumDatabaseSize = j;
        SQLiteDatabase sQLiteDatabase = this.mDb;
        if (sQLiteDatabase != null) {
            sQLiteDatabase.setMaximumSize(j);
        }
    }

    private boolean deleteDB() {
        closeDatabase();
        return this.mContext.deleteDatabase(DATABASE_NAME);
    }

    public synchronized void closeDatabase() {
        SQLiteDatabase sQLiteDatabase = this.mDb;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            this.mDb.close();
            this.mDb = null;
        }
    }

    private void createTableIfNotExists(SQLiteDatabase sQLiteDatabase) {
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.rawQuery("SELECT DISTINCT tbl_name FROM sqlite_master WHERE tbl_name = 'default_wx_storage'", null);
            if (cursor == null || cursor.getCount() <= 0) {
                sQLiteDatabase.execSQL(STATEMENT_CREATE_TABLE);
                if (cursor == null) {
                    return;
                }
                cursor.close();
            } else if (cursor != null) {
                cursor.close();
            }
        } catch (Exception e) {
            e.printStackTrace();
            if (0 == 0) {
            }
        } catch (Throwable th) {
            if (0 != 0) {
                cursor.close();
            }
            throw th;
        }
    }
}
