package com.fm.openinstall;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import io.openinstall.sdk.ag;
import io.openinstall.sdk.ai;
import io.openinstall.sdk.am;
import io.openinstall.sdk.av;
import io.openinstall.sdk.cc;
import io.openinstall.sdk.cd;
import io.openinstall.sdk.l;

public final class OpenInstallHelper {
    private OpenInstallHelper() {
    }

    public static String checkGaid(Context context) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            if (cd.a) {
                cd.b("不能在UI线程调用", new Object[0]);
            }
            return null;
        }
        ag.a a = ag.a(context.getApplicationContext());
        if (a != null) {
            return a.a();
        }
        return null;
    }

    public static String checkOaid(Context context) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            ai aiVar = new ai();
            aiVar.a(context.getApplicationContext());
            return aiVar.a();
        } else if (!cd.a) {
            return null;
        } else {
            cd.b("不能在UI线程调用", new Object[0]);
            return null;
        }
    }

    public static boolean checkSimulator(Context context) {
        return l.a().a(context);
    }

    public static boolean isLauncherFromYYB(Activity activity, Intent intent) {
        Uri referrer;
        boolean z = false;
        if (activity == null || intent == null || TextUtils.isEmpty(intent.getAction()) || intent.getCategories() == null || !intent.getAction().equals("android.intent.action.MAIN") || !intent.getCategories().contains("android.intent.category.LAUNCHER") || Build.VERSION.SDK_INT < 22 || (referrer = activity.getReferrer()) == null) {
            return false;
        }
        String authority = referrer.getAuthority();
        if (TextUtils.isEmpty(authority)) {
            return false;
        }
        if (authority.equalsIgnoreCase(cc.o) || authority.equalsIgnoreCase(cc.p) || authority.equalsIgnoreCase(cc.n)) {
            z = true;
        }
        if (authority.equalsIgnoreCase(cc.q) || authority.equalsIgnoreCase(cc.r) || authority.equalsIgnoreCase(cc.s)) {
            return true;
        }
        return z;
    }

    public static boolean isSchemeWakeup(Intent intent) {
        if (!(intent == null || intent.getData() == null || intent.getAction() == null)) {
            String action = intent.getAction();
            String host = intent.getData().getHost();
            if (!TextUtils.isEmpty(host) && action.equals("android.intent.action.VIEW")) {
                return av.a(host);
            }
        }
        return false;
    }

    public static boolean isTrackData(ClipData clipData) {
        am a = am.a(clipData);
        if (a == null) {
            return false;
        }
        return a.c(1) || a.c(2);
    }
}
