package com.fm.openinstall;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.fm.openinstall.listener.AppInstallListener;
import com.fm.openinstall.listener.AppInstallRetryAdapter;
import com.fm.openinstall.listener.AppWakeUpListener;
import com.fm.openinstall.listener.ResultCallback;
import io.openinstall.sdk.b;
import io.openinstall.sdk.bg;
import io.openinstall.sdk.cd;
import io.openinstall.sdk.ce;
import io.openinstall.sdk.cf;
import io.openinstall.sdk.d;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Map;

public final class OpenInstall {
    private static volatile boolean a = false;
    private static volatile boolean b = false;

    private OpenInstall() {
    }

    private static void a(Context context, Configuration configuration, Runnable runnable) {
        init(context, configuration);
        if (runnable != null) {
            runnable.run();
            d.a().a((Runnable) null);
        }
    }

    private static boolean a() {
        if (b) {
            return true;
        }
        if (cd.a) {
            cd.c("请先调用 init(Context) 初始化", new Object[0]);
        }
        return false;
    }

    public static void clipBoardEnabled(boolean z) {
        d.a().a(Boolean.valueOf(z));
    }

    public static void getInstall(AppInstallListener appInstallListener) {
        getInstall(appInstallListener, 10);
    }

    public static void getInstall(AppInstallListener appInstallListener, int i) {
        if (!a()) {
            appInstallListener.onInstallFinish(null, bg.a.NOT_INIT.a().c());
            return;
        }
        if (cd.a && i < 5) {
            cd.b("getInstall设置超时时间过小，易造成数据获取失败，请增大超时时间或调整调用时机", new Object[0]);
        }
        b.a().a(false, i, appInstallListener);
    }

    public static void getInstallCanRetry(AppInstallRetryAdapter appInstallRetryAdapter, int i) {
        if (!a()) {
            appInstallRetryAdapter.onInstallFinish(null, bg.a.NOT_INIT.a().c());
        } else {
            b.a().a(true, i, (AppInstallListener) appInstallRetryAdapter);
        }
    }

    public static String getOpid() {
        if (!a()) {
            return null;
        }
        return b.a().b();
    }

    @Deprecated
    public static void getUpdateApk(ResultCallback<File> resultCallback) {
        if (!a()) {
            resultCallback.onResult(null, bg.a.NOT_INIT.a().c());
        } else {
            b.a().a(resultCallback);
        }
    }

    public static String getVersion() {
        return "2.8.2";
    }

    public static boolean getWakeUp(Intent intent, AppWakeUpListener appWakeUpListener) {
        if (!a() || !OpenInstallHelper.isSchemeWakeup(intent)) {
            return false;
        }
        b.a().a(intent, appWakeUpListener);
        return true;
    }

    public static void getWakeUpAlwaysCallback(Intent intent, AppWakeUpListener appWakeUpListener) {
        if (!a()) {
            appWakeUpListener.onWakeUpFinish(null, bg.a.NOT_INIT.a().c());
        } else if (OpenInstallHelper.isSchemeWakeup(intent)) {
            b.a().a(intent, appWakeUpListener);
        } else {
            appWakeUpListener.onWakeUpFinish(null, bg.a.INVALID_DATA.a().c());
        }
    }

    public static boolean getWakeUpYYB(Activity activity, Intent intent, AppWakeUpListener appWakeUpListener) {
        if (!a()) {
            return false;
        }
        if (OpenInstallHelper.isSchemeWakeup(intent)) {
            b.a().a(intent, appWakeUpListener);
            return true;
        } else if (!OpenInstallHelper.isLauncherFromYYB(activity, intent)) {
            return false;
        } else {
            b.a().a(appWakeUpListener);
            return true;
        }
    }

    public static void getWakeUpYYBAlwaysCallback(Activity activity, Intent intent, AppWakeUpListener appWakeUpListener) {
        if (!a()) {
            appWakeUpListener.onWakeUpFinish(null, bg.a.NOT_INIT.a().c());
        } else if (OpenInstallHelper.isSchemeWakeup(intent)) {
            b.a().a(intent, appWakeUpListener);
        } else if (OpenInstallHelper.isLauncherFromYYB(activity, intent)) {
            b.a().a(appWakeUpListener);
        } else {
            appWakeUpListener.onWakeUpFinish(null, bg.a.INVALID_DATA.a().c());
        }
    }

    public static void init(Context context) {
        init(context, Configuration.getDefault());
    }

    public static void init(Context context, Configuration configuration) {
        String a2 = ce.a(context);
        if (!TextUtils.isEmpty(a2)) {
            init(context, a2, configuration);
            return;
        }
        throw new IllegalArgumentException("请在AndroidManifest.xml中配置OpenInstall提供的AppKey");
    }

    public static void init(Context context, String str) {
        init(context, str, Configuration.getDefault());
    }

    public static void init(Context context, String str, Configuration configuration) {
        long currentTimeMillis = System.currentTimeMillis();
        d.a().a(configuration);
        WeakReference<Activity> weakReference = context instanceof Activity ? new WeakReference<>((Activity) context) : null;
        synchronized (OpenInstall.class) {
            if (!a) {
                if (cd.a) {
                    cd.b("未提前调用 preInit，可能导致统计数据不准确。", new Object[0]);
                }
                preInit(context, str);
            }
            if (!b) {
                b.a().a(weakReference, currentTimeMillis);
                b = true;
            }
        }
    }

    @Deprecated
    public static void initWithPermission(Activity activity, Configuration configuration) {
        initWithPermission(activity, configuration, null);
    }

    @Deprecated
    public static void initWithPermission(Activity activity, Configuration configuration, Runnable runnable) {
        if (cd.a) {
            cd.b("initWithPermission 方法在后续版本中将被移除，请自行进行权限申请", new Object[0]);
        }
        if (!cf.a(activity)) {
            cf.a(activity, new String[]{"android.permission.READ_PHONE_STATE"}, 987);
            d.a().a(activity.getApplicationContext());
            d.a().a(runnable);
            d.a().a(configuration);
            return;
        }
        a(activity.getApplicationContext(), configuration, runnable);
    }

    public static void onRequestPermissionsResult(int i, String[] strArr, int[] iArr) {
        Context b2 = d.a().b();
        if (b2 != null && i == 987) {
            a(b2, d.a().e(), d.a().j());
        }
    }

    public static void preInit(Context context) {
        String a2 = ce.a(context);
        if (!TextUtils.isEmpty(a2)) {
            preInit(context, a2);
            return;
        }
        throw new IllegalArgumentException("请在AndroidManifest.xml中配置OpenInstall提供的AppKey");
    }

    public static void preInit(Context context, String str) {
        if (context == null) {
            throw new IllegalArgumentException("context不能为空");
        } else if (!TextUtils.isEmpty(str)) {
            if (cd.a) {
                cd.a("SDK Version : " + getVersion(), new Object[0]);
            }
            d.a().a(context.getApplicationContext());
            d.a().a(str);
            synchronized (OpenInstall.class) {
                if (!a) {
                    b.a().c();
                    a = true;
                }
            }
        } else {
            throw new IllegalArgumentException("请前往OpenInstall控制台的 “Android集成” -> “Android应用配置” 中获取AppKey");
        }
    }

    public static void reportEffectPoint(String str, long j) {
        if (a()) {
            b.a().a(str, j);
        }
    }

    public static void reportEffectPoint(String str, long j, Map<String, String> map) {
        if (a()) {
            b.a().a(str, j, map);
        }
    }

    public static void reportRegister() {
        if (a()) {
            b.a().d();
        }
    }

    public static void reportShare(String str, SharePlatform sharePlatform, ResultCallback<Void> resultCallback) {
        reportShare(str, sharePlatform.name(), resultCallback);
    }

    public static void reportShare(String str, String str2, ResultCallback<Void> resultCallback) {
        if (!a()) {
            resultCallback.onResult(null, bg.a.NOT_INIT.a().c());
        } else {
            b.a().a(str, str2, resultCallback);
        }
    }

    @Deprecated
    public static void serialEnabled(boolean z) {
        d.a().b(Boolean.valueOf(z));
    }

    public static void setChannel(String str) {
        d.a().b(str);
    }

    public static void setDebug(boolean z) {
        cd.a = z;
    }

    public static void setTrackData(ClipData clipData) {
        d.a().a(clipData);
        d.a().a((Boolean) false);
    }
}
