package com.facebook.soloader;

import android.content.Context;
import com.facebook.soloader.UnpackingSoSource;
import com.taobao.weex.el.parse.Operators;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public final class ExoSoSource extends UnpackingSoSource {
    public ExoSoSource(Context context, String str) {
        super(context, str);
    }

    /* access modifiers changed from: protected */
    @Override // com.facebook.soloader.UnpackingSoSource
    public UnpackingSoSource.Unpacker makeUnpacker() throws IOException {
        return new ExoUnpacker(this);
    }

    private final class ExoUnpacker extends UnpackingSoSource.Unpacker {
        private final FileDso[] mDsos;

        /* JADX WARNING: Code restructure failed: missing block: B:35:0x00f3, code lost:
            r0 = move-exception;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:37:0x00f5, code lost:
            if (r0 != null) goto L_0x00f7;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:39:?, code lost:
            r8.close();
         */
        /* JADX WARNING: Code restructure failed: missing block: B:40:0x00fb, code lost:
            r0 = move-exception;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:41:0x00fc, code lost:
            r0.addSuppressed(r0);
         */
        /* JADX WARNING: Code restructure failed: missing block: B:42:0x0101, code lost:
            r8.close();
         */
        /* JADX WARNING: Code restructure failed: missing block: B:43:0x0104, code lost:
            throw r0;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:48:0x0108, code lost:
            r0 = move-exception;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:50:0x010a, code lost:
            if (r0 != null) goto L_0x010c;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:52:?, code lost:
            r10.close();
         */
        /* JADX WARNING: Code restructure failed: missing block: B:53:0x0110, code lost:
            r0 = move-exception;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:54:0x0111, code lost:
            r0.addSuppressed(r0);
         */
        /* JADX WARNING: Code restructure failed: missing block: B:55:0x0116, code lost:
            r10.close();
         */
        /* JADX WARNING: Code restructure failed: missing block: B:56:0x0119, code lost:
            throw r0;
         */
        ExoUnpacker(UnpackingSoSource unpackingSoSource) throws IOException {
            boolean z;
            Context context = ExoSoSource.this.mContext;
            File file = new File("/data/local/tmp/exopackage/" + context.getPackageName() + "/native-libs/");
            ArrayList arrayList = new ArrayList();
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            String[] supportedAbis = SysUtil.getSupportedAbis();
            int length = supportedAbis.length;
            int i = 0;
            int i2 = 0;
            while (i2 < length) {
                String str = supportedAbis[i2];
                File file2 = new File(file, str);
                if (file2.isDirectory()) {
                    linkedHashSet.add(str);
                    File file3 = new File(file2, "metadata.txt");
                    if (file3.isFile()) {
                        FileReader fileReader = new FileReader(file3);
                        BufferedReader bufferedReader = new BufferedReader(fileReader);
                        while (true) {
                            String readLine = bufferedReader.readLine();
                            if (readLine == null) {
                                bufferedReader.close();
                                fileReader.close();
                                break;
                            } else if (readLine.length() != 0) {
                                int indexOf = readLine.indexOf(32);
                                if (indexOf != -1) {
                                    String str2 = readLine.substring(i, indexOf) + ".so";
                                    int size = arrayList.size();
                                    int i3 = 0;
                                    while (true) {
                                        if (i3 >= size) {
                                            z = false;
                                            break;
                                        } else if (((FileDso) arrayList.get(i3)).name.equals(str2)) {
                                            z = true;
                                            break;
                                        } else {
                                            i3++;
                                        }
                                    }
                                    if (!z) {
                                        String substring = readLine.substring(indexOf + 1);
                                        arrayList.add(new FileDso(str2, substring, new File(file2, substring)));
                                    }
                                    i = 0;
                                } else {
                                    throw new RuntimeException("illegal line in exopackage metadata: [" + readLine + Operators.ARRAY_END_STR);
                                }
                            }
                        }
                    } else {
                        continue;
                    }
                }
                i2++;
                i = 0;
            }
            unpackingSoSource.setSoSourceAbis((String[]) linkedHashSet.toArray(new String[linkedHashSet.size()]));
            this.mDsos = (FileDso[]) arrayList.toArray(new FileDso[arrayList.size()]);
        }

        /* access modifiers changed from: protected */
        @Override // com.facebook.soloader.UnpackingSoSource.Unpacker
        public UnpackingSoSource.DsoManifest getDsoManifest() throws IOException {
            return new UnpackingSoSource.DsoManifest(this.mDsos);
        }

        /* access modifiers changed from: protected */
        @Override // com.facebook.soloader.UnpackingSoSource.Unpacker
        public UnpackingSoSource.InputDsoIterator openDsoIterator() throws IOException {
            return new FileBackedInputDsoIterator();
        }

        private final class FileBackedInputDsoIterator extends UnpackingSoSource.InputDsoIterator {
            private int mCurrentDso;

            private FileBackedInputDsoIterator() {
            }

            @Override // com.facebook.soloader.UnpackingSoSource.InputDsoIterator
            public boolean hasNext() {
                return this.mCurrentDso < ExoUnpacker.this.mDsos.length;
            }

            @Override // com.facebook.soloader.UnpackingSoSource.InputDsoIterator
            public UnpackingSoSource.InputDso next() throws IOException {
                FileDso[] fileDsoArr = ExoUnpacker.this.mDsos;
                int i = this.mCurrentDso;
                this.mCurrentDso = i + 1;
                FileDso fileDso = fileDsoArr[i];
                FileInputStream fileInputStream = new FileInputStream(fileDso.backingFile);
                try {
                    return new UnpackingSoSource.InputDso(fileDso, fileInputStream);
                } catch (Throwable th) {
                    fileInputStream.close();
                    throw th;
                }
            }
        }
    }

    /* access modifiers changed from: private */
    public static final class FileDso extends UnpackingSoSource.Dso {
        final File backingFile;

        FileDso(String str, String str2, File file) {
            super(str, str2);
            this.backingFile = file;
        }
    }
}
