package com.facebook.imagepipeline.producers;

import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import javax.annotation.Nullable;

public final class ThumbnailSizeChecker {
    public static final float ACCEPTABLE_REQUESTED_TO_ACTUAL_SIZE_RATIO = 1.3333334f;
    private static final int ROTATED_90_DEGREES_CLOCKWISE = 90;
    private static final int ROTATED_90_DEGREES_COUNTER_CLOCKWISE = 270;

    public static int getAcceptableSize(int i) {
        return (int) (((float) i) * 1.3333334f);
    }

    public static boolean isImageBigEnough(int i, int i2, @Nullable ResizeOptions resizeOptions) {
        if (resizeOptions == null) {
            if (((float) getAcceptableSize(i)) < 2048.0f || getAcceptableSize(i2) < 2048) {
                return false;
            }
            return true;
        } else if (getAcceptableSize(i) < resizeOptions.width || getAcceptableSize(i2) < resizeOptions.height) {
            return false;
        } else {
            return true;
        }
    }

    public static boolean isImageBigEnough(@Nullable EncodedImage encodedImage, @Nullable ResizeOptions resizeOptions) {
        if (encodedImage == null) {
            return false;
        }
        int rotationAngle = encodedImage.getRotationAngle();
        if (rotationAngle == 90 || rotationAngle == 270) {
            return isImageBigEnough(encodedImage.getHeight(), encodedImage.getWidth(), resizeOptions);
        }
        return isImageBigEnough(encodedImage.getWidth(), encodedImage.getHeight(), resizeOptions);
    }
}
