package com.facebook.imagepipeline.filter;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import com.facebook.common.internal.Preconditions;

public abstract class RenderScriptBlurFilter {
    public static final int BLUR_MAX_RADIUS = 25;

    /* JADX WARNING: Removed duplicated region for block: B:17:0x0062  */
    public static void blurBitmap(Bitmap bitmap, Bitmap bitmap2, Context context, int i) {
        Throwable th;
        Preconditions.checkNotNull(bitmap);
        Preconditions.checkNotNull(bitmap2);
        Preconditions.checkNotNull(context);
        Preconditions.checkArgument(Boolean.valueOf(i > 0 && i <= 25));
        RenderScript renderScript = null;
        try {
            RenderScript renderScript2 = (RenderScript) Preconditions.checkNotNull(RenderScript.create(context));
            try {
                ScriptIntrinsicBlur create = ScriptIntrinsicBlur.create(renderScript2, Element.U8_4(renderScript2));
                Allocation allocation = (Allocation) Preconditions.checkNotNull(Allocation.createFromBitmap(renderScript2, bitmap2));
                Allocation allocation2 = (Allocation) Preconditions.checkNotNull(Allocation.createFromBitmap(renderScript2, bitmap));
                create.setRadius((float) i);
                create.setInput(allocation);
                create.forEach(allocation2);
                allocation2.copyTo(bitmap);
                create.destroy();
                allocation.destroy();
                allocation2.destroy();
                if (renderScript2 != null) {
                    renderScript2.destroy();
                }
            } catch (Throwable th2) {
                th = th2;
                renderScript = renderScript2;
                if (renderScript != null) {
                    renderScript.destroy();
                }
                throw th;
            }
        } catch (Throwable th3) {
            th = th3;
            if (renderScript != null) {
            }
            throw th;
        }
    }

    public static boolean canUseRenderScript() {
        return Build.VERSION.SDK_INT >= 17;
    }
}
