package com.facebook.common.references;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import javax.annotation.Nullable;

public class DefaultCloseableReference<T> extends CloseableReference<T> {
    private static final String TAG = "DefaultCloseableReference";

    private DefaultCloseableReference(SharedReference<T> sharedReference, CloseableReference.LeakHandler leakHandler, @Nullable Throwable th) {
        super(sharedReference, leakHandler, th);
    }

    DefaultCloseableReference(T t, ResourceReleaser<T> resourceReleaser, CloseableReference.LeakHandler leakHandler, @Nullable Throwable th) {
        super(t, resourceReleaser, leakHandler, th);
    }

    @Override // com.facebook.common.references.CloseableReference, com.facebook.common.references.CloseableReference, java.lang.Object
    public CloseableReference<T> clone() {
        Preconditions.checkState(isValid());
        return new DefaultCloseableReference(this.mSharedReference, this.mLeakHandler, this.mStacktrace != null ? new Throwable(this.mStacktrace) : null);
    }

    /* access modifiers changed from: protected */
    /* JADX WARNING: Code restructure failed: missing block: B:10:0x0031, code lost:
        if (r0 != null) goto L_0x0035;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:11:0x0033, code lost:
        r0 = null;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:12:0x0035, code lost:
        r0 = r0.getClass().getName();
     */
    /* JADX WARNING: Code restructure failed: missing block: B:13:0x003d, code lost:
        r3[2] = r0;
        com.facebook.common.logging.FLog.w(com.facebook.common.references.DefaultCloseableReference.TAG, "Finalized without closing: %x %x (type = %s)", r3);
        r6.mLeakHandler.reportLeak(r6.mSharedReference, r6.mStacktrace);
        close();
        super.finalize();
     */
    /* JADX WARNING: Code restructure failed: missing block: B:14:0x0051, code lost:
        return;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:9:0x000b, code lost:
        r0 = r6.mSharedReference.get();
        r3 = new java.lang.Object[3];
        r3[0] = java.lang.Integer.valueOf(java.lang.System.identityHashCode(r6));
        r3[1] = java.lang.Integer.valueOf(java.lang.System.identityHashCode(r6.mSharedReference));
     */
    @Override // com.facebook.common.references.CloseableReference, java.lang.Object
    public void finalize() throws Throwable {
        try {
            synchronized (this) {
                if (this.mIsClosed) {
                }
            }
        } finally {
            super.finalize();
        }
    }
}
