package com.dcloud.zxing2.pdf417.encoder;

/* access modifiers changed from: package-private */
public final class BarcodeRow {
    private int currentLocation = 0;
    private final byte[] row;

    BarcodeRow(int i) {
        this.row = new byte[i];
    }

    /* access modifiers changed from: package-private */
    public void addBar(boolean z, int i) {
        for (int i2 = 0; i2 < i; i2++) {
            int i3 = this.currentLocation;
            this.currentLocation = i3 + 1;
            set(i3, z);
        }
    }

    /* access modifiers changed from: package-private */
    public byte[] getScaledRow(int i) {
        int length = this.row.length * i;
        byte[] bArr = new byte[length];
        for (int i2 = 0; i2 < length; i2++) {
            bArr[i2] = this.row[i2 / i];
        }
        return bArr;
    }

    /* access modifiers changed from: package-private */
    public void set(int i, byte b) {
        this.row[i] = b;
    }

    /* access modifiers changed from: package-private */
    public void set(int i, boolean z) {
        this.row[i] = z ? (byte) 1 : 0;
    }
}
