package com.dcloud.zxing2.datamatrix.encoder;

import java.util.Arrays;

public class DefaultPlacement {
    private final byte[] bits;
    private final CharSequence codewords;
    private final int numcols;
    private final int numrows;

    public DefaultPlacement(CharSequence charSequence, int i, int i2) {
        this.codewords = charSequence;
        this.numcols = i;
        this.numrows = i2;
        byte[] bArr = new byte[(i * i2)];
        this.bits = bArr;
        Arrays.fill(bArr, (byte) -1);
    }

    private void corner1(int i) {
        module(this.numrows - 1, 0, i, 1);
        module(this.numrows - 1, 1, i, 2);
        module(this.numrows - 1, 2, i, 3);
        module(0, this.numcols - 2, i, 4);
        module(0, this.numcols - 1, i, 5);
        module(1, this.numcols - 1, i, 6);
        module(2, this.numcols - 1, i, 7);
        module(3, this.numcols - 1, i, 8);
    }

    private void corner2(int i) {
        module(this.numrows - 3, 0, i, 1);
        module(this.numrows - 2, 0, i, 2);
        module(this.numrows - 1, 0, i, 3);
        module(0, this.numcols - 4, i, 4);
        module(0, this.numcols - 3, i, 5);
        module(0, this.numcols - 2, i, 6);
        module(0, this.numcols - 1, i, 7);
        module(1, this.numcols - 1, i, 8);
    }

    private void corner3(int i) {
        module(this.numrows - 3, 0, i, 1);
        module(this.numrows - 2, 0, i, 2);
        module(this.numrows - 1, 0, i, 3);
        module(0, this.numcols - 2, i, 4);
        module(0, this.numcols - 1, i, 5);
        module(1, this.numcols - 1, i, 6);
        module(2, this.numcols - 1, i, 7);
        module(3, this.numcols - 1, i, 8);
    }

    private void corner4(int i) {
        module(this.numrows - 1, 0, i, 1);
        module(this.numrows - 1, this.numcols - 1, i, 2);
        module(0, this.numcols - 3, i, 3);
        module(0, this.numcols - 2, i, 4);
        module(0, this.numcols - 1, i, 5);
        module(1, this.numcols - 3, i, 6);
        module(1, this.numcols - 2, i, 7);
        module(1, this.numcols - 1, i, 8);
    }

    private void module(int i, int i2, int i3, int i4) {
        if (i < 0) {
            int i5 = this.numrows;
            i += i5;
            i2 += 4 - ((i5 + 4) % 8);
        }
        if (i2 < 0) {
            int i6 = this.numcols;
            i2 += i6;
            i += 4 - ((i6 + 4) % 8);
        }
        boolean z = true;
        if ((this.codewords.charAt(i3) & (1 << (8 - i4))) == 0) {
            z = false;
        }
        setBit(i2, i, z);
    }

    private void utah(int i, int i2, int i3) {
        int i4 = i - 2;
        int i5 = i2 - 2;
        module(i4, i5, i3, 1);
        int i6 = i2 - 1;
        module(i4, i6, i3, 2);
        int i7 = i - 1;
        module(i7, i5, i3, 3);
        module(i7, i6, i3, 4);
        module(i7, i2, i3, 5);
        module(i, i5, i3, 6);
        module(i, i6, i3, 7);
        module(i, i2, i3, 8);
    }

    public final boolean getBit(int i, int i2) {
        return this.bits[(i2 * this.numcols) + i] == 1;
    }

    /* access modifiers changed from: package-private */
    public final byte[] getBits() {
        return this.bits;
    }

    /* access modifiers changed from: package-private */
    public final int getNumcols() {
        return this.numcols;
    }

    /* access modifiers changed from: package-private */
    public final int getNumrows() {
        return this.numrows;
    }

    /* access modifiers changed from: package-private */
    public final boolean hasBit(int i, int i2) {
        return this.bits[(i2 * this.numcols) + i] >= 0;
    }

    /* JADX WARNING: Removed duplicated region for block: B:56:0x0088 A[EDGE_INSN: B:56:0x0088->B:45:0x0088 ?: BREAK  , SYNTHETIC] */
    public final void place() {
        int i;
        int i2;
        int i3;
        int i4;
        int i5;
        int i6 = 0;
        int i7 = 0;
        int i8 = 4;
        while (true) {
            if (i8 == this.numrows && i6 == 0) {
                corner1(i7);
                i7++;
            }
            if (i8 == this.numrows - 2 && i6 == 0 && this.numcols % 4 != 0) {
                corner2(i7);
                i7++;
            }
            if (i8 == this.numrows - 2 && i6 == 0 && this.numcols % 8 == 4) {
                corner3(i7);
                i7++;
            }
            if (i8 == this.numrows + 4 && i6 == 2 && this.numcols % 8 == 0) {
                i = i7 + 1;
                corner4(i7);
                if (i8 < this.numrows || i6 < 0 || hasBit(i6, i8)) {
                    i7 = i;
                } else {
                    i7 = i + 1;
                    utah(i8, i6, i);
                }
                i8 -= 2;
                i6 += 2;
                if (i8 < 0 || i6 >= this.numcols) {
                    i2 = i8 + 1;
                    i3 = i6 + 3;
                    do {
                        if (i2 >= 0 && i3 < this.numcols && !hasBit(i3, i2)) {
                            utah(i2, i3, i7);
                            i7++;
                        }
                        i2 += 2;
                        i3 -= 2;
                        i4 = this.numrows;
                        if (i2 >= i4) {
                            break;
                        }
                    } while (i3 >= 0);
                    i8 = i2 + 3;
                    i6 = i3 + 1;
                    if (i8 < i4 && i6 >= (i5 = this.numcols)) {
                        break;
                    }
                }
            }
            i = i7;
            if (i8 < this.numrows) {
            }
            i7 = i;
            i8 -= 2;
            i6 += 2;
            i2 = i8 + 1;
            i3 = i6 + 3;
            do {
                utah(i2, i3, i7);
                i7++;
                i2 += 2;
                i3 -= 2;
                i4 = this.numrows;
                if (i2 >= i4) {
                    break;
                    break;
                }
            } while (i3 >= 0);
            i8 = i2 + 3;
            i6 = i3 + 1;
            if (i8 < i4) {
            }
        }
        if (!hasBit(i5 - 1, i4 - 1)) {
            setBit(this.numcols - 1, this.numrows - 1, true);
            setBit(this.numcols - 2, this.numrows - 2, true);
        }
    }

    /* access modifiers changed from: package-private */
    public final void setBit(int i, int i2, boolean z) {
        this.bits[(i2 * this.numcols) + i] = z ? (byte) 1 : 0;
    }
}
