package com.dcloud.zxing2.client.result;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.Result;

public final class ISBNResultParser extends ResultParser {
    @Override // com.dcloud.zxing2.client.result.ResultParser
    public ISBNParsedResult parse(Result result) {
        if (result.getBarcodeFormat() != BarcodeFormat.EAN_13) {
            return null;
        }
        String massagedText = ResultParser.getMassagedText(result);
        if (massagedText.length() != 13) {
            return null;
        }
        if (massagedText.startsWith("978") || massagedText.startsWith("979")) {
            return new ISBNParsedResult(massagedText);
        }
        return null;
    }
}
