package com.dcloud.zxing2;

import com.dcloud.zxing2.aztec.AztecWriter;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.datamatrix.DataMatrixWriter;
import com.dcloud.zxing2.oned.CodaBarWriter;
import com.dcloud.zxing2.oned.Code128Writer;
import com.dcloud.zxing2.oned.Code39Writer;
import com.dcloud.zxing2.oned.Code93Writer;
import com.dcloud.zxing2.oned.EAN13Writer;
import com.dcloud.zxing2.oned.EAN8Writer;
import com.dcloud.zxing2.oned.ITFWriter;
import com.dcloud.zxing2.oned.UPCAWriter;
import com.dcloud.zxing2.oned.UPCEWriter;
import com.dcloud.zxing2.pdf417.PDF417Writer;
import com.dcloud.zxing2.qrcode.QRCodeWriter;
import java.util.Map;

public final class MultiFormatWriter implements Writer {

    /* access modifiers changed from: package-private */
    /* renamed from: com.dcloud.zxing2.MultiFormatWriter$1  reason: invalid class name */
    public static /* synthetic */ class AnonymousClass1 {
        static final /* synthetic */ int[] $SwitchMap$com$dcloud$zxing2$BarcodeFormat;

        /* JADX WARNING: Can't wrap try/catch for region: R(26:0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|(3:25|26|28)) */
        /* JADX WARNING: Failed to process nested try/catch */
        /* JADX WARNING: Missing exception handler attribute for start block: B:11:0x003e */
        /* JADX WARNING: Missing exception handler attribute for start block: B:13:0x0049 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:15:0x0054 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:17:0x0060 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:19:0x006c */
        /* JADX WARNING: Missing exception handler attribute for start block: B:21:0x0078 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:23:0x0084 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:25:0x0090 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:3:0x0012 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:5:0x001d */
        /* JADX WARNING: Missing exception handler attribute for start block: B:7:0x0028 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:9:0x0033 */
        static {
            int[] iArr = new int[BarcodeFormat.values().length];
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat = iArr;
            iArr[BarcodeFormat.EAN_8.ordinal()] = 1;
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.UPC_E.ordinal()] = 2;
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.EAN_13.ordinal()] = 3;
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.UPC_A.ordinal()] = 4;
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.QR_CODE.ordinal()] = 5;
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.CODE_39.ordinal()] = 6;
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.CODE_93.ordinal()] = 7;
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.CODE_128.ordinal()] = 8;
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.ITF.ordinal()] = 9;
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.PDF_417.ordinal()] = 10;
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.CODABAR.ordinal()] = 11;
            $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.DATA_MATRIX.ordinal()] = 12;
            try {
                $SwitchMap$com$dcloud$zxing2$BarcodeFormat[BarcodeFormat.AZTEC.ordinal()] = 13;
            } catch (NoSuchFieldError unused) {
            }
        }
    }

    @Override // com.dcloud.zxing2.Writer
    public BitMatrix encode(String str, BarcodeFormat barcodeFormat, int i, int i2) throws WriterException {
        return encode(str, barcodeFormat, i, i2, null);
    }

    @Override // com.dcloud.zxing2.Writer
    public BitMatrix encode(String str, BarcodeFormat barcodeFormat, int i, int i2, Map<EncodeHintType, ?> map) throws WriterException {
        Writer writer;
        switch (AnonymousClass1.$SwitchMap$com$dcloud$zxing2$BarcodeFormat[barcodeFormat.ordinal()]) {
            case 1:
                writer = new EAN8Writer();
                break;
            case 2:
                writer = new UPCEWriter();
                break;
            case 3:
                writer = new EAN13Writer();
                break;
            case 4:
                writer = new UPCAWriter();
                break;
            case 5:
                writer = new QRCodeWriter();
                break;
            case 6:
                writer = new Code39Writer();
                break;
            case 7:
                writer = new Code93Writer();
                break;
            case 8:
                writer = new Code128Writer();
                break;
            case 9:
                writer = new ITFWriter();
                break;
            case 10:
                writer = new PDF417Writer();
                break;
            case 11:
                writer = new CodaBarWriter();
                break;
            case 12:
                writer = new DataMatrixWriter();
                break;
            case 13:
                writer = new AztecWriter();
                break;
            default:
                throw new IllegalArgumentException("No encoder available for format " + barcodeFormat);
        }
        return writer.encode(str, barcodeFormat, i, i2, map);
    }
}
