package com.dcloud.android.widget;

import android.content.Context;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import android.widget.Scroller;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import org.json.JSONObject;

public class SlideLayout extends AbsoluteLayout {
    private static String AFTER_SLIDE = "afterSlide";
    private static String BEFORE_SLIDE = "beforeSlide";
    private static String LEFT = "left";
    private static String RIGHT = "right";
    private static final int SCROLL_DURATION = 150;
    private static final int SNAP_VELOCITY = 1000;
    boolean isLeftSlide = false;
    boolean isRightSlide = false;
    boolean isSlideOpen = false;
    private boolean mCanDoSlideTransverseEvent = false;
    private OnStateChangeListener mChangeListener;
    private float mFirstX = 0.0f;
    private boolean mInterceptEventEnable = true;
    private boolean mIsHandledTouchEvent = false;
    private float mLastMotionX = -1.0f;
    private Scroller mScroller = new Scroller(getContext());
    private int mSlideLeftPosition = -1;
    private int mSlideRightPosition = -1;
    private int mSlideTransverseLeftMaxWitch = 0;
    private int mSlideTransverseRightMaxWitch = 0;
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;

    public interface OnStateChangeListener {
        void onStateChanged(String str, String str2);
    }

    public SlideLayout(Context context) {
        super(context);
        this.mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
    }

    private void setState(final String str, final String str2) {
        if (this.mChangeListener != null) {
            postDelayed(new Runnable() {
                /* class com.dcloud.android.widget.SlideLayout.AnonymousClass1 */

                public void run() {
                    SlideLayout.this.mChangeListener.onStateChanged(str2, str);
                }
            }, 150);
        }
    }

    private void smoothScrollTo(int i, int i2) {
        enableChildrenCache();
        this.mScroller.startScroll(getScrollX(), 0, i, 0, Math.abs(i) * 2);
        invalidate();
    }

    /* access modifiers changed from: package-private */
    public void clearChildrenCache() {
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            getChildAt(i).setDrawingCacheEnabled(false);
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            postInvalidate();
        } else {
            clearChildrenCache();
        }
        super.computeScroll();
    }

    /* access modifiers changed from: package-private */
    public void enableChildrenCache() {
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            getChildAt(i).setDrawingCacheEnabled(true);
        }
    }

    public void initSlideInfo(JSONObject jSONObject, float f, int i) {
        JSONObject jSONObject2 = JSONUtil.getJSONObject(jSONObject, AbsoluteConst.BOUNCE_SLIDEO_OFFSET);
        if (jSONObject2 != null) {
            JSONObject jSONObject3 = JSONUtil.getJSONObject(jSONObject, "position");
            if (jSONObject3 != null) {
                String optString = jSONObject3.optString(LEFT);
                String optString2 = jSONObject3.optString(RIGHT);
                if (!TextUtils.isEmpty(optString)) {
                    this.mSlideLeftPosition = PdrUtil.convertToScreenInt(optString, i, i / 2, f);
                }
                if (!TextUtils.isEmpty(optString2)) {
                    this.mSlideRightPosition = PdrUtil.convertToScreenInt(optString2, i, i / 2, f);
                }
            }
            boolean z = true;
            this.mInterceptEventEnable = jSONObject.optBoolean("preventTouchEvent", true);
            String string = JSONUtil.getString(jSONObject2, LEFT);
            if (!TextUtils.isEmpty(string)) {
                this.isLeftSlide = this.mSlideLeftPosition > 0;
                this.mSlideTransverseLeftMaxWitch = PdrUtil.convertToScreenInt(string, i, i / 2, f);
            }
            String string2 = JSONUtil.getString(jSONObject2, RIGHT);
            if (!TextUtils.isEmpty(string2)) {
                if (this.mSlideRightPosition <= 0) {
                    z = false;
                }
                this.isRightSlide = z;
                this.mSlideTransverseRightMaxWitch = PdrUtil.convertToScreenInt(string2, i, i / 2, f);
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int action = motionEvent.getAction();
        if (!this.mInterceptEventEnable) {
            return false;
        }
        if (!this.isLeftSlide && !this.isRightSlide) {
            return false;
        }
        if (action == 3 || action == 1) {
            this.mIsHandledTouchEvent = false;
            clearChildrenCache();
            return this.mIsHandledTouchEvent;
        } else if (action != 0 && this.mIsHandledTouchEvent) {
            return true;
        } else {
            if (action == 0) {
                this.mLastMotionX = motionEvent.getX();
                this.mFirstX = motionEvent.getX();
                this.mIsHandledTouchEvent = false;
                this.mCanDoSlideTransverseEvent = false;
            } else if (action == 2 && ((int) Math.abs(motionEvent.getX() - this.mFirstX)) > this.mTouchSlop) {
                enableChildrenCache();
                this.mIsHandledTouchEvent = true;
                this.mCanDoSlideTransverseEvent = true;
                requestDisallowInterceptTouchEvent(true);
            }
            return this.mIsHandledTouchEvent;
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:12:0x001c, code lost:
        if (r0 != 3) goto L_0x017c;
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int i;
        int i2;
        if (this.mCanDoSlideTransverseEvent && this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        int action = motionEvent.getAction();
        if (action != 0) {
            if (action != 1) {
                if (action == 2) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    if (velocityTracker != null) {
                        velocityTracker.addMovement(motionEvent);
                    }
                    float x = motionEvent.getX();
                    if (this.mCanDoSlideTransverseEvent) {
                        int i3 = (int) (this.mLastMotionX - x);
                        this.mLastMotionX = x;
                        int scrollX = getScrollX();
                        int right = (getChildAt(getChildCount() - 1).getRight() - scrollX) - getWidth();
                        if (scrollX == 0) {
                            if (this.isRightSlide && i3 > 0) {
                                scrollBy(i3, 0);
                            } else if (this.isLeftSlide && i3 < 0) {
                                scrollBy(i3, 0);
                            }
                        } else if (scrollX > 0 && right < 0 && this.isRightSlide) {
                            int i4 = scrollX + i3;
                            if (Math.abs(i4) <= this.mSlideRightPosition) {
                                if (i4 < 0) {
                                    scrollBy(0, 0);
                                } else if (Math.abs(i4) >= this.mSlideTransverseRightMaxWitch) {
                                    double d = (double) i3;
                                    Double.isNaN(d);
                                    scrollBy((int) (d / 1.5d), 0);
                                } else {
                                    scrollBy(i3, 0);
                                }
                            }
                        } else if (scrollX < 0 && right > 0 && this.isLeftSlide) {
                            int i5 = scrollX + i3;
                            if (Math.abs(i5) <= this.mSlideLeftPosition) {
                                if (i5 > 0) {
                                    scrollBy(0, 0);
                                } else if (Math.abs(i5) >= this.mSlideTransverseLeftMaxWitch) {
                                    double d2 = (double) i3;
                                    Double.isNaN(d2);
                                    scrollBy((int) (d2 / 1.5d), 0);
                                } else {
                                    scrollBy(i3, 0);
                                }
                            }
                        }
                    }
                }
            }
            if (this.mIsHandledTouchEvent) {
                this.mIsHandledTouchEvent = false;
                if (this.mCanDoSlideTransverseEvent) {
                    requestDisallowInterceptTouchEvent(false);
                    VelocityTracker velocityTracker2 = this.mVelocityTracker;
                    velocityTracker2.computeCurrentVelocity(1000);
                    int xVelocity = (int) velocityTracker2.getXVelocity();
                    int scrollX2 = getScrollX();
                    if (xVelocity > 1000) {
                        if (scrollX2 < 0 && this.isLeftSlide && this.mSlideLeftPosition >= (i2 = this.mSlideTransverseLeftMaxWitch)) {
                            smoothScrollTo(-(i2 - Math.abs(scrollX2)), 0);
                            this.isSlideOpen = true;
                            setState(LEFT, AFTER_SLIDE);
                        } else if (scrollX2 <= 0 || !this.isRightSlide) {
                            upSlideTo(scrollX2);
                        } else {
                            smoothScrollTo(-scrollX2, 0);
                            this.isSlideOpen = false;
                            setState(RIGHT, BEFORE_SLIDE);
                        }
                    } else if (xVelocity >= -1000) {
                        upSlideTo(scrollX2);
                    } else if (scrollX2 < 0 && this.isLeftSlide) {
                        smoothScrollTo(-scrollX2, 0);
                        this.isSlideOpen = false;
                        setState(LEFT, BEFORE_SLIDE);
                    } else if (scrollX2 <= 0 || !this.isRightSlide || this.mSlideRightPosition < (i = this.mSlideTransverseRightMaxWitch)) {
                        upSlideTo(scrollX2);
                    } else {
                        smoothScrollTo(i - Math.abs(scrollX2), 0);
                        this.isSlideOpen = true;
                        setState(RIGHT, AFTER_SLIDE);
                    }
                    VelocityTracker velocityTracker3 = this.mVelocityTracker;
                    if (velocityTracker3 != null) {
                        velocityTracker3.recycle();
                        this.mVelocityTracker = null;
                    }
                }
            }
            VelocityTracker velocityTracker4 = this.mVelocityTracker;
            if (velocityTracker4 != null) {
                velocityTracker4.recycle();
                this.mVelocityTracker = null;
            }
        } else {
            this.mIsHandledTouchEvent = false;
            if (!this.mScroller.isFinished()) {
                this.mScroller.abortAnimation();
            }
        }
        return super.onTouchEvent(motionEvent);
    }

    public void reset() {
        int scrollX = getScrollX();
        if (scrollX != 0) {
            smoothScrollTo(-scrollX, 0);
            if (scrollX < 0) {
                setState(LEFT, BEFORE_SLIDE);
            } else {
                setState(RIGHT, BEFORE_SLIDE);
            }
        }
    }

    public void setHeight(int i) {
        ViewGroup.LayoutParams layoutParams = getLayoutParams();
        if (layoutParams != null) {
            layoutParams.height = i;
            requestLayout();
        }
    }

    public void setInterceptTouchEventEnabled(boolean z) {
        this.mIsHandledTouchEvent = z;
    }

    public void setOffset(String str, String str2, float f) {
        int convertToScreenInt = PdrUtil.convertToScreenInt(str2, getWidth(), 0, f);
        int scrollX = getScrollX();
        if (str.equals(LEFT)) {
            if (convertToScreenInt != 0) {
                int i = this.mSlideLeftPosition;
                if (convertToScreenInt > i) {
                    convertToScreenInt = i;
                }
                int abs = convertToScreenInt - Math.abs(scrollX);
                smoothScrollTo(-abs, 0);
                postDelayed(new Runnable() {
                    /* class com.dcloud.android.widget.SlideLayout.AnonymousClass2 */

                    public void run() {
                        SlideLayout slideLayout = SlideLayout.this;
                        slideLayout.upSlideTo(slideLayout.getScrollX());
                    }
                }, (long) ((abs * 2) + 200));
            } else if (scrollX != 0) {
                smoothScrollTo(-scrollX, 0);
                setState(LEFT, BEFORE_SLIDE);
            }
        } else if (convertToScreenInt != 0) {
            int i2 = this.mSlideRightPosition;
            if (convertToScreenInt > i2) {
                convertToScreenInt = i2;
            }
            int abs2 = convertToScreenInt - Math.abs(scrollX);
            smoothScrollTo(abs2, 0);
            postDelayed(new Runnable() {
                /* class com.dcloud.android.widget.SlideLayout.AnonymousClass3 */

                public void run() {
                    SlideLayout slideLayout = SlideLayout.this;
                    slideLayout.upSlideTo(slideLayout.getScrollX());
                }
            }, (long) ((abs2 * 2) + 200));
        } else if (scrollX != 0) {
            smoothScrollTo(-scrollX, 0);
            setState(RIGHT, BEFORE_SLIDE);
        }
    }

    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.mChangeListener = onStateChangeListener;
    }

    public void setWidth(int i) {
        ViewGroup.LayoutParams layoutParams = getLayoutParams();
        if (layoutParams != null) {
            layoutParams.width = i;
            requestLayout();
        }
    }

    public void upSlideTo(int i) {
        if (i < 0) {
            int abs = Math.abs(i);
            int i2 = this.mSlideTransverseLeftMaxWitch;
            if (abs >= i2 / 2 && this.mSlideLeftPosition >= i2) {
                smoothScrollTo(-(i2 - Math.abs(i)), 0);
                this.isSlideOpen = true;
                setState(LEFT, AFTER_SLIDE);
                return;
            }
        }
        if (i > 0) {
            int abs2 = Math.abs(i);
            int i3 = this.mSlideTransverseRightMaxWitch;
            if (abs2 >= i3 / 2 && this.mSlideRightPosition >= i3) {
                smoothScrollTo(i3 - Math.abs(i), 0);
                this.isSlideOpen = true;
                setState(RIGHT, AFTER_SLIDE);
                return;
            }
        }
        if (i > 0) {
            smoothScrollTo(-i, 0);
            setState(RIGHT, BEFORE_SLIDE);
        } else {
            smoothScrollTo(-i, 0);
            setState(LEFT, BEFORE_SLIDE);
        }
        this.isSlideOpen = false;
    }
}
