package com.dcloud.android.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ProgressBar;
import com.facebook.common.statfs.StatFsHelper;
import io.dcloud.feature.gg.dcloud.ADSim;
import io.dcloud.nineoldandroids.animation.Animator;
import io.dcloud.nineoldandroids.animation.AnimatorListenerAdapter;
import io.dcloud.nineoldandroids.animation.ObjectAnimator;

public class DCWebViewProgressBar extends ProgressBar {
    int alpha = 255;
    public boolean isFinish = false;
    ObjectAnimator mCurrentAnmiator;

    public DCWebViewProgressBar(Context context) {
        super(context, null, 16842872);
        setMax(ADSim.INTISPLSH);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private ObjectAnimator getProgressAnimation(int i, int i2, Interpolator interpolator, AnimatorListenerAdapter animatorListenerAdapter) {
        ObjectAnimator ofInt = ObjectAnimator.ofInt(this, "progress", getProgress(), i * 100);
        ofInt.setDuration((long) i2);
        ofInt.setInterpolator(interpolator);
        if (animatorListenerAdapter != null) {
            ofInt.addListener(animatorListenerAdapter);
        }
        return ofInt;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void startDismissAnimation() {
        ObjectAnimator ofFloat = ObjectAnimator.ofFloat(this, "alpha", 1.0f, 0.0f);
        ofFloat.setDuration(1000L);
        ofFloat.setInterpolator(new DecelerateInterpolator());
        ofFloat.addListener(new AnimatorListenerAdapter() {
            /* class com.dcloud.android.widget.DCWebViewProgressBar.AnonymousClass3 */

            @Override // io.dcloud.nineoldandroids.animation.Animator.AnimatorListener, io.dcloud.nineoldandroids.animation.AnimatorListenerAdapter
            public void onAnimationEnd(Animator animator) {
                DCWebViewProgressBar.this.setProgress(0);
            }
        });
        ofFloat.start();
    }

    public void finishProgress() {
        if (!this.isFinish) {
            this.isFinish = true;
            ObjectAnimator objectAnimator = this.mCurrentAnmiator;
            if (objectAnimator != null) {
                objectAnimator.cancel();
            }
            ObjectAnimator progressAnimation = getProgressAnimation(100, StatFsHelper.DEFAULT_DISK_YELLOW_LEVEL_IN_MB, new AccelerateInterpolator(), new AnimatorListenerAdapter() {
                /* class com.dcloud.android.widget.DCWebViewProgressBar.AnonymousClass2 */

                @Override // io.dcloud.nineoldandroids.animation.Animator.AnimatorListener, io.dcloud.nineoldandroids.animation.AnimatorListenerAdapter
                public void onAnimationEnd(Animator animator) {
                    super.onAnimationEnd(animator);
                    DCWebViewProgressBar dCWebViewProgressBar = DCWebViewProgressBar.this;
                    if (dCWebViewProgressBar.isFinish) {
                        dCWebViewProgressBar.startDismissAnimation();
                    }
                }
            });
            this.mCurrentAnmiator = progressAnimation;
            progressAnimation.start();
        }
    }

    public void setAlphaInt(int i) {
        this.alpha = i;
    }

    public void setColorInt(int i) {
        int argb = Color.argb(this.alpha, Color.red(i), Color.green(i), Color.blue(i));
        ClipDrawable clipDrawable = new ClipDrawable(new ColorDrawable(0), 3, 1);
        clipDrawable.setLevel(ADSim.INTISPLSH);
        ClipDrawable clipDrawable2 = new ClipDrawable(new ColorDrawable(argb), 3, 1);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{clipDrawable, clipDrawable2, clipDrawable2});
        layerDrawable.setId(0, 16908288);
        layerDrawable.setId(1, 16908303);
        layerDrawable.setId(2, 16908301);
        setProgressDrawable(layerDrawable);
    }

    public void startProgress() {
        setProgress(0);
        setAlpha(1.0f);
        this.isFinish = false;
        final DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
        ObjectAnimator progressAnimation = getProgressAnimation(30, 2000, decelerateInterpolator, new AnimatorListenerAdapter() {
            /* class com.dcloud.android.widget.DCWebViewProgressBar.AnonymousClass1 */

            @Override // io.dcloud.nineoldandroids.animation.Animator.AnimatorListener, io.dcloud.nineoldandroids.animation.AnimatorListenerAdapter
            public void onAnimationEnd(Animator animator) {
                super.onAnimationEnd(animator);
                DCWebViewProgressBar dCWebViewProgressBar = DCWebViewProgressBar.this;
                if (!dCWebViewProgressBar.isFinish) {
                    dCWebViewProgressBar.mCurrentAnmiator = dCWebViewProgressBar.getProgressAnimation(70, 2000, decelerateInterpolator, new AnimatorListenerAdapter() {
                        /* class com.dcloud.android.widget.DCWebViewProgressBar.AnonymousClass1.AnonymousClass1 */

                        @Override // io.dcloud.nineoldandroids.animation.Animator.AnimatorListener, io.dcloud.nineoldandroids.animation.AnimatorListenerAdapter
                        public void onAnimationEnd(Animator animator) {
                            super.onAnimationEnd(animator);
                            AnonymousClass1 r5 = AnonymousClass1.this;
                            DCWebViewProgressBar dCWebViewProgressBar = DCWebViewProgressBar.this;
                            if (!dCWebViewProgressBar.isFinish) {
                                dCWebViewProgressBar.mCurrentAnmiator = dCWebViewProgressBar.getProgressAnimation(95, 50000, decelerateInterpolator, null);
                                DCWebViewProgressBar.this.mCurrentAnmiator.start();
                            }
                        }
                    });
                    DCWebViewProgressBar.this.mCurrentAnmiator.start();
                }
            }
        });
        this.mCurrentAnmiator = progressAnimation;
        progressAnimation.start();
    }
}
