package com.dcloud.android.downloader.core.thread;

import android.os.Process;
import android.util.Log;
import com.dcloud.android.downloader.config.Config;
import com.dcloud.android.downloader.core.DownloadResponse;
import com.dcloud.android.downloader.domain.DownloadInfo;
import com.dcloud.android.downloader.domain.DownloadThreadInfo;
import com.dcloud.android.downloader.exception.DownloadException;
import com.dcloud.android.downloader.exception.DownloadPauseException;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.adapter.util.DCloudTrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class DownloadThread implements Runnable {
    public static final String TAG = "DownloadThread";
    private final Config config;
    private final DownloadInfo downloadInfo;
    private final DownloadProgressListener downloadProgressListener;
    private final DownloadResponse downloadResponse;
    private final DownloadThreadInfo downloadThreadInfo;
    private InputStream inputStream;
    private long lastProgress;
    private int retryDownloadCount = 0;

    public interface DownloadProgressListener {
        void onDownloadSuccess();

        void onProgress();
    }

    public DownloadThread(DownloadThreadInfo downloadThreadInfo2, DownloadResponse downloadResponse2, Config config2, DownloadInfo downloadInfo2, DownloadProgressListener downloadProgressListener2) {
        this.downloadThreadInfo = downloadThreadInfo2;
        this.downloadResponse = downloadResponse2;
        this.config = config2;
        this.downloadInfo = downloadInfo2;
        this.lastProgress = downloadThreadInfo2.getProgress();
        this.downloadProgressListener = downloadProgressListener2;
    }

    private void checkPause() {
        if (this.downloadInfo.isPause()) {
            throw new DownloadPauseException(7);
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:65:0x01ea  */
    /* JADX WARNING: Removed duplicated region for block: B:77:0x0209  */
    /* JADX WARNING: Removed duplicated region for block: B:82:? A[RETURN, SYNTHETIC] */
    private void executeDownload() {
        Throwable th;
        ProtocolException e;
        IOException e2;
        NoSuchAlgorithmException e3;
        HttpURLConnection httpURLConnection;
        KeyManagementException e4;
        HttpURLConnection httpURLConnection2 = null;
        try {
            httpURLConnection = (HttpURLConnection) new URL(this.downloadThreadInfo.getUri()).openConnection();
            try {
                if (httpURLConnection instanceof HttpsURLConnection) {
                    SSLSocketFactory sSLSocketFactory = DCloudTrustManager.getSSLSocketFactory();
                    if (sSLSocketFactory != null) {
                        ((HttpsURLConnection) httpURLConnection).setSSLSocketFactory(sSLSocketFactory);
                    }
                    ((HttpsURLConnection) httpURLConnection).setHostnameVerifier(DCloudTrustManager.getHostnameVerifier(false));
                }
                httpURLConnection.setConnectTimeout(this.config.getConnectTimeout());
                httpURLConnection.setReadTimeout(this.config.getReadTimeout());
                httpURLConnection.setRequestMethod(this.config.getMethod());
                long start = this.downloadThreadInfo.getStart() + this.lastProgress;
                if (this.downloadInfo.isSupportRanges()) {
                    if (start > this.downloadThreadInfo.getEnd()) {
                        this.lastProgress = 0;
                        start = 0;
                    }
                    if (this.config.getEachDownloadThread() == 1) {
                        httpURLConnection.setRequestProperty("Range", "bytes=" + start + Operators.SUB);
                    } else {
                        httpURLConnection.setRequestProperty("Range", "bytes=" + start + Operators.SUB + this.downloadThreadInfo.getEnd());
                    }
                }
                int responseCode = httpURLConnection.getResponseCode();
                long parseInt = ((long) Integer.parseInt(httpURLConnection.getHeaderField("Content-Length"))) + start;
                if (this.config.getEachDownloadThread() == 1 && parseInt != this.downloadThreadInfo.getEnd()) {
                    if (parseInt - this.downloadThreadInfo.getEnd() == 1) {
                        start--;
                        this.lastProgress--;
                    } else {
                        throw new DownloadException(5, "IO error Data source change");
                    }
                }
                if (responseCode == 206 || responseCode == 200) {
                    this.inputStream = httpURLConnection.getInputStream();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(this.downloadInfo.getPath(), "rwd");
                    if (this.config.getEachDownloadThread() != 1 || randomAccessFile.length() >= this.lastProgress) {
                        randomAccessFile.seek(start);
                        byte[] bArr = new byte[4096];
                        int i = 0;
                        while (true) {
                            checkPause();
                            int read = this.inputStream.read(bArr);
                            if (read == -1) {
                                this.downloadProgressListener.onDownloadSuccess();
                                checkPause();
                                httpURLConnection.disconnect();
                                return;
                            }
                            randomAccessFile.write(bArr, 0, read);
                            i += read;
                            this.downloadThreadInfo.setProgress(this.lastProgress + ((long) i));
                            this.downloadProgressListener.onProgress();
                            Log.d(TAG, "downloadInfo:" + this.downloadInfo.getId() + " thread:" + this.downloadThreadInfo.getThreadId() + " progress:" + this.downloadThreadInfo.getProgress() + ",start:" + this.downloadThreadInfo.getStart() + ",end:" + this.downloadThreadInfo.getEnd());
                        }
                    } else {
                        throw new DownloadException(5, "IO error Have small download size");
                    }
                } else {
                    throw new DownloadException(8, "UnSupported response code:" + responseCode);
                }
            } catch (ProtocolException e5) {
                e = e5;
                httpURLConnection2 = httpURLConnection;
                try {
                    throw new DownloadException(4, "Protocol error", e);
                } catch (Throwable th2) {
                    th = th2;
                    if (httpURLConnection2 != null) {
                    }
                    throw th;
                }
            } catch (IOException e6) {
                e2 = e6;
                throw new DownloadException(5, "IO error", e2);
            } catch (DownloadPauseException unused) {
                httpURLConnection2 = httpURLConnection;
                if (httpURLConnection2 == null) {
                }
            } catch (NoSuchAlgorithmException e7) {
                e3 = e7;
                throw new DownloadException(5, "NO such", e3);
            } catch (KeyManagementException e8) {
                e4 = e8;
                throw new DownloadException(5, "Key management", e4);
            }
        } catch (ProtocolException e9) {
            e = e9;
            throw new DownloadException(4, "Protocol error", e);
        } catch (IOException e10) {
            e2 = e10;
            throw new DownloadException(5, "IO error", e2);
        } catch (DownloadPauseException unused2) {
            if (httpURLConnection2 == null) {
                httpURLConnection2.disconnect();
            }
        } catch (NoSuchAlgorithmException e11) {
            e3 = e11;
            throw new DownloadException(5, "NO such", e3);
        } catch (KeyManagementException e12) {
            httpURLConnection = null;
            e4 = e12;
            throw new DownloadException(5, "Key management", e4);
        } catch (Throwable th3) {
            th = th3;
            httpURLConnection2 = httpURLConnection;
            if (httpURLConnection2 != null) {
                httpURLConnection2.disconnect();
            }
            throw th;
        }
    }

    public void run() {
        Process.setThreadPriority(10);
        checkPause();
        try {
            executeDownload();
        } catch (DownloadException e) {
            this.downloadInfo.setStatus(6);
            this.downloadInfo.setException(e);
            this.downloadResponse.onStatusChanged(this.downloadInfo);
            this.downloadResponse.handleException(e);
        } catch (Exception e2) {
            DownloadException downloadException = new DownloadException(9, "other error", e2);
            this.downloadInfo.setStatus(6);
            this.downloadInfo.setException(downloadException);
            this.downloadResponse.onStatusChanged(this.downloadInfo);
            this.downloadResponse.handleException(downloadException);
        }
    }
}
