package com.alibaba.fastjson.util;

import com.taobao.weex.el.parse.Operators;
import java.lang.reflect.Array;
import java.math.BigInteger;

public final class RyuDouble {
    private static final int[][] POW5_INV_SPLIT = ((int[][]) Array.newInstance(int.class, 291, 4));
    private static final int[][] POW5_SPLIT = ((int[][]) Array.newInstance(int.class, 326, 4));

    static {
        int i;
        BigInteger subtract = BigInteger.ONE.shiftLeft(31).subtract(BigInteger.ONE);
        BigInteger subtract2 = BigInteger.ONE.shiftLeft(31).subtract(BigInteger.ONE);
        for (int i2 = 0; i2 < 326; i2++) {
            BigInteger pow = BigInteger.valueOf(5).pow(i2);
            int bitLength = pow.bitLength();
            if (i2 == 0) {
                i = 1;
            } else {
                i = (int) ((((((long) i2) * 23219280) + 10000000) - 1) / 10000000);
            }
            if (i == bitLength) {
                if (i2 < POW5_SPLIT.length) {
                    for (int i3 = 0; i3 < 4; i3++) {
                        POW5_SPLIT[i2][i3] = pow.shiftRight((bitLength - 121) + ((3 - i3) * 31)).and(subtract).intValue();
                    }
                }
                if (i2 < POW5_INV_SPLIT.length) {
                    BigInteger add = BigInteger.ONE.shiftLeft(bitLength + 121).divide(pow).add(BigInteger.ONE);
                    for (int i4 = 0; i4 < 4; i4++) {
                        if (i4 == 0) {
                            POW5_INV_SPLIT[i2][i4] = add.shiftRight((3 - i4) * 31).intValue();
                        } else {
                            POW5_INV_SPLIT[i2][i4] = add.shiftRight((3 - i4) * 31).and(subtract2).intValue();
                        }
                    }
                }
            } else {
                throw new IllegalStateException(bitLength + " != " + i);
            }
        }
    }

    public static String toString(double d) {
        char[] cArr = new char[24];
        return new String(cArr, 0, toString(d, cArr, 0));
    }

    /* JADX WARNING: Removed duplicated region for block: B:238:0x05bb  */
    /* JADX WARNING: Removed duplicated region for block: B:239:0x05bd  */
    public static int toString(double d, char[] cArr, int i) {
        int i2;
        long j;
        boolean z;
        boolean z2;
        long j2;
        int i3;
        boolean z3;
        boolean z4;
        long j3;
        long j4;
        int i4;
        int i5;
        int i6;
        int i7;
        int i8;
        int i9;
        int i10;
        boolean z5;
        int i11;
        int i12;
        int i13;
        int i14;
        if (Double.isNaN(d)) {
            int i15 = i + 1;
            cArr[i] = 'N';
            int i16 = i15 + 1;
            cArr[i15] = 'a';
            i14 = i16 + 1;
            cArr[i16] = 'N';
        } else {
            if (d == Double.POSITIVE_INFINITY) {
                int i17 = i + 1;
                cArr[i] = 'I';
                int i18 = i17 + 1;
                cArr[i17] = 'n';
                int i19 = i18 + 1;
                cArr[i18] = 'f';
                int i20 = i19 + 1;
                cArr[i19] = 'i';
                int i21 = i20 + 1;
                cArr[i20] = 'n';
                int i22 = i21 + 1;
                cArr[i21] = 'i';
                int i23 = i22 + 1;
                cArr[i22] = 't';
                i8 = i23 + 1;
                cArr[i23] = 'y';
            } else if (d == Double.NEGATIVE_INFINITY) {
                int i24 = i + 1;
                cArr[i] = '-';
                int i25 = i24 + 1;
                cArr[i24] = 'I';
                int i26 = i25 + 1;
                cArr[i25] = 'n';
                int i27 = i26 + 1;
                cArr[i26] = 'f';
                int i28 = i27 + 1;
                cArr[i27] = 'i';
                int i29 = i28 + 1;
                cArr[i28] = 'n';
                int i30 = i29 + 1;
                cArr[i29] = 'i';
                int i31 = i30 + 1;
                cArr[i30] = 't';
                i14 = i31 + 1;
                cArr[i31] = 'y';
            } else {
                long doubleToLongBits = Double.doubleToLongBits(d);
                if (doubleToLongBits == 0) {
                    int i32 = i + 1;
                    cArr[i] = '0';
                    int i33 = i32 + 1;
                    cArr[i32] = Operators.DOT;
                    i14 = i33 + 1;
                    cArr[i33] = '0';
                } else if (doubleToLongBits == Long.MIN_VALUE) {
                    int i34 = i + 1;
                    cArr[i] = '-';
                    int i35 = i34 + 1;
                    cArr[i34] = '0';
                    int i36 = i35 + 1;
                    cArr[i35] = Operators.DOT;
                    i8 = i36 + 1;
                    cArr[i36] = '0';
                } else {
                    int i37 = (int) ((doubleToLongBits >>> 52) & 2047);
                    long j5 = 4503599627370495L & doubleToLongBits;
                    if (i37 == 0) {
                        i2 = -1074;
                    } else {
                        i2 = (i37 - 1023) - 52;
                        j5 |= 4503599627370496L;
                    }
                    boolean z6 = doubleToLongBits < 0;
                    boolean z7 = (j5 & 1) == 0;
                    long j6 = 4 * j5;
                    long j7 = j6 + 2;
                    int i38 = (j5 != 4503599627370496L || i37 <= 1) ? 1 : 0;
                    long j8 = (j6 - 1) - ((long) i38);
                    int i39 = i2 - 2;
                    int i40 = 3;
                    if (i39 >= 0) {
                        int max = Math.max(0, ((int) ((((long) i39) * 3010299) / 10000000)) - 1);
                        if (max == 0) {
                            i10 = 1;
                        } else {
                            i10 = (int) ((((((long) max) * 23219280) + 10000000) - 1) / 10000000);
                        }
                        int i41 = ((((-i39) + max) + ((i10 + 122) - 1)) - 93) - 21;
                        if (i41 >= 0) {
                            int[] iArr = POW5_INV_SPLIT[max];
                            long j9 = j6 >>> 31;
                            long j10 = j6 & 2147483647L;
                            z2 = z6;
                            z = z7;
                            long j11 = ((((((((((((j10 * ((long) iArr[3])) >>> 31) + (((long) iArr[2]) * j10)) + (((long) iArr[3]) * j9)) >>> 31) + (((long) iArr[1]) * j10)) + (((long) iArr[2]) * j9)) >>> 31) + (((long) iArr[0]) * j10)) + (((long) iArr[1]) * j9)) >>> 21) + ((((long) iArr[0]) * j9) << 10)) >>> i41;
                            long j12 = j7 >>> 31;
                            long j13 = j7 & 2147483647L;
                            long j14 = ((((((((((((((long) iArr[3]) * j13) >>> 31) + (((long) iArr[2]) * j13)) + (j12 * ((long) iArr[3]))) >>> 31) + (((long) iArr[1]) * j13)) + (((long) iArr[2]) * j12)) >>> 31) + (((long) iArr[0]) * j13)) + (((long) iArr[1]) * j12)) >>> 21) + ((((long) iArr[0]) * j12) << 10)) >>> i41;
                            long j15 = j8 >>> 31;
                            long j16 = j8 & 2147483647L;
                            j = j14;
                            j3 = ((((((((((((j16 * ((long) iArr[3])) >>> 31) + (((long) iArr[2]) * j16)) + (j15 * ((long) iArr[3]))) >>> 31) + (((long) iArr[1]) * j16)) + (((long) iArr[2]) * j15)) >>> 31) + (((long) iArr[0]) * j16)) + (((long) iArr[1]) * j15)) >>> 21) + ((((long) iArr[0]) * j15) << 10)) >>> i41;
                            if (max <= 21) {
                                long j17 = j6 % 5;
                                long j18 = 0;
                                if (j17 == 0) {
                                    if (j17 != 0) {
                                        i13 = 0;
                                    } else if (j6 % 25 != 0) {
                                        i13 = 1;
                                    } else if (j6 % 125 != 0) {
                                        i13 = 2;
                                    } else if (j6 % 625 != 0) {
                                        i13 = 3;
                                    } else {
                                        long j19 = j6 / 625;
                                        i13 = 4;
                                        while (j19 > j18 && j19 % 5 == j18) {
                                            j19 /= 5;
                                            i13++;
                                            j18 = 0;
                                        }
                                    }
                                    z5 = i13 >= max;
                                    z4 = false;
                                    j2 = j11;
                                    i3 = max;
                                    z3 = z5;
                                } else if (z) {
                                    long j20 = 0;
                                    if (j8 % 5 != 0) {
                                        i12 = 0;
                                    } else if (j8 % 25 != 0) {
                                        i12 = 1;
                                    } else if (j8 % 125 != 0) {
                                        i12 = 2;
                                    } else if (j8 % 625 != 0) {
                                        i12 = 3;
                                    } else {
                                        long j21 = j8 / 625;
                                        i12 = 4;
                                        while (j21 > j20 && j21 % 5 == j20) {
                                            j21 /= 5;
                                            i12++;
                                            j20 = 0;
                                        }
                                    }
                                    if (i12 >= max) {
                                        z4 = true;
                                        z5 = false;
                                        j2 = j11;
                                        i3 = max;
                                        z3 = z5;
                                    }
                                } else {
                                    long j22 = 0;
                                    if (j7 % 5 != 0) {
                                        i11 = 0;
                                    } else if (j7 % 25 != 0) {
                                        i11 = 1;
                                    } else if (j7 % 125 != 0) {
                                        i11 = 2;
                                    } else if (j7 % 625 != 0) {
                                        i11 = 3;
                                    } else {
                                        long j23 = j7 / 625;
                                        i11 = 4;
                                        while (j23 > j22 && j23 % 5 == j22) {
                                            j23 /= 5;
                                            i11++;
                                            j22 = 0;
                                        }
                                    }
                                    if (i11 >= max) {
                                        j--;
                                    }
                                }
                            }
                            z4 = false;
                            z5 = false;
                            j2 = j11;
                            i3 = max;
                            z3 = z5;
                        } else {
                            throw new IllegalArgumentException("" + i41);
                        }
                    } else {
                        z2 = z6;
                        z = z7;
                        int i42 = -i39;
                        int max2 = Math.max(0, ((int) ((((long) i42) * 6989700) / 10000000)) - 1);
                        int i43 = i42 - max2;
                        if (i43 == 0) {
                            i9 = 1;
                        } else {
                            i9 = (int) ((((((long) i43) * 23219280) + 10000000) - 1) / 10000000);
                        }
                        int i44 = ((max2 - (i9 - 121)) - 93) - 21;
                        if (i44 >= 0) {
                            int[] iArr2 = POW5_SPLIT[i43];
                            long j24 = j6 >>> 31;
                            long j25 = j6 & 2147483647L;
                            long j26 = ((long) iArr2[0]) * j24;
                            long j27 = ((long) iArr2[0]) * j25;
                            long j28 = ((long) iArr2[1]) * j24;
                            long j29 = ((long) iArr2[1]) * j25;
                            long j30 = ((long) iArr2[2]) * j24;
                            long j31 = ((long) iArr2[2]) * j25;
                            long j32 = j24 * ((long) iArr2[3]);
                            long j33 = j7 >>> 31;
                            long j34 = j7 & 2147483647L;
                            long j35 = ((long) iArr2[0]) * j33;
                            long j36 = ((long) iArr2[1]) * j33;
                            j2 = ((((((((((((j25 * ((long) iArr2[3])) >>> 31) + j31) + j32) >>> 31) + j29) + j30) >>> 31) + j27) + j28) >>> 21) + (j26 << 10)) >>> i44;
                            j = ((((((((((((((long) iArr2[3]) * j34) >>> 31) + (((long) iArr2[2]) * j34)) + (j33 * ((long) iArr2[3]))) >>> 31) + (((long) iArr2[1]) * j34)) + (((long) iArr2[2]) * j33)) >>> 31) + (((long) iArr2[0]) * j34)) + j36) >>> 21) + (j35 << 10)) >>> i44;
                            long j37 = j8 >>> 31;
                            long j38 = j8 & 2147483647L;
                            j3 = ((((((((((((j38 * ((long) iArr2[3])) >>> 31) + (((long) iArr2[2]) * j38)) + (j37 * ((long) iArr2[3]))) >>> 31) + (((long) iArr2[1]) * j38)) + (((long) iArr2[2]) * j37)) >>> 31) + (((long) iArr2[0]) * j38)) + (((long) iArr2[1]) * j37)) >>> 21) + ((((long) iArr2[0]) * j37) << 10)) >>> i44;
                            i3 = max2 + i39;
                            if (max2 <= 1) {
                                if (z) {
                                    z4 = i38 == 1;
                                } else {
                                    j--;
                                    z4 = false;
                                }
                                z3 = true;
                            } else if (max2 < 63) {
                                z3 = (j6 & ((1 << (max2 - 1)) - 1)) == 0;
                                z4 = false;
                            } else {
                                z4 = false;
                                z3 = false;
                            }
                        } else {
                            throw new IllegalArgumentException("" + i44);
                        }
                    }
                    if (j >= 1000000000000000000L) {
                        i40 = 19;
                    } else if (j >= 100000000000000000L) {
                        i40 = 18;
                    } else if (j >= 10000000000000000L) {
                        i40 = 17;
                    } else if (j >= 1000000000000000L) {
                        i40 = 16;
                    } else if (j >= 100000000000000L) {
                        i40 = 15;
                    } else if (j >= 10000000000000L) {
                        i40 = 14;
                    } else if (j >= 1000000000000L) {
                        i40 = 13;
                    } else if (j >= 100000000000L) {
                        i40 = 12;
                    } else if (j >= 10000000000L) {
                        i40 = 11;
                    } else if (j >= 1000000000) {
                        i40 = 10;
                    } else if (j >= 100000000) {
                        i40 = 9;
                    } else if (j >= 10000000) {
                        i40 = 8;
                    } else if (j >= 1000000) {
                        i40 = 7;
                    } else if (j >= 100000) {
                        i40 = 6;
                    } else if (j >= 10000) {
                        i40 = 5;
                    } else if (j >= 1000) {
                        i40 = 4;
                    } else if (j < 100) {
                        i40 = j >= 10 ? 2 : 1;
                    }
                    int i45 = (i3 + i40) - 1;
                    boolean z8 = i45 < -3 || i45 >= 7;
                    if (z4 || z3) {
                        int i46 = 0;
                        int i47 = 0;
                        while (true) {
                            long j39 = j / 10;
                            long j40 = j3 / 10;
                            if (j39 > j40 && (j >= 100 || !z8)) {
                                z4 &= j3 % 10 == 0;
                                z3 &= i46 == 0;
                                i46 = (int) (j2 % 10);
                                j2 /= 10;
                                i47++;
                                j = j39;
                                j3 = j40;
                            } else if (z4 && z) {
                                while (j3 % 10 == 0 && (j >= 100 || !z8)) {
                                    z3 &= i46 != 0;
                                    i46 = (int) (j2 % 10);
                                    j /= 10;
                                    j2 /= 10;
                                    j3 /= 10;
                                    i47++;
                                }
                            }
                        }
                        while (j3 % 10 == 0) {
                            z3 &= i46 != 0;
                            i46 = (int) (j2 % 10);
                            j /= 10;
                            j2 /= 10;
                            j3 /= 10;
                            i47++;
                        }
                        if (z3 && i46 == 5 && j2 % 2 == 0) {
                            i46 = 4;
                        }
                        j4 = j2 + ((long) (((j2 != j3 || (z4 && z)) && i46 < 5) ? 0 : 1));
                        i4 = i47;
                    } else {
                        i4 = 0;
                        int i48 = 0;
                        while (true) {
                            long j41 = j / 10;
                            long j42 = j3 / 10;
                            if (j41 > j42 && (j >= 100 || !z8)) {
                                i48 = (int) (j2 % 10);
                                j2 /= 10;
                                i4++;
                                j = j41;
                                j3 = j42;
                            }
                        }
                        j4 = j2 + ((long) ((j2 == j3 || i48 >= 5) ? 1 : 0));
                    }
                    int i49 = i40 - i4;
                    if (z2) {
                        i5 = i + 1;
                        cArr[i] = '-';
                    } else {
                        i5 = i;
                    }
                    if (z8) {
                        for (int i50 = 0; i50 < i49 - 1; i50++) {
                            j4 /= 10;
                            cArr[(i5 + i49) - i50] = (char) (((int) (j4 % 10)) + 48);
                        }
                        cArr[i5] = (char) ((int) ((j4 % 10) + 48));
                        cArr[i5 + 1] = Operators.DOT;
                        int i51 = i5 + i49 + 1;
                        if (i49 == 1) {
                            cArr[i51] = '0';
                            i51++;
                        }
                        int i52 = i51 + 1;
                        cArr[i51] = 'E';
                        if (i45 < 0) {
                            cArr[i52] = '-';
                            i45 = -i45;
                            i52++;
                        }
                        if (i45 >= 100) {
                            int i53 = i52 + 1;
                            i7 = 48;
                            cArr[i52] = (char) ((i45 / 100) + 48);
                            i45 %= 100;
                            i52 = i53 + 1;
                            cArr[i53] = (char) ((i45 / 10) + 48);
                        } else {
                            i7 = 48;
                            if (i45 >= 10) {
                                cArr[i52] = (char) ((i45 / 10) + 48);
                                i52++;
                            }
                        }
                        i8 = i52 + 1;
                        cArr[i52] = (char) ((i45 % 10) + i7);
                    } else {
                        char c = '0';
                        if (i45 < 0) {
                            int i54 = i5 + 1;
                            cArr[i5] = '0';
                            int i55 = i54 + 1;
                            cArr[i54] = Operators.DOT;
                            int i56 = -1;
                            while (i56 > i45) {
                                cArr[i55] = c;
                                i56--;
                                i55++;
                                c = '0';
                            }
                            i6 = i55;
                            for (int i57 = 0; i57 < i49; i57++) {
                                cArr[((i55 + i49) - i57) - 1] = (char) ((int) ((j4 % 10) + 48));
                                j4 /= 10;
                                i6++;
                            }
                        } else {
                            int i58 = i45 + 1;
                            if (i58 >= i49) {
                                for (int i59 = 0; i59 < i49; i59++) {
                                    cArr[((i5 + i49) - i59) - 1] = (char) ((int) ((j4 % 10) + 48));
                                    j4 /= 10;
                                }
                                int i60 = i5 + i49;
                                while (i49 < i58) {
                                    cArr[i60] = '0';
                                    i49++;
                                    i60++;
                                }
                                int i61 = i60 + 1;
                                cArr[i60] = Operators.DOT;
                                i6 = i61 + 1;
                                cArr[i61] = '0';
                            } else {
                                int i62 = i5 + 1;
                                for (int i63 = 0; i63 < i49; i63++) {
                                    if ((i49 - i63) - 1 == i45) {
                                        cArr[((i62 + i49) - i63) - 1] = Operators.DOT;
                                        i62--;
                                    }
                                    cArr[((i62 + i49) - i63) - 1] = (char) ((int) ((j4 % 10) + 48));
                                    j4 /= 10;
                                }
                                i6 = i5 + i49 + 1;
                            }
                        }
                        return i6 - i;
                    }
                }
            }
            return i8 - i;
        }
        return i14 - i;
    }
}
