package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONPOJOBuilder;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.taobao.weex.common.Constants;
import io.dcloud.common.DHInterface.IApp;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JavaBeanInfo {
    public final Method buildMethod;
    public final Class<?> builderClass;
    public final Class<?> clazz;
    public final Constructor<?> creatorConstructor;
    public Type[] creatorConstructorParameterTypes;
    public String[] creatorConstructorParameters;
    public final Constructor<?> defaultConstructor;
    public final int defaultConstructorParameterSize;
    public final Method factoryMethod;
    public final FieldInfo[] fields;
    public final JSONType jsonType;

    /* renamed from: kotlin  reason: collision with root package name */
    public boolean f0kotlin;
    public Constructor<?> kotlinDefaultConstructor;
    public String[] orders;
    public final int parserFeatures;
    public final FieldInfo[] sortedFields;
    public final String typeKey;
    public final String typeName;

    public JavaBeanInfo(Class<?> cls, Class<?> cls2, Constructor<?> constructor, Constructor<?> constructor2, Method method, Method method2, JSONType jSONType, List<FieldInfo> list) {
        JSONField jSONField;
        this.clazz = cls;
        this.builderClass = cls2;
        this.defaultConstructor = constructor;
        this.creatorConstructor = constructor2;
        this.factoryMethod = method;
        this.parserFeatures = TypeUtils.getParserFeatures(cls);
        this.buildMethod = method2;
        this.jsonType = jSONType;
        if (jSONType != null) {
            String typeName2 = jSONType.typeName();
            String typeKey2 = jSONType.typeKey();
            this.typeKey = typeKey2.length() <= 0 ? null : typeKey2;
            if (typeName2.length() != 0) {
                this.typeName = typeName2;
            } else {
                this.typeName = cls.getName();
            }
            String[] orders2 = jSONType.orders();
            this.orders = orders2.length == 0 ? null : orders2;
        } else {
            this.typeName = cls.getName();
            this.typeKey = null;
            this.orders = null;
        }
        FieldInfo[] fieldInfoArr = new FieldInfo[list.size()];
        this.fields = fieldInfoArr;
        list.toArray(fieldInfoArr);
        FieldInfo[] fieldInfoArr2 = new FieldInfo[fieldInfoArr.length];
        boolean z = false;
        if (this.orders != null) {
            LinkedHashMap linkedHashMap = new LinkedHashMap(list.size());
            for (FieldInfo fieldInfo : fieldInfoArr) {
                linkedHashMap.put(fieldInfo.name, fieldInfo);
            }
            String[] strArr = this.orders;
            int i = 0;
            for (String str : strArr) {
                FieldInfo fieldInfo2 = (FieldInfo) linkedHashMap.get(str);
                if (fieldInfo2 != null) {
                    fieldInfoArr2[i] = fieldInfo2;
                    linkedHashMap.remove(str);
                    i++;
                }
            }
            for (FieldInfo fieldInfo3 : linkedHashMap.values()) {
                fieldInfoArr2[i] = fieldInfo3;
                i++;
            }
        } else {
            System.arraycopy(fieldInfoArr, 0, fieldInfoArr2, 0, fieldInfoArr.length);
            Arrays.sort(fieldInfoArr2);
        }
        this.sortedFields = Arrays.equals(this.fields, fieldInfoArr2) ? this.fields : fieldInfoArr2;
        if (constructor != null) {
            this.defaultConstructorParameterSize = constructor.getParameterTypes().length;
        } else if (method != null) {
            this.defaultConstructorParameterSize = method.getParameterTypes().length;
        } else {
            this.defaultConstructorParameterSize = 0;
        }
        if (constructor2 != null) {
            this.creatorConstructorParameterTypes = constructor2.getParameterTypes();
            boolean isKotlin = TypeUtils.isKotlin(cls);
            this.f0kotlin = isKotlin;
            if (isKotlin) {
                this.creatorConstructorParameters = TypeUtils.getKoltinConstructorParameters(cls);
                try {
                    this.kotlinDefaultConstructor = cls.getConstructor(new Class[0]);
                } catch (Throwable unused) {
                }
                Annotation[][] parameterAnnotations = TypeUtils.getParameterAnnotations(constructor2);
                int i2 = 0;
                while (i2 < this.creatorConstructorParameters.length && i2 < parameterAnnotations.length) {
                    Annotation[] annotationArr = parameterAnnotations[i2];
                    int length = annotationArr.length;
                    int i3 = 0;
                    while (true) {
                        if (i3 >= length) {
                            jSONField = null;
                            break;
                        }
                        Annotation annotation = annotationArr[i3];
                        if (annotation instanceof JSONField) {
                            jSONField = (JSONField) annotation;
                            break;
                        }
                        i3++;
                    }
                    if (jSONField != null) {
                        String name = jSONField.name();
                        if (name.length() > 0) {
                            this.creatorConstructorParameters[i2] = name;
                        }
                    }
                    i2++;
                }
                return;
            }
            if (this.creatorConstructorParameterTypes.length == this.fields.length) {
                int i4 = 0;
                while (true) {
                    Type[] typeArr = this.creatorConstructorParameterTypes;
                    if (i4 >= typeArr.length) {
                        z = true;
                        break;
                    } else if (typeArr[i4] != this.fields[i4].fieldClass) {
                        break;
                    } else {
                        i4++;
                    }
                }
            }
            if (!z) {
                this.creatorConstructorParameters = ASMUtils.lookupParameterNames(constructor2);
            }
        }
    }

    private static FieldInfo getField(List<FieldInfo> list, String str) {
        for (FieldInfo fieldInfo : list) {
            if (fieldInfo.name.equals(str)) {
                return fieldInfo;
            }
            Field field = fieldInfo.field;
            if (!(field == null || fieldInfo.getAnnotation() == null || !field.getName().equals(str))) {
                return fieldInfo;
            }
        }
        return null;
    }

    static boolean add(List<FieldInfo> list, FieldInfo fieldInfo) {
        for (int size = list.size() - 1; size >= 0; size--) {
            FieldInfo fieldInfo2 = list.get(size);
            if (fieldInfo2.name.equals(fieldInfo.name) && (!fieldInfo2.getOnly || fieldInfo.getOnly)) {
                if (fieldInfo2.fieldClass.isAssignableFrom(fieldInfo.fieldClass)) {
                    list.set(size, fieldInfo);
                    return true;
                } else if (fieldInfo2.compareTo(fieldInfo) >= 0) {
                    return false;
                } else {
                    list.set(size, fieldInfo);
                    return true;
                }
            }
        }
        list.add(fieldInfo);
        return true;
    }

    public static JavaBeanInfo build(Class<?> cls, Type type, PropertyNamingStrategy propertyNamingStrategy) {
        return build(cls, type, propertyNamingStrategy, false, TypeUtils.compatibleWithJavaBean, false);
    }

    private static Map<TypeVariable, Type> buildGenericInfo(Class<?> cls) {
        Class<? super Object> superclass = cls.getSuperclass();
        HashMap hashMap = null;
        if (superclass == null) {
            return null;
        }
        while (true) {
            cls = superclass;
            if (cls == null || cls == Object.class) {
                return hashMap;
            }
            if (cls.getGenericSuperclass() instanceof ParameterizedType) {
                Type[] actualTypeArguments = ((ParameterizedType) cls.getGenericSuperclass()).getActualTypeArguments();
                TypeVariable<Class<?>>[] typeParameters = cls.getTypeParameters();
                for (int i = 0; i < actualTypeArguments.length; i++) {
                    if (hashMap == null) {
                        hashMap = new HashMap();
                    }
                    if (hashMap.containsKey(actualTypeArguments[i])) {
                        hashMap.put(typeParameters[i], hashMap.get(actualTypeArguments[i]));
                    } else {
                        hashMap.put(typeParameters[i], actualTypeArguments[i]);
                    }
                }
            }
            superclass = cls.getSuperclass();
        }
        return hashMap;
    }

    public static JavaBeanInfo build(Class<?> cls, Type type, PropertyNamingStrategy propertyNamingStrategy, boolean z, boolean z2) {
        return build(cls, type, propertyNamingStrategy, z, z2, false);
    }

    /* JADX WARNING: Code restructure failed: missing block: B:136:0x02a8, code lost:
        r7 = r1;
        r22 = r3;
     */
    /* JADX WARNING: Removed duplicated region for block: B:118:0x025d  */
    /* JADX WARNING: Removed duplicated region for block: B:173:0x032e  */
    /* JADX WARNING: Removed duplicated region for block: B:174:0x0334  */
    /* JADX WARNING: Removed duplicated region for block: B:293:0x062e  */
    /* JADX WARNING: Removed duplicated region for block: B:391:0x0866  */
    /* JADX WARNING: Removed duplicated region for block: B:393:0x086c  */
    /* JADX WARNING: Removed duplicated region for block: B:397:0x089a  */
    /* JADX WARNING: Removed duplicated region for block: B:399:0x089e  */
    /* JADX WARNING: Removed duplicated region for block: B:410:0x091c  */
    /* JADX WARNING: Removed duplicated region for block: B:413:0x092f  */
    /* JADX WARNING: Removed duplicated region for block: B:418:0x097b  */
    /* JADX WARNING: Removed duplicated region for block: B:44:0x00c1  */
    /* JADX WARNING: Removed duplicated region for block: B:470:0x0ac1  */
    /* JADX WARNING: Removed duplicated region for block: B:514:0x095e A[EDGE_INSN: B:514:0x095e->B:416:0x095e ?: BREAK  , SYNTHETIC] */
    /* JADX WARNING: Removed duplicated region for block: B:87:0x01ab  */
    public static JavaBeanInfo build(Class<?> cls, Type type, PropertyNamingStrategy propertyNamingStrategy, boolean z, boolean z2, boolean z3) {
        Constructor<?> constructor;
        PropertyNamingStrategy propertyNamingStrategy2;
        Constructor<?> constructor2;
        ArrayList arrayList;
        Method[] methodArr;
        String str;
        PropertyNamingStrategy propertyNamingStrategy3;
        Field[] fieldArr;
        JSONType jSONType;
        Method[] methodArr2;
        Class<?> cls2;
        char c;
        int length;
        int i;
        String str2;
        int i2;
        int length2;
        int i3;
        Field[] fieldArr2;
        PropertyNamingStrategy propertyNamingStrategy4;
        int i4;
        Method[] methodArr3;
        String str3;
        int i5;
        Type type2;
        JSONField jSONField;
        Field[] fieldArr3;
        Field field;
        String str4;
        Field[] fieldArr4;
        Class<?> cls3;
        String str5;
        Method[] methodArr4;
        int i6;
        int i7;
        PropertyNamingStrategy propertyNamingStrategy5;
        ArrayList arrayList2;
        Field[] fieldArr5;
        Class<?> cls4;
        Field field2;
        String str6;
        JSONField jSONField2;
        int i8;
        Field[] fieldArr6;
        String str7;
        PropertyNamingStrategy propertyNamingStrategy6;
        Class<?> cls5;
        Field[] fieldArr7;
        Method[] methodArr5;
        int i9;
        int i10;
        JSONType jSONType2;
        String str8;
        Method[] methodArr6;
        String str9;
        String str10;
        int i11;
        int i12;
        int i13;
        String str11;
        StringBuilder sb;
        char charAt;
        Constructor<?> constructor3;
        String[] strArr;
        JSONField jSONField3;
        int i14;
        int i15;
        int i16;
        String[] lookupParameterNames;
        String[] strArr2;
        JSONField jSONField4;
        int i17;
        int i18;
        int i19;
        String str12;
        JSONField jSONField5;
        int i20;
        int i21;
        int i22;
        String str13;
        Field field3;
        Field field4;
        String[] strArr3;
        Field field5;
        Constructor<?> creatorConstructor2;
        Constructor<?> constructor4;
        PropertyNamingStrategy naming;
        Class<?> cls6 = cls;
        boolean z4 = z3;
        JSONType jSONType3 = (JSONType) TypeUtils.getAnnotation(cls6, JSONType.class);
        PropertyNamingStrategy propertyNamingStrategy7 = (jSONType3 == null || (naming = jSONType3.naming()) == null || naming == PropertyNamingStrategy.CamelCase) ? propertyNamingStrategy : naming;
        Class<?> builderClass2 = getBuilderClass(cls6, jSONType3);
        Field[] declaredFields = cls.getDeclaredFields();
        Method[] methods = cls.getMethods();
        Map<TypeVariable, Type> buildGenericInfo = buildGenericInfo(cls);
        boolean isKotlin = TypeUtils.isKotlin(cls);
        Constructor<?>[] declaredConstructors = cls.getDeclaredConstructors();
        if (!isKotlin || declaredConstructors.length == 1) {
            if (builderClass2 == null) {
                constructor4 = getDefaultConstructor(cls6, declaredConstructors);
            } else {
                constructor4 = getDefaultConstructor(builderClass2, builderClass2.getDeclaredConstructors());
            }
            constructor = constructor4;
        } else {
            constructor = null;
        }
        Method method = null;
        Method method2 = null;
        ArrayList arrayList3 = new ArrayList();
        if (z) {
            for (Class<?> cls7 = cls6; cls7 != null; cls7 = cls7.getSuperclass()) {
                computeFields(cls6, type, propertyNamingStrategy7, arrayList3, cls7.getDeclaredFields());
            }
            if (constructor != null) {
                TypeUtils.setAccessible(constructor);
            }
            return new JavaBeanInfo(cls, builderClass2, constructor, null, null, null, jSONType3, arrayList3);
        }
        boolean z5 = cls.isInterface() || Modifier.isAbstract(cls.getModifiers());
        if (!(constructor == null && builderClass2 == null) && !z5) {
            arrayList = arrayList3;
            propertyNamingStrategy2 = propertyNamingStrategy7;
            methodArr = methods;
            constructor2 = null;
        } else {
            Type mixInAnnotations = JSON.getMixInAnnotations(cls);
            if ((mixInAnnotations instanceof Class) && (creatorConstructor2 = getCreatorConstructor(((Class) mixInAnnotations).getConstructors())) != null) {
                try {
                    constructor3 = cls6.getConstructor(creatorConstructor2.getParameterTypes());
                } catch (NoSuchMethodException unused) {
                }
                if (constructor3 == null) {
                    constructor3 = getCreatorConstructor(declaredConstructors);
                }
                constructor2 = constructor3;
                if (constructor2 != null || z5) {
                    arrayList = arrayList3;
                    propertyNamingStrategy2 = propertyNamingStrategy7;
                    methodArr = methods;
                    method2 = getFactoryMethod(cls6, methodArr, z4);
                    if (method2 == null) {
                        TypeUtils.setAccessible(method2);
                        Class<?>[] parameterTypes = method2.getParameterTypes();
                        if (parameterTypes.length > 0) {
                            Annotation[][] parameterAnnotations = TypeUtils.getParameterAnnotations(method2);
                            String[] strArr4 = null;
                            int i23 = 0;
                            while (i23 < parameterTypes.length) {
                                Annotation[] annotationArr = parameterAnnotations[i23];
                                int length3 = annotationArr.length;
                                int i24 = 0;
                                while (true) {
                                    if (i24 >= length3) {
                                        jSONField4 = null;
                                        break;
                                    }
                                    Annotation annotation = annotationArr[i24];
                                    if (annotation instanceof JSONField) {
                                        jSONField4 = (JSONField) annotation;
                                        break;
                                    }
                                    i24++;
                                }
                                if (jSONField4 != null || (z4 && TypeUtils.isJacksonCreator(method2))) {
                                    if (jSONField4 != null) {
                                        str12 = jSONField4.name();
                                        int ordinal = jSONField4.ordinal();
                                        int of = SerializerFeature.of(jSONField4.serialzeFeatures());
                                        i19 = ordinal;
                                        i17 = Feature.of(jSONField4.parseFeatures());
                                        i18 = of;
                                    } else {
                                        str12 = null;
                                        i19 = 0;
                                        i18 = 0;
                                        i17 = 0;
                                    }
                                    if (str12 == null || str12.length() == 0) {
                                        if (strArr4 == null) {
                                            strArr4 = ASMUtils.lookupParameterNames(method2);
                                        }
                                        str12 = strArr4[i23];
                                    }
                                    add(arrayList, new FieldInfo(str12, cls, parameterTypes[i23], method2.getGenericParameterTypes()[i23], TypeUtils.getField(cls6, str12, declaredFields), i19, i18, i17));
                                    i23++;
                                    z4 = z3;
                                    parameterTypes = parameterTypes;
                                    strArr4 = strArr4;
                                } else {
                                    throw new JSONException("illegal json creator");
                                }
                            }
                            return new JavaBeanInfo(cls, builderClass2, null, null, method2, null, jSONType3, arrayList);
                        }
                    } else if (!z5) {
                        String name = cls.getName();
                        if (!isKotlin || declaredConstructors.length <= 0) {
                            int length4 = declaredConstructors.length;
                            String[] strArr5 = null;
                            int i25 = 0;
                            while (true) {
                                if (i25 >= length4) {
                                    strArr = strArr5;
                                    break;
                                }
                                Constructor<?> constructor5 = declaredConstructors[i25];
                                Class<?>[] parameterTypes2 = constructor5.getParameterTypes();
                                if (name.equals("org.springframework.security.web.authentication.WebAuthenticationDetails")) {
                                    if (parameterTypes2.length == 2 && parameterTypes2[0] == String.class && parameterTypes2[1] == String.class) {
                                        constructor5.setAccessible(true);
                                        strArr2 = ASMUtils.lookupParameterNames(constructor5);
                                        break;
                                    }
                                    i25++;
                                } else if (name.equals("org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken")) {
                                    if (parameterTypes2.length == 3 && parameterTypes2[0] == Object.class && parameterTypes2[1] == Object.class && parameterTypes2[2] == Collection.class) {
                                        constructor5.setAccessible(true);
                                        strArr2 = new String[]{"principal", "credentials", "authorities"};
                                        break;
                                    }
                                    i25++;
                                } else {
                                    if (name.equals("org.springframework.security.core.authority.SimpleGrantedAuthority")) {
                                        if (parameterTypes2.length == 1 && parameterTypes2[0] == String.class) {
                                            strArr = new String[]{IApp.ConfigProperty.CONFIG_AUTHORITY};
                                            constructor2 = constructor5;
                                            break;
                                        }
                                    } else if (((constructor5.getModifiers() & 1) != 0) && (lookupParameterNames = ASMUtils.lookupParameterNames(constructor5)) != null && lookupParameterNames.length != 0 && (constructor2 == null || strArr5 == null || lookupParameterNames.length > strArr5.length)) {
                                        constructor2 = constructor5;
                                        strArr5 = lookupParameterNames;
                                    }
                                    i25++;
                                }
                            }
                            Class<?>[] parameterTypes3 = strArr == null ? constructor2.getParameterTypes() : null;
                            if (strArr == null && parameterTypes3.length == strArr.length) {
                                Annotation[][] parameterAnnotations2 = TypeUtils.getParameterAnnotations(constructor2);
                                int i26 = 0;
                                while (i26 < parameterTypes3.length) {
                                    Annotation[] annotationArr2 = parameterAnnotations2[i26];
                                    String str14 = strArr[i26];
                                    int length5 = annotationArr2.length;
                                    int i27 = 0;
                                    while (true) {
                                        if (i27 >= length5) {
                                            jSONField3 = null;
                                            break;
                                        }
                                        Annotation annotation2 = annotationArr2[i27];
                                        if (annotation2 instanceof JSONField) {
                                            jSONField3 = (JSONField) annotation2;
                                            break;
                                        }
                                        i27++;
                                    }
                                    Class<?> cls8 = parameterTypes3[i26];
                                    Type type3 = constructor2.getGenericParameterTypes()[i26];
                                    Field field6 = TypeUtils.getField(cls6, str14, declaredFields);
                                    if (field6 != null && jSONField3 == null) {
                                        jSONField3 = (JSONField) TypeUtils.getAnnotation(field6, JSONField.class);
                                    }
                                    if (jSONField3 != null) {
                                        String name2 = jSONField3.name();
                                        if (name2.length() != 0) {
                                            str14 = name2;
                                        }
                                        int ordinal2 = jSONField3.ordinal();
                                        int of2 = SerializerFeature.of(jSONField3.serialzeFeatures());
                                        i14 = Feature.of(jSONField3.parseFeatures());
                                        i15 = of2;
                                        i16 = ordinal2;
                                    } else if (!"org.springframework.security.core.userdetails.User".equals(name) || !Constants.Value.PASSWORD.equals(str14)) {
                                        i16 = 0;
                                        i15 = 0;
                                        i14 = 0;
                                    } else {
                                        i14 = Feature.InitStringFieldAsEmpty.mask;
                                        i16 = 0;
                                        i15 = 0;
                                    }
                                    add(arrayList, new FieldInfo(str14, cls, cls8, type3, field6, i16, i15, i14));
                                    i26++;
                                    name = name;
                                    strArr = strArr;
                                    parameterTypes3 = parameterTypes3;
                                }
                                if (!isKotlin && !cls.getName().equals("javax.servlet.http.Cookie")) {
                                    return new JavaBeanInfo(cls, builderClass2, null, constructor2, null, null, jSONType3, arrayList);
                                }
                            } else {
                                throw new JSONException("default constructor not found. " + cls6);
                            }
                        } else {
                            String[] koltinConstructorParameters = TypeUtils.getKoltinConstructorParameters(cls);
                            Constructor<?> kotlinConstructor = TypeUtils.getKotlinConstructor(declaredConstructors, koltinConstructorParameters);
                            TypeUtils.setAccessible(kotlinConstructor);
                            constructor2 = kotlinConstructor;
                            strArr = koltinConstructorParameters;
                        }
                        if (strArr == null) {
                        }
                        if (strArr == null) {
                        }
                        throw new JSONException("default constructor not found. " + cls6);
                    }
                } else {
                    TypeUtils.setAccessible(constructor2);
                    Class<?>[] parameterTypes4 = constructor2.getParameterTypes();
                    if (parameterTypes4.length > 0) {
                        Annotation[][] parameterAnnotations3 = TypeUtils.getParameterAnnotations(constructor2);
                        String[] strArr6 = null;
                        int i28 = 0;
                        while (i28 < parameterTypes4.length && i28 < parameterAnnotations3.length) {
                            Annotation[] annotationArr3 = parameterAnnotations3[i28];
                            int length6 = annotationArr3.length;
                            int i29 = 0;
                            while (true) {
                                if (i29 >= length6) {
                                    jSONField5 = null;
                                    break;
                                }
                                Annotation annotation3 = annotationArr3[i29];
                                if (annotation3 instanceof JSONField) {
                                    jSONField5 = (JSONField) annotation3;
                                    break;
                                }
                                i29++;
                                annotationArr3 = annotationArr3;
                            }
                            Class<?> cls9 = parameterTypes4[i28];
                            Type type4 = constructor2.getGenericParameterTypes()[i28];
                            if (jSONField5 != null) {
                                field3 = TypeUtils.getField(cls6, jSONField5.name(), declaredFields);
                                i22 = jSONField5.ordinal();
                                i21 = SerializerFeature.of(jSONField5.serialzeFeatures());
                                i20 = Feature.of(jSONField5.parseFeatures());
                                str13 = jSONField5.name();
                            } else {
                                field3 = null;
                                str13 = null;
                                i22 = 0;
                                i21 = 0;
                                i20 = 0;
                            }
                            if (str13 == null || str13.length() == 0) {
                                if (strArr6 == null) {
                                    strArr6 = ASMUtils.lookupParameterNames(constructor2);
                                }
                                str13 = strArr6[i28];
                            }
                            if (field3 == null) {
                                if (strArr6 == null) {
                                    if (isKotlin) {
                                        strArr6 = TypeUtils.getKoltinConstructorParameters(cls);
                                    } else {
                                        strArr6 = ASMUtils.lookupParameterNames(constructor2);
                                    }
                                }
                                field5 = field3;
                                if (strArr6.length > i28) {
                                    strArr3 = strArr6;
                                    field4 = TypeUtils.getField(cls6, strArr6[i28], declaredFields);
                                    add(arrayList3, new FieldInfo(str13, cls, cls9, type4, field4, i22, i21, i20));
                                    i28++;
                                    parameterTypes4 = parameterTypes4;
                                    methods = methods;
                                    arrayList3 = arrayList3;
                                    propertyNamingStrategy7 = propertyNamingStrategy7;
                                    strArr6 = strArr3;
                                    parameterAnnotations3 = parameterAnnotations3;
                                }
                            } else {
                                field5 = field3;
                            }
                            field4 = field5;
                            strArr3 = strArr6;
                            add(arrayList3, new FieldInfo(str13, cls, cls9, type4, field4, i22, i21, i20));
                            i28++;
                            parameterTypes4 = parameterTypes4;
                            methods = methods;
                            arrayList3 = arrayList3;
                            propertyNamingStrategy7 = propertyNamingStrategy7;
                            strArr6 = strArr3;
                            parameterAnnotations3 = parameterAnnotations3;
                        }
                    }
                    arrayList = arrayList3;
                    propertyNamingStrategy2 = propertyNamingStrategy7;
                    methodArr = methods;
                }
            }
            constructor3 = null;
            if (constructor3 == null) {
            }
            constructor2 = constructor3;
            if (constructor2 != null) {
            }
            arrayList = arrayList3;
            propertyNamingStrategy2 = propertyNamingStrategy7;
            methodArr = methods;
            method2 = getFactoryMethod(cls6, methodArr, z4);
            if (method2 == null) {
            }
        }
        if (constructor != null) {
            TypeUtils.setAccessible(constructor);
        }
        String str15 = "set";
        if (builderClass2 != null) {
            JSONPOJOBuilder jSONPOJOBuilder = (JSONPOJOBuilder) TypeUtils.getAnnotation(builderClass2, JSONPOJOBuilder.class);
            String withPrefix = jSONPOJOBuilder != null ? jSONPOJOBuilder.withPrefix() : null;
            if (withPrefix == null) {
                withPrefix = "with";
            }
            String str16 = withPrefix;
            Method[] methods2 = builderClass2.getMethods();
            int length7 = methods2.length;
            int i30 = 0;
            while (i30 < length7) {
                Method method3 = methods2[i30];
                if (!Modifier.isStatic(method3.getModifiers()) && method3.getReturnType().equals(builderClass2)) {
                    JSONField jSONField6 = (JSONField) TypeUtils.getAnnotation(method3, JSONField.class);
                    if (jSONField6 == null) {
                        jSONField6 = TypeUtils.getSuperMethodAnnotation(cls6, method3);
                    }
                    if (jSONField6 == null) {
                        i10 = i30;
                        i9 = length7;
                        methodArr5 = methods2;
                        str9 = str16;
                        str10 = str15;
                        fieldArr7 = declaredFields;
                        cls5 = builderClass2;
                        jSONType2 = jSONType3;
                        propertyNamingStrategy6 = propertyNamingStrategy2;
                        methodArr6 = methodArr;
                        i13 = 0;
                        i12 = 0;
                        i11 = 0;
                    } else if (jSONField6.deserialize()) {
                        int ordinal3 = jSONField6.ordinal();
                        int of3 = SerializerFeature.of(jSONField6.serialzeFeatures());
                        int of4 = Feature.of(jSONField6.parseFeatures());
                        if (jSONField6.name().length() != 0) {
                            i10 = i30;
                            i9 = length7;
                            methodArr5 = methods2;
                            fieldArr7 = declaredFields;
                            cls5 = builderClass2;
                            jSONType2 = jSONType3;
                            propertyNamingStrategy6 = propertyNamingStrategy2;
                            methodArr6 = methodArr;
                            add(arrayList, new FieldInfo(jSONField6.name(), method3, null, cls, type, ordinal3, of3, of4, jSONField6, null, null, buildGenericInfo));
                            str8 = str16;
                            str7 = str15;
                            i30 = i10 + 1;
                            cls6 = cls;
                            methodArr = methodArr6;
                            str16 = str8;
                            jSONType3 = jSONType2;
                            length7 = i9;
                            methods2 = methodArr5;
                            declaredFields = fieldArr7;
                            builderClass2 = cls5;
                            propertyNamingStrategy2 = propertyNamingStrategy6;
                            str15 = str7;
                        } else {
                            i10 = i30;
                            i9 = length7;
                            methodArr5 = methods2;
                            str9 = str16;
                            str10 = str15;
                            fieldArr7 = declaredFields;
                            cls5 = builderClass2;
                            jSONType2 = jSONType3;
                            propertyNamingStrategy6 = propertyNamingStrategy2;
                            methodArr6 = methodArr;
                            i13 = ordinal3;
                            i12 = of3;
                            i11 = of4;
                        }
                    }
                    String name3 = method3.getName();
                    if (name3.startsWith(str10)) {
                        if (name3.length() > 3) {
                            sb = new StringBuilder(name3.substring(3));
                            str11 = str9;
                            charAt = sb.charAt(0);
                            if (str11.length() == 0 || Character.isUpperCase(charAt)) {
                                sb.setCharAt(0, Character.toLowerCase(charAt));
                                str8 = str11;
                                str7 = str10;
                                add(arrayList, new FieldInfo(sb.toString(), method3, null, cls, type, i13, i12, i11, jSONField6, null, null, buildGenericInfo));
                                i30 = i10 + 1;
                                cls6 = cls;
                                methodArr = methodArr6;
                                str16 = str8;
                                jSONType3 = jSONType2;
                                length7 = i9;
                                methods2 = methodArr5;
                                declaredFields = fieldArr7;
                                builderClass2 = cls5;
                                propertyNamingStrategy2 = propertyNamingStrategy6;
                                str15 = str7;
                            }
                            str8 = str11;
                            str7 = str10;
                            i30 = i10 + 1;
                            cls6 = cls;
                            methodArr = methodArr6;
                            str16 = str8;
                            jSONType3 = jSONType2;
                            length7 = i9;
                            methods2 = methodArr5;
                            declaredFields = fieldArr7;
                            builderClass2 = cls5;
                            propertyNamingStrategy2 = propertyNamingStrategy6;
                            str15 = str7;
                        }
                    }
                    if (str9.length() == 0) {
                        sb = new StringBuilder(name3);
                        str11 = str9;
                        charAt = sb.charAt(0);
                        sb.setCharAt(0, Character.toLowerCase(charAt));
                        str8 = str11;
                        str7 = str10;
                        add(arrayList, new FieldInfo(sb.toString(), method3, null, cls, type, i13, i12, i11, jSONField6, null, null, buildGenericInfo));
                        i30 = i10 + 1;
                        cls6 = cls;
                        methodArr = methodArr6;
                        str16 = str8;
                        jSONType3 = jSONType2;
                        length7 = i9;
                        methods2 = methodArr5;
                        declaredFields = fieldArr7;
                        builderClass2 = cls5;
                        propertyNamingStrategy2 = propertyNamingStrategy6;
                        str15 = str7;
                    } else {
                        str11 = str9;
                        if (name3.startsWith(str11) && name3.length() > str11.length()) {
                            sb = new StringBuilder(name3.substring(str11.length()));
                            charAt = sb.charAt(0);
                            sb.setCharAt(0, Character.toLowerCase(charAt));
                            str8 = str11;
                            str7 = str10;
                            add(arrayList, new FieldInfo(sb.toString(), method3, null, cls, type, i13, i12, i11, jSONField6, null, null, buildGenericInfo));
                            i30 = i10 + 1;
                            cls6 = cls;
                            methodArr = methodArr6;
                            str16 = str8;
                            jSONType3 = jSONType2;
                            length7 = i9;
                            methods2 = methodArr5;
                            declaredFields = fieldArr7;
                            builderClass2 = cls5;
                            propertyNamingStrategy2 = propertyNamingStrategy6;
                            str15 = str7;
                        }
                        str8 = str11;
                        str7 = str10;
                        i30 = i10 + 1;
                        cls6 = cls;
                        methodArr = methodArr6;
                        str16 = str8;
                        jSONType3 = jSONType2;
                        length7 = i9;
                        methods2 = methodArr5;
                        declaredFields = fieldArr7;
                        builderClass2 = cls5;
                        propertyNamingStrategy2 = propertyNamingStrategy6;
                        str15 = str7;
                    }
                }
                i10 = i30;
                i9 = length7;
                methodArr5 = methods2;
                str8 = str16;
                str7 = str15;
                fieldArr7 = declaredFields;
                cls5 = builderClass2;
                jSONType2 = jSONType3;
                propertyNamingStrategy6 = propertyNamingStrategy2;
                methodArr6 = methodArr;
                i30 = i10 + 1;
                cls6 = cls;
                methodArr = methodArr6;
                str16 = str8;
                jSONType3 = jSONType2;
                length7 = i9;
                methods2 = methodArr5;
                declaredFields = fieldArr7;
                builderClass2 = cls5;
                propertyNamingStrategy2 = propertyNamingStrategy6;
                str15 = str7;
            }
            str = str15;
            fieldArr = declaredFields;
            cls2 = builderClass2;
            jSONType = jSONType3;
            propertyNamingStrategy3 = propertyNamingStrategy2;
            methodArr2 = methodArr;
            if (cls2 != null) {
                JSONPOJOBuilder jSONPOJOBuilder2 = (JSONPOJOBuilder) TypeUtils.getAnnotation(cls2, JSONPOJOBuilder.class);
                String buildMethod2 = jSONPOJOBuilder2 != null ? jSONPOJOBuilder2.buildMethod() : null;
                if (buildMethod2 == null || buildMethod2.length() == 0) {
                    buildMethod2 = "build";
                }
                c = 0;
                try {
                    method = cls2.getMethod(buildMethod2, new Class[0]);
                } catch (NoSuchMethodException | SecurityException unused2) {
                }
                if (method == null) {
                    try {
                        method = cls2.getMethod("create", new Class[0]);
                    } catch (NoSuchMethodException | SecurityException unused3) {
                    }
                }
                if (method != null) {
                    TypeUtils.setAccessible(method);
                    length = methodArr2.length;
                    i = 0;
                    while (true) {
                        str2 = "get";
                        i2 = 4;
                        if (i < length) {
                            break;
                        }
                        Method method4 = methodArr2[i];
                        int i31 = 0;
                        int i32 = 0;
                        int i33 = 0;
                        String name4 = method4.getName();
                        if (!Modifier.isStatic(method4.getModifiers())) {
                            Class<?> returnType = method4.getReturnType();
                            if ((returnType.equals(Void.TYPE) || returnType.equals(method4.getDeclaringClass())) && method4.getDeclaringClass() != Object.class) {
                                Class<?>[] parameterTypes5 = method4.getParameterTypes();
                                if (parameterTypes5.length != 0 && parameterTypes5.length <= 2) {
                                    JSONField jSONField7 = (JSONField) TypeUtils.getAnnotation(method4, JSONField.class);
                                    if (jSONField7 != null && parameterTypes5.length == 2 && parameterTypes5[c] == String.class && parameterTypes5[1] == Object.class) {
                                        i6 = i;
                                        i7 = length;
                                        add(arrayList, new FieldInfo("", method4, null, cls, type, 0, 0, 0, jSONField7, null, null, buildGenericInfo));
                                    } else {
                                        i6 = i;
                                        i7 = length;
                                        if (parameterTypes5.length == 1) {
                                            if (jSONField7 == null) {
                                                jSONField7 = TypeUtils.getSuperMethodAnnotation(cls, method4);
                                            }
                                            if (jSONField7 != null || name4.length() >= 4) {
                                                if (jSONField7 != null) {
                                                    if (jSONField7.deserialize()) {
                                                        i31 = jSONField7.ordinal();
                                                        i32 = SerializerFeature.of(jSONField7.serialzeFeatures());
                                                        int of5 = Feature.of(jSONField7.parseFeatures());
                                                        if (jSONField7.name().length() != 0) {
                                                            add(arrayList, new FieldInfo(jSONField7.name(), method4, null, cls, type, i31, i32, of5, jSONField7, null, null, buildGenericInfo));
                                                        } else {
                                                            i33 = of5;
                                                        }
                                                    }
                                                }
                                                if ((jSONField7 != null || name4.startsWith(str)) && cls2 == null) {
                                                    char charAt2 = name4.charAt(3);
                                                    if (isKotlin) {
                                                        arrayList2 = new ArrayList();
                                                        for (int i34 = 0; i34 < methodArr2.length; i34++) {
                                                            if (methodArr2[i34].getName().startsWith(str2)) {
                                                                arrayList2.add(methodArr2[i34].getName());
                                                            }
                                                        }
                                                    } else {
                                                        arrayList2 = null;
                                                    }
                                                    if (Character.isUpperCase(charAt2) || charAt2 > 512) {
                                                        cls4 = cls;
                                                        fieldArr5 = fieldArr;
                                                        if (isKotlin) {
                                                            str6 = TypeUtils.getPropertyNameByMethodName("g" + name4.substring(1));
                                                        } else if (TypeUtils.compatibleWithJavaBean) {
                                                            str6 = TypeUtils.decapitalize(name4.substring(3));
                                                        } else {
                                                            str6 = TypeUtils.getPropertyNameByMethodName(name4);
                                                        }
                                                        field2 = null;
                                                        if (field2 == null) {
                                                            field2 = TypeUtils.getField(cls4, str6, fieldArr5);
                                                        }
                                                        if (field2 == null) {
                                                            if (parameterTypes5[0] == Boolean.TYPE) {
                                                                field2 = TypeUtils.getField(cls4, "is" + Character.toUpperCase(str6.charAt(0)) + str6.substring(1), fieldArr5);
                                                            }
                                                        }
                                                        if (field2 != null) {
                                                            JSONField jSONField8 = (JSONField) TypeUtils.getAnnotation(field2, JSONField.class);
                                                            if (jSONField8 == null) {
                                                                fieldArr4 = fieldArr5;
                                                                str5 = str;
                                                                methodArr4 = methodArr2;
                                                                i8 = i33;
                                                            } else if (!jSONField8.deserialize()) {
                                                                fieldArr4 = fieldArr5;
                                                            } else {
                                                                i31 = jSONField8.ordinal();
                                                                i32 = SerializerFeature.of(jSONField8.serialzeFeatures());
                                                                int of6 = Feature.of(jSONField8.parseFeatures());
                                                                if (jSONField8.name().length() != 0) {
                                                                    fieldArr4 = fieldArr5;
                                                                    methodArr4 = methodArr2;
                                                                    str5 = str;
                                                                    add(arrayList, new FieldInfo(jSONField8.name(), method4, field2, cls, type, i31, i32, of6, jSONField7, jSONField8, null, buildGenericInfo));
                                                                    cls3 = cls2;
                                                                    propertyNamingStrategy5 = propertyNamingStrategy3;
                                                                    i = i6 + 1;
                                                                    propertyNamingStrategy3 = propertyNamingStrategy5;
                                                                    length = i7;
                                                                    methodArr2 = methodArr4;
                                                                    str = str5;
                                                                    cls2 = cls3;
                                                                    fieldArr = fieldArr4;
                                                                    c = 0;
                                                                } else {
                                                                    fieldArr4 = fieldArr5;
                                                                    str5 = str;
                                                                    methodArr4 = methodArr2;
                                                                    i8 = of6;
                                                                }
                                                            }
                                                            jSONField2 = jSONField8;
                                                        } else {
                                                            fieldArr4 = fieldArr5;
                                                            str5 = str;
                                                            methodArr4 = methodArr2;
                                                            jSONField2 = null;
                                                            i8 = i33;
                                                        }
                                                        if (propertyNamingStrategy3 != null) {
                                                            str6 = propertyNamingStrategy3.translate(str6);
                                                        }
                                                        cls3 = cls2;
                                                        propertyNamingStrategy5 = propertyNamingStrategy3;
                                                        add(arrayList, new FieldInfo(str6, method4, field2, cls, type, i31, i32, i8, jSONField7, jSONField2, null, buildGenericInfo));
                                                        i = i6 + 1;
                                                        propertyNamingStrategy3 = propertyNamingStrategy5;
                                                        length = i7;
                                                        methodArr2 = methodArr4;
                                                        str = str5;
                                                        cls2 = cls3;
                                                        fieldArr = fieldArr4;
                                                        c = 0;
                                                    } else {
                                                        if (charAt2 != '_') {
                                                            cls4 = cls;
                                                            fieldArr6 = fieldArr;
                                                            if (charAt2 == 'f') {
                                                                str6 = name4.substring(3);
                                                            } else if (name4.length() < 5 || !Character.isUpperCase(name4.charAt(4))) {
                                                                str6 = name4.substring(3);
                                                                field2 = TypeUtils.getField(cls4, str6, fieldArr6);
                                                                if (field2 == null) {
                                                                    fieldArr4 = fieldArr6;
                                                                }
                                                            } else {
                                                                str6 = TypeUtils.decapitalize(name4.substring(3));
                                                            }
                                                            fieldArr5 = fieldArr6;
                                                            field2 = null;
                                                            if (field2 == null) {
                                                            }
                                                            if (field2 == null) {
                                                            }
                                                            if (field2 != null) {
                                                            }
                                                            if (propertyNamingStrategy3 != null) {
                                                            }
                                                            cls3 = cls2;
                                                            propertyNamingStrategy5 = propertyNamingStrategy3;
                                                            add(arrayList, new FieldInfo(str6, method4, field2, cls, type, i31, i32, i8, jSONField7, jSONField2, null, buildGenericInfo));
                                                            i = i6 + 1;
                                                            propertyNamingStrategy3 = propertyNamingStrategy5;
                                                            length = i7;
                                                            methodArr2 = methodArr4;
                                                            str = str5;
                                                            cls2 = cls3;
                                                            fieldArr = fieldArr4;
                                                            c = 0;
                                                        } else if (isKotlin) {
                                                            str6 = arrayList2.contains("g" + name4.substring(1)) ? name4.substring(3) : "is" + name4.substring(3);
                                                            cls4 = cls;
                                                            fieldArr6 = fieldArr;
                                                            field2 = TypeUtils.getField(cls4, str6, fieldArr6);
                                                        } else {
                                                            cls4 = cls;
                                                            fieldArr6 = fieldArr;
                                                            String substring = name4.substring(4);
                                                            Field field7 = TypeUtils.getField(cls4, substring, fieldArr6);
                                                            if (field7 != null || (field7 = TypeUtils.getField(cls4, (str6 = name4.substring(3)), fieldArr6)) == null) {
                                                                str6 = substring;
                                                            }
                                                            field2 = field7;
                                                        }
                                                        fieldArr5 = fieldArr6;
                                                        if (field2 == null) {
                                                        }
                                                        if (field2 == null) {
                                                        }
                                                        if (field2 != null) {
                                                        }
                                                        if (propertyNamingStrategy3 != null) {
                                                        }
                                                        cls3 = cls2;
                                                        propertyNamingStrategy5 = propertyNamingStrategy3;
                                                        add(arrayList, new FieldInfo(str6, method4, field2, cls, type, i31, i32, i8, jSONField7, jSONField2, null, buildGenericInfo));
                                                        i = i6 + 1;
                                                        propertyNamingStrategy3 = propertyNamingStrategy5;
                                                        length = i7;
                                                        methodArr2 = methodArr4;
                                                        str = str5;
                                                        cls2 = cls3;
                                                        fieldArr = fieldArr4;
                                                        c = 0;
                                                    }
                                                    str5 = str;
                                                    cls3 = cls2;
                                                    methodArr4 = methodArr2;
                                                } else {
                                                    str5 = str;
                                                    cls3 = cls2;
                                                    methodArr4 = methodArr2;
                                                    fieldArr4 = fieldArr;
                                                }
                                                propertyNamingStrategy5 = propertyNamingStrategy3;
                                                i = i6 + 1;
                                                propertyNamingStrategy3 = propertyNamingStrategy5;
                                                length = i7;
                                                methodArr2 = methodArr4;
                                                str = str5;
                                                cls2 = cls3;
                                                fieldArr = fieldArr4;
                                                c = 0;
                                            }
                                        }
                                    }
                                    cls3 = cls2;
                                    methodArr4 = methodArr2;
                                    fieldArr4 = fieldArr;
                                    propertyNamingStrategy5 = propertyNamingStrategy3;
                                    str5 = str;
                                    i = i6 + 1;
                                    propertyNamingStrategy3 = propertyNamingStrategy5;
                                    length = i7;
                                    methodArr2 = methodArr4;
                                    str = str5;
                                    cls2 = cls3;
                                    fieldArr = fieldArr4;
                                    c = 0;
                                }
                            }
                        }
                        i6 = i;
                        i7 = length;
                        cls3 = cls2;
                        methodArr4 = methodArr2;
                        fieldArr4 = fieldArr;
                        propertyNamingStrategy5 = propertyNamingStrategy3;
                        str5 = str;
                        i = i6 + 1;
                        propertyNamingStrategy3 = propertyNamingStrategy5;
                        length = i7;
                        methodArr2 = methodArr4;
                        str = str5;
                        cls2 = cls3;
                        fieldArr = fieldArr4;
                        c = 0;
                    }
                    Field[] fieldArr8 = fieldArr;
                    PropertyNamingStrategy propertyNamingStrategy8 = propertyNamingStrategy3;
                    boolean z6 = true;
                    Type type5 = type;
                    computeFields(cls, type5, propertyNamingStrategy8, arrayList, cls.getFields());
                    Method[] methods3 = cls.getMethods();
                    length2 = methods3.length;
                    i3 = 0;
                    while (i3 < length2) {
                        Method method5 = methods3[i3];
                        String name5 = method5.getName();
                        if (name5.length() >= i2 && !Modifier.isStatic(method5.getModifiers()) && cls2 == null && name5.startsWith(str2) && Character.isUpperCase(name5.charAt(3)) && method5.getParameterTypes().length == 0 && ((Collection.class.isAssignableFrom(method5.getReturnType()) || Map.class.isAssignableFrom(method5.getReturnType()) || AtomicBoolean.class == method5.getReturnType() || AtomicInteger.class == method5.getReturnType() || AtomicLong.class == method5.getReturnType()) && ((jSONField = (JSONField) TypeUtils.getAnnotation(method5, JSONField.class)) == null || !jSONField.deserialize()))) {
                            if (jSONField == null || jSONField.name().length() <= 0) {
                                str4 = TypeUtils.getPropertyNameByMethodName(name5);
                                fieldArr3 = fieldArr8;
                                Field field8 = TypeUtils.getField(cls, str4, fieldArr3);
                                if (field8 != null) {
                                    JSONField jSONField9 = (JSONField) TypeUtils.getAnnotation(field8, JSONField.class);
                                    if (jSONField9 == null || jSONField9.deserialize()) {
                                        if (Collection.class.isAssignableFrom(method5.getReturnType()) || Map.class.isAssignableFrom(method5.getReturnType())) {
                                            field = field8;
                                        }
                                    }
                                    fieldArr2 = fieldArr3;
                                    i4 = i3;
                                    str3 = str2;
                                    i5 = length2;
                                    methodArr3 = methods3;
                                    propertyNamingStrategy4 = propertyNamingStrategy8;
                                }
                                field = null;
                            } else {
                                str4 = jSONField.name();
                                field = null;
                                fieldArr3 = fieldArr8;
                            }
                            if (propertyNamingStrategy8 != null) {
                                str4 = propertyNamingStrategy8.translate(str4);
                            }
                            if (getField(arrayList, str4) == null) {
                                fieldArr2 = fieldArr3;
                                i4 = i3;
                                str3 = str2;
                                i5 = length2;
                                methodArr3 = methods3;
                                propertyNamingStrategy4 = propertyNamingStrategy8;
                                type2 = type5;
                                add(arrayList, new FieldInfo(str4, method5, field, cls, type, 0, 0, 0, jSONField, null, null, buildGenericInfo));
                                i3 = i4 + 1;
                                type5 = type2;
                                length2 = i5;
                                str2 = str3;
                                methods3 = methodArr3;
                                propertyNamingStrategy8 = propertyNamingStrategy4;
                                fieldArr8 = fieldArr2;
                                i2 = 4;
                            }
                            fieldArr2 = fieldArr3;
                            i4 = i3;
                            str3 = str2;
                            i5 = length2;
                            methodArr3 = methods3;
                            propertyNamingStrategy4 = propertyNamingStrategy8;
                        } else {
                            i4 = i3;
                            str3 = str2;
                            i5 = length2;
                            methodArr3 = methods3;
                            propertyNamingStrategy4 = propertyNamingStrategy8;
                            fieldArr2 = fieldArr8;
                        }
                        type2 = type5;
                        i3 = i4 + 1;
                        type5 = type2;
                        length2 = i5;
                        str2 = str3;
                        methods3 = methodArr3;
                        propertyNamingStrategy8 = propertyNamingStrategy4;
                        fieldArr8 = fieldArr2;
                        i2 = 4;
                    }
                    if (arrayList.size() == 0) {
                        if (!TypeUtils.isXmlField(cls)) {
                            z6 = z;
                        }
                        if (z6) {
                            for (Class<?> cls10 = cls; cls10 != null; cls10 = cls10.getSuperclass()) {
                                computeFields(cls, type5, propertyNamingStrategy8, arrayList, fieldArr8);
                            }
                        }
                    }
                    return new JavaBeanInfo(cls, cls2, constructor, constructor2, method2, method, jSONType, arrayList);
                }
                throw new JSONException("buildMethod not found.");
            }
        } else {
            str = str15;
            fieldArr = declaredFields;
            cls2 = builderClass2;
            jSONType = jSONType3;
            propertyNamingStrategy3 = propertyNamingStrategy2;
            methodArr2 = methodArr;
        }
        c = 0;
        length = methodArr2.length;
        i = 0;
        while (true) {
            str2 = "get";
            i2 = 4;
            if (i < length) {
            }
            i = i6 + 1;
            propertyNamingStrategy3 = propertyNamingStrategy5;
            length = i7;
            methodArr2 = methodArr4;
            str = str5;
            cls2 = cls3;
            fieldArr = fieldArr4;
            c = 0;
        }
        Field[] fieldArr82 = fieldArr;
        PropertyNamingStrategy propertyNamingStrategy82 = propertyNamingStrategy3;
        boolean z62 = true;
        Type type52 = type;
        computeFields(cls, type52, propertyNamingStrategy82, arrayList, cls.getFields());
        Method[] methods32 = cls.getMethods();
        length2 = methods32.length;
        i3 = 0;
        while (i3 < length2) {
        }
        if (arrayList.size() == 0) {
        }
        return new JavaBeanInfo(cls, cls2, constructor, constructor2, method2, method, jSONType, arrayList);
    }

    /* JADX WARNING: Code restructure failed: missing block: B:19:0x0055, code lost:
        if ((java.util.Map.class.isAssignableFrom(r2) || java.util.Collection.class.isAssignableFrom(r2) || java.util.concurrent.atomic.AtomicLong.class.equals(r2) || java.util.concurrent.atomic.AtomicInteger.class.equals(r2) || java.util.concurrent.atomic.AtomicBoolean.class.equals(r2)) == false) goto L_0x0018;
     */
    private static void computeFields(Class<?> cls, Type type, PropertyNamingStrategy propertyNamingStrategy, List<FieldInfo> list, Field[] fieldArr) {
        int i;
        int i2;
        int i3;
        int i4;
        int i5;
        Map<TypeVariable, Type> buildGenericInfo = buildGenericInfo(cls);
        int length = fieldArr.length;
        int i6 = 0;
        while (i6 < length) {
            Field field = fieldArr[i6];
            int modifiers = field.getModifiers();
            if ((modifiers & 8) == 0) {
                boolean z = true;
                if ((modifiers & 16) != 0) {
                    Class<?> type2 = field.getType();
                }
                Iterator<FieldInfo> it = list.iterator();
                while (true) {
                    if (it.hasNext()) {
                        if (it.next().name.equals(field.getName())) {
                            break;
                        }
                    } else {
                        z = false;
                        break;
                    }
                }
                if (!z) {
                    String name = field.getName();
                    JSONField jSONField = (JSONField) TypeUtils.getAnnotation(field, JSONField.class);
                    if (jSONField == null) {
                        i5 = 0;
                        i4 = 0;
                        i3 = 0;
                    } else if (jSONField.deserialize()) {
                        int ordinal = jSONField.ordinal();
                        int of = SerializerFeature.of(jSONField.serialzeFeatures());
                        int of2 = Feature.of(jSONField.parseFeatures());
                        if (jSONField.name().length() != 0) {
                            name = jSONField.name();
                        }
                        i5 = ordinal;
                        i4 = of;
                        i3 = of2;
                    }
                    if (propertyNamingStrategy != null) {
                        name = propertyNamingStrategy.translate(name);
                    }
                    i2 = i6;
                    i = length;
                    add(list, new FieldInfo(name, null, field, cls, type, i5, i4, i3, null, jSONField, null, buildGenericInfo));
                    i6 = i2 + 1;
                    length = i;
                }
            }
            i2 = i6;
            i = length;
            i6 = i2 + 1;
            length = i;
        }
    }

    static Constructor<?> getDefaultConstructor(Class<?> cls, Constructor<?>[] constructorArr) {
        Constructor<?> constructor = null;
        if (Modifier.isAbstract(cls.getModifiers())) {
            return null;
        }
        int length = constructorArr.length;
        int i = 0;
        while (true) {
            if (i >= length) {
                break;
            }
            Constructor<?> constructor2 = constructorArr[i];
            if (constructor2.getParameterTypes().length == 0) {
                constructor = constructor2;
                break;
            }
            i++;
        }
        if (constructor != null || !cls.isMemberClass() || Modifier.isStatic(cls.getModifiers())) {
            return constructor;
        }
        for (Constructor<?> constructor3 : constructorArr) {
            Class<?>[] parameterTypes = constructor3.getParameterTypes();
            if (parameterTypes.length == 1 && parameterTypes[0].equals(cls.getDeclaringClass())) {
                return constructor3;
            }
        }
        return constructor;
    }

    public static Constructor<?> getCreatorConstructor(Constructor[] constructorArr) {
        boolean z;
        Constructor constructor = null;
        for (Constructor constructor2 : constructorArr) {
            if (((JSONCreator) constructor2.getAnnotation(JSONCreator.class)) != null) {
                if (constructor == null) {
                    constructor = constructor2;
                } else {
                    throw new JSONException("multi-JSONCreator");
                }
            }
        }
        if (constructor != null) {
            return constructor;
        }
        for (Constructor constructor3 : constructorArr) {
            Annotation[][] parameterAnnotations = TypeUtils.getParameterAnnotations(constructor3);
            if (parameterAnnotations.length != 0) {
                int length = parameterAnnotations.length;
                int i = 0;
                while (true) {
                    z = true;
                    if (i >= length) {
                        break;
                    }
                    Annotation[] annotationArr = parameterAnnotations[i];
                    int length2 = annotationArr.length;
                    int i2 = 0;
                    while (true) {
                        if (i2 >= length2) {
                            z = false;
                            break;
                        } else if (annotationArr[i2] instanceof JSONField) {
                            break;
                        } else {
                            i2++;
                        }
                    }
                    if (!z) {
                        z = false;
                        break;
                    }
                    i++;
                }
                if (!z) {
                    continue;
                } else if (constructor == null) {
                    constructor = constructor3;
                } else {
                    throw new JSONException("multi-JSONCreator");
                }
            }
        }
        return constructor;
    }

    private static Method getFactoryMethod(Class<?> cls, Method[] methodArr, boolean z) {
        Method method = null;
        for (Method method2 : methodArr) {
            if (Modifier.isStatic(method2.getModifiers()) && cls.isAssignableFrom(method2.getReturnType()) && ((JSONCreator) TypeUtils.getAnnotation(method2, JSONCreator.class)) != null) {
                if (method == null) {
                    method = method2;
                } else {
                    throw new JSONException("multi-JSONCreator");
                }
            }
        }
        if (method != null || !z) {
            return method;
        }
        for (Method method3 : methodArr) {
            if (TypeUtils.isJacksonCreator(method3)) {
                return method3;
            }
        }
        return method;
    }

    public static Class<?> getBuilderClass(JSONType jSONType) {
        return getBuilderClass(null, jSONType);
    }

    public static Class<?> getBuilderClass(Class<?> cls, JSONType jSONType) {
        Class<?> builder;
        if (cls != null && cls.getName().equals("org.springframework.security.web.savedrequest.DefaultSavedRequest")) {
            return TypeUtils.loadClass("org.springframework.security.web.savedrequest.DefaultSavedRequest$Builder");
        }
        if (jSONType == null || (builder = jSONType.builder()) == Void.class) {
            return null;
        }
        return builder;
    }
}
