package com.alibaba.fastjson.util;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.asm.ClassReader;
import com.alibaba.fastjson.asm.TypeCollector;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.util.ExifInterface;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class ASMUtils {
    public static final boolean IS_ANDROID;
    public static final String JAVA_VM_NAME;

    static {
        String property = System.getProperty("java.vm.name");
        JAVA_VM_NAME = property;
        IS_ANDROID = isAndroid(property);
    }

    public static boolean isAndroid(String str) {
        if (str == null) {
            return false;
        }
        String lowerCase = str.toLowerCase();
        if (lowerCase.contains("dalvik") || lowerCase.contains("lemur")) {
            return true;
        }
        return false;
    }

    public static String desc(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuilder sb = new StringBuilder((parameterTypes.length + 1) << 4);
        sb.append(Operators.BRACKET_START);
        for (Class<?> cls : parameterTypes) {
            sb.append(desc(cls));
        }
        sb.append(Operators.BRACKET_END);
        sb.append(desc(method.getReturnType()));
        return sb.toString();
    }

    public static String desc(Class<?> cls) {
        if (cls.isPrimitive()) {
            return getPrimitiveLetter(cls);
        }
        if (cls.isArray()) {
            return Operators.ARRAY_START_STR + desc(cls.getComponentType());
        }
        return "L" + type(cls) + ";";
    }

    public static String type(Class<?> cls) {
        if (cls.isArray()) {
            return Operators.ARRAY_START_STR + desc(cls.getComponentType());
        } else if (!cls.isPrimitive()) {
            return cls.getName().replace(Operators.DOT, '/');
        } else {
            return getPrimitiveLetter(cls);
        }
    }

    public static String getPrimitiveLetter(Class<?> cls) {
        if (Integer.TYPE == cls) {
            return "I";
        }
        if (Void.TYPE == cls) {
            return ExifInterface.GPS_MEASUREMENT_INTERRUPTED;
        }
        if (Boolean.TYPE == cls) {
            return "Z";
        }
        if (Character.TYPE == cls) {
            return "C";
        }
        if (Byte.TYPE == cls) {
            return "B";
        }
        if (Short.TYPE == cls) {
            return ExifInterface.LATITUDE_SOUTH;
        }
        if (Float.TYPE == cls) {
            return "F";
        }
        if (Long.TYPE == cls) {
            return "J";
        }
        if (Double.TYPE == cls) {
            return "D";
        }
        throw new IllegalStateException("Type: " + cls.getCanonicalName() + " is not a primitive type");
    }

    public static Type getMethodType(Class<?> cls, String str) {
        try {
            return cls.getMethod(str, new Class[0]).getGenericReturnType();
        } catch (Exception unused) {
            return null;
        }
    }

    public static boolean checkName(String str) {
        for (int i = 0; i < str.length(); i++) {
            char charAt = str.charAt(i);
            if (charAt < 1 || charAt > 127 || charAt == '.') {
                return false;
            }
        }
        return true;
    }

    /* JADX WARNING: Can't wrap try/catch for region: R(4:40|41|42|43) */
    /* JADX WARNING: Code restructure failed: missing block: B:39:0x00a4, code lost:
        r8 = move-exception;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:43:0x00ab, code lost:
        return new java.lang.String[0];
     */
    /* JADX WARNING: Code restructure failed: missing block: B:44:0x00ac, code lost:
        com.alibaba.fastjson.util.IOUtils.close(r3);
     */
    /* JADX WARNING: Code restructure failed: missing block: B:45:0x00b0, code lost:
        throw r8;
     */
    /* JADX WARNING: Failed to process nested try/catch */
    /* JADX WARNING: Missing exception handler attribute for start block: B:40:0x00a6 */
    public static String[] lookupParameterNames(AccessibleObject accessibleObject) {
        Annotation[][] annotationArr;
        Class<?> cls;
        String str;
        Class<?>[] clsArr;
        String name;
        if (IS_ANDROID) {
            return new String[0];
        }
        if (accessibleObject instanceof Method) {
            Method method = (Method) accessibleObject;
            clsArr = method.getParameterTypes();
            str = method.getName();
            cls = method.getDeclaringClass();
            annotationArr = TypeUtils.getParameterAnnotations(method);
        } else {
            Constructor constructor = (Constructor) accessibleObject;
            clsArr = constructor.getParameterTypes();
            cls = constructor.getDeclaringClass();
            annotationArr = TypeUtils.getParameterAnnotations(constructor);
            str = "<init>";
        }
        if (clsArr.length == 0) {
            return new String[0];
        }
        ClassLoader classLoader = cls.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String name2 = cls.getName();
        InputStream resourceAsStream = classLoader.getResourceAsStream(name2.replace(Operators.DOT, '/') + ".class");
        if (resourceAsStream == null) {
            return new String[0];
        }
        ClassReader classReader = new ClassReader(resourceAsStream, false);
        TypeCollector typeCollector = new TypeCollector(str, clsArr);
        classReader.accept(typeCollector);
        String[] parameterNamesForMethod = typeCollector.getParameterNamesForMethod();
        for (int i = 0; i < parameterNamesForMethod.length; i++) {
            Annotation[] annotationArr2 = annotationArr[i];
            if (annotationArr2 != null) {
                for (int i2 = 0; i2 < annotationArr2.length; i2++) {
                    if ((annotationArr2[i2] instanceof JSONField) && (name = ((JSONField) annotationArr2[i2]).name()) != null && name.length() > 0) {
                        parameterNamesForMethod[i] = name;
                    }
                }
            }
        }
        IOUtils.close(resourceAsStream);
        return parameterNamesForMethod;
    }
}
