package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobSerializer implements ObjectSerializer {
    public static final ClobSerializer instance = new ClobSerializer();

    @Override // com.alibaba.fastjson.serializer.ObjectSerializer
    public void write(JSONSerializer jSONSerializer, Object obj, Object obj2, Type type, int i) throws IOException {
        if (obj == null) {
            try {
                jSONSerializer.writeNull();
            } catch (SQLException e) {
                throw new IOException("write clob error", e);
            }
        } else {
            Reader characterStream = ((Clob) obj).getCharacterStream();
            StringBuilder sb = new StringBuilder();
            try {
                char[] cArr = new char[2048];
                while (true) {
                    int read = characterStream.read(cArr, 0, 2048);
                    if (read < 0) {
                        String sb2 = sb.toString();
                        characterStream.close();
                        jSONSerializer.write(sb2);
                        return;
                    }
                    sb.append(cArr, 0, read);
                }
            } catch (Exception e2) {
                throw new JSONException("read string from reader error", e2);
            }
        }
    }
}
