package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONLexerBase;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.JavaBeanInfo;
import com.alibaba.fastjson.util.TypeUtils;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.util.PdrUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JavaBeanDeserializer implements ObjectDeserializer {
    private final Map<String, FieldDeserializer> alterNameFieldDeserializers;
    private final ParserConfig.AutoTypeCheckHandler autoTypeCheckHandler;
    public final JavaBeanInfo beanInfo;
    protected final Class<?> clazz;
    private ConcurrentMap<String, Object> extraFieldDeserializers;
    private Map<String, FieldDeserializer> fieldDeserializerMap;
    private final FieldDeserializer[] fieldDeserializers;
    private transient long[] hashArray;
    private transient short[] hashArrayMapping;
    private transient long[] smartMatchHashArray;
    private transient short[] smartMatchHashArrayMapping;
    protected final FieldDeserializer[] sortedFieldDeserializers;

    @Override // com.alibaba.fastjson.parser.deserializer.ObjectDeserializer
    public int getFastMatchToken() {
        return 12;
    }

    public JavaBeanDeserializer(ParserConfig parserConfig, Class<?> cls) {
        this(parserConfig, cls, cls);
    }

    public JavaBeanDeserializer(ParserConfig parserConfig, Class<?> cls, Type type) {
        this(parserConfig, JavaBeanInfo.build(cls, type, parserConfig.propertyNamingStrategy, parserConfig.fieldBased, parserConfig.compatibleWithJavaBean, parserConfig.isJacksonCompatible()));
    }

    /* JADX WARNING: Removed duplicated region for block: B:10:0x0036  */
    /* JADX WARNING: Removed duplicated region for block: B:25:0x007e A[LOOP:2: B:24:0x007c->B:25:0x007e, LOOP_END] */
    public JavaBeanDeserializer(ParserConfig parserConfig, JavaBeanInfo javaBeanInfo) {
        ParserConfig.AutoTypeCheckHandler autoTypeCheckHandler2;
        int length;
        int i;
        int i2;
        int length2;
        this.clazz = javaBeanInfo.clazz;
        this.beanInfo = javaBeanInfo;
        HashMap hashMap = null;
        if (!(javaBeanInfo.jsonType == null || javaBeanInfo.jsonType.autoTypeCheckHandler() == ParserConfig.AutoTypeCheckHandler.class)) {
            try {
                autoTypeCheckHandler2 = (ParserConfig.AutoTypeCheckHandler) javaBeanInfo.jsonType.autoTypeCheckHandler().newInstance();
            } catch (Exception unused) {
            }
            this.autoTypeCheckHandler = autoTypeCheckHandler2;
            this.sortedFieldDeserializers = new FieldDeserializer[javaBeanInfo.sortedFields.length];
            length = javaBeanInfo.sortedFields.length;
            for (i2 = 0; i2 < length; i2++) {
                FieldInfo fieldInfo = javaBeanInfo.sortedFields[i2];
                FieldDeserializer createFieldDeserializer = parserConfig.createFieldDeserializer(parserConfig, javaBeanInfo, fieldInfo);
                this.sortedFieldDeserializers[i2] = createFieldDeserializer;
                if (length > 128) {
                    if (this.fieldDeserializerMap == null) {
                        this.fieldDeserializerMap = new HashMap();
                    }
                    this.fieldDeserializerMap.put(fieldInfo.name, createFieldDeserializer);
                }
                String[] strArr = fieldInfo.alternateNames;
                for (String str : strArr) {
                    if (hashMap == null) {
                        hashMap = new HashMap();
                    }
                    hashMap.put(str, createFieldDeserializer);
                }
            }
            this.alterNameFieldDeserializers = hashMap;
            this.fieldDeserializers = new FieldDeserializer[javaBeanInfo.fields.length];
            length2 = javaBeanInfo.fields.length;
            for (i = 0; i < length2; i++) {
                this.fieldDeserializers[i] = getFieldDeserializer(javaBeanInfo.fields[i].name);
            }
        }
        autoTypeCheckHandler2 = null;
        this.autoTypeCheckHandler = autoTypeCheckHandler2;
        this.sortedFieldDeserializers = new FieldDeserializer[javaBeanInfo.sortedFields.length];
        length = javaBeanInfo.sortedFields.length;
        while (i2 < length) {
        }
        this.alterNameFieldDeserializers = hashMap;
        this.fieldDeserializers = new FieldDeserializer[javaBeanInfo.fields.length];
        length2 = javaBeanInfo.fields.length;
        while (i < length2) {
        }
    }

    public FieldDeserializer getFieldDeserializer(String str) {
        return getFieldDeserializer(str, null);
    }

    public FieldDeserializer getFieldDeserializer(String str, int[] iArr) {
        FieldDeserializer fieldDeserializer;
        if (str == null) {
            return null;
        }
        Map<String, FieldDeserializer> map = this.fieldDeserializerMap;
        if (map != null && (fieldDeserializer = map.get(str)) != null) {
            return fieldDeserializer;
        }
        int i = 0;
        int length = this.sortedFieldDeserializers.length - 1;
        while (i <= length) {
            int i2 = (i + length) >>> 1;
            int compareTo = this.sortedFieldDeserializers[i2].fieldInfo.name.compareTo(str);
            if (compareTo < 0) {
                i = i2 + 1;
            } else if (compareTo > 0) {
                length = i2 - 1;
            } else if (isSetFlag(i2, iArr)) {
                return null;
            } else {
                return this.sortedFieldDeserializers[i2];
            }
        }
        Map<String, FieldDeserializer> map2 = this.alterNameFieldDeserializers;
        if (map2 != null) {
            return map2.get(str);
        }
        return null;
    }

    public FieldDeserializer getFieldDeserializer(long j) {
        int i = 0;
        if (this.hashArray == null) {
            long[] jArr = new long[this.sortedFieldDeserializers.length];
            int i2 = 0;
            while (true) {
                FieldDeserializer[] fieldDeserializerArr = this.sortedFieldDeserializers;
                if (i2 >= fieldDeserializerArr.length) {
                    break;
                }
                jArr[i2] = TypeUtils.fnv1a_64(fieldDeserializerArr[i2].fieldInfo.name);
                i2++;
            }
            Arrays.sort(jArr);
            this.hashArray = jArr;
        }
        int binarySearch = Arrays.binarySearch(this.hashArray, j);
        if (binarySearch < 0) {
            return null;
        }
        if (this.hashArrayMapping == null) {
            short[] sArr = new short[this.hashArray.length];
            Arrays.fill(sArr, (short) -1);
            while (true) {
                FieldDeserializer[] fieldDeserializerArr2 = this.sortedFieldDeserializers;
                if (i >= fieldDeserializerArr2.length) {
                    break;
                }
                int binarySearch2 = Arrays.binarySearch(this.hashArray, TypeUtils.fnv1a_64(fieldDeserializerArr2[i].fieldInfo.name));
                if (binarySearch2 >= 0) {
                    sArr[binarySearch2] = (short) i;
                }
                i++;
            }
            this.hashArrayMapping = sArr;
        }
        short s = this.hashArrayMapping[binarySearch];
        if (s != -1) {
            return this.sortedFieldDeserializers[s];
        }
        return null;
    }

    static boolean isSetFlag(int i, int[] iArr) {
        int i2;
        if (iArr == null || (i2 = i / 32) >= iArr.length) {
            return false;
        }
        if (((1 << (i % 32)) & iArr[i2]) != 0) {
            return true;
        }
        return false;
    }

    public Object createInstance(DefaultJSONParser defaultJSONParser, Type type) {
        Object obj;
        if (!(type instanceof Class) || !this.clazz.isInterface()) {
            Object obj2 = null;
            if (this.beanInfo.defaultConstructor == null && this.beanInfo.factoryMethod == null) {
                return null;
            }
            if (this.beanInfo.factoryMethod != null && this.beanInfo.defaultConstructorParameterSize > 0) {
                return null;
            }
            try {
                Constructor<?> constructor = this.beanInfo.defaultConstructor;
                if (this.beanInfo.defaultConstructorParameterSize != 0) {
                    ParseContext context = defaultJSONParser.getContext();
                    if (context == null || context.object == null) {
                        throw new JSONException("can't create non-static inner class instance.");
                    } else if (type instanceof Class) {
                        String name = ((Class) type).getName();
                        String substring = name.substring(0, name.lastIndexOf(36));
                        Object obj3 = context.object;
                        String name2 = obj3.getClass().getName();
                        if (!name2.equals(substring)) {
                            ParseContext parseContext = context.parent;
                            if (parseContext == null || parseContext.object == null || (!"java.util.ArrayList".equals(name2) && !"java.util.List".equals(name2) && !"java.util.Collection".equals(name2) && !"java.util.Map".equals(name2) && !"java.util.HashMap".equals(name2))) {
                                obj2 = obj3;
                            } else if (parseContext.object.getClass().getName().equals(substring)) {
                                obj2 = parseContext.object;
                            }
                            obj3 = obj2;
                        }
                        if (obj3 == null || ((obj3 instanceof Collection) && ((Collection) obj3).isEmpty())) {
                            throw new JSONException("can't create non-static inner class instance.");
                        }
                        obj = constructor.newInstance(obj3);
                    } else {
                        throw new JSONException("can't create non-static inner class instance.");
                    }
                } else if (constructor != null) {
                    obj = constructor.newInstance(new Object[0]);
                } else {
                    obj = this.beanInfo.factoryMethod.invoke(null, new Object[0]);
                }
                if (defaultJSONParser != null && defaultJSONParser.lexer.isEnabled(Feature.InitStringFieldAsEmpty)) {
                    FieldInfo[] fieldInfoArr = this.beanInfo.fields;
                    for (FieldInfo fieldInfo : fieldInfoArr) {
                        if (fieldInfo.fieldClass == String.class) {
                            try {
                                fieldInfo.set(obj, "");
                            } catch (Exception e) {
                                throw new JSONException("create instance error, class " + this.clazz.getName(), e);
                            }
                        }
                    }
                }
                return obj;
            } catch (JSONException e2) {
                throw e2;
            } catch (Exception e3) {
                throw new JSONException("create instance error, class " + this.clazz.getName(), e3);
            }
        } else {
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{(Class) type}, new JSONObject());
        }
    }

    @Override // com.alibaba.fastjson.parser.deserializer.ObjectDeserializer
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object obj) {
        return (T) deserialze(defaultJSONParser, type, obj, 0);
    }

    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object obj, int i) {
        return (T) deserialze(defaultJSONParser, type, obj, null, i, null);
    }

    public <T> T deserialzeArrayMapping(DefaultJSONParser defaultJSONParser, Type type, Object obj, Object obj2) {
        Enum<?> r1;
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 14) {
            String scanTypeName = jSONLexer.scanTypeName(defaultJSONParser.symbolTable);
            if (scanTypeName != null) {
                ObjectDeserializer seeAlso = getSeeAlso(defaultJSONParser.getConfig(), this.beanInfo, scanTypeName);
                if (seeAlso == null) {
                    seeAlso = defaultJSONParser.getConfig().getDeserializer(defaultJSONParser.getConfig().checkAutoType(scanTypeName, TypeUtils.getClass(type), jSONLexer.getFeatures()));
                }
                if (seeAlso instanceof JavaBeanDeserializer) {
                    return (T) ((JavaBeanDeserializer) seeAlso).deserialzeArrayMapping(defaultJSONParser, type, obj, obj2);
                }
            }
            T t = (T) createInstance(defaultJSONParser, type);
            int i = 0;
            int length = this.sortedFieldDeserializers.length;
            while (true) {
                int i2 = 16;
                if (i >= length) {
                    break;
                }
                char c = i == length + -1 ? Operators.ARRAY_END : Operators.ARRAY_SEPRATOR;
                FieldDeserializer fieldDeserializer = this.sortedFieldDeserializers[i];
                Class<?> cls = fieldDeserializer.fieldInfo.fieldClass;
                if (cls == Integer.TYPE) {
                    fieldDeserializer.setValue((Object) t, jSONLexer.scanInt(c));
                } else if (cls == String.class) {
                    fieldDeserializer.setValue((Object) t, jSONLexer.scanString(c));
                } else if (cls == Long.TYPE) {
                    fieldDeserializer.setValue(t, jSONLexer.scanLong(c));
                } else if (cls.isEnum()) {
                    char current = jSONLexer.getCurrent();
                    if (current == '\"' || current == 'n') {
                        r1 = jSONLexer.scanEnum(cls, defaultJSONParser.getSymbolTable(), c);
                    } else if (current < '0' || current > '9') {
                        r1 = scanEnum(jSONLexer, c);
                    } else {
                        r1 = ((EnumDeserializer) ((DefaultFieldDeserializer) fieldDeserializer).getFieldValueDeserilizer(defaultJSONParser.getConfig())).valueOf(jSONLexer.scanInt(c));
                    }
                    fieldDeserializer.setValue(t, r1);
                } else if (cls == Boolean.TYPE) {
                    fieldDeserializer.setValue(t, jSONLexer.scanBoolean(c));
                } else if (cls == Float.TYPE) {
                    fieldDeserializer.setValue(t, Float.valueOf(jSONLexer.scanFloat(c)));
                } else if (cls == Double.TYPE) {
                    fieldDeserializer.setValue(t, Double.valueOf(jSONLexer.scanDouble(c)));
                } else if (cls == Date.class && jSONLexer.getCurrent() == '1') {
                    fieldDeserializer.setValue(t, new Date(jSONLexer.scanLong(c)));
                } else if (cls == BigDecimal.class) {
                    fieldDeserializer.setValue(t, jSONLexer.scanDecimal(c));
                } else {
                    jSONLexer.nextToken(14);
                    fieldDeserializer.setValue(t, defaultJSONParser.parseObject(fieldDeserializer.fieldInfo.fieldType, fieldDeserializer.fieldInfo.name));
                    if (jSONLexer.token() == 15) {
                        break;
                    }
                    if (c == ']') {
                        i2 = 15;
                    }
                    check(jSONLexer, i2);
                }
                i++;
            }
            jSONLexer.nextToken(16);
            return t;
        }
        throw new JSONException("error");
    }

    /* access modifiers changed from: protected */
    public void check(JSONLexer jSONLexer, int i) {
        if (jSONLexer.token() != i) {
            throw new JSONException("syntax error");
        }
    }

    /* access modifiers changed from: protected */
    public Enum<?> scanEnum(JSONLexer jSONLexer, char c) {
        throw new JSONException("illegal enum. " + jSONLexer.info());
    }

    /* JADX DEBUG: Failed to insert an additional move for type inference into block B:755:0x087a */
    /* JADX DEBUG: Failed to insert an additional move for type inference into block B:644:0x08bd */
    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r32v0, types: [com.alibaba.fastjson.parser.DefaultJSONParser] */
    /* JADX WARN: Type inference failed for: r4v15, types: [boolean] */
    /* JADX WARN: Type inference failed for: r4v28 */
    /* JADX WARN: Type inference failed for: r4v29 */
    /* JADX WARN: Type inference failed for: r4v30, types: [int] */
    /* JADX WARN: Type inference failed for: r4v33, types: [java.lang.Class<?>] */
    /* JADX WARN: Type inference failed for: r2v69, types: [java.lang.Object] */
    /* JADX WARN: Type inference failed for: r4v131 */
    /* access modifiers changed from: protected */
    /* JADX WARNING: Code restructure failed: missing block: B:292:0x038f, code lost:
        if (r12.matchStat == -2) goto L_0x0391;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:312:0x03da, code lost:
        if (r12.isEnabled(com.alibaba.fastjson.parser.Feature.AllowArbitraryCommas) != false) goto L_0x03dc;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:394:0x053f, code lost:
        r2 = r32.getConfig().getDeserializer(r15);
     */
    /* JADX WARNING: Code restructure failed: missing block: B:396:0x0549, code lost:
        r3 = (T) r2.deserialze(r32, r15, r34);
     */
    /* JADX WARNING: Code restructure failed: missing block: B:397:0x054f, code lost:
        if ((r2 instanceof com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer) == false) goto L_0x055e;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:398:0x0551, code lost:
        r2 = (com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer) r2;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:399:0x0553, code lost:
        if (r6 == null) goto L_0x055e;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:400:0x0555, code lost:
        r2 = r2.getFieldDeserializer(r6);
     */
    /* JADX WARNING: Code restructure failed: missing block: B:401:0x0559, code lost:
        if (r2 == null) goto L_0x055e;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:402:0x055b, code lost:
        r2.setValue((java.lang.Object) r3, r1);
     */
    /* JADX WARNING: Code restructure failed: missing block: B:403:0x055e, code lost:
        if (r5 == null) goto L_0x0564;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:404:0x0560, code lost:
        r5.object = r27;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:405:0x0564, code lost:
        r32.setContext(r7);
     */
    /* JADX WARNING: Code restructure failed: missing block: B:406:0x0567, code lost:
        return r3;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:467:0x0658, code lost:
        if ((r29.parserFeatures & com.alibaba.fastjson.parser.Feature.TrimStringFieldValue.mask) != 0) goto L_0x065a;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:501:0x06f4, code lost:
        r1 = r19;
        r5 = r27;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:697:0x09c3, code lost:
        throw new com.alibaba.fastjson.JSONException("syntax error, unexpect token " + com.alibaba.fastjson.parser.JSONToken.name(r12.token()));
     */
    /* JADX WARNING: Removed duplicated region for block: B:244:0x030b A[Catch:{ all -> 0x03e2 }] */
    /* JADX WARNING: Removed duplicated region for block: B:302:0x03b3 A[SYNTHETIC, Splitter:B:302:0x03b3] */
    /* JADX WARNING: Removed duplicated region for block: B:421:0x05ab  */
    /* JADX WARNING: Removed duplicated region for block: B:427:0x05be A[Catch:{ all -> 0x05ea }] */
    /* JADX WARNING: Removed duplicated region for block: B:431:0x05cb A[Catch:{ all -> 0x0691 }] */
    /* JADX WARNING: Removed duplicated region for block: B:434:0x05d3  */
    /* JADX WARNING: Removed duplicated region for block: B:442:0x05f7  */
    /* JADX WARNING: Removed duplicated region for block: B:476:0x0680  */
    /* JADX WARNING: Removed duplicated region for block: B:497:0x06e7  */
    /* JADX WARNING: Removed duplicated region for block: B:498:0x06eb  */
    /* JADX WARNING: Removed duplicated region for block: B:624:0x087e A[SYNTHETIC, Splitter:B:624:0x087e] */
    /* JADX WARNING: Removed duplicated region for block: B:644:0x08bd A[SYNTHETIC, Splitter:B:644:0x08bd] */
    /* JADX WARNING: Removed duplicated region for block: B:711:0x09e5  */
    /* JADX WARNING: Unknown variable types count: 2 */
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object obj, Object obj2, int i, int[] iArr) {
        T t;
        ParseContext parseContext;
        Throwable th;
        Throwable th2;
        ParseContext parseContext2;
        Throwable th3;
        int i2;
        JSONField jSONField;
        DefaultFieldDeserializer defaultFieldDeserializer;
        Class<?> cls;
        FieldInfo fieldInfo;
        boolean z;
        Object obj3;
        String str;
        HashMap hashMap;
        int[] iArr2;
        int i3;
        int i4;
        int[] iArr3;
        int i5;
        FieldInfo fieldInfo2;
        boolean z2;
        Object obj4;
        boolean z3;
        byte b;
        ParseContext parseContext3;
        Throwable th4;
        Object[] objArr;
        boolean z4;
        Object obj5;
        Exception exc;
        String str2;
        Class<?> cls2;
        String str3;
        HashMap hashMap2;
        int i6;
        Throwable th5;
        Throwable th6;
        Class<?> cls3;
        T t2;
        Throwable th7;
        Class<?> cls4;
        if (type == JSON.class || type == JSONObject.class) {
            return (T) defaultJSONParser.parse();
        }
        JSONLexerBase jSONLexerBase = (JSONLexerBase) defaultJSONParser.lexer;
        ParserConfig config = defaultJSONParser.getConfig();
        int i7 = jSONLexerBase.token();
        ParseContext parseContext4 = null;
        if (i7 == 8) {
            jSONLexerBase.nextToken(16);
            return null;
        }
        ParseContext context = defaultJSONParser.getContext();
        if (!(obj2 == null || context == null)) {
            context = context.parent;
        }
        ParseContext parseContext5 = context;
        if (i7 == 13) {
            try {
                jSONLexerBase.nextToken(16);
                T t3 = obj2 == null ? (T) createInstance((DefaultJSONParser) defaultJSONParser, type) : (T) obj2;
                defaultJSONParser.setContext(parseContext5);
                return t3;
            } catch (Throwable th8) {
                t = (T) obj2;
                th = th8;
                parseContext = parseContext5;
                if (parseContext4 != null) {
                }
                defaultJSONParser.setContext(parseContext);
                throw th;
            }
        } else {
            if (i7 == 14) {
                int i8 = Feature.SupportArrayToBean.mask;
                if (((this.beanInfo.parserFeatures & i8) == 0 && !jSONLexerBase.isEnabled(Feature.SupportArrayToBean) && (i & i8) == 0) ? false : true) {
                    T t4 = (T) deserialzeArrayMapping(defaultJSONParser, type, obj, obj2);
                    defaultJSONParser.setContext(parseContext5);
                    return t4;
                }
            }
            if (i7 == 12 || i7 == 16) {
                try {
                    if (defaultJSONParser.resolveStatus == 2) {
                        defaultJSONParser.resolveStatus = 0;
                    }
                    String str4 = this.beanInfo.typeKey;
                    Object obj6 = obj2;
                    int[] iArr4 = iArr;
                    ParseContext parseContext6 = null;
                    HashMap hashMap3 = null;
                    int i9 = 0;
                    int i10 = 0;
                    while (true) {
                        try {
                            FieldDeserializer[] fieldDeserializerArr = this.sortedFieldDeserializers;
                            if (i10 >= fieldDeserializerArr.length || i9 >= 16) {
                                i2 = i10;
                                z = false;
                                fieldInfo = null;
                                cls = null;
                                defaultFieldDeserializer = null;
                                jSONField = null;
                            } else {
                                try {
                                    FieldDeserializer fieldDeserializer = fieldDeserializerArr[i10];
                                    FieldInfo fieldInfo3 = fieldDeserializer.fieldInfo;
                                    i2 = i10;
                                    Class<?> cls5 = fieldInfo3.fieldClass;
                                    jSONField = fieldInfo3.getAnnotation();
                                    if (jSONField != null) {
                                        cls4 = cls5;
                                        if (fieldDeserializer instanceof DefaultFieldDeserializer) {
                                            z = ((DefaultFieldDeserializer) fieldDeserializer).customDeserilizer;
                                            fieldInfo = fieldInfo3;
                                            defaultFieldDeserializer = fieldDeserializer;
                                            cls = cls4;
                                        }
                                    } else {
                                        cls4 = cls5;
                                    }
                                    fieldInfo = fieldInfo3;
                                    z = false;
                                    defaultFieldDeserializer = fieldDeserializer;
                                    cls = cls4;
                                } catch (Throwable th9) {
                                    th2 = th9;
                                    t = obj6;
                                    parseContext4 = parseContext6;
                                    parseContext = parseContext5;
                                    th = th2;
                                    if (parseContext4 != null) {
                                    }
                                    defaultJSONParser.setContext(parseContext);
                                    throw th;
                                }
                            }
                            if (defaultFieldDeserializer != null) {
                                iArr3 = iArr4;
                                try {
                                    char[] cArr = fieldInfo.name_chars;
                                    if (!z || !jSONLexerBase.matchField(cArr)) {
                                        obj3 = obj6;
                                        if (cls == Integer.TYPE || cls == Integer.class) {
                                            fieldInfo2 = fieldInfo;
                                            int scanFieldInt = jSONLexerBase.scanFieldInt(cArr);
                                            if (scanFieldInt == 0 && jSONLexerBase.matchStat == 5) {
                                                obj4 = null;
                                            } else {
                                                obj4 = Integer.valueOf(scanFieldInt);
                                            }
                                            if (jSONLexerBase.matchStat > 0) {
                                            }
                                        } else {
                                            try {
                                                if (cls != Long.TYPE) {
                                                    if (cls != Long.class) {
                                                        if (cls == String.class) {
                                                            obj4 = jSONLexerBase.scanFieldString(cArr);
                                                            if (jSONLexerBase.matchStat <= 0) {
                                                                if (jSONLexerBase.matchStat == -2) {
                                                                    i4 = i2;
                                                                    i3 = i9 + 1;
                                                                    str = str4;
                                                                    parseContext = parseContext5;
                                                                    hashMap = hashMap3;
                                                                    iArr2 = iArr3;
                                                                    i10 = i4 + 1;
                                                                    iArr4 = iArr2;
                                                                    hashMap3 = hashMap;
                                                                    str4 = str;
                                                                    obj6 = obj3;
                                                                    parseContext5 = parseContext;
                                                                    i9 = i3;
                                                                }
                                                                fieldInfo2 = fieldInfo;
                                                                z3 = false;
                                                                z2 = false;
                                                                if (!z3) {
                                                                    try {
                                                                        str3 = jSONLexerBase.scanSymbol(defaultJSONParser.symbolTable);
                                                                        if (str3 == null) {
                                                                            i5 = i9;
                                                                            int i11 = jSONLexerBase.token();
                                                                            cls2 = cls;
                                                                            if (i11 == 13) {
                                                                                jSONLexerBase.nextToken(16);
                                                                                break;
                                                                            }
                                                                            if (i11 == 16) {
                                                                            }
                                                                            if ("$ref" != str3 && parseContext5 != null) {
                                                                                jSONLexerBase.nextTokenWithColon(4);
                                                                                int i12 = jSONLexerBase.token();
                                                                                if (i12 == 4) {
                                                                                    String stringVal = jSONLexerBase.stringVal();
                                                                                    if ("@".equals(stringVal)) {
                                                                                        t2 = (T) parseContext5.object;
                                                                                    } else {
                                                                                        if (PdrUtil.FILE_PATH_ENTRY_BACK.equals(stringVal)) {
                                                                                            ParseContext parseContext7 = parseContext5.parent;
                                                                                            if (parseContext7.object != null) {
                                                                                                t2 = (T) parseContext7.object;
                                                                                            } else {
                                                                                                defaultJSONParser.addResolveTask(new DefaultJSONParser.ResolveTask(parseContext7, stringVal));
                                                                                                defaultJSONParser.resolveStatus = 1;
                                                                                            }
                                                                                        } else if (Operators.DOLLAR_STR.equals(stringVal)) {
                                                                                            ParseContext parseContext8 = parseContext5;
                                                                                            while (parseContext8.parent != null) {
                                                                                                parseContext8 = parseContext8.parent;
                                                                                            }
                                                                                            if (parseContext8.object != null) {
                                                                                                t2 = (T) parseContext8.object;
                                                                                            } else {
                                                                                                defaultJSONParser.addResolveTask(new DefaultJSONParser.ResolveTask(parseContext8, stringVal));
                                                                                                defaultJSONParser.resolveStatus = 1;
                                                                                            }
                                                                                        } else {
                                                                                            if (stringVal.indexOf(92) > 0) {
                                                                                                StringBuilder sb = new StringBuilder();
                                                                                                int i13 = 0;
                                                                                                while (i13 < stringVal.length()) {
                                                                                                    char charAt = stringVal.charAt(i13);
                                                                                                    if (charAt == '\\') {
                                                                                                        i13++;
                                                                                                        charAt = stringVal.charAt(i13);
                                                                                                    }
                                                                                                    sb.append(charAt);
                                                                                                    i13++;
                                                                                                }
                                                                                                stringVal = sb.toString();
                                                                                            }
                                                                                            ?? resolveReference = defaultJSONParser.resolveReference(stringVal);
                                                                                            if (resolveReference != null) {
                                                                                                t2 = resolveReference;
                                                                                            } else {
                                                                                                defaultJSONParser.addResolveTask(new DefaultJSONParser.ResolveTask(parseContext5, stringVal));
                                                                                                defaultJSONParser.resolveStatus = 1;
                                                                                            }
                                                                                        }
                                                                                        t2 = (T) obj3;
                                                                                    }
                                                                                    jSONLexerBase.nextToken(13);
                                                                                    if (jSONLexerBase.token() == 13) {
                                                                                        jSONLexerBase.nextToken(16);
                                                                                        defaultJSONParser.setContext(parseContext5, t2, obj);
                                                                                        if (parseContext6 != null) {
                                                                                            parseContext6.object = t2;
                                                                                        }
                                                                                        defaultJSONParser.setContext(parseContext5);
                                                                                        return t2;
                                                                                    }
                                                                                    throw new JSONException("illegal ref");
                                                                                }
                                                                                throw new JSONException("illegal ref, " + JSONToken.name(i12));
                                                                            } else if ((str4 != null || !str4.equals(str3)) && JSON.DEFAULT_TYPE_KEY != str3) {
                                                                                t = obj3;
                                                                            } else {
                                                                                jSONLexerBase.nextTokenWithColon(4);
                                                                                if (jSONLexerBase.token() == 4) {
                                                                                    String stringVal2 = jSONLexerBase.stringVal();
                                                                                    jSONLexerBase.nextToken(16);
                                                                                    if (stringVal2.equals(this.beanInfo.typeName) || defaultJSONParser.isEnabled(Feature.IgnoreAutoType)) {
                                                                                        t = (T) obj3;
                                                                                        try {
                                                                                            if (jSONLexerBase.token() == 13) {
                                                                                                jSONLexerBase.nextToken();
                                                                                                break;
                                                                                            }
                                                                                            i4 = i2;
                                                                                            str = str4;
                                                                                            parseContext = parseContext5;
                                                                                            obj3 = t;
                                                                                            hashMap = hashMap3;
                                                                                            i3 = i5;
                                                                                            iArr2 = iArr3;
                                                                                            i10 = i4 + 1;
                                                                                            iArr4 = iArr2;
                                                                                            hashMap3 = hashMap;
                                                                                            str4 = str;
                                                                                            obj6 = obj3;
                                                                                            parseContext5 = parseContext;
                                                                                            i9 = i3;
                                                                                        } catch (Throwable th10) {
                                                                                            th6 = th10;
                                                                                            th = th6;
                                                                                            parseContext4 = parseContext6;
                                                                                            parseContext = parseContext5;
                                                                                            if (parseContext4 != null) {
                                                                                            }
                                                                                            defaultJSONParser.setContext(parseContext);
                                                                                            throw th;
                                                                                        }
                                                                                    } else {
                                                                                        ObjectDeserializer seeAlso = getSeeAlso(config, this.beanInfo, stringVal2);
                                                                                        if (seeAlso != null) {
                                                                                            cls3 = null;
                                                                                            break;
                                                                                        }
                                                                                        Class<?> cls6 = TypeUtils.getClass(type);
                                                                                        ParserConfig.AutoTypeCheckHandler autoTypeCheckHandler2 = this.autoTypeCheckHandler;
                                                                                        Class<?> handler = autoTypeCheckHandler2 != null ? autoTypeCheckHandler2.handler(stringVal2, cls6, jSONLexerBase.getFeatures()) : null;
                                                                                        if (handler != null || (!stringVal2.equals("java.util.HashMap") && !stringVal2.equals("java.util.LinkedHashMap"))) {
                                                                                            cls3 = handler == null ? config.checkAutoType(stringVal2, cls6, jSONLexerBase.getFeatures()) : handler;
                                                                                        } else {
                                                                                            if (jSONLexerBase.token() == 13) {
                                                                                                jSONLexerBase.nextToken();
                                                                                                break;
                                                                                            }
                                                                                            t = obj3;
                                                                                            i4 = i2;
                                                                                            str = str4;
                                                                                            parseContext = parseContext5;
                                                                                            obj3 = t;
                                                                                            hashMap = hashMap3;
                                                                                            i3 = i5;
                                                                                            iArr2 = iArr3;
                                                                                            i10 = i4 + 1;
                                                                                            iArr4 = iArr2;
                                                                                            hashMap3 = hashMap;
                                                                                            str4 = str;
                                                                                            obj6 = obj3;
                                                                                            parseContext5 = parseContext;
                                                                                            i9 = i3;
                                                                                        }
                                                                                    }
                                                                                } else {
                                                                                    throw new JSONException("syntax error");
                                                                                }
                                                                            }
                                                                        } else {
                                                                            i5 = i9;
                                                                            cls2 = cls;
                                                                            if ("$ref" != str3) {
                                                                            }
                                                                            if (str4 != null) {
                                                                            }
                                                                            t = obj3;
                                                                        }
                                                                    } catch (Throwable th11) {
                                                                        th6 = th11;
                                                                        t = obj3;
                                                                        th = th6;
                                                                        parseContext4 = parseContext6;
                                                                        parseContext = parseContext5;
                                                                        if (parseContext4 != null) {
                                                                        }
                                                                        defaultJSONParser.setContext(parseContext);
                                                                        throw th;
                                                                    }
                                                                } else {
                                                                    i5 = i9;
                                                                    cls2 = cls;
                                                                    t = obj3;
                                                                    str3 = null;
                                                                }
                                                                if (t == null && hashMap3 == null) {
                                                                    t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                                    if (t == null) {
                                                                        parseContext2 = parseContext6;
                                                                        try {
                                                                            hashMap3 = new HashMap(this.fieldDeserializers.length);
                                                                        } catch (Throwable th12) {
                                                                            th5 = th12;
                                                                            th = th5;
                                                                            parseContext = parseContext5;
                                                                            parseContext4 = parseContext2;
                                                                            if (parseContext4 != null) {
                                                                            }
                                                                            defaultJSONParser.setContext(parseContext);
                                                                            throw th;
                                                                        }
                                                                    }
                                                                    parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                                    if (iArr3 == null) {
                                                                        parseContext2 = parseContext6;
                                                                        hashMap2 = hashMap3;
                                                                        iArr2 = new int[((this.fieldDeserializers.length / 32) + 1)];
                                                                        if (!z3) {
                                                                            if (z2) {
                                                                                if (t == null) {
                                                                                    hashMap2.put(fieldInfo2.name, obj4);
                                                                                } else if (obj4 != null) {
                                                                                    String str5 = obj4;
                                                                                    if (cls2 == String.class) {
                                                                                        if ((i & Feature.TrimStringFieldValue.mask) == 0 && (this.beanInfo.parserFeatures & Feature.TrimStringFieldValue.mask) == 0) {
                                                                                            str5 = obj4;
                                                                                        }
                                                                                        str5 = ((String) obj4).trim();
                                                                                    }
                                                                                    defaultFieldDeserializer.setValue(t, str5);
                                                                                } else if (!(cls2 == Integer.TYPE || cls2 == Long.TYPE || cls2 == Float.TYPE || cls2 == Double.TYPE || cls2 == Boolean.TYPE)) {
                                                                                    defaultFieldDeserializer.setValue(t, obj4);
                                                                                }
                                                                                if (iArr2 != null) {
                                                                                    int i14 = i2 / 32;
                                                                                    iArr2[i14] = (1 << (i2 % 32)) | iArr2[i14];
                                                                                }
                                                                                if (jSONLexerBase.matchStat == 4) {
                                                                                    hashMap = hashMap2;
                                                                                    parseContext3 = parseContext5;
                                                                                    b = 0;
                                                                                    break;
                                                                                }
                                                                            } else {
                                                                                defaultFieldDeserializer.parseField(defaultJSONParser, t, type, hashMap2);
                                                                            }
                                                                            i4 = i2;
                                                                            hashMap = hashMap2;
                                                                            str = str4;
                                                                            parseContext3 = parseContext5;
                                                                            i3 = i5;
                                                                            b = 0;
                                                                            i6 = 13;
                                                                            if (jSONLexerBase.token() != 16) {
                                                                                parseContext = parseContext3;
                                                                            } else if (jSONLexerBase.token() == i6) {
                                                                                jSONLexerBase.nextToken(16);
                                                                                break;
                                                                            } else {
                                                                                parseContext = parseContext3;
                                                                                try {
                                                                                    if (jSONLexerBase.token() == 18 || jSONLexerBase.token() == 1) {
                                                                                    }
                                                                                    parseContext6 = parseContext2;
                                                                                    obj3 = t;
                                                                                    i10 = i4 + 1;
                                                                                    iArr4 = iArr2;
                                                                                    hashMap3 = hashMap;
                                                                                    str4 = str;
                                                                                    obj6 = obj3;
                                                                                    parseContext5 = parseContext;
                                                                                    i9 = i3;
                                                                                } catch (Throwable th13) {
                                                                                    th3 = th13;
                                                                                    th = th3;
                                                                                    parseContext4 = parseContext2;
                                                                                    if (parseContext4 != null) {
                                                                                    }
                                                                                    defaultJSONParser.setContext(parseContext);
                                                                                    throw th;
                                                                                }
                                                                            }
                                                                        } else {
                                                                            i3 = i5;
                                                                            i4 = i2;
                                                                            hashMap = hashMap2;
                                                                            b = 0;
                                                                            str = str4;
                                                                            i6 = 13;
                                                                            parseContext3 = parseContext5;
                                                                            try {
                                                                                if (!parseField(defaultJSONParser, str3, t, type, hashMap2 == null ? new HashMap(this.fieldDeserializers.length) : hashMap2, iArr2)) {
                                                                                    try {
                                                                                        if (jSONLexerBase.token() == 13) {
                                                                                            jSONLexerBase.nextToken();
                                                                                            break;
                                                                                        }
                                                                                        parseContext = parseContext3;
                                                                                    } catch (Throwable th14) {
                                                                                        th = th14;
                                                                                        parseContext4 = parseContext2;
                                                                                        parseContext = parseContext3;
                                                                                        if (parseContext4 != null) {
                                                                                        }
                                                                                        defaultJSONParser.setContext(parseContext);
                                                                                        throw th;
                                                                                    }
                                                                                } else {
                                                                                    if (jSONLexerBase.token() == 17) {
                                                                                        throw new JSONException("syntax error, unexpect token ':'");
                                                                                    }
                                                                                    if (jSONLexerBase.token() != 16) {
                                                                                    }
                                                                                }
                                                                            } catch (Throwable th15) {
                                                                                th3 = th15;
                                                                                parseContext = parseContext3;
                                                                                th = th3;
                                                                                parseContext4 = parseContext2;
                                                                                if (parseContext4 != null) {
                                                                                }
                                                                                defaultJSONParser.setContext(parseContext);
                                                                                throw th;
                                                                            }
                                                                        }
                                                                        parseContext6 = parseContext2;
                                                                        obj3 = t;
                                                                        i10 = i4 + 1;
                                                                        iArr4 = iArr2;
                                                                        hashMap3 = hashMap;
                                                                        str4 = str;
                                                                        obj6 = obj3;
                                                                        parseContext5 = parseContext;
                                                                        i9 = i3;
                                                                    }
                                                                }
                                                                parseContext2 = parseContext6;
                                                                hashMap2 = hashMap3;
                                                                iArr2 = iArr3;
                                                                if (!z3) {
                                                                }
                                                                parseContext6 = parseContext2;
                                                                obj3 = t;
                                                                i10 = i4 + 1;
                                                                iArr4 = iArr2;
                                                                hashMap3 = hashMap;
                                                                str4 = str;
                                                                obj6 = obj3;
                                                                parseContext5 = parseContext;
                                                                i9 = i3;
                                                            }
                                                        } else if (cls == Date.class && fieldInfo.format == null) {
                                                            obj4 = jSONLexerBase.scanFieldDate(cArr);
                                                            if (jSONLexerBase.matchStat <= 0) {
                                                                if (jSONLexerBase.matchStat == -2) {
                                                                    i4 = i2;
                                                                    i3 = i9 + 1;
                                                                    str = str4;
                                                                    parseContext = parseContext5;
                                                                    hashMap = hashMap3;
                                                                    iArr2 = iArr3;
                                                                    i10 = i4 + 1;
                                                                    iArr4 = iArr2;
                                                                    hashMap3 = hashMap;
                                                                    str4 = str;
                                                                    obj6 = obj3;
                                                                    parseContext5 = parseContext;
                                                                    i9 = i3;
                                                                }
                                                                fieldInfo2 = fieldInfo;
                                                                z3 = false;
                                                                z2 = false;
                                                                if (!z3) {
                                                                }
                                                                t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                                if (t == null) {
                                                                }
                                                                parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                                if (iArr3 == null) {
                                                                }
                                                                parseContext2 = parseContext6;
                                                                hashMap2 = hashMap3;
                                                                iArr2 = iArr3;
                                                                if (!z3) {
                                                                }
                                                                parseContext6 = parseContext2;
                                                                obj3 = t;
                                                                i10 = i4 + 1;
                                                                iArr4 = iArr2;
                                                                hashMap3 = hashMap;
                                                                str4 = str;
                                                                obj6 = obj3;
                                                                parseContext5 = parseContext;
                                                                i9 = i3;
                                                            }
                                                        } else if (cls == BigDecimal.class) {
                                                            obj4 = jSONLexerBase.scanFieldDecimal(cArr);
                                                            if (jSONLexerBase.matchStat <= 0) {
                                                                if (jSONLexerBase.matchStat == -2) {
                                                                    i4 = i2;
                                                                    i3 = i9 + 1;
                                                                    str = str4;
                                                                    parseContext = parseContext5;
                                                                    hashMap = hashMap3;
                                                                    iArr2 = iArr3;
                                                                    i10 = i4 + 1;
                                                                    iArr4 = iArr2;
                                                                    hashMap3 = hashMap;
                                                                    str4 = str;
                                                                    obj6 = obj3;
                                                                    parseContext5 = parseContext;
                                                                    i9 = i3;
                                                                }
                                                                fieldInfo2 = fieldInfo;
                                                                z3 = false;
                                                                z2 = false;
                                                                if (!z3) {
                                                                }
                                                                t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                                if (t == null) {
                                                                }
                                                                parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                                if (iArr3 == null) {
                                                                }
                                                                parseContext2 = parseContext6;
                                                                hashMap2 = hashMap3;
                                                                iArr2 = iArr3;
                                                                if (!z3) {
                                                                }
                                                                parseContext6 = parseContext2;
                                                                obj3 = t;
                                                                i10 = i4 + 1;
                                                                iArr4 = iArr2;
                                                                hashMap3 = hashMap;
                                                                str4 = str;
                                                                obj6 = obj3;
                                                                parseContext5 = parseContext;
                                                                i9 = i3;
                                                            }
                                                        } else if (cls == BigInteger.class) {
                                                            obj4 = jSONLexerBase.scanFieldBigInteger(cArr);
                                                            if (jSONLexerBase.matchStat <= 0) {
                                                                if (jSONLexerBase.matchStat == -2) {
                                                                    i4 = i2;
                                                                    i3 = i9 + 1;
                                                                    str = str4;
                                                                    parseContext = parseContext5;
                                                                    hashMap = hashMap3;
                                                                    iArr2 = iArr3;
                                                                    i10 = i4 + 1;
                                                                    iArr4 = iArr2;
                                                                    hashMap3 = hashMap;
                                                                    str4 = str;
                                                                    obj6 = obj3;
                                                                    parseContext5 = parseContext;
                                                                    i9 = i3;
                                                                }
                                                                fieldInfo2 = fieldInfo;
                                                                z3 = false;
                                                                z2 = false;
                                                                if (!z3) {
                                                                }
                                                                t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                                if (t == null) {
                                                                }
                                                                parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                                if (iArr3 == null) {
                                                                }
                                                                parseContext2 = parseContext6;
                                                                hashMap2 = hashMap3;
                                                                iArr2 = iArr3;
                                                                if (!z3) {
                                                                }
                                                                parseContext6 = parseContext2;
                                                                obj3 = t;
                                                                i10 = i4 + 1;
                                                                iArr4 = iArr2;
                                                                hashMap3 = hashMap;
                                                                str4 = str;
                                                                obj6 = obj3;
                                                                parseContext5 = parseContext;
                                                                i9 = i3;
                                                            }
                                                        } else {
                                                            if (cls != Boolean.TYPE) {
                                                                if (cls != Boolean.class) {
                                                                    if (cls != Float.TYPE) {
                                                                        if (cls != Float.class) {
                                                                            if (cls != Double.TYPE) {
                                                                                if (cls != Double.class) {
                                                                                    if (!cls.isEnum() || !(defaultJSONParser.getConfig().getDeserializer(cls) instanceof EnumDeserializer) || !(jSONField == null || jSONField.deserializeUsing() == Void.class)) {
                                                                                        if (cls == int[].class) {
                                                                                            obj4 = jSONLexerBase.scanFieldIntArray(cArr);
                                                                                            if (jSONLexerBase.matchStat <= 0) {
                                                                                                if (jSONLexerBase.matchStat == -2) {
                                                                                                    i4 = i2;
                                                                                                    i3 = i9 + 1;
                                                                                                    str = str4;
                                                                                                    parseContext = parseContext5;
                                                                                                    hashMap = hashMap3;
                                                                                                    iArr2 = iArr3;
                                                                                                    i10 = i4 + 1;
                                                                                                    iArr4 = iArr2;
                                                                                                    hashMap3 = hashMap;
                                                                                                    str4 = str;
                                                                                                    obj6 = obj3;
                                                                                                    parseContext5 = parseContext;
                                                                                                    i9 = i3;
                                                                                                }
                                                                                                fieldInfo2 = fieldInfo;
                                                                                                z3 = false;
                                                                                                z2 = false;
                                                                                                if (!z3) {
                                                                                                }
                                                                                                t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                                                                if (t == null) {
                                                                                                }
                                                                                                parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                                                                if (iArr3 == null) {
                                                                                                }
                                                                                                parseContext2 = parseContext6;
                                                                                                hashMap2 = hashMap3;
                                                                                                iArr2 = iArr3;
                                                                                                if (!z3) {
                                                                                                }
                                                                                                parseContext6 = parseContext2;
                                                                                                obj3 = t;
                                                                                                i10 = i4 + 1;
                                                                                                iArr4 = iArr2;
                                                                                                hashMap3 = hashMap;
                                                                                                str4 = str;
                                                                                                obj6 = obj3;
                                                                                                parseContext5 = parseContext;
                                                                                                i9 = i3;
                                                                                            }
                                                                                        } else if (cls == float[].class) {
                                                                                            obj4 = jSONLexerBase.scanFieldFloatArray(cArr);
                                                                                            if (jSONLexerBase.matchStat <= 0) {
                                                                                                if (jSONLexerBase.matchStat == -2) {
                                                                                                    i4 = i2;
                                                                                                    i3 = i9 + 1;
                                                                                                    str = str4;
                                                                                                    parseContext = parseContext5;
                                                                                                    hashMap = hashMap3;
                                                                                                    iArr2 = iArr3;
                                                                                                    i10 = i4 + 1;
                                                                                                    iArr4 = iArr2;
                                                                                                    hashMap3 = hashMap;
                                                                                                    str4 = str;
                                                                                                    obj6 = obj3;
                                                                                                    parseContext5 = parseContext;
                                                                                                    i9 = i3;
                                                                                                }
                                                                                                fieldInfo2 = fieldInfo;
                                                                                                z3 = false;
                                                                                                z2 = false;
                                                                                                if (!z3) {
                                                                                                }
                                                                                                t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                                                                if (t == null) {
                                                                                                }
                                                                                                parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                                                                if (iArr3 == null) {
                                                                                                }
                                                                                                parseContext2 = parseContext6;
                                                                                                hashMap2 = hashMap3;
                                                                                                iArr2 = iArr3;
                                                                                                if (!z3) {
                                                                                                }
                                                                                                parseContext6 = parseContext2;
                                                                                                obj3 = t;
                                                                                                i10 = i4 + 1;
                                                                                                iArr4 = iArr2;
                                                                                                hashMap3 = hashMap;
                                                                                                str4 = str;
                                                                                                obj6 = obj3;
                                                                                                parseContext5 = parseContext;
                                                                                                i9 = i3;
                                                                                            }
                                                                                        } else if (cls == float[][].class) {
                                                                                            obj4 = jSONLexerBase.scanFieldFloatArray2(cArr);
                                                                                            if (jSONLexerBase.matchStat <= 0) {
                                                                                                if (jSONLexerBase.matchStat == -2) {
                                                                                                    i4 = i2;
                                                                                                    i3 = i9 + 1;
                                                                                                    str = str4;
                                                                                                    parseContext = parseContext5;
                                                                                                    hashMap = hashMap3;
                                                                                                    iArr2 = iArr3;
                                                                                                    i10 = i4 + 1;
                                                                                                    iArr4 = iArr2;
                                                                                                    hashMap3 = hashMap;
                                                                                                    str4 = str;
                                                                                                    obj6 = obj3;
                                                                                                    parseContext5 = parseContext;
                                                                                                    i9 = i3;
                                                                                                }
                                                                                                fieldInfo2 = fieldInfo;
                                                                                                z3 = false;
                                                                                                z2 = false;
                                                                                                if (!z3) {
                                                                                                }
                                                                                                t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                                                                if (t == null) {
                                                                                                }
                                                                                                parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                                                                if (iArr3 == null) {
                                                                                                }
                                                                                                parseContext2 = parseContext6;
                                                                                                hashMap2 = hashMap3;
                                                                                                iArr2 = iArr3;
                                                                                                if (!z3) {
                                                                                                }
                                                                                                parseContext6 = parseContext2;
                                                                                                obj3 = t;
                                                                                                i10 = i4 + 1;
                                                                                                iArr4 = iArr2;
                                                                                                hashMap3 = hashMap;
                                                                                                str4 = str;
                                                                                                obj6 = obj3;
                                                                                                parseContext5 = parseContext;
                                                                                                i9 = i3;
                                                                                            }
                                                                                        } else if (!jSONLexerBase.matchField(cArr)) {
                                                                                            i5 = i9;
                                                                                            t = obj3;
                                                                                            i4 = i2;
                                                                                            str = str4;
                                                                                            parseContext = parseContext5;
                                                                                            obj3 = t;
                                                                                            hashMap = hashMap3;
                                                                                            i3 = i5;
                                                                                            iArr2 = iArr3;
                                                                                            i10 = i4 + 1;
                                                                                            iArr4 = iArr2;
                                                                                            hashMap3 = hashMap;
                                                                                            str4 = str;
                                                                                            obj6 = obj3;
                                                                                            parseContext5 = parseContext;
                                                                                            i9 = i3;
                                                                                        }
                                                                                    } else if (defaultFieldDeserializer instanceof DefaultFieldDeserializer) {
                                                                                        obj4 = scanEnum(jSONLexerBase, cArr, defaultFieldDeserializer.fieldValueDeserilizer);
                                                                                        if (jSONLexerBase.matchStat > 0) {
                                                                                            z3 = true;
                                                                                            z2 = true;
                                                                                        } else if (jSONLexerBase.matchStat == -2) {
                                                                                            i4 = i2;
                                                                                            i3 = i9 + 1;
                                                                                            str = str4;
                                                                                            parseContext = parseContext5;
                                                                                            hashMap = hashMap3;
                                                                                            iArr2 = iArr3;
                                                                                            i10 = i4 + 1;
                                                                                            iArr4 = iArr2;
                                                                                            hashMap3 = hashMap;
                                                                                            str4 = str;
                                                                                            obj6 = obj3;
                                                                                            parseContext5 = parseContext;
                                                                                            i9 = i3;
                                                                                        } else {
                                                                                            z3 = false;
                                                                                            z2 = false;
                                                                                        }
                                                                                        fieldInfo2 = fieldInfo;
                                                                                        if (!z3) {
                                                                                        }
                                                                                        t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                                                        if (t == null) {
                                                                                        }
                                                                                        parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                                                        if (iArr3 == null) {
                                                                                        }
                                                                                        parseContext2 = parseContext6;
                                                                                        hashMap2 = hashMap3;
                                                                                        iArr2 = iArr3;
                                                                                        if (!z3) {
                                                                                        }
                                                                                        parseContext6 = parseContext2;
                                                                                        obj3 = t;
                                                                                        i10 = i4 + 1;
                                                                                        iArr4 = iArr2;
                                                                                        hashMap3 = hashMap;
                                                                                        str4 = str;
                                                                                        obj6 = obj3;
                                                                                        parseContext5 = parseContext;
                                                                                        i9 = i3;
                                                                                    }
                                                                                }
                                                                            }
                                                                            double scanFieldDouble = jSONLexerBase.scanFieldDouble(cArr);
                                                                            if (scanFieldDouble == 0.0d) {
                                                                                fieldInfo2 = fieldInfo;
                                                                                if (jSONLexerBase.matchStat == 5) {
                                                                                    obj4 = null;
                                                                                    if (jSONLexerBase.matchStat <= 0) {
                                                                                        if (jSONLexerBase.matchStat == -2) {
                                                                                            i4 = i2;
                                                                                            i3 = i9 + 1;
                                                                                            str = str4;
                                                                                            parseContext = parseContext5;
                                                                                            hashMap = hashMap3;
                                                                                            iArr2 = iArr3;
                                                                                            i10 = i4 + 1;
                                                                                            iArr4 = iArr2;
                                                                                            hashMap3 = hashMap;
                                                                                            str4 = str;
                                                                                            obj6 = obj3;
                                                                                            parseContext5 = parseContext;
                                                                                            i9 = i3;
                                                                                        }
                                                                                        z3 = false;
                                                                                        z2 = false;
                                                                                        if (!z3) {
                                                                                        }
                                                                                        t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                                                        if (t == null) {
                                                                                        }
                                                                                        parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                                                        if (iArr3 == null) {
                                                                                        }
                                                                                        parseContext2 = parseContext6;
                                                                                        hashMap2 = hashMap3;
                                                                                        iArr2 = iArr3;
                                                                                        if (!z3) {
                                                                                        }
                                                                                        parseContext6 = parseContext2;
                                                                                        obj3 = t;
                                                                                        i10 = i4 + 1;
                                                                                        iArr4 = iArr2;
                                                                                        hashMap3 = hashMap;
                                                                                        str4 = str;
                                                                                        obj6 = obj3;
                                                                                        parseContext5 = parseContext;
                                                                                        i9 = i3;
                                                                                    }
                                                                                }
                                                                            } else {
                                                                                fieldInfo2 = fieldInfo;
                                                                            }
                                                                            obj4 = Double.valueOf(scanFieldDouble);
                                                                            if (jSONLexerBase.matchStat <= 0) {
                                                                            }
                                                                        }
                                                                    }
                                                                    fieldInfo2 = fieldInfo;
                                                                    float scanFieldFloat = jSONLexerBase.scanFieldFloat(cArr);
                                                                    if (scanFieldFloat == 0.0f && jSONLexerBase.matchStat == 5) {
                                                                        obj4 = null;
                                                                    } else {
                                                                        obj4 = Float.valueOf(scanFieldFloat);
                                                                    }
                                                                    if (jSONLexerBase.matchStat <= 0) {
                                                                        if (jSONLexerBase.matchStat == -2) {
                                                                            i4 = i2;
                                                                            i3 = i9 + 1;
                                                                            str = str4;
                                                                            parseContext = parseContext5;
                                                                            hashMap = hashMap3;
                                                                            iArr2 = iArr3;
                                                                            i10 = i4 + 1;
                                                                            iArr4 = iArr2;
                                                                            hashMap3 = hashMap;
                                                                            str4 = str;
                                                                            obj6 = obj3;
                                                                            parseContext5 = parseContext;
                                                                            i9 = i3;
                                                                        }
                                                                        z3 = false;
                                                                        z2 = false;
                                                                        if (!z3) {
                                                                        }
                                                                        t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                                        if (t == null) {
                                                                        }
                                                                        parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                                        if (iArr3 == null) {
                                                                        }
                                                                        parseContext2 = parseContext6;
                                                                        hashMap2 = hashMap3;
                                                                        iArr2 = iArr3;
                                                                        if (!z3) {
                                                                        }
                                                                        parseContext6 = parseContext2;
                                                                        obj3 = t;
                                                                        i10 = i4 + 1;
                                                                        iArr4 = iArr2;
                                                                        hashMap3 = hashMap;
                                                                        str4 = str;
                                                                        obj6 = obj3;
                                                                        parseContext5 = parseContext;
                                                                        i9 = i3;
                                                                    }
                                                                }
                                                            }
                                                            fieldInfo2 = fieldInfo;
                                                            boolean scanFieldBoolean = jSONLexerBase.scanFieldBoolean(cArr);
                                                            if (jSONLexerBase.matchStat == 5) {
                                                                obj4 = null;
                                                            } else {
                                                                obj4 = Boolean.valueOf(scanFieldBoolean);
                                                            }
                                                            if (jSONLexerBase.matchStat <= 0) {
                                                                if (jSONLexerBase.matchStat == -2) {
                                                                    i4 = i2;
                                                                    i3 = i9 + 1;
                                                                    str = str4;
                                                                    parseContext = parseContext5;
                                                                    hashMap = hashMap3;
                                                                    iArr2 = iArr3;
                                                                    i10 = i4 + 1;
                                                                    iArr4 = iArr2;
                                                                    hashMap3 = hashMap;
                                                                    str4 = str;
                                                                    obj6 = obj3;
                                                                    parseContext5 = parseContext;
                                                                    i9 = i3;
                                                                }
                                                                z3 = false;
                                                                z2 = false;
                                                                if (!z3) {
                                                                }
                                                                t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                                if (t == null) {
                                                                }
                                                                parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                                if (iArr3 == null) {
                                                                }
                                                                parseContext2 = parseContext6;
                                                                hashMap2 = hashMap3;
                                                                iArr2 = iArr3;
                                                                if (!z3) {
                                                                }
                                                                parseContext6 = parseContext2;
                                                                obj3 = t;
                                                                i10 = i4 + 1;
                                                                iArr4 = iArr2;
                                                                hashMap3 = hashMap;
                                                                str4 = str;
                                                                obj6 = obj3;
                                                                parseContext5 = parseContext;
                                                                i9 = i3;
                                                            }
                                                        }
                                                        fieldInfo2 = fieldInfo;
                                                    }
                                                }
                                                fieldInfo2 = fieldInfo;
                                                long scanFieldLong = jSONLexerBase.scanFieldLong(cArr);
                                                if (scanFieldLong == 0 && jSONLexerBase.matchStat == 5) {
                                                    obj4 = null;
                                                } else {
                                                    obj4 = Long.valueOf(scanFieldLong);
                                                }
                                                if (jSONLexerBase.matchStat <= 0) {
                                                    if (jSONLexerBase.matchStat == -2) {
                                                        i4 = i2;
                                                        i3 = i9 + 1;
                                                        str = str4;
                                                        parseContext = parseContext5;
                                                        hashMap = hashMap3;
                                                        iArr2 = iArr3;
                                                        i10 = i4 + 1;
                                                        iArr4 = iArr2;
                                                        hashMap3 = hashMap;
                                                        str4 = str;
                                                        obj6 = obj3;
                                                        parseContext5 = parseContext;
                                                        i9 = i3;
                                                    }
                                                    z3 = false;
                                                    z2 = false;
                                                    if (!z3) {
                                                    }
                                                    t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                                    if (t == null) {
                                                    }
                                                    parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                                    if (iArr3 == null) {
                                                    }
                                                    parseContext2 = parseContext6;
                                                    hashMap2 = hashMap3;
                                                    iArr2 = iArr3;
                                                    if (!z3) {
                                                    }
                                                    parseContext6 = parseContext2;
                                                    obj3 = t;
                                                    i10 = i4 + 1;
                                                    iArr4 = iArr2;
                                                    hashMap3 = hashMap;
                                                    str4 = str;
                                                    obj6 = obj3;
                                                    parseContext5 = parseContext;
                                                    i9 = i3;
                                                }
                                            } catch (Throwable th16) {
                                                th7 = th16;
                                                th = th7;
                                                parseContext4 = parseContext6;
                                                parseContext = parseContext5;
                                                t = (T) obj3;
                                                if (parseContext4 != null) {
                                                    parseContext4.object = t;
                                                }
                                                defaultJSONParser.setContext(parseContext);
                                                throw th;
                                            }
                                        }
                                        z3 = true;
                                        z2 = true;
                                        if (!z3) {
                                        }
                                        t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                        if (t == null) {
                                        }
                                        parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                        if (iArr3 == null) {
                                        }
                                        parseContext2 = parseContext6;
                                        hashMap2 = hashMap3;
                                        iArr2 = iArr3;
                                        if (!z3) {
                                        }
                                        parseContext6 = parseContext2;
                                        obj3 = t;
                                        i10 = i4 + 1;
                                        iArr4 = iArr2;
                                        hashMap3 = hashMap;
                                        str4 = str;
                                        obj6 = obj3;
                                        parseContext5 = parseContext;
                                        i9 = i3;
                                    } else {
                                        obj3 = obj6;
                                    }
                                    fieldInfo2 = fieldInfo;
                                    z3 = true;
                                    obj4 = null;
                                    z2 = false;
                                    if (!z3) {
                                    }
                                    t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                    if (t == null) {
                                    }
                                    parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                    if (iArr3 == null) {
                                    }
                                    parseContext2 = parseContext6;
                                    hashMap2 = hashMap3;
                                    iArr2 = iArr3;
                                    if (!z3) {
                                    }
                                    parseContext6 = parseContext2;
                                    obj3 = t;
                                    i10 = i4 + 1;
                                    iArr4 = iArr2;
                                    hashMap3 = hashMap;
                                    str4 = str;
                                    obj6 = obj3;
                                    parseContext5 = parseContext;
                                    i9 = i3;
                                } catch (Throwable th17) {
                                    th7 = th17;
                                    obj3 = obj6;
                                    th = th7;
                                    parseContext4 = parseContext6;
                                    parseContext = parseContext5;
                                    t = (T) obj3;
                                    if (parseContext4 != null) {
                                    }
                                    defaultJSONParser.setContext(parseContext);
                                    throw th;
                                }
                            } else {
                                obj3 = obj6;
                                iArr3 = iArr4;
                            }
                            fieldInfo2 = fieldInfo;
                            z3 = false;
                            obj4 = null;
                            z2 = false;
                            if (!z3) {
                            }
                            try {
                                t = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                                if (t == null) {
                                }
                                parseContext6 = defaultJSONParser.setContext(parseContext5, t, obj);
                                if (iArr3 == null) {
                                }
                                parseContext2 = parseContext6;
                                hashMap2 = hashMap3;
                                iArr2 = iArr3;
                                if (!z3) {
                                }
                                parseContext6 = parseContext2;
                                obj3 = t;
                                i10 = i4 + 1;
                                iArr4 = iArr2;
                                hashMap3 = hashMap;
                                str4 = str;
                                obj6 = obj3;
                                parseContext5 = parseContext;
                                i9 = i3;
                            } catch (Throwable th18) {
                                th5 = th18;
                                parseContext2 = parseContext6;
                                th = th5;
                                parseContext = parseContext5;
                                parseContext4 = parseContext2;
                                if (parseContext4 != null) {
                                }
                                defaultJSONParser.setContext(parseContext);
                                throw th;
                            }
                        } catch (Throwable th19) {
                            th3 = th19;
                            t = obj6;
                            parseContext2 = parseContext6;
                            parseContext = parseContext5;
                            th = th3;
                            parseContext4 = parseContext2;
                            if (parseContext4 != null) {
                            }
                            defaultJSONParser.setContext(parseContext);
                            throw th;
                        }
                    }
                    t = (T) obj3;
                    parseContext3 = parseContext5;
                    HashMap hashMap4 = hashMap3;
                    b = 0;
                    if (t != null) {
                        parseContext = parseContext3;
                    } else if (hashMap4 == null) {
                        try {
                            T t5 = (T) createInstance((DefaultJSONParser) defaultJSONParser, type);
                            if (parseContext6 == null) {
                                parseContext = parseContext3;
                                try {
                                    parseContext6 = defaultJSONParser.setContext(parseContext, t5, obj);
                                } catch (Throwable th20) {
                                    th2 = th20;
                                    t = t5;
                                    parseContext4 = parseContext6;
                                }
                            } else {
                                parseContext = parseContext3;
                            }
                            if (parseContext6 != null) {
                                parseContext6.object = t5;
                            }
                            defaultJSONParser.setContext(parseContext);
                            return t5;
                        } catch (Throwable th21) {
                            th4 = th21;
                            parseContext = parseContext3;
                            th = th4;
                            parseContext4 = parseContext6;
                            if (parseContext4 != null) {
                            }
                            defaultJSONParser.setContext(parseContext);
                            throw th;
                        }
                    } else {
                        parseContext = parseContext3;
                        try {
                            String[] strArr = this.beanInfo.creatorConstructorParameters;
                            String str6 = "";
                            if (strArr != null) {
                                objArr = new Object[strArr.length];
                                int i15 = 0;
                                while (i15 < strArr.length) {
                                    long remove = hashMap4.remove(strArr[i15]);
                                    if (remove == null) {
                                        Type type2 = this.beanInfo.creatorConstructorParameterTypes[i15];
                                        FieldInfo fieldInfo4 = this.beanInfo.fields[i15];
                                        if (type2 == Byte.TYPE) {
                                            remove = Byte.valueOf(b);
                                        } else if (type2 == Short.TYPE) {
                                            remove = Short.valueOf(b);
                                        } else if (type2 == Integer.TYPE) {
                                            remove = Integer.valueOf(b);
                                        } else if (type2 == Long.TYPE) {
                                            remove = 0L;
                                        } else if (type2 == Float.TYPE) {
                                            remove = Float.valueOf(0.0f);
                                        } else if (type2 == Double.TYPE) {
                                            remove = Double.valueOf(0.0d);
                                        } else if (type2 == Boolean.TYPE) {
                                            remove = Boolean.FALSE;
                                        } else if (type2 == String.class && (fieldInfo4.parserFeatures & Feature.InitStringFieldAsEmpty.mask) != 0) {
                                            remove = str6;
                                        }
                                    } else if (this.beanInfo.creatorConstructorParameterTypes != null && i15 < this.beanInfo.creatorConstructorParameterTypes.length) {
                                        Type type3 = this.beanInfo.creatorConstructorParameterTypes[i15];
                                        if (type3 instanceof Class) {
                                            Class cls7 = (Class) type3;
                                            if (!cls7.isInstance(remove) && (remove instanceof List)) {
                                                List list = (List) remove;
                                                if (list.size() == 1) {
                                                    if (cls7.isInstance(list.get(0))) {
                                                        remove = list.get(0);
                                                    }
                                                    objArr[i15] = remove;
                                                    i15++;
                                                    b = 0;
                                                }
                                            }
                                        }
                                    }
                                    objArr[i15] = remove;
                                    i15++;
                                    b = 0;
                                }
                            } else {
                                FieldInfo[] fieldInfoArr = this.beanInfo.fields;
                                int length = fieldInfoArr.length;
                                Object[] objArr2 = new Object[length];
                                int i16 = 0;
                                while (i16 < length) {
                                    FieldInfo fieldInfo5 = fieldInfoArr[i16];
                                    long j = hashMap4.get(fieldInfo5.name);
                                    if (j == null) {
                                        Type type4 = fieldInfo5.fieldType;
                                        str2 = str6;
                                        if (type4 == Byte.TYPE) {
                                            j = (byte) 0;
                                        } else if (type4 == Short.TYPE) {
                                            j = (short) 0;
                                        } else if (type4 == Integer.TYPE) {
                                            j = 0;
                                        } else if (type4 == Long.TYPE) {
                                            j = 0L;
                                        } else if (type4 == Float.TYPE) {
                                            j = Float.valueOf(0.0f);
                                        } else if (type4 == Double.TYPE) {
                                            j = Double.valueOf(0.0d);
                                        } else if (type4 == Boolean.TYPE) {
                                            j = Boolean.FALSE;
                                        } else if (type4 == String.class && (fieldInfo5.parserFeatures & Feature.InitStringFieldAsEmpty.mask) != 0) {
                                            j = str2;
                                        }
                                    } else {
                                        str2 = str6;
                                    }
                                    objArr2[i16] = j;
                                    i16++;
                                    str6 = str2;
                                }
                                objArr = objArr2;
                            }
                            if (this.beanInfo.creatorConstructor != null) {
                                ?? r4 = this.beanInfo.f0kotlin;
                                if (r4 != 0) {
                                    r4 = 0;
                                    while (true) {
                                        if (r4 >= objArr.length) {
                                            break;
                                        } else if (objArr[r4] != null || this.beanInfo.fields == null || r4 >= this.beanInfo.fields.length) {
                                            r4++;
                                        } else {
                                            r4 = this.beanInfo.fields[r4].fieldClass;
                                            if (r4 == String.class) {
                                                z4 = true;
                                                obj5 = r4;
                                            }
                                        }
                                    }
                                    if (z4) {
                                        try {
                                            if (this.beanInfo.kotlinDefaultConstructor != null) {
                                                obj5 = this.beanInfo.kotlinDefaultConstructor.newInstance(new Object[0]);
                                                for (int i17 = 0; i17 < objArr.length; i17++) {
                                                    try {
                                                        Object obj7 = objArr[i17];
                                                        if (!(obj7 == null || this.beanInfo.fields == null || i17 >= this.beanInfo.fields.length)) {
                                                            this.beanInfo.fields[i17].set(obj5, obj7);
                                                        }
                                                    } catch (Exception e) {
                                                        exc = e;
                                                        throw new JSONException("create instance error, " + strArr + ", " + this.beanInfo.creatorConstructor.toGenericString(), exc);
                                                    }
                                                }
                                                if (strArr != null) {
                                                    for (Map.Entry<String, Object> entry : hashMap4.entrySet()) {
                                                        FieldDeserializer fieldDeserializer2 = getFieldDeserializer(entry.getKey());
                                                        if (fieldDeserializer2 != null) {
                                                            fieldDeserializer2.setValue(obj5, entry.getValue());
                                                        }
                                                    }
                                                }
                                                t = (T) obj5;
                                            }
                                        } catch (Exception e2) {
                                            exc = e2;
                                            throw new JSONException("create instance error, " + strArr + ", " + this.beanInfo.creatorConstructor.toGenericString(), exc);
                                        } catch (Throwable th22) {
                                            th = th22;
                                            t = (T) obj5;
                                            parseContext4 = parseContext6;
                                            if (parseContext4 != null) {
                                            }
                                            defaultJSONParser.setContext(parseContext);
                                            throw th;
                                        }
                                    }
                                    obj5 = this.beanInfo.creatorConstructor.newInstance(objArr);
                                    if (strArr != null) {
                                    }
                                    t = (T) obj5;
                                }
                                z4 = false;
                                obj5 = r4;
                                if (z4) {
                                }
                                obj5 = this.beanInfo.creatorConstructor.newInstance(objArr);
                                if (strArr != null) {
                                }
                                t = (T) obj5;
                            } else if (this.beanInfo.factoryMethod != null) {
                                try {
                                    t = (T) this.beanInfo.factoryMethod.invoke(null, objArr);
                                } catch (Exception e3) {
                                    throw new JSONException("create factory method error, " + this.beanInfo.factoryMethod.toString(), e3);
                                }
                            }
                            if (parseContext6 != null) {
                                parseContext6.object = t;
                            }
                        } catch (Throwable th23) {
                            th4 = th23;
                            th = th4;
                            parseContext4 = parseContext6;
                            if (parseContext4 != null) {
                            }
                            defaultJSONParser.setContext(parseContext);
                            throw th;
                        }
                    }
                    Method method = this.beanInfo.buildMethod;
                    if (method == null) {
                        if (parseContext6 != null) {
                            parseContext6.object = t;
                        }
                        defaultJSONParser.setContext(parseContext);
                        return (T) t;
                    }
                    try {
                        T t6 = (T) method.invoke(t, new Object[0]);
                        if (parseContext6 != null) {
                            parseContext6.object = t;
                        }
                        defaultJSONParser.setContext(parseContext);
                        return t6;
                    } catch (Exception e4) {
                        throw new JSONException("build object error", e4);
                    }
                } catch (Throwable th24) {
                    th2 = th24;
                    parseContext = parseContext5;
                    t = obj2;
                    th = th2;
                    if (parseContext4 != null) {
                    }
                    defaultJSONParser.setContext(parseContext);
                    throw th;
                }
            } else if (jSONLexerBase.isBlankInput()) {
                defaultJSONParser.setContext(parseContext5);
                return null;
            } else {
                if (i7 == 4) {
                    String stringVal3 = jSONLexerBase.stringVal();
                    if (stringVal3.length() == 0) {
                        jSONLexerBase.nextToken();
                        defaultJSONParser.setContext(parseContext5);
                        return null;
                    } else if (this.beanInfo.jsonType != null) {
                        Class<?>[] seeAlso2 = this.beanInfo.jsonType.seeAlso();
                        for (Class<?> cls8 : seeAlso2) {
                            if (Enum.class.isAssignableFrom(cls8)) {
                                try {
                                    T t7 = (T) Enum.valueOf(cls8, stringVal3);
                                    defaultJSONParser.setContext(parseContext5);
                                    return t7;
                                } catch (IllegalArgumentException unused) {
                                    continue;
                                }
                            }
                        }
                    }
                }
                if (i7 == 14 && jSONLexerBase.getCurrent() == ']') {
                    jSONLexerBase.next();
                    jSONLexerBase.nextToken();
                    defaultJSONParser.setContext(parseContext5);
                    return null;
                }
                if (this.beanInfo.factoryMethod != null && this.beanInfo.fields.length == 1) {
                    try {
                        FieldInfo fieldInfo6 = this.beanInfo.fields[0];
                        if (fieldInfo6.fieldClass == Integer.class) {
                            if (i7 == 2) {
                                int intValue = jSONLexerBase.intValue();
                                jSONLexerBase.nextToken();
                                T t8 = (T) createFactoryInstance(config, Integer.valueOf(intValue));
                                defaultJSONParser.setContext(parseContext5);
                                return t8;
                            }
                        } else if (fieldInfo6.fieldClass == String.class && i7 == 4) {
                            String stringVal4 = jSONLexerBase.stringVal();
                            jSONLexerBase.nextToken();
                            T t9 = (T) createFactoryInstance(config, stringVal4);
                            defaultJSONParser.setContext(parseContext5);
                            return t9;
                        }
                    } catch (Exception e5) {
                        throw new JSONException(e5.getMessage(), e5);
                    }
                }
                StringBuilder sb2 = new StringBuilder();
                sb2.append("syntax error, expect {, actual ");
                sb2.append(jSONLexerBase.tokenName());
                sb2.append(", pos ");
                sb2.append(jSONLexerBase.pos());
                if (obj instanceof String) {
                    sb2.append(", fieldName ");
                    sb2.append(obj);
                }
                sb2.append(", fastjson-version ");
                sb2.append(JSON.VERSION);
                throw new JSONException(sb2.toString());
            }
        }
    }

    /* access modifiers changed from: protected */
    public Enum scanEnum(JSONLexerBase jSONLexerBase, char[] cArr, ObjectDeserializer objectDeserializer) {
        EnumDeserializer enumDeserializer = objectDeserializer instanceof EnumDeserializer ? (EnumDeserializer) objectDeserializer : null;
        if (enumDeserializer == null) {
            jSONLexerBase.matchStat = -1;
            return null;
        }
        long scanEnumSymbol = jSONLexerBase.scanEnumSymbol(cArr);
        if (jSONLexerBase.matchStat <= 0) {
            return null;
        }
        Enum enumByHashCode = enumDeserializer.getEnumByHashCode(scanEnumSymbol);
        if (enumByHashCode == null) {
            if (scanEnumSymbol == TypeUtils.fnv1a_64_magic_hashcode) {
                return null;
            }
            if (jSONLexerBase.isEnabled(Feature.ErrorOnEnumNotMatch)) {
                throw new JSONException("not match enum value, " + enumDeserializer.enumClass);
            }
        }
        return enumByHashCode;
    }

    public boolean parseField(DefaultJSONParser defaultJSONParser, String str, Object obj, Type type, Map<String, Object> map) {
        return parseField(defaultJSONParser, str, obj, type, map, null);
    }

    /* JADX DEBUG: Multi-variable search result rejected for r5v3, resolved type: com.alibaba.fastjson.parser.deserializer.ArrayListTypeFieldDeserializer */
    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r17v0, types: [int, boolean] */
    /* JADX WARN: Type inference failed for: r17v1 */
    /* JADX WARN: Type inference failed for: r17v3 */
    /* JADX WARN: Type inference failed for: r17v4 */
    /* JADX WARNING: Removed duplicated region for block: B:106:0x0212  */
    /* JADX WARNING: Removed duplicated region for block: B:53:0x0125  */
    /* JADX WARNING: Unknown variable types count: 1 */
    public boolean parseField(DefaultJSONParser defaultJSONParser, String str, Object obj, Type type, Map<String, Object> map, int[] iArr) {
        FieldDeserializer fieldDeserializer;
        ?? r17;
        JSONLexer jSONLexer;
        FieldDeserializer fieldDeserializer2;
        FieldDeserializer fieldDeserializer3;
        Field[] fieldArr;
        FieldDeserializer fieldDeserializer4;
        JSONLexer jSONLexer2 = defaultJSONParser.lexer;
        int i = Feature.DisableFieldSmartMatch.mask;
        int i2 = Feature.InitStringFieldAsEmpty.mask;
        if (jSONLexer2.isEnabled(i) || (i & this.beanInfo.parserFeatures) != 0) {
            fieldDeserializer = getFieldDeserializer(str);
        } else if (jSONLexer2.isEnabled(i2) || (this.beanInfo.parserFeatures & i2) != 0) {
            fieldDeserializer = smartMatch(str);
        } else {
            fieldDeserializer = smartMatch(str, iArr);
        }
        int i3 = Feature.SupportNonPublicField.mask;
        if (fieldDeserializer != null || (!jSONLexer2.isEnabled(i3) && (i3 & this.beanInfo.parserFeatures) == 0)) {
            fieldDeserializer3 = fieldDeserializer;
        } else {
            if (this.extraFieldDeserializers == null) {
                ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(1, 0.75f, 1);
                Class<?> cls = this.clazz;
                while (cls != null && cls != Object.class) {
                    Field[] declaredFields = cls.getDeclaredFields();
                    int length = declaredFields.length;
                    int i4 = 0;
                    while (i4 < length) {
                        Field field = declaredFields[i4];
                        String name = field.getName();
                        if (getFieldDeserializer(name) == null) {
                            int modifiers = field.getModifiers();
                            if ((modifiers & 16) == 0 && (modifiers & 8) == 0) {
                                fieldDeserializer4 = fieldDeserializer;
                                JSONField jSONField = (JSONField) TypeUtils.getAnnotation(field, JSONField.class);
                                if (jSONField != null) {
                                    String name2 = jSONField.name();
                                    fieldArr = declaredFields;
                                    if (!"".equals(name2)) {
                                        name = name2;
                                    }
                                } else {
                                    fieldArr = declaredFields;
                                }
                                concurrentHashMap.put(name, field);
                                i4++;
                                fieldDeserializer = fieldDeserializer4;
                                declaredFields = fieldArr;
                            }
                        }
                        fieldDeserializer4 = fieldDeserializer;
                        fieldArr = declaredFields;
                        i4++;
                        fieldDeserializer = fieldDeserializer4;
                        declaredFields = fieldArr;
                    }
                    cls = cls.getSuperclass();
                }
                fieldDeserializer3 = fieldDeserializer;
                this.extraFieldDeserializers = concurrentHashMap;
            } else {
                fieldDeserializer3 = fieldDeserializer;
            }
            Object obj2 = this.extraFieldDeserializers.get(str);
            if (obj2 != null) {
                if (obj2 instanceof FieldDeserializer) {
                    fieldDeserializer2 = (FieldDeserializer) obj2;
                    jSONLexer = jSONLexer2;
                    r17 = 1;
                } else {
                    Field field2 = (Field) obj2;
                    field2.setAccessible(true);
                    r17 = 1;
                    jSONLexer = jSONLexer2;
                    fieldDeserializer2 = new DefaultFieldDeserializer(defaultJSONParser.getConfig(), this.clazz, new FieldInfo(str, field2.getDeclaringClass(), field2.getType(), field2.getGenericType(), field2, 0, 0, 0));
                    this.extraFieldDeserializers.put(str, fieldDeserializer2);
                }
                if (fieldDeserializer2 == null) {
                    int i5 = 0;
                    while (true) {
                        FieldDeserializer[] fieldDeserializerArr = this.sortedFieldDeserializers;
                        if (i5 >= fieldDeserializerArr.length) {
                            i5 = -1;
                            break;
                        } else if (fieldDeserializerArr[i5] == fieldDeserializer2) {
                            break;
                        } else {
                            i5++;
                        }
                    }
                    if (i5 == -1 || iArr == null || !str.startsWith("_") || !isSetFlag(i5, iArr)) {
                        jSONLexer.nextTokenWithColon(fieldDeserializer2.getFastMatchToken());
                        fieldDeserializer2.parseField(defaultJSONParser, obj, type, map);
                        if (iArr != null) {
                            int i6 = i5 / 32;
                            int i7 = iArr[i6];
                            int i8 = r17 == true ? 1 : 0;
                            int i9 = r17 == true ? 1 : 0;
                            int i10 = r17 == true ? 1 : 0;
                            int i11 = r17 == true ? 1 : 0;
                            iArr[i6] = i7 | (i8 << (i5 % 32));
                        }
                        return r17;
                    }
                    defaultJSONParser.parseExtra(obj, str);
                    return false;
                } else if (jSONLexer.isEnabled(Feature.IgnoreNotMatch)) {
                    int i12 = 0;
                    int i13 = -1;
                    while (true) {
                        FieldDeserializer[] fieldDeserializerArr2 = this.sortedFieldDeserializers;
                        if (i12 >= fieldDeserializerArr2.length) {
                            break;
                        }
                        FieldDeserializer fieldDeserializer5 = fieldDeserializerArr2[i12];
                        FieldInfo fieldInfo = fieldDeserializer5.fieldInfo;
                        if (fieldInfo.unwrapped && (fieldDeserializer5 instanceof DefaultFieldDeserializer)) {
                            if (fieldInfo.field != null) {
                                DefaultFieldDeserializer defaultFieldDeserializer = (DefaultFieldDeserializer) fieldDeserializer5;
                                ObjectDeserializer fieldValueDeserilizer = defaultFieldDeserializer.getFieldValueDeserilizer(defaultJSONParser.getConfig());
                                if (fieldValueDeserilizer instanceof JavaBeanDeserializer) {
                                    FieldDeserializer fieldDeserializer6 = ((JavaBeanDeserializer) fieldValueDeserilizer).getFieldDeserializer(str);
                                    if (fieldDeserializer6 != null) {
                                        try {
                                            Object obj3 = fieldInfo.field.get(obj);
                                            if (obj3 == null) {
                                                obj3 = ((JavaBeanDeserializer) fieldValueDeserilizer).createInstance(defaultJSONParser, fieldInfo.fieldType);
                                                fieldDeserializer5.setValue(obj, obj3);
                                            }
                                            jSONLexer.nextTokenWithColon(defaultFieldDeserializer.getFastMatchToken());
                                            fieldDeserializer6.parseField(defaultJSONParser, obj3, type, map);
                                        } catch (Exception e) {
                                            throw new JSONException("parse unwrapped field error.", e);
                                        }
                                    }
                                } else if (fieldValueDeserilizer instanceof MapDeserializer) {
                                    MapDeserializer mapDeserializer = (MapDeserializer) fieldValueDeserilizer;
                                    try {
                                        Map<Object, Object> map2 = (Map) fieldInfo.field.get(obj);
                                        if (map2 == null) {
                                            map2 = mapDeserializer.createMap(fieldInfo.fieldType);
                                            fieldDeserializer5.setValue(obj, map2);
                                        }
                                        jSONLexer.nextTokenWithColon();
                                        map2.put(str, defaultJSONParser.parse(str));
                                    } catch (Exception e2) {
                                        throw new JSONException("parse unwrapped field error.", e2);
                                    }
                                }
                            } else if (fieldInfo.method.getParameterTypes().length == 2) {
                                jSONLexer.nextTokenWithColon();
                                Object parse = defaultJSONParser.parse(str);
                                try {
                                    Method method = fieldInfo.method;
                                    Object[] objArr = new Object[2];
                                    objArr[0] = str;
                                    char c = r17 == true ? 1 : 0;
                                    char c2 = r17 == true ? 1 : 0;
                                    char c3 = r17 == true ? 1 : 0;
                                    char c4 = r17 == true ? 1 : 0;
                                    objArr[c] = parse;
                                    method.invoke(obj, objArr);
                                } catch (Exception e3) {
                                    throw new JSONException("parse unwrapped field error.", e3);
                                }
                            }
                            i13 = i12;
                        }
                        i12++;
                    }
                    if (i13 != -1) {
                        if (iArr != null) {
                            int i14 = i13 / 32;
                            iArr[i14] = iArr[i14] | (r17 << (i13 % 32));
                        }
                        return r17;
                    }
                    defaultJSONParser.parseExtra(obj, str);
                    return false;
                } else {
                    throw new JSONException("setter not found, class " + this.clazz.getName() + ", property " + str);
                }
            }
        }
        jSONLexer = jSONLexer2;
        r17 = 1;
        fieldDeserializer2 = fieldDeserializer3;
        if (fieldDeserializer2 == null) {
        }
    }

    public FieldDeserializer smartMatch(String str) {
        return smartMatch(str, null);
    }

    public FieldDeserializer smartMatch(String str, int[] iArr) {
        boolean z;
        if (str == null) {
            return null;
        }
        FieldDeserializer fieldDeserializer = getFieldDeserializer(str, iArr);
        if (fieldDeserializer == null) {
            int i = 0;
            if (this.smartMatchHashArray == null) {
                long[] jArr = new long[this.sortedFieldDeserializers.length];
                int i2 = 0;
                while (true) {
                    FieldDeserializer[] fieldDeserializerArr = this.sortedFieldDeserializers;
                    if (i2 >= fieldDeserializerArr.length) {
                        break;
                    }
                    jArr[i2] = fieldDeserializerArr[i2].fieldInfo.nameHashCode;
                    i2++;
                }
                Arrays.sort(jArr);
                this.smartMatchHashArray = jArr;
            }
            int binarySearch = Arrays.binarySearch(this.smartMatchHashArray, TypeUtils.fnv1a_64_lower(str));
            if (binarySearch < 0) {
                binarySearch = Arrays.binarySearch(this.smartMatchHashArray, TypeUtils.fnv1a_64_extract(str));
            }
            if (binarySearch < 0) {
                z = str.startsWith("is");
                if (z) {
                    binarySearch = Arrays.binarySearch(this.smartMatchHashArray, TypeUtils.fnv1a_64_extract(str.substring(2)));
                }
            } else {
                z = false;
            }
            if (binarySearch >= 0) {
                if (this.smartMatchHashArrayMapping == null) {
                    short[] sArr = new short[this.smartMatchHashArray.length];
                    Arrays.fill(sArr, (short) -1);
                    while (true) {
                        FieldDeserializer[] fieldDeserializerArr2 = this.sortedFieldDeserializers;
                        if (i >= fieldDeserializerArr2.length) {
                            break;
                        }
                        int binarySearch2 = Arrays.binarySearch(this.smartMatchHashArray, fieldDeserializerArr2[i].fieldInfo.nameHashCode);
                        if (binarySearch2 >= 0) {
                            sArr[binarySearch2] = (short) i;
                        }
                        i++;
                    }
                    this.smartMatchHashArrayMapping = sArr;
                }
                short s = this.smartMatchHashArrayMapping[binarySearch];
                if (s != -1 && !isSetFlag(s, iArr)) {
                    fieldDeserializer = this.sortedFieldDeserializers[s];
                }
            }
            if (fieldDeserializer != null) {
                FieldInfo fieldInfo = fieldDeserializer.fieldInfo;
                if ((fieldInfo.parserFeatures & Feature.DisableFieldSmartMatch.mask) != 0) {
                    return null;
                }
                Class<?> cls = fieldInfo.fieldClass;
                if (!(!z || cls == Boolean.TYPE || cls == Boolean.class)) {
                    return null;
                }
            }
        }
        return fieldDeserializer;
    }

    private Object createFactoryInstance(ParserConfig parserConfig, Object obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.beanInfo.factoryMethod.invoke(null, obj);
    }

    /* JADX WARNING: Code restructure failed: missing block: B:19:0x006b, code lost:
        if (com.alibaba.fastjson.JSONValidator.from(r6).validate() != false) goto L_0x0072;
     */
    public Object createInstance(Map<String, Object> map, ParserConfig parserConfig) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        boolean z;
        Integer num;
        Object obj;
        double d;
        float f;
        String str;
        if (this.beanInfo.creatorConstructor == null && this.beanInfo.factoryMethod == null) {
            Object createInstance = createInstance((DefaultJSONParser) null, this.clazz);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                FieldDeserializer smartMatch = smartMatch(entry.getKey());
                if (smartMatch != null) {
                    FieldInfo fieldInfo = smartMatch.fieldInfo;
                    Field field = smartMatch.fieldInfo.field;
                    Type type = fieldInfo.fieldType;
                    Class<?> cls = fieldInfo.fieldClass;
                    JSONField annotation = fieldInfo.getAnnotation();
                    if (fieldInfo.declaringClass == null || (cls.isInstance(value) && (annotation == null || annotation.deserializeUsing() == Void.class))) {
                        if (field != null && fieldInfo.method == null) {
                            Class<?> type2 = field.getType();
                            if (type2 == Boolean.TYPE) {
                                if (value == Boolean.FALSE) {
                                    field.setBoolean(createInstance, false);
                                } else if (value == Boolean.TRUE) {
                                    field.setBoolean(createInstance, true);
                                }
                            } else if (type2 == Integer.TYPE) {
                                if (value instanceof Number) {
                                    field.setInt(createInstance, ((Number) value).intValue());
                                }
                            } else if (type2 == Long.TYPE) {
                                if (value instanceof Number) {
                                    field.setLong(createInstance, ((Number) value).longValue());
                                }
                            } else if (type2 == Float.TYPE) {
                                if (value instanceof Number) {
                                    field.setFloat(createInstance, ((Number) value).floatValue());
                                } else if (value instanceof String) {
                                    String str2 = (String) value;
                                    if (str2.length() <= 10) {
                                        f = TypeUtils.parseFloat(str2);
                                    } else {
                                        f = Float.parseFloat(str2);
                                    }
                                    field.setFloat(createInstance, f);
                                }
                            } else if (type2 == Double.TYPE) {
                                if (value instanceof Number) {
                                    field.setDouble(createInstance, ((Number) value).doubleValue());
                                } else if (value instanceof String) {
                                    String str3 = (String) value;
                                    if (str3.length() <= 10) {
                                        d = TypeUtils.parseDouble(str3);
                                    } else {
                                        d = Double.parseDouble(str3);
                                    }
                                    field.setDouble(createInstance, d);
                                }
                            } else if (value != null && type == value.getClass()) {
                                field.set(createInstance, value);
                            }
                        }
                        String str4 = fieldInfo.format;
                        if (str4 != null && type == Date.class) {
                            obj = TypeUtils.castToDate(value, str4);
                        } else if (str4 != null && (type instanceof Class) && ((Class) type).getName().equals("java.time.LocalDateTime")) {
                            obj = Jdk8DateCodec.castToLocalDateTime(value, str4);
                        } else if (type instanceof ParameterizedType) {
                            obj = TypeUtils.cast(value, (ParameterizedType) type, parserConfig);
                        } else {
                            obj = TypeUtils.cast(value, type, parserConfig);
                        }
                        smartMatch.setValue(createInstance, obj);
                    } else {
                        if (value instanceof String) {
                            str = (String) value;
                        }
                        str = JSON.toJSONString(value);
                        smartMatch.parseField(new DefaultJSONParser(str), createInstance, type, null);
                    }
                }
            }
            if (this.beanInfo.buildMethod == null) {
                return createInstance;
            }
            try {
                return this.beanInfo.buildMethod.invoke(createInstance, new Object[0]);
            } catch (Exception e) {
                throw new JSONException("build object error", e);
            }
        } else {
            FieldInfo[] fieldInfoArr = this.beanInfo.fields;
            int length = fieldInfoArr.length;
            Object[] objArr = new Object[length];
            HashMap hashMap = null;
            for (int i = 0; i < length; i++) {
                FieldInfo fieldInfo2 = fieldInfoArr[i];
                boolean z2 = map.get(fieldInfo2.name);
                if (z2 == null) {
                    Class<?> cls2 = fieldInfo2.fieldClass;
                    if (cls2 == Integer.TYPE) {
                        z2 = 0;
                    } else if (cls2 == Long.TYPE) {
                        z2 = 0L;
                    } else if (cls2 == Short.TYPE) {
                        z2 = (short) 0;
                    } else if (cls2 == Byte.TYPE) {
                        z2 = (byte) 0;
                    } else if (cls2 == Float.TYPE) {
                        z2 = Float.valueOf(0.0f);
                    } else if (cls2 == Double.TYPE) {
                        z2 = Double.valueOf(0.0d);
                    } else if (cls2 == Character.TYPE) {
                        z2 = '0';
                    } else if (cls2 == Boolean.TYPE) {
                        z2 = false;
                    }
                    if (hashMap == null) {
                        hashMap = new HashMap();
                    }
                    hashMap.put(fieldInfo2.name, Integer.valueOf(i));
                }
                objArr[i] = z2;
            }
            if (hashMap != null) {
                for (Map.Entry<String, Object> entry2 : map.entrySet()) {
                    Object value2 = entry2.getValue();
                    FieldDeserializer smartMatch2 = smartMatch(entry2.getKey());
                    if (!(smartMatch2 == null || (num = (Integer) hashMap.get(smartMatch2.fieldInfo.name)) == null)) {
                        objArr[num.intValue()] = value2;
                    }
                }
            }
            if (this.beanInfo.creatorConstructor != null) {
                if (this.beanInfo.f0kotlin) {
                    z = false;
                    for (int i2 = 0; i2 < length; i2++) {
                        Object obj2 = objArr[i2];
                        if (obj2 == null) {
                            if (this.beanInfo.fields != null && i2 < this.beanInfo.fields.length && this.beanInfo.fields[i2].fieldClass == String.class) {
                                z = true;
                            }
                        } else if (obj2.getClass() != this.beanInfo.fields[i2].fieldClass) {
                            objArr[i2] = TypeUtils.cast(obj2, (Class) this.beanInfo.fields[i2].fieldClass, parserConfig);
                        }
                    }
                } else {
                    z = false;
                }
                if (!z || this.beanInfo.kotlinDefaultConstructor == null) {
                    try {
                        return this.beanInfo.creatorConstructor.newInstance(objArr);
                    } catch (Exception e2) {
                        throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toGenericString(), e2);
                    }
                } else {
                    try {
                        Object newInstance = this.beanInfo.kotlinDefaultConstructor.newInstance(new Object[0]);
                        for (int i3 = 0; i3 < length; i3++) {
                            Object obj3 = objArr[i3];
                            if (!(obj3 == null || this.beanInfo.fields == null || i3 >= this.beanInfo.fields.length)) {
                                this.beanInfo.fields[i3].set(newInstance, obj3);
                            }
                        }
                        return newInstance;
                    } catch (Exception e3) {
                        throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toGenericString(), e3);
                    }
                }
            } else if (this.beanInfo.factoryMethod == null) {
                return null;
            } else {
                try {
                    return this.beanInfo.factoryMethod.invoke(null, objArr);
                } catch (Exception e4) {
                    throw new JSONException("create factory method error, " + this.beanInfo.factoryMethod.toString(), e4);
                }
            }
        }
    }

    public Type getFieldType(int i) {
        return this.sortedFieldDeserializers[i].fieldInfo.fieldType;
    }

    /* access modifiers changed from: protected */
    public Object parseRest(DefaultJSONParser defaultJSONParser, Type type, Object obj, Object obj2, int i) {
        return parseRest(defaultJSONParser, type, obj, obj2, i, new int[0]);
    }

    /* access modifiers changed from: protected */
    public Object parseRest(DefaultJSONParser defaultJSONParser, Type type, Object obj, Object obj2, int i, int[] iArr) {
        return deserialze(defaultJSONParser, type, obj, obj2, i, iArr);
    }

    protected static JavaBeanDeserializer getSeeAlso(ParserConfig parserConfig, JavaBeanInfo javaBeanInfo, String str) {
        if (javaBeanInfo.jsonType == null) {
            return null;
        }
        for (Class<?> cls : javaBeanInfo.jsonType.seeAlso()) {
            ObjectDeserializer deserializer = parserConfig.getDeserializer(cls);
            if (deserializer instanceof JavaBeanDeserializer) {
                JavaBeanDeserializer javaBeanDeserializer = (JavaBeanDeserializer) deserializer;
                JavaBeanInfo javaBeanInfo2 = javaBeanDeserializer.beanInfo;
                if (javaBeanInfo2.typeName.equals(str)) {
                    return javaBeanDeserializer;
                }
                JavaBeanDeserializer seeAlso = getSeeAlso(parserConfig, javaBeanInfo2, str);
                if (seeAlso != null) {
                    return seeAlso;
                }
            }
        }
        return null;
    }

    protected static void parseArray(Collection collection, ObjectDeserializer objectDeserializer, DefaultJSONParser defaultJSONParser, Type type, Object obj) {
        JSONLexerBase jSONLexerBase = (JSONLexerBase) defaultJSONParser.lexer;
        int i = jSONLexerBase.token();
        if (i == 8) {
            jSONLexerBase.nextToken(16);
            jSONLexerBase.token();
            return;
        }
        if (i != 14) {
            defaultJSONParser.throwException(i);
        }
        if (jSONLexerBase.getCurrent() == '[') {
            jSONLexerBase.next();
            jSONLexerBase.setToken(14);
        } else {
            jSONLexerBase.nextToken(14);
        }
        if (jSONLexerBase.token() == 15) {
            jSONLexerBase.nextToken();
            return;
        }
        int i2 = 0;
        while (true) {
            collection.add(objectDeserializer.deserialze(defaultJSONParser, type, Integer.valueOf(i2)));
            i2++;
            if (jSONLexerBase.token() != 16) {
                break;
            } else if (jSONLexerBase.getCurrent() == '[') {
                jSONLexerBase.next();
                jSONLexerBase.setToken(14);
            } else {
                jSONLexerBase.nextToken(14);
            }
        }
        int i3 = jSONLexerBase.token();
        if (i3 != 15) {
            defaultJSONParser.throwException(i3);
        }
        if (jSONLexerBase.getCurrent() == ',') {
            jSONLexerBase.next();
            jSONLexerBase.setToken(16);
            return;
        }
        jSONLexerBase.nextToken(16);
    }
}
