package com.alibaba.fastjson;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONScanner;
import io.dcloud.common.constant.AbsoluteConst;

public class JSONPatch {

    @JSONType(orders = {"op", "from", AbsoluteConst.XML_PATH, "value"})
    public static class Operation {
        public String from;
        public String path;
        @JSONField(name = "op")
        public OperationType type;
        public Object value;
    }

    public enum OperationType {
        add,
        remove,
        replace,
        move,
        copy,
        test
    }

    public static String apply(String str, String str2) {
        return JSON.toJSONString(apply(JSON.parse(str, Feature.OrderedField), str2));
    }

    public static Object apply(Object obj, String str) {
        boolean z = false;
        Operation[] operationArr = isObject(str) ? new Operation[]{(Operation) JSON.parseObject(str, Operation.class)} : (Operation[]) JSON.parseObject(str, Operation[].class);
        for (Operation operation : operationArr) {
            JSONPath compile = JSONPath.compile(operation.path);
            switch (AnonymousClass1.$SwitchMap$com$alibaba$fastjson$JSONPatch$OperationType[operation.type.ordinal()]) {
                case 1:
                    compile.patchAdd(obj, operation.value, false);
                    break;
                case 2:
                    compile.patchAdd(obj, operation.value, true);
                    break;
                case 3:
                    compile.remove(obj);
                    break;
                case 4:
                case 5:
                    JSONPath compile2 = JSONPath.compile(operation.from);
                    Object eval = compile2.eval(obj);
                    if (operation.type != OperationType.move || compile2.remove(obj)) {
                        compile.set(obj, eval);
                        break;
                    } else {
                        throw new JSONException("json patch move error : " + operation.from + " -> " + operation.path);
                    }
                case 6:
                    Object eval2 = compile.eval(obj);
                    if (eval2 != null) {
                        return Boolean.valueOf(eval2.equals(operation.value));
                    }
                    if (operation.value == null) {
                        z = true;
                    }
                    return Boolean.valueOf(z);
            }
        }
        return obj;
    }

    /* access modifiers changed from: package-private */
    /* renamed from: com.alibaba.fastjson.JSONPatch$1  reason: invalid class name */
    public static /* synthetic */ class AnonymousClass1 {
        static final /* synthetic */ int[] $SwitchMap$com$alibaba$fastjson$JSONPatch$OperationType;

        /* JADX WARNING: Can't wrap try/catch for region: R(14:0|1|2|3|4|5|6|7|8|9|10|11|12|14) */
        /* JADX WARNING: Failed to process nested try/catch */
        /* JADX WARNING: Missing exception handler attribute for start block: B:11:0x003e */
        /* JADX WARNING: Missing exception handler attribute for start block: B:3:0x0012 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:5:0x001d */
        /* JADX WARNING: Missing exception handler attribute for start block: B:7:0x0028 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:9:0x0033 */
        static {
            int[] iArr = new int[OperationType.values().length];
            $SwitchMap$com$alibaba$fastjson$JSONPatch$OperationType = iArr;
            iArr[OperationType.add.ordinal()] = 1;
            $SwitchMap$com$alibaba$fastjson$JSONPatch$OperationType[OperationType.replace.ordinal()] = 2;
            $SwitchMap$com$alibaba$fastjson$JSONPatch$OperationType[OperationType.remove.ordinal()] = 3;
            $SwitchMap$com$alibaba$fastjson$JSONPatch$OperationType[OperationType.copy.ordinal()] = 4;
            $SwitchMap$com$alibaba$fastjson$JSONPatch$OperationType[OperationType.move.ordinal()] = 5;
            try {
                $SwitchMap$com$alibaba$fastjson$JSONPatch$OperationType[OperationType.test.ordinal()] = 6;
            } catch (NoSuchFieldError unused) {
            }
        }
    }

    private static boolean isObject(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); i++) {
            char charAt = str.charAt(i);
            if (!JSONScanner.isWhitespace(charAt)) {
                if (charAt == '{') {
                    return true;
                } else {
                    return false;
                }
            }
        }
        return false;
    }
}
