package com.alibaba.android.bindingx.plugin.weex;

import android.content.Context;
import android.graphics.Color;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.View;
import com.alibaba.android.bindingx.core.BindingXCore;
import com.alibaba.android.bindingx.core.BindingXEventType;
import com.alibaba.android.bindingx.core.IEventHandler;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.BindingXConstants;
import com.alibaba.android.bindingx.core.internal.Utils;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.ui.animation.TransformParser;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.view.WXTextView;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.feature.uniapp.dom.AbsCSSShorthand;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class WXBindingXModule extends WXSDKEngine.DestroyableModule {
    private BindingXCore mBindingXCore;
    private PlatformManager mPlatformManager;

    public WXBindingXModule() {
    }

    WXBindingXModule(BindingXCore bindingXCore) {
        this.mBindingXCore = bindingXCore;
    }

    private void prepareInternal() {
        if (this.mPlatformManager == null) {
            this.mPlatformManager = createPlatformManager(this.mWXSDKInstance);
        }
        if (this.mBindingXCore == null) {
            BindingXCore bindingXCore = new BindingXCore(this.mPlatformManager);
            this.mBindingXCore = bindingXCore;
            bindingXCore.registerEventHandler("scroll", new BindingXCore.ObjectCreator<IEventHandler, Context, PlatformManager>() {
                /* class com.alibaba.android.bindingx.plugin.weex.WXBindingXModule.AnonymousClass1 */

                public IEventHandler createWith(Context context, PlatformManager platformManager, Object... objArr) {
                    return new BindingXScrollHandler(context, platformManager, objArr);
                }
            });
            this.mBindingXCore.registerEventHandler("pan", new BindingXCore.ObjectCreator<IEventHandler, Context, PlatformManager>() {
                /* class com.alibaba.android.bindingx.plugin.weex.WXBindingXModule.AnonymousClass2 */

                public IEventHandler createWith(Context context, PlatformManager platformManager, Object... objArr) {
                    return new BindingXGestureHandler(context, platformManager, objArr);
                }
            });
        }
    }

    @JSMethod(uiThread = false)
    public void prepare(Map<String, Object> map) {
        prepareInternal();
    }

    @JSMethod(uiThread = false)
    public Map<String, String> bind(Map<String, Object> map, final JSCallback jSCallback) {
        prepareInternal();
        BindingXCore bindingXCore = this.mBindingXCore;
        String str = null;
        Context context = this.mWXSDKInstance == null ? null : this.mWXSDKInstance.getContext();
        if (this.mWXSDKInstance != null) {
            str = this.mWXSDKInstance.getInstanceId();
        }
        if (map == null) {
            map = Collections.emptyMap();
        }
        String doBind = bindingXCore.doBind(context, str, map, new BindingXCore.JavaScriptCallback() {
            /* class com.alibaba.android.bindingx.plugin.weex.WXBindingXModule.AnonymousClass3 */

            @Override // com.alibaba.android.bindingx.core.BindingXCore.JavaScriptCallback
            public void callback(Object obj) {
                if (jSCallback != null) {
                    Log.e("触发去往前端的回调", WXBridgeManager.METHOD_CALLBACK);
                    jSCallback.invokeAndKeepAlive(obj);
                }
            }
        }, new Object[0]);
        HashMap hashMap = new HashMap(2);
        hashMap.put(BindingXConstants.KEY_TOKEN, doBind);
        return hashMap;
    }

    @JSMethod(uiThread = false)
    public void bindAsync(Map<String, Object> map, JSCallback jSCallback, JSCallback jSCallback2) {
        Map<String, String> bind = bind(map, jSCallback);
        if (jSCallback2 != null && bind != null) {
            jSCallback2.invoke(bind);
        }
    }

    @JSMethod(uiThread = false)
    public void unbind(Map<String, Object> map) {
        BindingXCore bindingXCore = this.mBindingXCore;
        if (bindingXCore != null) {
            bindingXCore.doUnbind(map);
        }
    }

    @JSMethod(uiThread = false)
    public void unbindAll() {
        BindingXCore bindingXCore = this.mBindingXCore;
        if (bindingXCore != null) {
            bindingXCore.doRelease();
        }
    }

    @JSMethod(uiThread = false)
    public List<String> supportFeatures() {
        return Arrays.asList("pan", "orientation", BindingXEventType.TYPE_TIMING, "scroll", "experimentalGestureFeatures");
    }

    @JSMethod(uiThread = false)
    public void getComputedStyleAsync(String str, JSCallback jSCallback) {
        Map<String, Object> computedStyle = getComputedStyle(str);
        if (jSCallback != null) {
            jSCallback.invoke(computedStyle);
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:18:0x0232  */
    @JSMethod(uiThread = false)
    public Map<String, Object> getComputedStyle(String str) {
        double d;
        double d2;
        double d3;
        Layout textLayout;
        CharSequence text;
        ForegroundColorSpan[] foregroundColorSpanArr;
        prepareInternal();
        PlatformManager.IDeviceResolutionTranslator resolutionTranslator = this.mPlatformManager.getResolutionTranslator();
        WXComponent findComponentByRef = WXModuleUtils.findComponentByRef(this.mWXSDKInstance.getInstanceId(), str);
        if (findComponentByRef == null) {
            return Collections.emptyMap();
        }
        View hostView = findComponentByRef.getHostView();
        if (hostView == null) {
            return Collections.emptyMap();
        }
        HashMap hashMap = new HashMap();
        hashMap.put("width", Double.valueOf(resolutionTranslator.nativeToWeb((double) findComponentByRef.getLayoutWidth(), new Object[0])));
        hashMap.put("height", Double.valueOf(resolutionTranslator.nativeToWeb((double) findComponentByRef.getLayoutHeight(), new Object[0])));
        hashMap.put(AbsoluteConst.JSON_KEY_PADDING_LEFT, Double.valueOf(resolutionTranslator.nativeToWeb((double) findComponentByRef.getPadding().get(AbsCSSShorthand.EDGE.LEFT), new Object[0])));
        hashMap.put("padding-top", Double.valueOf(resolutionTranslator.nativeToWeb((double) findComponentByRef.getPadding().get(AbsCSSShorthand.EDGE.TOP), new Object[0])));
        hashMap.put(AbsoluteConst.JSON_KEY_PADDING_RIGHT, Double.valueOf(resolutionTranslator.nativeToWeb((double) findComponentByRef.getPadding().get(AbsCSSShorthand.EDGE.RIGHT), new Object[0])));
        hashMap.put("padding-bottom", Double.valueOf(resolutionTranslator.nativeToWeb((double) findComponentByRef.getPadding().get(AbsCSSShorthand.EDGE.BOTTOM), new Object[0])));
        hashMap.put("margin-left", Double.valueOf(resolutionTranslator.nativeToWeb((double) findComponentByRef.getMargin().get(AbsCSSShorthand.EDGE.LEFT), new Object[0])));
        hashMap.put("margin-top", Double.valueOf(resolutionTranslator.nativeToWeb((double) findComponentByRef.getMargin().get(AbsCSSShorthand.EDGE.TOP), new Object[0])));
        hashMap.put("margin-right", Double.valueOf(resolutionTranslator.nativeToWeb((double) findComponentByRef.getMargin().get(AbsCSSShorthand.EDGE.RIGHT), new Object[0])));
        hashMap.put("margin-bottom", Double.valueOf(resolutionTranslator.nativeToWeb((double) findComponentByRef.getMargin().get(AbsCSSShorthand.EDGE.BOTTOM), new Object[0])));
        hashMap.put("translateX", Double.valueOf(resolutionTranslator.nativeToWeb((double) hostView.getTranslationX(), new Object[0])));
        hashMap.put("translateY", Double.valueOf(resolutionTranslator.nativeToWeb((double) hostView.getTranslationY(), new Object[0])));
        hashMap.put("rotateX", Float.valueOf(Utils.normalizeRotation(hostView.getRotationX())));
        hashMap.put("rotateY", Float.valueOf(Utils.normalizeRotation(hostView.getRotationY())));
        hashMap.put(TransformParser.WX_ROTATE_Z, Float.valueOf(Utils.normalizeRotation(hostView.getRotation())));
        hashMap.put("scaleX", Float.valueOf(hostView.getScaleX()));
        hashMap.put("scaleY", Float.valueOf(hostView.getScaleY()));
        hashMap.put("opacity", Float.valueOf(hostView.getAlpha()));
        Drawable background = hostView.getBackground();
        double d4 = 0.0d;
        if (background != null && (background instanceof BorderDrawable)) {
            float[] borderRadius = ((BorderDrawable) background).getBorderRadius(new RectF(0.0f, 0.0f, (float) hostView.getWidth(), (float) hostView.getHeight()));
            if (borderRadius.length == 8) {
                d2 = (double) borderRadius[2];
                d = (double) borderRadius[6];
                d3 = (double) borderRadius[4];
                d4 = (double) borderRadius[0];
                hashMap.put("border-top-left-radius", Double.valueOf(resolutionTranslator.nativeToWeb(d4, new Object[0])));
                hashMap.put("border-top-right-radius", Double.valueOf(resolutionTranslator.nativeToWeb(d2, new Object[0])));
                hashMap.put("border-bottom-left-radius", Double.valueOf(resolutionTranslator.nativeToWeb(d, new Object[0])));
                hashMap.put("border-bottom-right-radius", Double.valueOf(resolutionTranslator.nativeToWeb(d3, new Object[0])));
                if (hostView.getBackground() != null) {
                    int i = -16777216;
                    if (hostView.getBackground() instanceof ColorDrawable) {
                        i = ((ColorDrawable) hostView.getBackground()).getColor();
                    } else if (hostView.getBackground() instanceof BorderDrawable) {
                        i = ((BorderDrawable) hostView.getBackground()).getColor();
                    }
                    double alpha = (double) Color.alpha(i);
                    Double.isNaN(alpha);
                    hashMap.put("background-color", String.format(Locale.getDefault(), "rgba(%d,%d,%d,%f)", Integer.valueOf(Color.red(i)), Integer.valueOf(Color.green(i)), Integer.valueOf(Color.blue(i)), Double.valueOf(alpha / 255.0d)));
                }
                if ((findComponentByRef instanceof WXText) && (hostView instanceof WXTextView) && (textLayout = ((WXTextView) hostView).getTextLayout()) != null && (text = textLayout.getText()) != null && (text instanceof SpannableString) && (foregroundColorSpanArr = (ForegroundColorSpan[]) ((SpannableString) text).getSpans(0, text.length(), ForegroundColorSpan.class)) != null && foregroundColorSpanArr.length == 1) {
                    int foregroundColor = foregroundColorSpanArr[0].getForegroundColor();
                    double alpha2 = (double) Color.alpha(foregroundColor);
                    Double.isNaN(alpha2);
                    hashMap.put("color", String.format(Locale.getDefault(), "rgba(%d,%d,%d,%f)", Integer.valueOf(Color.red(foregroundColor)), Integer.valueOf(Color.green(foregroundColor)), Integer.valueOf(Color.blue(foregroundColor)), Double.valueOf(alpha2 / 255.0d)));
                }
                return hashMap;
            }
        }
        d3 = 0.0d;
        d2 = 0.0d;
        d = 0.0d;
        hashMap.put("border-top-left-radius", Double.valueOf(resolutionTranslator.nativeToWeb(d4, new Object[0])));
        hashMap.put("border-top-right-radius", Double.valueOf(resolutionTranslator.nativeToWeb(d2, new Object[0])));
        hashMap.put("border-bottom-left-radius", Double.valueOf(resolutionTranslator.nativeToWeb(d, new Object[0])));
        hashMap.put("border-bottom-right-radius", Double.valueOf(resolutionTranslator.nativeToWeb(d3, new Object[0])));
        if (hostView.getBackground() != null) {
        }
        int foregroundColor2 = foregroundColorSpanArr[0].getForegroundColor();
        double alpha22 = (double) Color.alpha(foregroundColor2);
        Double.isNaN(alpha22);
        hashMap.put("color", String.format(Locale.getDefault(), "rgba(%d,%d,%d,%f)", Integer.valueOf(Color.red(foregroundColor2)), Integer.valueOf(Color.green(foregroundColor2)), Integer.valueOf(Color.blue(foregroundColor2)), Double.valueOf(alpha22 / 255.0d)));
        return hashMap;
    }

    @Override // com.taobao.weex.common.Destroyable
    public void destroy() {
        WXBridgeManager.getInstance().post(new Runnable() {
            /* class com.alibaba.android.bindingx.plugin.weex.WXBindingXModule.AnonymousClass4 */

            public void run() {
                if (WXBindingXModule.this.mBindingXCore != null) {
                    WXBindingXModule.this.mBindingXCore.doRelease();
                    WXBindingXModule.this.mBindingXCore = null;
                }
                WXViewUpdateService.clearCallbacks();
            }
        }, null);
    }

    static PlatformManager createPlatformManager(WXSDKInstance wXSDKInstance) {
        final int instanceViewPortWidth = wXSDKInstance == null ? 750 : wXSDKInstance.getInstanceViewPortWidth();
        return new PlatformManager.Builder().withViewFinder(new PlatformManager.IViewFinder() {
            /* class com.alibaba.android.bindingx.plugin.weex.WXBindingXModule.AnonymousClass7 */

            @Override // com.alibaba.android.bindingx.core.PlatformManager.IViewFinder
            public View findViewBy(String str, Object... objArr) {
                if (objArr.length <= 0 || !(objArr[0] instanceof String)) {
                    return null;
                }
                return WXModuleUtils.findViewByRef((String) objArr[0], str);
            }
        }).withViewUpdater(new PlatformManager.IViewUpdater() {
            /* class com.alibaba.android.bindingx.plugin.weex.WXBindingXModule.AnonymousClass6 */

            @Override // com.alibaba.android.bindingx.core.PlatformManager.IViewUpdater
            public void synchronouslyUpdateViewOnUIThread(View view, String str, Object obj, PlatformManager.IDeviceResolutionTranslator iDeviceResolutionTranslator, Map<String, Object> map, Object... objArr) {
                if (objArr != null && objArr.length >= 2 && (objArr[0] instanceof String) && (objArr[1] instanceof String)) {
                    String str2 = (String) objArr[0];
                    String str3 = (String) objArr[1];
                    WXComponent findComponentByRef = WXModuleUtils.findComponentByRef(str3, str2);
                    if (findComponentByRef == null) {
                        LogProxy.e("unexpected error. component not found [ref:" + str2 + ",instanceId:" + str3 + Operators.ARRAY_END_STR);
                        return;
                    }
                    WXViewUpdateService.findUpdater(str).update(findComponentByRef, view, obj, iDeviceResolutionTranslator, map);
                }
            }
        }).withDeviceResolutionTranslator(new PlatformManager.IDeviceResolutionTranslator() {
            /* class com.alibaba.android.bindingx.plugin.weex.WXBindingXModule.AnonymousClass5 */

            @Override // com.alibaba.android.bindingx.core.PlatformManager.IDeviceResolutionTranslator
            public double webToNative(double d, Object... objArr) {
                return (double) WXViewUtils.getRealPxByWidth((float) d, instanceViewPortWidth);
            }

            @Override // com.alibaba.android.bindingx.core.PlatformManager.IDeviceResolutionTranslator
            public double nativeToWeb(double d, Object... objArr) {
                return (double) WXViewUtils.getWebPxByWidth((float) d, instanceViewPortWidth);
            }
        }).build();
    }

    @Override // com.taobao.weex.common.WXModule
    public void onActivityPause() {
        WXBridgeManager.getInstance().post(new Runnable() {
            /* class com.alibaba.android.bindingx.plugin.weex.WXBindingXModule.AnonymousClass8 */

            public void run() {
                if (WXBindingXModule.this.mBindingXCore != null) {
                    WXBindingXModule.this.mBindingXCore.onActivityPause();
                }
            }
        }, null);
    }

    @Override // com.taobao.weex.common.WXModule
    public void onActivityResume() {
        WXBridgeManager.getInstance().post(new Runnable() {
            /* class com.alibaba.android.bindingx.plugin.weex.WXBindingXModule.AnonymousClass9 */

            public void run() {
                if (WXBindingXModule.this.mBindingXCore != null) {
                    WXBindingXModule.this.mBindingXCore.onActivityResume();
                }
            }
        }, null);
    }
}
