package com.alibaba.android.bindingx.core.internal;

import com.taobao.weex.el.parse.Operators;

/* access modifiers changed from: package-private */
public class Quaternion {
    double w;
    double x;
    double y;
    double z;

    Quaternion() {
    }

    Quaternion(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    /* access modifiers changed from: package-private */
    public Quaternion setFromEuler(Euler euler) {
        if (euler == null || !euler.isEuler) {
            return null;
        }
        double cos = Math.cos(euler.x / 2.0d);
        double cos2 = Math.cos(euler.y / 2.0d);
        double cos3 = Math.cos(euler.z / 2.0d);
        double sin = Math.sin(euler.x / 2.0d);
        double sin2 = Math.sin(euler.y / 2.0d);
        double sin3 = Math.sin(euler.z / 2.0d);
        String str = euler.order;
        if ("XYZ".equals(str)) {
            double d = sin * cos2;
            double d2 = cos * sin2;
            this.x = (d * cos3) + (d2 * sin3);
            this.y = (d2 * cos3) - (d * sin3);
            double d3 = cos * cos2;
            double d4 = sin * sin2;
            this.z = (d3 * sin3) + (d4 * cos3);
            this.w = (d3 * cos3) - (d4 * sin3);
        } else if ("YXZ".equals(str)) {
            double d5 = sin * cos2;
            double d6 = cos * sin2;
            this.x = (d5 * cos3) + (d6 * sin3);
            this.y = (d6 * cos3) - (d5 * sin3);
            double d7 = cos * cos2;
            double d8 = sin * sin2;
            this.z = (d7 * sin3) - (d8 * cos3);
            this.w = (d7 * cos3) + (d8 * sin3);
        } else if ("ZXY".equals(str)) {
            double d9 = sin * cos2;
            double d10 = cos * sin2;
            this.x = (d9 * cos3) - (d10 * sin3);
            this.y = (d10 * cos3) + (d9 * sin3);
            double d11 = cos * cos2;
            double d12 = sin * sin2;
            this.z = (d11 * sin3) + (d12 * cos3);
            this.w = (d11 * cos3) - (d12 * sin3);
        } else if ("ZYX".equals(str)) {
            double d13 = sin * cos2;
            double d14 = cos * sin2;
            this.x = (d13 * cos3) - (d14 * sin3);
            this.y = (d14 * cos3) + (d13 * sin3);
            double d15 = cos * cos2;
            double d16 = sin * sin2;
            this.z = (d15 * sin3) - (d16 * cos3);
            this.w = (d15 * cos3) + (d16 * sin3);
        } else if ("YZX".equals(str)) {
            double d17 = sin * cos2;
            double d18 = cos * sin2;
            this.x = (d17 * cos3) + (d18 * sin3);
            this.y = (d18 * cos3) + (d17 * sin3);
            double d19 = cos * cos2;
            double d20 = sin * sin2;
            this.z = (d19 * sin3) - (d20 * cos3);
            this.w = (d19 * cos3) - (d20 * sin3);
        } else if ("XZY".equals(str)) {
            double d21 = sin * cos2;
            double d22 = cos * sin2;
            this.x = (d21 * cos3) - (d22 * sin3);
            this.y = (d22 * cos3) - (d21 * sin3);
            double d23 = cos * cos2;
            double d24 = sin * sin2;
            this.z = (d23 * sin3) + (d24 * cos3);
            this.w = (d23 * cos3) + (d24 * sin3);
        }
        return this;
    }

    /* access modifiers changed from: package-private */
    public Quaternion setFromAxisAngle(Vector3 vector3, double d) {
        double d2 = d / 2.0d;
        double sin = Math.sin(d2);
        this.x = vector3.x * sin;
        this.y = vector3.y * sin;
        this.z = vector3.z * sin;
        this.w = Math.cos(d2);
        return this;
    }

    /* access modifiers changed from: package-private */
    public Quaternion multiply(Quaternion quaternion) {
        return multiplyQuaternions(this, quaternion);
    }

    /* access modifiers changed from: package-private */
    public Quaternion multiplyQuaternions(Quaternion quaternion, Quaternion quaternion2) {
        double d = quaternion.x;
        double d2 = quaternion.y;
        double d3 = quaternion.z;
        double d4 = quaternion.w;
        double d5 = quaternion2.x;
        double d6 = quaternion2.y;
        double d7 = quaternion2.z;
        double d8 = quaternion2.w;
        this.x = (((d * d8) + (d4 * d5)) + (d2 * d7)) - (d3 * d6);
        this.y = (((d2 * d8) + (d4 * d6)) + (d3 * d5)) - (d * d7);
        this.z = (((d3 * d8) + (d4 * d7)) + (d * d6)) - (d2 * d5);
        this.w = (((d4 * d8) - (d * d5)) - (d2 * d6)) - (d3 * d7);
        return this;
    }

    public String toString() {
        return "Quaternion{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + Operators.BLOCK_END;
    }
}
