package com.alibaba.android.bindingx.core.internal;

import com.alibaba.android.bindingx.core.LogProxy;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.ui.component.richtext.node.RichTextNode;
import io.dcloud.common.constant.AbsoluteConst;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/* access modifiers changed from: package-private */
public class Expression {
    private JSONObject root;

    Expression(String str) {
        try {
            this.root = (JSONObject) new JSONTokener(str).nextValue();
        } catch (Throwable th) {
            LogProxy.e("[Expression] expression is illegal. \n ", th);
        }
    }

    Expression(JSONObject jSONObject) {
        this.root = jSONObject;
    }

    /* access modifiers changed from: package-private */
    public Object execute(Map<String, Object> map) throws IllegalArgumentException, JSONException {
        return execute(this.root, map);
    }

    private double toNumber(Object obj) {
        if (obj instanceof String) {
            return Double.parseDouble((String) obj);
        }
        if (obj instanceof Boolean) {
            return ((Boolean) obj).booleanValue() ? 1.0d : 0.0d;
        }
        return ((Double) obj).doubleValue();
    }

    private boolean toBoolean(Object obj) {
        if (obj instanceof String) {
            return "".equals(obj);
        }
        if (obj instanceof Double) {
            return ((Double) obj).doubleValue() != 0.0d;
        }
        return ((Boolean) obj).booleanValue();
    }

    private String toString(Object obj) {
        if (obj instanceof Boolean) {
            return ((Boolean) obj).booleanValue() ? AbsoluteConst.TRUE : AbsoluteConst.FALSE;
        }
        if (obj instanceof Double) {
            return Double.toString(((Double) obj).doubleValue());
        }
        return (String) obj;
    }

    private boolean equal(Object obj, Object obj2) {
        if ((obj instanceof JSObjectInterface) && (obj2 instanceof JSObjectInterface)) {
            return obj == obj2;
        }
        if ((obj instanceof String) && (obj2 instanceof String)) {
            return obj.equals(obj2);
        }
        if (!(obj instanceof Boolean) || !(obj2 instanceof Boolean)) {
            if (toNumber(obj) == toNumber(obj2)) {
                return true;
            }
            return false;
        } else if (toBoolean(obj) == toBoolean(obj2)) {
            return true;
        } else {
            return false;
        }
    }

    private boolean strictlyEqual(Object obj, Object obj2) {
        if ((obj instanceof JSObjectInterface) && !(obj2 instanceof JSObjectInterface)) {
            return false;
        }
        if ((obj instanceof Boolean) && !(obj2 instanceof Boolean)) {
            return false;
        }
        if ((obj instanceof Double) && !(obj2 instanceof Double)) {
            return false;
        }
        if ((!(obj instanceof String) || (obj2 instanceof String)) && obj == obj2) {
            return true;
        }
        return false;
    }

    private Object execute(JSONObject jSONObject, Map<String, Object> map) throws IllegalArgumentException, JSONException {
        String string = jSONObject.getString("type");
        JSONArray optJSONArray = jSONObject.optJSONArray(RichTextNode.CHILDREN);
        string.hashCode();
        boolean z = false;
        boolean z2 = false;
        boolean z3 = false;
        boolean z4 = false;
        char c = 65535;
        switch (string.hashCode()) {
            case -1746151498:
                if (string.equals("CallExpression")) {
                    c = 0;
                    break;
                }
                break;
            case 33:
                if (string.equals(Operators.AND_NOT)) {
                    c = 1;
                    break;
                }
                break;
            case 37:
                if (string.equals("%")) {
                    c = 2;
                    break;
                }
                break;
            case 42:
                if (string.equals("*")) {
                    c = 3;
                    break;
                }
                break;
            case 43:
                if (string.equals(Operators.PLUS)) {
                    c = 4;
                    break;
                }
                break;
            case 45:
                if (string.equals(Operators.SUB)) {
                    c = 5;
                    break;
                }
                break;
            case 47:
                if (string.equals("/")) {
                    c = 6;
                    break;
                }
                break;
            case 60:
                if (string.equals(Operators.L)) {
                    c = 7;
                    break;
                }
                break;
            case 62:
                if (string.equals(Operators.G)) {
                    c = '\b';
                    break;
                }
                break;
            case 63:
                if (string.equals(Operators.CONDITION_IF_STRING)) {
                    c = '\t';
                    break;
                }
                break;
            case 1084:
                if (string.equals(Operators.NOT_EQUAL2)) {
                    c = '\n';
                    break;
                }
                break;
            case 1216:
                if (string.equals(Operators.AND)) {
                    c = 11;
                    break;
                }
                break;
            case 1344:
                if (string.equals("**")) {
                    c = '\f';
                    break;
                }
                break;
            case 1921:
                if (string.equals(Operators.LE)) {
                    c = '\r';
                    break;
                }
                break;
            case 1952:
                if (string.equals(Operators.EQUAL2)) {
                    c = 14;
                    break;
                }
                break;
            case 1983:
                if (string.equals(Operators.GE)) {
                    c = 15;
                    break;
                }
                break;
            case 3968:
                if (string.equals(Operators.OR)) {
                    c = 16;
                    break;
                }
                break;
            case 33665:
                if (string.equals(Operators.NOT_EQUAL)) {
                    c = 17;
                    break;
                }
                break;
            case 60573:
                if (string.equals(Operators.EQUAL)) {
                    c = 18;
                    break;
                }
                break;
            case 189157634:
                if (string.equals("NumericLiteral")) {
                    c = 19;
                    break;
                }
                break;
            case 375032009:
                if (string.equals("Identifier")) {
                    c = 20;
                    break;
                }
                break;
            case 1074430782:
                if (string.equals("StringLiteral")) {
                    c = 21;
                    break;
                }
                break;
            case 1816238983:
                if (string.equals("BooleanLiteral")) {
                    c = 22;
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
                JSFunctionInterface jSFunctionInterface = (JSFunctionInterface) execute(optJSONArray.getJSONObject(0), map);
                ArrayList<Object> arrayList = new ArrayList<>();
                JSONArray jSONArray = optJSONArray.getJSONObject(1).getJSONArray(RichTextNode.CHILDREN);
                for (int i = 0; i < jSONArray.length(); i++) {
                    arrayList.add(execute(jSONArray.getJSONObject(i), map));
                }
                return jSFunctionInterface.execute(arrayList);
            case 1:
                return Boolean.valueOf(!toBoolean(execute(optJSONArray.getJSONObject(0), map)));
            case 2:
                return Double.valueOf(toNumber(execute(optJSONArray.getJSONObject(0), map)) % toNumber(execute(optJSONArray.getJSONObject(1), map)));
            case 3:
                return Double.valueOf(toNumber(execute(optJSONArray.getJSONObject(0), map)) * toNumber(execute(optJSONArray.getJSONObject(1), map)));
            case 4:
                return Double.valueOf(toNumber(execute(optJSONArray.getJSONObject(0), map)) + toNumber(execute(optJSONArray.getJSONObject(1), map)));
            case 5:
                return Double.valueOf(toNumber(execute(optJSONArray.getJSONObject(0), map)) - toNumber(execute(optJSONArray.getJSONObject(1), map)));
            case 6:
                return Double.valueOf(toNumber(execute(optJSONArray.getJSONObject(0), map)) / toNumber(execute(optJSONArray.getJSONObject(1), map)));
            case 7:
                if (toNumber(execute(optJSONArray.getJSONObject(0), map)) < toNumber(execute(optJSONArray.getJSONObject(1), map))) {
                    z4 = true;
                }
                return Boolean.valueOf(z4);
            case '\b':
                if (toNumber(execute(optJSONArray.getJSONObject(0), map)) > toNumber(execute(optJSONArray.getJSONObject(1), map))) {
                    z3 = true;
                }
                return Boolean.valueOf(z3);
            case '\t':
                if (((Boolean) execute(optJSONArray.getJSONObject(0), map)).booleanValue()) {
                    return execute(optJSONArray.getJSONObject(1), map);
                }
                return execute(optJSONArray.getJSONObject(2), map);
            case '\n':
                return Boolean.valueOf(!equal(execute(optJSONArray.getJSONObject(0), map), execute(optJSONArray.getJSONObject(1), map)));
            case 11:
                Object execute = execute(optJSONArray.getJSONObject(0), map);
                if (!toBoolean(execute)) {
                    return execute;
                }
                return execute(optJSONArray.getJSONObject(1), map);
            case '\f':
                return Double.valueOf(Math.pow(toNumber(execute(optJSONArray.getJSONObject(0), map)), toNumber(execute(optJSONArray.getJSONObject(1), map))));
            case '\r':
                if (toNumber(execute(optJSONArray.getJSONObject(0), map)) <= toNumber(execute(optJSONArray.getJSONObject(1), map))) {
                    z2 = true;
                }
                return Boolean.valueOf(z2);
            case 14:
                return Boolean.valueOf(equal(execute(optJSONArray.getJSONObject(0), map), execute(optJSONArray.getJSONObject(1), map)));
            case 15:
                if (toNumber(execute(optJSONArray.getJSONObject(0), map)) >= toNumber(execute(optJSONArray.getJSONObject(1), map))) {
                    z = true;
                }
                return Boolean.valueOf(z);
            case 16:
                Object execute2 = execute(optJSONArray.getJSONObject(0), map);
                if (toBoolean(execute2)) {
                    return execute2;
                }
                return execute(optJSONArray.getJSONObject(1), map);
            case 17:
                return Boolean.valueOf(!strictlyEqual(execute(optJSONArray.getJSONObject(0), map), execute(optJSONArray.getJSONObject(1), map)));
            case 18:
                return Boolean.valueOf(strictlyEqual(execute(optJSONArray.getJSONObject(0), map), execute(optJSONArray.getJSONObject(1), map)));
            case 19:
                return Double.valueOf(jSONObject.getDouble("value"));
            case 20:
                return map.get(jSONObject.getString("value"));
            case 21:
                return jSONObject.getString("value");
            case 22:
                return Boolean.valueOf(jSONObject.getBoolean("value"));
            default:
                return null;
        }
    }
}
