package androidtranscoder;

import android.media.MediaFormat;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidtranscoder.engine.MediaTranscoderEngine;
import androidtranscoder.format.MediaFormatPresets;
import androidtranscoder.format.MediaFormatStrategy;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class MediaTranscoder {
    private static final int MAXIMUM_THREAD = 1;
    private static final String TAG = "MediaTranscoder";
    private static volatile MediaTranscoder sMediaTranscoder;
    private ThreadPoolExecutor mExecutor = new ThreadPoolExecutor(0, 1, 60, TimeUnit.SECONDS, new LinkedBlockingQueue(), new ThreadFactory() {
        /* class androidtranscoder.MediaTranscoder.AnonymousClass1 */

        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "MediaTranscoder-Worker");
        }
    });

    public interface Listener {
        void onTranscodeCanceled();

        void onTranscodeCompleted();

        void onTranscodeFailed(Exception exc);

        void onTranscodeProgress(double d);
    }

    private MediaTranscoder() {
    }

    public static MediaTranscoder getInstance() {
        if (sMediaTranscoder == null) {
            synchronized (MediaTranscoder.class) {
                if (sMediaTranscoder == null) {
                    sMediaTranscoder = new MediaTranscoder();
                }
            }
        }
        return sMediaTranscoder;
    }

    @Deprecated
    public Future<Void> transcodeVideo(FileDescriptor fileDescriptor, String str, Listener listener) {
        return transcodeVideo(fileDescriptor, str, new MediaFormatStrategy() {
            /* class androidtranscoder.MediaTranscoder.AnonymousClass2 */

            @Override // androidtranscoder.format.MediaFormatStrategy
            public MediaFormat createAudioOutputFormat(MediaFormat mediaFormat) {
                return null;
            }

            @Override // androidtranscoder.format.MediaFormatStrategy
            public MediaFormat createVideoOutputFormat(MediaFormat mediaFormat) {
                return MediaFormatPresets.getExportPreset960x540();
            }
        }, listener);
    }

    /* JADX WARNING: Removed duplicated region for block: B:10:0x0019 A[SYNTHETIC, Splitter:B:10:0x0019] */
    public Future<Void> transcodeVideo(String str, String str2, MediaFormatStrategy mediaFormatStrategy, final Listener listener) throws IOException {
        IOException e;
        final FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(str);
            try {
                return transcodeVideo(fileInputStream.getFD(), str2, mediaFormatStrategy, new Listener() {
                    /* class androidtranscoder.MediaTranscoder.AnonymousClass3 */

                    private void closeStream() {
                        try {
                            fileInputStream.close();
                        } catch (IOException e) {
                            Log.e(MediaTranscoder.TAG, "Can't close input stream: ", e);
                        }
                    }

                    @Override // androidtranscoder.MediaTranscoder.Listener
                    public void onTranscodeCanceled() {
                        closeStream();
                        listener.onTranscodeCanceled();
                    }

                    @Override // androidtranscoder.MediaTranscoder.Listener
                    public void onTranscodeCompleted() {
                        closeStream();
                        listener.onTranscodeCompleted();
                    }

                    @Override // androidtranscoder.MediaTranscoder.Listener
                    public void onTranscodeFailed(Exception exc) {
                        closeStream();
                        listener.onTranscodeFailed(exc);
                    }

                    @Override // androidtranscoder.MediaTranscoder.Listener
                    public void onTranscodeProgress(double d) {
                        listener.onTranscodeProgress(d);
                    }
                });
            } catch (IOException e2) {
                e = e2;
                if (fileInputStream != null) {
                }
                throw e;
            }
        } catch (IOException e3) {
            e = e3;
            fileInputStream = null;
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                } catch (IOException e4) {
                    Log.e(TAG, "Can't close input stream: ", e4);
                }
            }
            throw e;
        }
    }

    public Future<Void> transcodeVideo(final FileDescriptor fileDescriptor, final String str, final MediaFormatStrategy mediaFormatStrategy, final Listener listener) {
        Looper myLooper = Looper.myLooper();
        if (myLooper == null) {
            myLooper = Looper.getMainLooper();
        }
        final Handler handler = new Handler(myLooper);
        final AtomicReference atomicReference = new AtomicReference();
        Future<Void> submit = this.mExecutor.submit(new Callable<Void>() {
            /* class androidtranscoder.MediaTranscoder.AnonymousClass4 */

            @Override // java.util.concurrent.Callable
            public Void call() throws Exception {
                final Exception e;
                try {
                    MediaTranscoderEngine mediaTranscoderEngine = new MediaTranscoderEngine();
                    mediaTranscoderEngine.setProgressCallback(new MediaTranscoderEngine.ProgressCallback() {
                        /* class androidtranscoder.MediaTranscoder.AnonymousClass4.AnonymousClass1 */

                        @Override // androidtranscoder.engine.MediaTranscoderEngine.ProgressCallback
                        public void onProgress(final double d) {
                            handler.post(new Runnable() {
                                /* class androidtranscoder.MediaTranscoder.AnonymousClass4.AnonymousClass1.AnonymousClass1 */

                                public void run() {
                                    listener.onTranscodeProgress(d);
                                }
                            });
                        }
                    });
                    mediaTranscoderEngine.setDataSource(fileDescriptor);
                    mediaTranscoderEngine.transcodeVideo(str, mediaFormatStrategy);
                    e = null;
                } catch (IOException e2) {
                    e = e2;
                    Log.w(MediaTranscoder.TAG, "Transcode failed: input file (fd: " + fileDescriptor.toString() + ") not found or could not open output file ('" + str + "') .", e);
                } catch (InterruptedException e3) {
                    e = e3;
                    Log.i(MediaTranscoder.TAG, "Cancel transcode video file.", e);
                } catch (RuntimeException e4) {
                    e = e4;
                    Log.e(MediaTranscoder.TAG, "Fatal error while transcoding, this might be invalid format or bug in engine or Android.", e);
                }
                handler.post(new Runnable() {
                    /* class androidtranscoder.MediaTranscoder.AnonymousClass4.AnonymousClass2 */

                    public void run() {
                        if (e == null) {
                            listener.onTranscodeCompleted();
                            return;
                        }
                        Future future = (Future) atomicReference.get();
                        if (future == null || !future.isCancelled()) {
                            listener.onTranscodeFailed(e);
                        } else {
                            listener.onTranscodeCanceled();
                        }
                    }
                });
                if (e == null) {
                    return null;
                }
                throw e;
            }
        });
        atomicReference.set(submit);
        return submit;
    }
}
