package androidx.core.math;
/* loaded from: classes.dex */
public class MathUtils {
    public static double clamp(double d, double d2, double d3) {
        return d < d2 ? d2 : d > d3 ? d3 : d;
    }

    public static float clamp(float f, float f2, float f3) {
        return f < f2 ? f2 : f > f3 ? f3 : f;
    }

    public static int clamp(int i, int i2, int i3) {
        return i < i2 ? i2 : i > i3 ? i3 : i;
    }

    public static long clamp(long j, long j2, long j3) {
        return j < j2 ? j2 : j > j3 ? j3 : j;
    }

    private MathUtils() {
    }

    public static int addExact(int i, int i2) {
        int i3 = i + i2;
        if ((i >= 0) == (i2 >= 0)) {
            if ((i >= 0) != (i3 >= 0)) {
                throw new ArithmeticException("integer overflow");
            }
        }
        return i3;
    }

    public static long addExact(long j, long j2) {
        long j3 = j + j2;
        int i = (j > 0L ? 1 : (j == 0L ? 0 : -1));
        if ((i >= 0) == (j2 >= 0)) {
            if ((i >= 0) != (j3 >= 0)) {
                throw new ArithmeticException("integer overflow");
            }
        }
        return j3;
    }

    public static int subtractExact(int i, int i2) {
        int i3 = i - i2;
        if ((i < 0) != (i2 < 0)) {
            if ((i < 0) != (i3 < 0)) {
                throw new ArithmeticException("integer overflow");
            }
        }
        return i3;
    }

    public static long subtractExact(long j, long j2) {
        long j3 = j - j2;
        int i = (j > 0L ? 1 : (j == 0L ? 0 : -1));
        if ((i < 0) != (j2 < 0)) {
            if ((i < 0) != (j3 < 0)) {
                throw new ArithmeticException("integer overflow");
            }
        }
        return j3;
    }

    public static int multiplyExact(int i, int i2) {
        int i3 = i * i2;
        if (i == 0 || i2 == 0 || (i3 / i == i2 && i3 / i2 == i)) {
            return i3;
        }
        throw new ArithmeticException("integer overflow");
    }

    public static long multiplyExact(long j, long j2) {
        long j3 = j * j2;
        if (j == 0 || j2 == 0 || (j3 / j == j2 && j3 / j2 == j)) {
            return j3;
        }
        throw new ArithmeticException("integer overflow");
    }

    public static int incrementExact(int i) {
        if (i != Integer.MAX_VALUE) {
            return i + 1;
        }
        throw new ArithmeticException("integer overflow");
    }

    public static long incrementExact(long j) {
        if (j != Long.MAX_VALUE) {
            return j + 1;
        }
        throw new ArithmeticException("integer overflow");
    }

    public static int decrementExact(int i) {
        if (i != Integer.MIN_VALUE) {
            return i - 1;
        }
        throw new ArithmeticException("integer overflow");
    }

    public static long decrementExact(long j) {
        if (j != Long.MIN_VALUE) {
            return j - 1;
        }
        throw new ArithmeticException("integer overflow");
    }

    public static int negateExact(int i) {
        if (i != Integer.MIN_VALUE) {
            return -i;
        }
        throw new ArithmeticException("integer overflow");
    }

    public static long negateExact(long j) {
        if (j != Long.MIN_VALUE) {
            return -j;
        }
        throw new ArithmeticException("integer overflow");
    }

    public static int toIntExact(long j) {
        if (j > 2147483647L || j < -2147483648L) {
            throw new ArithmeticException("integer overflow");
        }
        return (int) j;
    }
}
