package kotlinx.coroutines;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
/* loaded from: classes.dex */
public final class v extends e1 {

    /* renamed from: e  reason: collision with root package name */
    public static final v f1161e = new v();

    /* renamed from: f  reason: collision with root package name */
    private static final int f1162f;

    /* renamed from: g  reason: collision with root package name */
    private static boolean f1163g;
    private static volatile Executor pool;

    static {
        String str;
        Integer f2;
        int intValue;
        try {
            str = System.getProperty("kotlinx.coroutines.default.parallelism");
        } catch (Throwable unused) {
            str = null;
        }
        if (str == null) {
            intValue = -1;
        } else {
            f2 = i.a0.l.f(str);
            if (f2 == null || f2.intValue() < 1) {
                throw new IllegalStateException(i.v.d.i.j("Expected positive number in kotlinx.coroutines.default.parallelism, but has ", str).toString());
            }
            intValue = f2.intValue();
        }
        f1162f = intValue;
    }

    private v() {
    }

    private final ExecutorService o() {
        final AtomicInteger atomicInteger = new AtomicInteger();
        return Executors.newFixedThreadPool(u(), new ThreadFactory() { // from class: kotlinx.coroutines.b
            @Override // java.util.concurrent.ThreadFactory
            public final Thread newThread(Runnable runnable) {
                Thread q;
                q = v.q(atomicInteger, runnable);
                return q;
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final Thread q(AtomicInteger atomicInteger, Runnable runnable) {
        Thread thread = new Thread(runnable, i.v.d.i.j("CommonPool-worker-", Integer.valueOf(atomicInteger.incrementAndGet())));
        thread.setDaemon(true);
        return thread;
    }

    /* JADX WARN: Removed duplicated region for block: B:24:0x003d  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private final ExecutorService s() {
        Class<?> cls;
        ExecutorService executorService;
        Object invoke;
        if (System.getSecurityManager() != null) {
            return o();
        }
        ExecutorService executorService2 = null;
        try {
            cls = Class.forName("java.util.concurrent.ForkJoinPool");
        } catch (Throwable unused) {
            cls = null;
        }
        if (cls == null) {
            return o();
        }
        if (!f1163g && f1162f < 0) {
            try {
                invoke = cls.getMethod("commonPool", new Class[0]).invoke(null, new Object[0]);
            } catch (Throwable unused2) {
            }
            if (invoke instanceof ExecutorService) {
                executorService = (ExecutorService) invoke;
                if (executorService != null) {
                    if (!f1161e.v(cls, executorService)) {
                        executorService = null;
                    }
                    if (executorService != null) {
                        return executorService;
                    }
                }
            }
            executorService = null;
            if (executorService != null) {
            }
        }
        try {
            Object newInstance = cls.getConstructor(Integer.TYPE).newInstance(Integer.valueOf(f1161e.u()));
            if (newInstance instanceof ExecutorService) {
                executorService2 = (ExecutorService) newInstance;
            }
        } catch (Throwable unused3) {
        }
        return executorService2 == null ? o() : executorService2;
    }

    private final synchronized Executor t() {
        Executor executor;
        executor = pool;
        if (executor == null) {
            executor = s();
            pool = executor;
        }
        return executor;
    }

    private final int u() {
        int a;
        Integer valueOf = Integer.valueOf(f1162f);
        if (!(valueOf.intValue() > 0)) {
            valueOf = null;
        }
        if (valueOf == null) {
            a = i.x.f.a(Runtime.getRuntime().availableProcessors() - 1, 1);
            return a;
        }
        return valueOf.intValue();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void w() {
    }

    @Override // java.io.Closeable, java.lang.AutoCloseable
    public void close() {
        throw new IllegalStateException("Close cannot be invoked on CommonPool".toString());
    }

    @Override // kotlinx.coroutines.f0
    public void j(i.s.g gVar, Runnable runnable) {
        try {
            Executor executor = pool;
            if (executor == null) {
                executor = t();
            }
            d a = e.a();
            executor.execute(a == null ? runnable : a.h(runnable));
        } catch (RejectedExecutionException unused) {
            d a2 = e.a();
            if (a2 != null) {
                a2.e();
            }
            q0.f1146j.G(runnable);
        }
    }

    @Override // kotlinx.coroutines.f0
    public String toString() {
        return "CommonPool";
    }

    public final boolean v(Class<?> cls, ExecutorService executorService) {
        executorService.submit(a.f1000d);
        Integer num = null;
        try {
            Object invoke = cls.getMethod("getPoolSize", new Class[0]).invoke(executorService, new Object[0]);
            if (invoke instanceof Integer) {
                num = (Integer) invoke;
            }
        } catch (Throwable unused) {
        }
        return num != null && num.intValue() >= 1;
    }
}
