package io.flutter.plugins.imagepicker;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import h.a.c.a.h;
import h.a.c.a.i;
import h.a.c.a.k;
import h.a.c.a.n;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
/* loaded from: classes.dex */
public class e implements k, n {
    final String a;
    private final Activity b;
    final File c;

    /* renamed from: d  reason: collision with root package name */
    private final io.flutter.plugins.imagepicker.g f778d;

    /* renamed from: e  reason: collision with root package name */
    private final io.flutter.plugins.imagepicker.d f779e;

    /* renamed from: f  reason: collision with root package name */
    private final g f780f;

    /* renamed from: g  reason: collision with root package name */
    private final InterfaceC0059e f781g;

    /* renamed from: h  reason: collision with root package name */
    private final io.flutter.plugins.imagepicker.c f782h;

    /* renamed from: i  reason: collision with root package name */
    private io.flutter.plugins.imagepicker.a f783i;

    /* renamed from: j  reason: collision with root package name */
    private Uri f784j;
    private i.d k;
    private h l;

    /* loaded from: classes.dex */
    class a implements g {
        final /* synthetic */ Activity a;

        a(Activity activity) {
            this.a = activity;
        }

        @Override // io.flutter.plugins.imagepicker.e.g
        public boolean a() {
            return io.flutter.plugins.imagepicker.f.b(this.a);
        }

        @Override // io.flutter.plugins.imagepicker.e.g
        public boolean b(String str) {
            return e.c.a.a.a(this.a, str) == 0;
        }

        @Override // io.flutter.plugins.imagepicker.e.g
        public void c(String str, int i2) {
            androidx.core.app.a.f(this.a, new String[]{str}, i2);
        }
    }

    /* loaded from: classes.dex */
    class b implements InterfaceC0059e {
        final /* synthetic */ Activity a;

        /* loaded from: classes.dex */
        class a implements MediaScannerConnection.OnScanCompletedListener {
            final /* synthetic */ f a;

            a(b bVar, f fVar) {
                this.a = fVar;
            }

            @Override // android.media.MediaScannerConnection.OnScanCompletedListener
            public void onScanCompleted(String str, Uri uri) {
                this.a.a(str);
            }
        }

        b(Activity activity) {
            this.a = activity;
        }

        @Override // io.flutter.plugins.imagepicker.e.InterfaceC0059e
        public Uri a(String str, File file) {
            return e.c.a.b.e(this.a, str, file);
        }

        @Override // io.flutter.plugins.imagepicker.e.InterfaceC0059e
        public void b(Uri uri, f fVar) {
            Activity activity = this.a;
            String[] strArr = new String[1];
            strArr[0] = uri != null ? uri.getPath() : "";
            MediaScannerConnection.scanFile(activity, strArr, null, new a(this, fVar));
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class c implements f {
        c() {
        }

        @Override // io.flutter.plugins.imagepicker.e.f
        public void a(String str) {
            e.this.w(str, true);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class d implements f {
        d() {
        }

        @Override // io.flutter.plugins.imagepicker.e.f
        public void a(String str) {
            e.this.y(str);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: io.flutter.plugins.imagepicker.e$e  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public interface InterfaceC0059e {
        Uri a(String str, File file);

        void b(Uri uri, f fVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public interface f {
        void a(String str);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public interface g {
        boolean a();

        boolean b(String str);

        void c(String str, int i2);
    }

    e(Activity activity, File file, io.flutter.plugins.imagepicker.g gVar, i.d dVar, h hVar, io.flutter.plugins.imagepicker.d dVar2, g gVar2, InterfaceC0059e interfaceC0059e, io.flutter.plugins.imagepicker.c cVar) {
        this.b = activity;
        this.c = file;
        this.f778d = gVar;
        this.a = activity.getPackageName() + ".flutter.image_provider";
        this.k = dVar;
        this.l = hVar;
        this.f780f = gVar2;
        this.f781g = interfaceC0059e;
        this.f782h = cVar;
        this.f779e = dVar2;
    }

    public e(Activity activity, File file, io.flutter.plugins.imagepicker.g gVar, io.flutter.plugins.imagepicker.d dVar) {
        this(activity, file, gVar, null, null, dVar, new a(activity), new b(activity), new io.flutter.plugins.imagepicker.c());
    }

    private void A() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        this.b.startActivityForResult(intent, 2342);
    }

    private void B() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("video/*");
        this.b.startActivityForResult(intent, 2352);
    }

    private void C() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (this.f783i == io.flutter.plugins.imagepicker.a.FRONT) {
            L(intent);
        }
        File j2 = j();
        this.f784j = Uri.parse("file:" + j2.getAbsolutePath());
        Uri a2 = this.f781g.a(this.a, j2);
        intent.putExtra("output", a2);
        q(intent, a2);
        try {
            try {
                this.b.startActivityForResult(intent, 2343);
            } catch (ActivityNotFoundException unused) {
                j2.delete();
                m("no_available_camera", "No cameras available for taking pictures.");
            }
        } catch (SecurityException e2) {
            e2.printStackTrace();
            m("no_available_camera", "No cameras available for taking pictures.");
        }
    }

    private void D() {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        h hVar = this.l;
        if (hVar != null && hVar.a("maxDuration") != null) {
            intent.putExtra("android.intent.extra.durationLimit", ((Integer) this.l.a("maxDuration")).intValue());
        }
        if (this.f783i == io.flutter.plugins.imagepicker.a.FRONT) {
            L(intent);
        }
        File k = k();
        this.f784j = Uri.parse("file:" + k.getAbsolutePath());
        Uri a2 = this.f781g.a(this.a, k);
        intent.putExtra("output", a2);
        q(intent, a2);
        try {
            try {
                this.b.startActivityForResult(intent, 2353);
            } catch (ActivityNotFoundException unused) {
                k.delete();
                m("no_available_camera", "No cameras available for taking pictures.");
            }
        } catch (SecurityException e2) {
            e2.printStackTrace();
            m("no_available_camera", "No cameras available for taking pictures.");
        }
    }

    private boolean E() {
        g gVar = this.f780f;
        if (gVar == null) {
            return false;
        }
        return gVar.a();
    }

    private boolean I(h hVar, i.d dVar) {
        if (this.k != null) {
            return false;
        }
        this.l = hVar;
        this.k = dVar;
        this.f779e.a();
        return true;
    }

    private void L(Intent intent) {
        int i2 = Build.VERSION.SDK_INT;
        if (i2 < 22) {
            intent.putExtra("android.intent.extras.CAMERA_FACING", 1);
            return;
        }
        intent.putExtra("android.intent.extras.CAMERA_FACING", 0);
        if (i2 >= 26) {
            intent.putExtra("android.intent.extra.USE_FRONT_CAMERA", true);
        }
    }

    private void h() {
        this.l = null;
        this.k = null;
    }

    private File i(String str) {
        String uuid = UUID.randomUUID().toString();
        try {
            this.c.mkdirs();
            return File.createTempFile(uuid, str, this.c);
        } catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private File j() {
        return i(".jpg");
    }

    private File k() {
        return i(".mp4");
    }

    private void l(i.d dVar) {
        dVar.b("already_active", "Image picker is already active", null);
    }

    private void m(String str, String str2) {
        i.d dVar = this.k;
        if (dVar == null) {
            this.f779e.f(null, str, str2);
            return;
        }
        dVar.b(str, str2, null);
        h();
    }

    private void n(ArrayList<String> arrayList) {
        i.d dVar = this.k;
        if (dVar == null) {
            this.f779e.f(arrayList, null, null);
            return;
        }
        dVar.a(arrayList);
        h();
    }

    private void o(String str) {
        i.d dVar = this.k;
        if (dVar != null) {
            dVar.a(str);
            h();
            return;
        }
        ArrayList<String> arrayList = new ArrayList<>();
        arrayList.add(str);
        this.f779e.f(arrayList, null, null);
    }

    private String p(String str) {
        return this.f778d.h(str, (Double) this.l.a("maxWidth"), (Double) this.l.a("maxHeight"), (Integer) this.l.a("imageQuality"));
    }

    private void q(Intent intent, Uri uri) {
        for (ResolveInfo resolveInfo : this.b.getPackageManager().queryIntentActivities(intent, 65536)) {
            this.b.grantUriPermission(resolveInfo.activityInfo.packageName, uri, 3);
        }
    }

    private void r(int i2) {
        if (i2 != -1) {
            o(null);
            return;
        }
        InterfaceC0059e interfaceC0059e = this.f781g;
        Uri uri = this.f784j;
        if (uri == null) {
            uri = Uri.parse(this.f779e.c());
        }
        interfaceC0059e.b(uri, new c());
    }

    private void s(int i2) {
        if (i2 != -1) {
            o(null);
            return;
        }
        InterfaceC0059e interfaceC0059e = this.f781g;
        Uri uri = this.f784j;
        if (uri == null) {
            uri = Uri.parse(this.f779e.c());
        }
        interfaceC0059e.b(uri, new d());
    }

    private void t(int i2, Intent intent) {
        if (i2 != -1 || intent == null) {
            o(null);
        } else {
            w(this.f782h.c(this.b, intent.getData()), false);
        }
    }

    private void u(int i2, Intent intent) {
        if (i2 != -1 || intent == null) {
            o(null);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<>();
        if (intent.getClipData() != null) {
            for (int i3 = 0; i3 < intent.getClipData().getItemCount(); i3++) {
                arrayList.add(this.f782h.c(this.b, intent.getClipData().getItemAt(i3).getUri()));
            }
        } else {
            arrayList.add(this.f782h.c(this.b, intent.getData()));
        }
        x(arrayList, false);
    }

    private void v(int i2, Intent intent) {
        if (i2 != -1 || intent == null) {
            o(null);
        } else {
            y(this.f782h.c(this.b, intent.getData()));
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void w(String str, boolean z) {
        if (this.l == null) {
            o(str);
            return;
        }
        String p = p(str);
        if (p != null && !p.equals(str) && z) {
            new File(str).delete();
        }
        o(p);
    }

    private void x(ArrayList<String> arrayList, boolean z) {
        if (this.l == null) {
            n(arrayList);
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<>();
        for (int i2 = 0; i2 < arrayList.size(); i2++) {
            String p = p(arrayList.get(i2));
            if (p != null && !p.equals(arrayList.get(i2)) && z) {
                new File(arrayList.get(i2)).delete();
            }
            arrayList2.add(i2, p);
        }
        n(arrayList2);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void y(String str) {
        o(str);
    }

    private void z() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        if (Build.VERSION.SDK_INT >= 18) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        intent.setType("image/*");
        this.b.startActivityForResult(intent, 2346);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void F(i.d dVar) {
        Map<String, Object> b2 = this.f779e.b();
        ArrayList arrayList = (ArrayList) b2.get("pathList");
        ArrayList arrayList2 = new ArrayList();
        if (arrayList != null) {
            Iterator it = arrayList.iterator();
            while (it.hasNext()) {
                arrayList2.add(this.f778d.h((String) it.next(), (Double) b2.get("maxWidth"), (Double) b2.get("maxHeight"), Integer.valueOf(b2.get("imageQuality") == null ? 100 : ((Integer) b2.get("imageQuality")).intValue())));
            }
            b2.put("pathList", arrayList2);
            b2.put("path", arrayList2.get(arrayList2.size() - 1));
        }
        if (b2.isEmpty()) {
            b2 = null;
        }
        dVar.a(b2);
        this.f779e.a();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void G() {
        h hVar = this.l;
        if (hVar == null) {
            return;
        }
        this.f779e.g(hVar.a);
        this.f779e.d(this.l);
        Uri uri = this.f784j;
        if (uri != null) {
            this.f779e.e(uri);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void H(io.flutter.plugins.imagepicker.a aVar) {
        this.f783i = aVar;
    }

    public void J(h hVar, i.d dVar) {
        if (!I(hVar, dVar)) {
            l(dVar);
        } else if (!E() || this.f780f.b("android.permission.CAMERA")) {
            C();
        } else {
            this.f780f.c("android.permission.CAMERA", 2345);
        }
    }

    public void K(h hVar, i.d dVar) {
        if (!I(hVar, dVar)) {
            l(dVar);
        } else if (!E() || this.f780f.b("android.permission.CAMERA")) {
            D();
        } else {
            this.f780f.c("android.permission.CAMERA", 2355);
        }
    }

    @Override // h.a.c.a.n
    public boolean a(int i2, String[] strArr, int[] iArr) {
        boolean z = iArr.length > 0 && iArr[0] == 0;
        if (i2 != 2345) {
            if (i2 != 2355) {
                return false;
            }
            if (z) {
                D();
            }
        } else if (z) {
            C();
        }
        if (!z && (i2 == 2345 || i2 == 2355)) {
            m("camera_access_denied", "The user did not allow camera access.");
        }
        return true;
    }

    @Override // h.a.c.a.k
    public boolean b(int i2, int i3, Intent intent) {
        if (i2 == 2342) {
            t(i3, intent);
            return true;
        } else if (i2 == 2343) {
            r(i3);
            return true;
        } else if (i2 == 2346) {
            u(i3, intent);
            return true;
        } else if (i2 == 2352) {
            v(i3, intent);
            return true;
        } else if (i2 != 2353) {
            return false;
        } else {
            s(i3);
            return true;
        }
    }

    public void e(h hVar, i.d dVar) {
        if (I(hVar, dVar)) {
            A();
        } else {
            l(dVar);
        }
    }

    public void f(h hVar, i.d dVar) {
        if (I(hVar, dVar)) {
            z();
        } else {
            l(dVar);
        }
    }

    public void g(h hVar, i.d dVar) {
        if (I(hVar, dVar)) {
            B();
        } else {
            l(dVar);
        }
    }
}
