package io.flutter.plugins.imagepicker;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.lifecycle.DefaultLifecycleObserver;
import h.a.c.a.h;
import h.a.c.a.i;
import h.a.c.a.m;
import io.flutter.embedding.engine.i.a;
import java.io.File;
/* loaded from: classes.dex */
public class ImagePickerPlugin implements i.c, io.flutter.embedding.engine.i.a, io.flutter.embedding.engine.i.c.a {
    private i a;
    private e b;
    private a.b c;

    /* renamed from: d  reason: collision with root package name */
    private io.flutter.embedding.engine.i.c.c f763d;

    /* renamed from: e  reason: collision with root package name */
    private Application f764e;

    /* renamed from: f  reason: collision with root package name */
    private Activity f765f;

    /* renamed from: g  reason: collision with root package name */
    private androidx.lifecycle.d f766g;

    /* renamed from: h  reason: collision with root package name */
    private LifeCycleObserver f767h;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class LifeCycleObserver implements Application.ActivityLifecycleCallbacks, DefaultLifecycleObserver {
        private final Activity a;

        LifeCycleObserver(Activity activity) {
            this.a = activity;
        }

        @Override // androidx.lifecycle.b
        public void a(androidx.lifecycle.g gVar) {
        }

        @Override // androidx.lifecycle.b
        public void b(androidx.lifecycle.g gVar) {
            onActivityDestroyed(this.a);
        }

        @Override // androidx.lifecycle.b
        public void d(androidx.lifecycle.g gVar) {
        }

        @Override // androidx.lifecycle.b
        public void f(androidx.lifecycle.g gVar) {
        }

        @Override // androidx.lifecycle.b
        public void g(androidx.lifecycle.g gVar) {
            onActivityStopped(this.a);
        }

        @Override // androidx.lifecycle.b
        public void h(androidx.lifecycle.g gVar) {
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityDestroyed(Activity activity) {
            if (this.a != activity || activity.getApplicationContext() == null) {
                return;
            }
            ((Application) activity.getApplicationContext()).unregisterActivityLifecycleCallbacks(this);
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityPaused(Activity activity) {
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityResumed(Activity activity) {
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityStarted(Activity activity) {
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityStopped(Activity activity) {
            if (this.a == activity) {
                ImagePickerPlugin.this.b.G();
            }
        }
    }

    /* loaded from: classes.dex */
    private static class a implements i.d {
        private i.d a;
        private Handler b = new Handler(Looper.getMainLooper());

        /* renamed from: io.flutter.plugins.imagepicker.ImagePickerPlugin$a$a  reason: collision with other inner class name */
        /* loaded from: classes.dex */
        class RunnableC0058a implements Runnable {

            /* renamed from: d  reason: collision with root package name */
            final /* synthetic */ Object f768d;

            RunnableC0058a(Object obj) {
                this.f768d = obj;
            }

            @Override // java.lang.Runnable
            public void run() {
                a.this.a.a(this.f768d);
            }
        }

        /* loaded from: classes.dex */
        class b implements Runnable {

            /* renamed from: d  reason: collision with root package name */
            final /* synthetic */ String f770d;

            /* renamed from: e  reason: collision with root package name */
            final /* synthetic */ String f771e;

            /* renamed from: f  reason: collision with root package name */
            final /* synthetic */ Object f772f;

            b(String str, String str2, Object obj) {
                this.f770d = str;
                this.f771e = str2;
                this.f772f = obj;
            }

            @Override // java.lang.Runnable
            public void run() {
                a.this.a.b(this.f770d, this.f771e, this.f772f);
            }
        }

        /* loaded from: classes.dex */
        class c implements Runnable {
            c() {
            }

            @Override // java.lang.Runnable
            public void run() {
                a.this.a.c();
            }
        }

        a(i.d dVar) {
            this.a = dVar;
        }

        @Override // h.a.c.a.i.d
        public void a(Object obj) {
            this.b.post(new RunnableC0058a(obj));
        }

        @Override // h.a.c.a.i.d
        public void b(String str, String str2, Object obj) {
            this.b.post(new b(str, str2, obj));
        }

        @Override // h.a.c.a.i.d
        public void c() {
            this.b.post(new c());
        }
    }

    private void j(h.a.c.a.b bVar, Application application, Activity activity, m mVar, io.flutter.embedding.engine.i.c.c cVar) {
        this.f765f = activity;
        this.f764e = application;
        this.b = b(activity);
        i iVar = new i(bVar, "plugins.flutter.io/image_picker");
        this.a = iVar;
        iVar.e(this);
        LifeCycleObserver lifeCycleObserver = new LifeCycleObserver(activity);
        this.f767h = lifeCycleObserver;
        if (mVar != null) {
            application.registerActivityLifecycleCallbacks(lifeCycleObserver);
            mVar.b(this.b);
            mVar.c(this.b);
            return;
        }
        cVar.b(this.b);
        cVar.c(this.b);
        androidx.lifecycle.d a2 = io.flutter.embedding.engine.plugins.lifecycle.a.a(cVar);
        this.f766g = a2;
        a2.a(this.f767h);
    }

    private void k() {
        this.f763d.e(this.b);
        this.f763d.f(this.b);
        this.f763d = null;
        this.f766g.c(this.f767h);
        this.f766g = null;
        this.b = null;
        this.a.e(null);
        this.a = null;
        this.f764e.unregisterActivityLifecycleCallbacks(this.f767h);
        this.f764e = null;
    }

    final e b(Activity activity) {
        d dVar = new d(activity);
        File cacheDir = activity.getCacheDir();
        return new e(activity, cacheDir, new g(cacheDir, new b()), dVar);
    }

    @Override // io.flutter.embedding.engine.i.c.a
    public void c(io.flutter.embedding.engine.i.c.c cVar) {
        this.f763d = cVar;
        j(this.c.b(), (Application) this.c.a(), this.f763d.d(), null, this.f763d);
    }

    @Override // io.flutter.embedding.engine.i.a
    public void d(a.b bVar) {
        this.c = bVar;
    }

    @Override // io.flutter.embedding.engine.i.c.a
    public void e() {
        k();
    }

    @Override // io.flutter.embedding.engine.i.c.a
    public void f(io.flutter.embedding.engine.i.c.c cVar) {
        c(cVar);
    }

    @Override // io.flutter.embedding.engine.i.a
    public void g(a.b bVar) {
        this.c = null;
    }

    @Override // io.flutter.embedding.engine.i.c.a
    public void h() {
        e();
    }

    @Override // h.a.c.a.i.c
    public void i(h hVar, i.d dVar) {
        if (this.f765f == null) {
            dVar.b("no_activity", "image_picker plugin requires a foreground activity.", null);
            return;
        }
        a aVar = new a(dVar);
        if (hVar.a("cameraDevice") != null) {
            this.b.H(((Integer) hVar.a("cameraDevice")).intValue() == 1 ? io.flutter.plugins.imagepicker.a.FRONT : io.flutter.plugins.imagepicker.a.REAR);
        }
        String str = hVar.a;
        str.hashCode();
        char c = 65535;
        switch (str.hashCode()) {
            case -1708939613:
                if (str.equals("pickMultiImage")) {
                    c = 0;
                    break;
                }
                break;
            case -1457314374:
                if (str.equals("pickImage")) {
                    c = 1;
                    break;
                }
                break;
            case -1445424934:
                if (str.equals("pickVideo")) {
                    c = 2;
                    break;
                }
                break;
            case -310034372:
                if (str.equals("retrieve")) {
                    c = 3;
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
                this.b.f(hVar, aVar);
                return;
            case 1:
                int intValue = ((Integer) hVar.a("source")).intValue();
                if (intValue == 0) {
                    this.b.J(hVar, aVar);
                    return;
                } else if (intValue == 1) {
                    this.b.e(hVar, aVar);
                    return;
                } else {
                    throw new IllegalArgumentException("Invalid image source: " + intValue);
                }
            case 2:
                int intValue2 = ((Integer) hVar.a("source")).intValue();
                if (intValue2 == 0) {
                    this.b.K(hVar, aVar);
                    return;
                } else if (intValue2 == 1) {
                    this.b.g(hVar, aVar);
                    return;
                } else {
                    throw new IllegalArgumentException("Invalid video source: " + intValue2);
                }
            case 3:
                this.b.F(aVar);
                return;
            default:
                throw new IllegalArgumentException("Unknown method " + hVar.a);
        }
    }
}
