package io.flutter.plugins.e;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.ListPopupWindow;
/* loaded from: classes.dex */
class b3 extends WebView {
    private View a;
    private h3 b;
    private View c;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements Runnable {

        /* renamed from: d  reason: collision with root package name */
        final /* synthetic */ View f730d;

        a(View view) {
            this.f730d = view;
        }

        @Override // java.lang.Runnable
        public void run() {
            if (b3.this.c == null) {
                Log.e("InputAwareWebView", "Can't set the input connection target because there is no containerView to use as a handler.");
                return;
            }
            this.f730d.onWindowFocusChanged(true);
            ((InputMethodManager) b3.this.getContext().getSystemService("input_method")).isActive(b3.this.c);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public b3(Context context, View view) {
        super(context);
        this.c = view;
    }

    private boolean f() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (stackTraceElement.getClassName().equals(ListPopupWindow.class.getCanonicalName()) && stackTraceElement.getMethodName().equals("show")) {
                return true;
            }
        }
        return false;
    }

    private void g() {
        if (this.b == null) {
            return;
        }
        View view = this.c;
        if (view == null) {
            Log.e("InputAwareWebView", "Can't reset the input connection to the container view because there is none.");
        } else {
            setInputConnectionTarget(view);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void a() {
        g();
    }

    @Override // android.view.View
    public boolean checkInputConnectionProxy(View view) {
        View view2 = this.a;
        this.a = view;
        if (view2 == view) {
            return super.checkInputConnectionProxy(view);
        }
        View view3 = this.c;
        if (view3 == null) {
            Log.e("InputAwareWebView", "Can't create a proxy view because there's no container view. Text input may not work.");
        } else {
            h3 h3Var = new h3(view3, view, view.getHandler());
            this.b = h3Var;
            setInputConnectionTarget(h3Var);
        }
        return super.checkInputConnectionProxy(view);
    }

    @Override // android.view.ViewGroup, android.view.View
    public void clearFocus() {
        super.clearFocus();
        g();
    }

    @Override // android.webkit.WebView, android.view.View
    protected void onFocusChanged(boolean z, int i2, Rect rect) {
        if (Build.VERSION.SDK_INT >= 28 || !f() || z) {
            super.onFocusChanged(z, i2, rect);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void setContainerView(View view) {
        this.c = view;
        if (this.b == null) {
            return;
        }
        Log.w("InputAwareWebView", "The containerView has changed while the proxyAdapterView exists.");
        if (view != null) {
            setInputConnectionTarget(this.b);
        }
    }

    void setInputConnectionTarget(View view) {
        if (this.c == null) {
            Log.e("InputAwareWebView", "Can't set the input connection target because there is no containerView to use as a handler.");
            return;
        }
        view.requestFocus();
        this.c.post(new a(view));
    }
}
