package io.flutter.plugin.editing;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.os.Build;
import android.os.Bundle;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.Layout;
import android.text.Selection;
import android.text.TextPaint;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import io.flutter.embedding.android.m;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.j.n;
import io.flutter.plugin.editing.c;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class b extends BaseInputConnection implements c.b {
    private final View a;
    private final int b;
    private final n c;

    /* renamed from: d  reason: collision with root package name */
    private final c f692d;

    /* renamed from: e  reason: collision with root package name */
    private final EditorInfo f693e;

    /* renamed from: f  reason: collision with root package name */
    private ExtractedTextRequest f694f;

    /* renamed from: g  reason: collision with root package name */
    private boolean f695g;

    /* renamed from: h  reason: collision with root package name */
    private CursorAnchorInfo.Builder f696h;

    /* renamed from: i  reason: collision with root package name */
    private ExtractedText f697i;

    /* renamed from: j  reason: collision with root package name */
    private InputMethodManager f698j;
    private final Layout k;
    private a l;
    private final m m;
    private int n;

    public b(View view, int i2, n nVar, m mVar, c cVar, EditorInfo editorInfo) {
        this(view, i2, nVar, mVar, cVar, editorInfo, new FlutterJNI());
    }

    public b(View view, int i2, n nVar, m mVar, c cVar, EditorInfo editorInfo, FlutterJNI flutterJNI) {
        super(view, true);
        this.f695g = false;
        this.f697i = new ExtractedText();
        this.n = 0;
        this.a = view;
        this.b = i2;
        this.c = nVar;
        this.f692d = cVar;
        cVar.a(this);
        this.f693e = editorInfo;
        this.m = mVar;
        this.l = new a(flutterJNI);
        this.k = new DynamicLayout(cVar, new TextPaint(), Integer.MAX_VALUE, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        this.f698j = (InputMethodManager) view.getContext().getSystemService("input_method");
    }

    private boolean b(int i2) {
        if (i2 == 16908319) {
            setSelection(0, this.f692d.length());
            return true;
        } else if (i2 == 16908320) {
            int selectionStart = Selection.getSelectionStart(this.f692d);
            int selectionEnd = Selection.getSelectionEnd(this.f692d);
            if (selectionStart != selectionEnd) {
                int min = Math.min(selectionStart, selectionEnd);
                int max = Math.max(selectionStart, selectionEnd);
                ((ClipboardManager) this.a.getContext().getSystemService("clipboard")).setPrimaryClip(ClipData.newPlainText("text label?", this.f692d.subSequence(min, max)));
                this.f692d.delete(min, max);
                setSelection(min, min);
            }
            return true;
        } else if (i2 == 16908321) {
            int selectionStart2 = Selection.getSelectionStart(this.f692d);
            int selectionEnd2 = Selection.getSelectionEnd(this.f692d);
            if (selectionStart2 != selectionEnd2) {
                ((ClipboardManager) this.a.getContext().getSystemService("clipboard")).setPrimaryClip(ClipData.newPlainText("text label?", this.f692d.subSequence(Math.min(selectionStart2, selectionEnd2), Math.max(selectionStart2, selectionEnd2))));
            }
            return true;
        } else if (i2 == 16908322) {
            ClipData primaryClip = ((ClipboardManager) this.a.getContext().getSystemService("clipboard")).getPrimaryClip();
            if (primaryClip != null) {
                CharSequence coerceToText = primaryClip.getItemAt(0).coerceToText(this.a.getContext());
                int max2 = Math.max(0, Selection.getSelectionStart(this.f692d));
                int max3 = Math.max(0, Selection.getSelectionEnd(this.f692d));
                int min2 = Math.min(max2, max3);
                int max4 = Math.max(max2, max3);
                if (min2 != max4) {
                    this.f692d.delete(min2, max4);
                }
                this.f692d.insert(min2, coerceToText);
                int length = min2 + coerceToText.length();
                setSelection(length, length);
            }
            return true;
        } else {
            return false;
        }
    }

    private CursorAnchorInfo c() {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        CursorAnchorInfo.Builder builder = this.f696h;
        if (builder == null) {
            this.f696h = new CursorAnchorInfo.Builder();
        } else {
            builder.reset();
        }
        this.f696h.setSelectionRange(this.f692d.i(), this.f692d.h());
        int g2 = this.f692d.g();
        int f2 = this.f692d.f();
        if (g2 < 0 || f2 <= g2) {
            this.f696h.setComposingText(-1, "");
        } else {
            this.f696h.setComposingText(g2, this.f692d.toString().subSequence(g2, f2));
        }
        return this.f696h.build();
    }

    private ExtractedText d(ExtractedTextRequest extractedTextRequest) {
        ExtractedText extractedText = this.f697i;
        extractedText.startOffset = 0;
        extractedText.partialStartOffset = -1;
        extractedText.partialEndOffset = -1;
        extractedText.selectionStart = this.f692d.i();
        this.f697i.selectionEnd = this.f692d.h();
        this.f697i.text = (extractedTextRequest == null || (extractedTextRequest.flags & 1) == 0) ? this.f692d.toString() : this.f692d;
        return this.f697i;
    }

    private boolean e(boolean z, boolean z2) {
        int selectionStart = Selection.getSelectionStart(this.f692d);
        int selectionEnd = Selection.getSelectionEnd(this.f692d);
        boolean z3 = false;
        if (selectionStart < 0 || selectionEnd < 0) {
            return false;
        }
        int max = z ? Math.max(this.l.b(this.f692d, selectionEnd), 0) : Math.min(this.l.a(this.f692d, selectionEnd), this.f692d.length());
        if (selectionStart == selectionEnd && !z2) {
            z3 = true;
        }
        if (z3) {
            setSelection(max, max);
        } else {
            setSelection(selectionStart, max);
        }
        return true;
    }

    private boolean g(boolean z, boolean z2) {
        int selectionStart = Selection.getSelectionStart(this.f692d);
        int selectionEnd = Selection.getSelectionEnd(this.f692d);
        boolean z3 = false;
        if (selectionStart < 0 || selectionEnd < 0) {
            return false;
        }
        if (selectionStart == selectionEnd && !z2) {
            z3 = true;
        }
        beginBatchEdit();
        if (z3) {
            if (z) {
                Selection.moveUp(this.f692d, this.k);
            } else {
                Selection.moveDown(this.f692d, this.k);
            }
            int selectionStart2 = Selection.getSelectionStart(this.f692d);
            setSelection(selectionStart2, selectionStart2);
        } else {
            if (z) {
                Selection.extendUp(this.f692d, this.k);
            } else {
                Selection.extendDown(this.f692d, this.k);
            }
            setSelection(Selection.getSelectionStart(this.f692d), Selection.getSelectionEnd(this.f692d));
        }
        endBatchEdit();
        return true;
    }

    @Override // io.flutter.plugin.editing.c.b
    public void a(boolean z, boolean z2, boolean z3) {
        this.f698j.updateSelection(this.a, this.f692d.i(), this.f692d.h(), this.f692d.g(), this.f692d.f());
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        ExtractedTextRequest extractedTextRequest = this.f694f;
        if (extractedTextRequest != null) {
            this.f698j.updateExtractedText(this.a, extractedTextRequest.token, d(extractedTextRequest));
        }
        if (this.f695g) {
            this.f698j.updateCursorAnchorInfo(this.a, c());
        }
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean beginBatchEdit() {
        this.f692d.b();
        this.n++;
        return super.beginBatchEdit();
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean clearMetaKeyStates(int i2) {
        return super.clearMetaKeyStates(i2);
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public void closeConnection() {
        super.closeConnection();
        this.f692d.l(this);
        while (this.n > 0) {
            endBatchEdit();
            this.n--;
        }
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean commitText(CharSequence charSequence, int i2) {
        return super.commitText(charSequence, i2);
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean deleteSurroundingText(int i2, int i3) {
        if (this.f692d.i() == -1) {
            return true;
        }
        return super.deleteSurroundingText(i2, i3);
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean deleteSurroundingTextInCodePoints(int i2, int i3) {
        return super.deleteSurroundingTextInCodePoints(i2, i3);
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean endBatchEdit() {
        boolean endBatchEdit = super.endBatchEdit();
        this.n--;
        this.f692d.d();
        return endBatchEdit;
    }

    public boolean f(KeyEvent keyEvent) {
        if (keyEvent.getAction() != 0) {
            if (keyEvent.getAction() == 1 && (keyEvent.getKeyCode() == 59 || keyEvent.getKeyCode() == 60)) {
                int selectionEnd = Selection.getSelectionEnd(this.f692d);
                setSelection(selectionEnd, selectionEnd);
                return true;
            }
            return false;
        } else if (keyEvent.getKeyCode() == 21) {
            return e(true, keyEvent.isShiftPressed());
        } else {
            if (keyEvent.getKeyCode() == 22) {
                return e(false, keyEvent.isShiftPressed());
            }
            if (keyEvent.getKeyCode() == 19) {
                return g(true, keyEvent.isShiftPressed());
            }
            if (keyEvent.getKeyCode() == 20) {
                return g(false, keyEvent.isShiftPressed());
            }
            if (keyEvent.getKeyCode() == 66 || keyEvent.getKeyCode() == 160) {
                EditorInfo editorInfo = this.f693e;
                if ((131072 & editorInfo.inputType) == 0) {
                    performEditorAction(editorInfo.imeOptions & 255);
                    return true;
                }
            }
            int selectionStart = Selection.getSelectionStart(this.f692d);
            int selectionEnd2 = Selection.getSelectionEnd(this.f692d);
            int unicodeChar = keyEvent.getUnicodeChar();
            if (selectionStart < 0 || selectionEnd2 < 0 || unicodeChar == 0) {
                return false;
            }
            int min = Math.min(selectionStart, selectionEnd2);
            int max = Math.max(selectionStart, selectionEnd2);
            beginBatchEdit();
            if (min != max) {
                this.f692d.delete(min, max);
            }
            this.f692d.insert(min, (CharSequence) String.valueOf((char) unicodeChar));
            int i2 = min + 1;
            setSelection(i2, i2);
            endBatchEdit();
            return true;
        }
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean finishComposingText() {
        return super.finishComposingText();
    }

    @Override // android.view.inputmethod.BaseInputConnection
    public Editable getEditable() {
        return this.f692d;
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int i2) {
        boolean z = (i2 & 1) != 0;
        if (z == (this.f694f == null)) {
            StringBuilder sb = new StringBuilder();
            sb.append("The input method toggled text monitoring ");
            sb.append(z ? "on" : "off");
            h.a.b.a("InputConnectionAdaptor", sb.toString());
        }
        this.f694f = z ? extractedTextRequest : null;
        return d(extractedTextRequest);
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean performContextMenuAction(int i2) {
        beginBatchEdit();
        boolean b = b(i2);
        endBatchEdit();
        return b;
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean performEditorAction(int i2) {
        if (i2 == 0) {
            this.c.n(this.b);
        } else if (i2 == 1) {
            this.c.f(this.b);
        } else if (i2 == 2) {
            this.c.e(this.b);
        } else if (i2 == 3) {
            this.c.k(this.b);
        } else if (i2 == 4) {
            this.c.l(this.b);
        } else if (i2 == 5) {
            this.c.g(this.b);
        } else if (i2 != 7) {
            this.c.d(this.b);
        } else {
            this.c.i(this.b);
        }
        return true;
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean performPrivateCommand(String str, Bundle bundle) {
        this.c.h(this.b, str, bundle);
        return true;
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean requestCursorUpdates(int i2) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        if ((i2 & 1) != 0) {
            this.f698j.updateCursorAnchorInfo(this.a, c());
        }
        boolean z = (i2 & 2) != 0;
        if (z != this.f695g) {
            StringBuilder sb = new StringBuilder();
            sb.append("The input method toggled cursor monitoring ");
            sb.append(z ? "on" : "off");
            h.a.b.a("InputConnectionAdaptor", sb.toString());
        }
        this.f695g = z;
        return true;
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean sendKeyEvent(KeyEvent keyEvent) {
        return this.m.c(keyEvent);
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean setComposingRegion(int i2, int i3) {
        return super.setComposingRegion(i2, i3);
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean setComposingText(CharSequence charSequence, int i2) {
        beginBatchEdit();
        boolean commitText = charSequence.length() == 0 ? super.commitText(charSequence, i2) : super.setComposingText(charSequence, i2);
        endBatchEdit();
        return commitText;
    }

    @Override // android.view.inputmethod.BaseInputConnection, android.view.inputmethod.InputConnection
    public boolean setSelection(int i2, int i3) {
        beginBatchEdit();
        boolean selection = super.setSelection(i2, i3);
        endBatchEdit();
        return selection;
    }
}
