package io.flutter.embedding.engine.renderer;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.view.Surface;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.view.d;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
@TargetApi(16)
/* loaded from: classes.dex */
public class a implements io.flutter.view.d {
    private final FlutterJNI a;
    private Surface c;

    /* renamed from: g  reason: collision with root package name */
    private final io.flutter.embedding.engine.renderer.b f664g;
    private final AtomicLong b = new AtomicLong(0);

    /* renamed from: d  reason: collision with root package name */
    private boolean f661d = false;

    /* renamed from: e  reason: collision with root package name */
    private Handler f662e = new Handler();

    /* renamed from: f  reason: collision with root package name */
    private final Set<WeakReference<d.b>> f663f = new HashSet();

    /* renamed from: io.flutter.embedding.engine.renderer.a$a  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    class C0054a implements io.flutter.embedding.engine.renderer.b {
        C0054a() {
        }

        @Override // io.flutter.embedding.engine.renderer.b
        public void c() {
            a.this.f661d = false;
        }

        @Override // io.flutter.embedding.engine.renderer.b
        public void f() {
            a.this.f661d = true;
        }
    }

    /* loaded from: classes.dex */
    public static final class b {
        public final Rect a;
        public final d b;
        public final c c;

        public b(Rect rect, d dVar) {
            this.a = rect;
            this.b = dVar;
            this.c = c.UNKNOWN;
        }

        public b(Rect rect, d dVar, c cVar) {
            this.a = rect;
            this.b = dVar;
            this.c = cVar;
        }
    }

    /* loaded from: classes.dex */
    public enum c {
        UNKNOWN(0),
        POSTURE_FLAT(1),
        POSTURE_HALF_OPENED(2);
        

        /* renamed from: d  reason: collision with root package name */
        public final int f669d;

        c(int i2) {
            this.f669d = i2;
        }
    }

    /* loaded from: classes.dex */
    public enum d {
        UNKNOWN(0),
        FOLD(1),
        HINGE(2),
        CUTOUT(3);
        

        /* renamed from: d  reason: collision with root package name */
        public final int f675d;

        d(int i2) {
            this.f675d = i2;
        }
    }

    /* loaded from: classes.dex */
    static final class e implements Runnable {

        /* renamed from: d  reason: collision with root package name */
        private final long f676d;

        /* renamed from: e  reason: collision with root package name */
        private final FlutterJNI f677e;

        e(long j2, FlutterJNI flutterJNI) {
            this.f676d = j2;
            this.f677e = flutterJNI;
        }

        @Override // java.lang.Runnable
        public void run() {
            if (this.f677e.isAttached()) {
                h.a.b.e("FlutterRenderer", "Releasing a SurfaceTexture (" + this.f676d + ").");
                this.f677e.unregisterTexture(this.f676d);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public final class f implements d.c, d.b {
        private final long a;
        private final SurfaceTextureWrapper b;
        private boolean c;

        /* renamed from: d  reason: collision with root package name */
        private d.b f678d;

        /* renamed from: e  reason: collision with root package name */
        private d.a f679e;

        /* renamed from: f  reason: collision with root package name */
        private final Runnable f680f;

        /* renamed from: g  reason: collision with root package name */
        private SurfaceTexture.OnFrameAvailableListener f681g;

        /* renamed from: io.flutter.embedding.engine.renderer.a$f$a  reason: collision with other inner class name */
        /* loaded from: classes.dex */
        class RunnableC0055a implements Runnable {
            RunnableC0055a() {
            }

            @Override // java.lang.Runnable
            public void run() {
                if (f.this.f679e != null) {
                    f.this.f679e.a();
                }
            }
        }

        /* loaded from: classes.dex */
        class b implements SurfaceTexture.OnFrameAvailableListener {
            b() {
            }

            @Override // android.graphics.SurfaceTexture.OnFrameAvailableListener
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                if (f.this.c || !a.this.a.isAttached()) {
                    return;
                }
                f fVar = f.this;
                a.this.l(fVar.a);
            }
        }

        f(long j2, SurfaceTexture surfaceTexture) {
            RunnableC0055a runnableC0055a = new RunnableC0055a();
            this.f680f = runnableC0055a;
            this.f681g = new b();
            this.a = j2;
            this.b = new SurfaceTextureWrapper(surfaceTexture, runnableC0055a);
            if (Build.VERSION.SDK_INT >= 21) {
                d().setOnFrameAvailableListener(this.f681g, new Handler());
            } else {
                d().setOnFrameAvailableListener(this.f681g);
            }
        }

        @Override // io.flutter.view.d.c
        public long a() {
            return this.a;
        }

        @Override // io.flutter.view.d.c
        public void b(d.b bVar) {
            this.f678d = bVar;
        }

        @Override // io.flutter.view.d.c
        public void c(d.a aVar) {
            this.f679e = aVar;
        }

        @Override // io.flutter.view.d.c
        public SurfaceTexture d() {
            return this.b.surfaceTexture();
        }

        protected void finalize() {
            try {
                if (this.c) {
                    return;
                }
                a.this.f662e.post(new e(this.a, a.this.a));
            } finally {
                super.finalize();
            }
        }

        public SurfaceTextureWrapper h() {
            return this.b;
        }

        @Override // io.flutter.view.d.b
        public void onTrimMemory(int i2) {
            d.b bVar = this.f678d;
            if (bVar != null) {
                bVar.onTrimMemory(i2);
            }
        }
    }

    /* loaded from: classes.dex */
    public static final class g {
        public float a = 1.0f;
        public int b = 0;
        public int c = 0;

        /* renamed from: d  reason: collision with root package name */
        public int f685d = 0;

        /* renamed from: e  reason: collision with root package name */
        public int f686e = 0;

        /* renamed from: f  reason: collision with root package name */
        public int f687f = 0;

        /* renamed from: g  reason: collision with root package name */
        public int f688g = 0;

        /* renamed from: h  reason: collision with root package name */
        public int f689h = 0;

        /* renamed from: i  reason: collision with root package name */
        public int f690i = 0;

        /* renamed from: j  reason: collision with root package name */
        public int f691j = 0;
        public int k = 0;
        public int l = 0;
        public int m = 0;
        public int n = 0;
        public int o = 0;
        public int p = -1;
        public List<b> q = new ArrayList();

        boolean a() {
            return this.b > 0 && this.c > 0 && this.a > 0.0f;
        }
    }

    public a(FlutterJNI flutterJNI) {
        C0054a c0054a = new C0054a();
        this.f664g = c0054a;
        this.a = flutterJNI;
        flutterJNI.addIsDisplayingFlutterUiListener(c0054a);
    }

    private void h() {
        Iterator<WeakReference<d.b>> it = this.f663f.iterator();
        while (it.hasNext()) {
            if (it.next().get() == null) {
                it.remove();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void l(long j2) {
        this.a.markTextureFrameAvailable(j2);
    }

    private void o(long j2, SurfaceTextureWrapper surfaceTextureWrapper) {
        this.a.registerTexture(j2, surfaceTextureWrapper);
    }

    @Override // io.flutter.view.d
    public d.c a() {
        h.a.b.e("FlutterRenderer", "Creating a SurfaceTexture.");
        return n(new SurfaceTexture(0));
    }

    public void f(io.flutter.embedding.engine.renderer.b bVar) {
        this.a.addIsDisplayingFlutterUiListener(bVar);
        if (this.f661d) {
            bVar.f();
        }
    }

    void g(d.b bVar) {
        h();
        this.f663f.add(new WeakReference<>(bVar));
    }

    public void i(ByteBuffer byteBuffer, int i2) {
        this.a.dispatchPointerDataPacket(byteBuffer, i2);
    }

    public boolean j() {
        return this.f661d;
    }

    public boolean k() {
        return this.a.getIsSoftwareRenderingEnabled();
    }

    public void m(int i2) {
        Iterator<WeakReference<d.b>> it = this.f663f.iterator();
        while (it.hasNext()) {
            d.b bVar = it.next().get();
            if (bVar != null) {
                bVar.onTrimMemory(i2);
            } else {
                it.remove();
            }
        }
    }

    public d.c n(SurfaceTexture surfaceTexture) {
        surfaceTexture.detachFromGLContext();
        f fVar = new f(this.b.getAndIncrement(), surfaceTexture);
        h.a.b.e("FlutterRenderer", "New SurfaceTexture ID: " + fVar.a());
        o(fVar.a(), fVar.h());
        g(fVar);
        return fVar;
    }

    public void p(io.flutter.embedding.engine.renderer.b bVar) {
        this.a.removeIsDisplayingFlutterUiListener(bVar);
    }

    public void q(boolean z) {
        this.a.setSemanticsEnabled(z);
    }

    public void r(g gVar) {
        if (gVar.a()) {
            h.a.b.e("FlutterRenderer", "Setting viewport metrics\nSize: " + gVar.b + " x " + gVar.c + "\nPadding - L: " + gVar.f688g + ", T: " + gVar.f685d + ", R: " + gVar.f686e + ", B: " + gVar.f687f + "\nInsets - L: " + gVar.k + ", T: " + gVar.f689h + ", R: " + gVar.f690i + ", B: " + gVar.f691j + "\nSystem Gesture Insets - L: " + gVar.o + ", T: " + gVar.l + ", R: " + gVar.m + ", B: " + gVar.m + "\nDisplay Features: " + gVar.q.size());
            int[] iArr = new int[gVar.q.size() * 4];
            int[] iArr2 = new int[gVar.q.size()];
            int[] iArr3 = new int[gVar.q.size()];
            for (int i2 = 0; i2 < gVar.q.size(); i2++) {
                b bVar = gVar.q.get(i2);
                int i3 = i2 * 4;
                Rect rect = bVar.a;
                iArr[i3] = rect.left;
                iArr[i3 + 1] = rect.top;
                iArr[i3 + 2] = rect.right;
                iArr[i3 + 3] = rect.bottom;
                iArr2[i2] = bVar.b.f675d;
                iArr3[i2] = bVar.c.f669d;
            }
            this.a.setViewportMetrics(gVar.a, gVar.b, gVar.c, gVar.f685d, gVar.f686e, gVar.f687f, gVar.f688g, gVar.f689h, gVar.f690i, gVar.f691j, gVar.k, gVar.l, gVar.m, gVar.n, gVar.o, gVar.p, iArr, iArr2, iArr3);
        }
    }

    public void s(Surface surface, boolean z) {
        if (this.c != null && !z) {
            t();
        }
        this.c = surface;
        this.a.onSurfaceCreated(surface);
    }

    public void t() {
        this.a.onSurfaceDestroyed();
        this.c = null;
        if (this.f661d) {
            this.f664g.c();
        }
        this.f661d = false;
    }

    public void u(int i2, int i3) {
        this.a.onSurfaceChanged(i2, i3);
    }

    public void v(Surface surface) {
        this.c = surface;
        this.a.onSurfaceWindowChanged(surface);
    }
}
