package io.flutter.embedding.engine.f;

import h.a.c.a.b;
import io.flutter.embedding.engine.FlutterJNI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class c implements h.a.c.a.b, io.flutter.embedding.engine.f.d {
    private final FlutterJNI a;
    private final Map<String, d> b;
    private Map<String, List<a>> c;

    /* renamed from: d  reason: collision with root package name */
    private final Object f552d;

    /* renamed from: e  reason: collision with root package name */
    private final AtomicBoolean f553e;

    /* renamed from: f  reason: collision with root package name */
    private final Map<Integer, b.InterfaceC0037b> f554f;

    /* renamed from: g  reason: collision with root package name */
    private int f555g;

    /* renamed from: h  reason: collision with root package name */
    private final b f556h;

    /* renamed from: i  reason: collision with root package name */
    private WeakHashMap<b.c, b> f557i;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class a {
        public final ByteBuffer a;
        int b;
        long c;

        a(ByteBuffer byteBuffer, int i2, long j2) {
            this.a = byteBuffer;
            this.b = i2;
            this.c = j2;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public interface b {
        void a(Runnable runnable);
    }

    /* renamed from: io.flutter.embedding.engine.f.c$c  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    private static class C0049c implements f {
        C0049c() {
            h.a.a.e().b();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class d {
        public final b.a a;
        public final b b;

        d(b.a aVar, b bVar) {
            this.a = aVar;
            this.b = bVar;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class e implements b.InterfaceC0037b {
        private final FlutterJNI a;
        private final int b;
        private final AtomicBoolean c = new AtomicBoolean(false);

        e(FlutterJNI flutterJNI, int i2) {
            this.a = flutterJNI;
            this.b = i2;
        }

        @Override // h.a.c.a.b.InterfaceC0037b
        public void a(ByteBuffer byteBuffer) {
            if (this.c.getAndSet(true)) {
                throw new IllegalStateException("Reply already submitted");
            }
            if (byteBuffer == null) {
                this.a.invokePlatformMessageEmptyResponseCallback(this.b);
            } else {
                this.a.invokePlatformMessageResponseCallback(this.b, byteBuffer, byteBuffer.position());
            }
        }
    }

    /* loaded from: classes.dex */
    interface f {
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public c(FlutterJNI flutterJNI) {
        this(flutterJNI, new C0049c());
    }

    c(FlutterJNI flutterJNI, f fVar) {
        this.b = new HashMap();
        this.c = new HashMap();
        this.f552d = new Object();
        this.f553e = new AtomicBoolean(false);
        this.f554f = new HashMap();
        this.f555g = 1;
        this.f556h = new io.flutter.embedding.engine.f.e();
        this.f557i = new WeakHashMap<>();
        this.a = flutterJNI;
    }

    private void f(final String str, final d dVar, final ByteBuffer byteBuffer, final int i2, final long j2) {
        b bVar = dVar != null ? dVar.b : null;
        Runnable runnable = new Runnable() { // from class: io.flutter.embedding.engine.f.a
            @Override // java.lang.Runnable
            public final void run() {
                c.this.j(str, dVar, byteBuffer, i2, j2);
            }
        };
        if (bVar == null) {
            bVar = this.f556h;
        }
        bVar.a(runnable);
    }

    private static void g(Error error) {
        Thread currentThread = Thread.currentThread();
        if (currentThread.getUncaughtExceptionHandler() == null) {
            throw error;
        }
        currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, error);
    }

    private void h(d dVar, ByteBuffer byteBuffer, int i2) {
        if (dVar != null) {
            try {
                h.a.b.e("DartMessenger", "Deferring to registered handler to process message.");
                dVar.a.a(byteBuffer, new e(this.a, i2));
                return;
            } catch (Error e2) {
                g(e2);
                return;
            } catch (Exception e3) {
                h.a.b.c("DartMessenger", "Uncaught exception in binary message listener", e3);
            }
        } else {
            h.a.b.e("DartMessenger", "No registered handler for message. Responding to Dart with empty reply message.");
        }
        this.a.invokePlatformMessageEmptyResponseCallback(i2);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* renamed from: i */
    public /* synthetic */ void j(String str, d dVar, ByteBuffer byteBuffer, int i2, long j2) {
        h.a.d.d.a("DartMessenger#handleMessageFromDart on " + str);
        try {
            h(dVar, byteBuffer, i2);
            if (byteBuffer != null && byteBuffer.isDirect()) {
                byteBuffer.limit(0);
            }
        } finally {
            this.a.cleanupMessageData(j2);
            h.a.d.d.b();
        }
    }

    @Override // h.a.c.a.b
    public void a(String str, ByteBuffer byteBuffer, b.InterfaceC0037b interfaceC0037b) {
        h.a.d.d.a("DartMessenger#send on " + str);
        try {
            h.a.b.e("DartMessenger", "Sending message with callback over channel '" + str + "'");
            int i2 = this.f555g;
            this.f555g = i2 + 1;
            if (interfaceC0037b != null) {
                this.f554f.put(Integer.valueOf(i2), interfaceC0037b);
            }
            if (byteBuffer == null) {
                this.a.dispatchEmptyPlatformMessage(str, i2);
            } else {
                this.a.dispatchPlatformMessage(str, byteBuffer, byteBuffer.position(), i2);
            }
        } finally {
            h.a.d.d.b();
        }
    }

    @Override // h.a.c.a.b
    public void b(String str, b.a aVar) {
        e(str, aVar, null);
    }

    @Override // io.flutter.embedding.engine.f.d
    public void c(int i2, ByteBuffer byteBuffer) {
        h.a.b.e("DartMessenger", "Received message reply from Dart.");
        b.InterfaceC0037b remove = this.f554f.remove(Integer.valueOf(i2));
        if (remove != null) {
            try {
                h.a.b.e("DartMessenger", "Invoking registered callback for reply from Dart.");
                remove.a(byteBuffer);
                if (byteBuffer == null || !byteBuffer.isDirect()) {
                    return;
                }
                byteBuffer.limit(0);
            } catch (Error e2) {
                g(e2);
            } catch (Exception e3) {
                h.a.b.c("DartMessenger", "Uncaught exception in binary message reply handler", e3);
            }
        }
    }

    @Override // io.flutter.embedding.engine.f.d
    public void d(String str, ByteBuffer byteBuffer, int i2, long j2) {
        d dVar;
        boolean z;
        h.a.b.e("DartMessenger", "Received message from Dart over channel '" + str + "'");
        synchronized (this.f552d) {
            dVar = this.b.get(str);
            z = this.f553e.get() && dVar == null;
            if (z) {
                if (!this.c.containsKey(str)) {
                    this.c.put(str, new LinkedList());
                }
                this.c.get(str).add(new a(byteBuffer, i2, j2));
            }
        }
        if (z) {
            return;
        }
        f(str, dVar, byteBuffer, i2, j2);
    }

    @Override // h.a.c.a.b
    public void e(String str, b.a aVar, b.c cVar) {
        if (aVar == null) {
            h.a.b.e("DartMessenger", "Removing handler for channel '" + str + "'");
            synchronized (this.f552d) {
                this.b.remove(str);
            }
            return;
        }
        b bVar = null;
        if (cVar != null && (bVar = this.f557i.get(cVar)) == null) {
            throw new IllegalArgumentException("Unrecognized TaskQueue, use BinaryMessenger to create your TaskQueue (ex makeBackgroundTaskQueue).");
        }
        h.a.b.e("DartMessenger", "Setting handler for channel '" + str + "'");
        synchronized (this.f552d) {
            this.b.put(str, new d(aVar, bVar));
            List<a> remove = this.c.remove(str);
            if (remove == null) {
                return;
            }
            for (a aVar2 : remove) {
                f(str, this.b.get(str), aVar2.a, aVar2.b, aVar2.c);
            }
        }
    }
}
