package h.a.c.d;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import io.flutter.view.d;
import java.util.concurrent.atomic.AtomicLong;
/* JADX INFO: Access modifiers changed from: package-private */
@TargetApi(23)
/* loaded from: classes.dex */
public class k extends FrameLayout {
    private int a;
    private int b;
    private int c;

    /* renamed from: d  reason: collision with root package name */
    private int f383d;

    /* renamed from: e  reason: collision with root package name */
    private int f384e;

    /* renamed from: f  reason: collision with root package name */
    private int f385f;

    /* renamed from: g  reason: collision with root package name */
    private SurfaceTexture f386g;

    /* renamed from: h  reason: collision with root package name */
    private Surface f387h;

    /* renamed from: i  reason: collision with root package name */
    private io.flutter.embedding.android.b f388i;

    /* renamed from: j  reason: collision with root package name */
    ViewTreeObserver.OnGlobalFocusChangeListener f389j;
    private final AtomicLong k;
    private final d.a l;
    private boolean m;
    private final d.b n;

    /* loaded from: classes.dex */
    class a implements d.a {
        a() {
        }

        @Override // io.flutter.view.d.a
        public void a() {
            if (Build.VERSION.SDK_INT == 29) {
                k.this.k.decrementAndGet();
            }
        }
    }

    /* loaded from: classes.dex */
    class b implements d.b {
        b() {
        }

        @Override // io.flutter.view.d.b
        public void onTrimMemory(int i2) {
            if (i2 != 80 || Build.VERSION.SDK_INT < 29) {
                return;
            }
            k.this.m = true;
        }
    }

    /* loaded from: classes.dex */
    class c implements ViewTreeObserver.OnGlobalFocusChangeListener {
        final /* synthetic */ View.OnFocusChangeListener a;

        c(View.OnFocusChangeListener onFocusChangeListener) {
            this.a = onFocusChangeListener;
        }

        @Override // android.view.ViewTreeObserver.OnGlobalFocusChangeListener
        public void onGlobalFocusChanged(View view, View view2) {
            View.OnFocusChangeListener onFocusChangeListener = this.a;
            k kVar = k.this;
            onFocusChangeListener.onFocusChange(kVar, h.a.d.e.a(kVar));
        }
    }

    public k(Context context) {
        super(context);
        this.k = new AtomicLong(0L);
        this.l = new a();
        this.m = false;
        this.n = new b();
        setWillNotDraw(false);
    }

    public k(Context context, d.c cVar) {
        this(context);
        cVar.c(this.l);
        cVar.b(this.n);
        l(cVar.d());
    }

    private void f() {
        if (Build.VERSION.SDK_INT == 29) {
            this.k.incrementAndGet();
        }
    }

    private void g() {
        if (this.m) {
            Surface surface = this.f387h;
            if (surface != null) {
                surface.release();
            }
            this.f387h = c(this.f386g);
            this.m = false;
        }
    }

    private boolean n() {
        return Build.VERSION.SDK_INT != 29 || this.k.get() <= 0;
    }

    protected Surface c(SurfaceTexture surfaceTexture) {
        return new Surface(surfaceTexture);
    }

    public int d() {
        return this.f385f;
    }

    @Override // android.view.View
    @SuppressLint({"NewApi"})
    public void draw(Canvas canvas) {
        String str;
        Surface surface = this.f387h;
        if (surface == null) {
            super.draw(canvas);
            str = "Platform view cannot be composed without a surface.";
        } else if (surface.isValid()) {
            SurfaceTexture surfaceTexture = this.f386g;
            if (surfaceTexture != null && !surfaceTexture.isReleased()) {
                if (!n()) {
                    invalidate();
                    return;
                }
                g();
                Canvas lockHardwareCanvas = this.f387h.lockHardwareCanvas();
                try {
                    if (Build.VERSION.SDK_INT >= 29) {
                        lockHardwareCanvas.drawColor(0, BlendMode.CLEAR);
                    } else {
                        lockHardwareCanvas.drawColor(0);
                    }
                    super.draw(lockHardwareCanvas);
                    f();
                    return;
                } finally {
                    this.f387h.unlockCanvasAndPost(lockHardwareCanvas);
                }
            }
            str = "Invalid texture. The platform view cannot be displayed.";
        } else {
            str = "Invalid surface. The platform view cannot be displayed.";
        }
        h.a.b.b("PlatformViewWrapper", str);
    }

    public int e() {
        return this.f384e;
    }

    public void h() {
        this.f386g = null;
        Surface surface = this.f387h;
        if (surface != null) {
            surface.release();
            this.f387h = null;
        }
    }

    public void i(int i2, int i3) {
        this.f384e = i2;
        this.f385f = i3;
        SurfaceTexture surfaceTexture = this.f386g;
        if (surfaceTexture != null) {
            surfaceTexture.setDefaultBufferSize(i2, i3);
        }
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public ViewParent invalidateChildInParent(int[] iArr, Rect rect) {
        invalidate();
        return super.invalidateChildInParent(iArr, rect);
    }

    public void j(FrameLayout.LayoutParams layoutParams) {
        super.setLayoutParams(layoutParams);
        this.c = layoutParams.leftMargin;
        this.f383d = layoutParams.topMargin;
    }

    public void k(View.OnFocusChangeListener onFocusChangeListener) {
        o();
        ViewTreeObserver viewTreeObserver = getViewTreeObserver();
        if (viewTreeObserver.isAlive() && this.f389j == null) {
            c cVar = new c(onFocusChangeListener);
            this.f389j = cVar;
            viewTreeObserver.addOnGlobalFocusChangeListener(cVar);
        }
    }

    @SuppressLint({"NewApi"})
    public void l(SurfaceTexture surfaceTexture) {
        int i2;
        int i3 = Build.VERSION.SDK_INT;
        if (i3 < 23) {
            h.a.b.b("PlatformViewWrapper", "Platform views cannot be displayed below API level 23. You can prevent this issue by setting `minSdkVersion: 23` in build.gradle.");
            return;
        }
        this.f386g = surfaceTexture;
        int i4 = this.f384e;
        if (i4 > 0 && (i2 = this.f385f) > 0) {
            surfaceTexture.setDefaultBufferSize(i4, i2);
        }
        Surface surface = this.f387h;
        if (surface != null) {
            surface.release();
        }
        Surface c2 = c(surfaceTexture);
        this.f387h = c2;
        Canvas lockHardwareCanvas = c2.lockHardwareCanvas();
        try {
            if (i3 >= 29) {
                lockHardwareCanvas.drawColor(0, BlendMode.CLEAR);
            } else {
                lockHardwareCanvas.drawColor(0);
            }
            f();
        } finally {
            this.f387h.unlockCanvasAndPost(lockHardwareCanvas);
        }
    }

    public void m(io.flutter.embedding.android.b bVar) {
        this.f388i = bVar;
    }

    public void o() {
        ViewTreeObserver.OnGlobalFocusChangeListener onGlobalFocusChangeListener;
        ViewTreeObserver viewTreeObserver = getViewTreeObserver();
        if (!viewTreeObserver.isAlive() || (onGlobalFocusChangeListener = this.f389j) == null) {
            return;
        }
        this.f389j = null;
        viewTreeObserver.removeOnGlobalFocusChangeListener(onGlobalFocusChangeListener);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    @SuppressLint({"NewApi"})
    public void onDescendantInvalidated(View view, View view2) {
        super.onDescendantInvalidated(view, view2);
        invalidate();
    }

    @Override // android.view.ViewGroup
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    @Override // android.view.View
    @SuppressLint({"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int i2;
        float f2;
        if (this.f388i == null) {
            return super.onTouchEvent(motionEvent);
        }
        Matrix matrix = new Matrix();
        int action = motionEvent.getAction();
        if (action == 0) {
            int i3 = this.c;
            this.a = i3;
            i2 = this.f383d;
            this.b = i2;
            f2 = i3;
        } else if (action == 2) {
            matrix.postTranslate(this.a, this.b);
            this.a = this.c;
            this.b = this.f383d;
            return this.f388i.f(motionEvent, matrix);
        } else {
            f2 = this.c;
            i2 = this.f383d;
        }
        matrix.postTranslate(f2, i2);
        return this.f388i.f(motionEvent, matrix);
    }
}
