package f.a.a;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.provider.Settings;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/* loaded from: classes.dex */
final class n implements h.a.c.a.k, h.a.c.a.n {
    private b a;
    private Activity b;
    private int c;

    /* renamed from: d  reason: collision with root package name */
    private Map<Integer, Integer> f302d;

    @FunctionalInterface
    /* loaded from: classes.dex */
    interface a {
        void a(int i2);
    }

    @FunctionalInterface
    /* loaded from: classes.dex */
    interface b {
        void a(Map<Integer, Integer> map);
    }

    @FunctionalInterface
    /* loaded from: classes.dex */
    interface c {
        void a(boolean z);
    }

    private int c(Context context) {
        List<String> b2 = o.b(context, 21);
        if (b2 == null || b2.isEmpty()) {
            Log.d("permissions_handler", "Bluetooth permission missing in manifest");
            return 0;
        }
        return 1;
    }

    private int d(Context context) {
        return Build.VERSION.SDK_INT < 33 ? androidx.core.app.h.d(context).a() ? 1 : 0 : context.checkSelfPermission("android.permission.POST_NOTIFICATIONS") == 0 ? 1 : 0;
    }

    private int f(int i2, Context context) {
        int i3 = Build.VERSION.SDK_INT;
        if (i2 == 17) {
            return d(context);
        }
        if (i2 == 21) {
            return c(context);
        }
        if ((i2 == 30 || i2 == 28 || i2 == 29) && i3 < 31) {
            return c(context);
        }
        List<String> b2 = o.b(context, i2);
        if (b2 == null) {
            Log.d("permissions_handler", "No android specific permissions needed for: " + i2);
            return 1;
        } else if (b2.size() == 0) {
            Log.d("permissions_handler", "No permissions found in manifest for: " + b2 + i2);
            if (i2 != 16 || i3 >= 23) {
                if (i2 != 22 || i3 >= 30) {
                    return i3 < 23 ? 1 : 0;
                }
                return 2;
            }
            return 2;
        } else {
            boolean z = context.getApplicationInfo().targetSdkVersion >= 23;
            for (String str : b2) {
                if (z) {
                    if (i2 == 16) {
                        String packageName = context.getPackageName();
                        PowerManager powerManager = (PowerManager) context.getSystemService("power");
                        if (i3 >= 23) {
                            return (powerManager == null || !powerManager.isIgnoringBatteryOptimizations(packageName)) ? 0 : 1;
                        }
                        return 2;
                    } else if (i2 == 22) {
                        if (i3 < 30) {
                            return 2;
                        }
                        return Environment.isExternalStorageManager() ? 1 : 0;
                    } else if (i2 == 23 && i3 >= 23) {
                        return Settings.canDrawOverlays(context) ? 1 : 0;
                    } else {
                        if (i2 == 24 && i3 >= 26) {
                            return context.getPackageManager().canRequestPackageInstalls() ? 1 : 0;
                        }
                        if (i2 == 27 && i3 >= 23) {
                            return ((NotificationManager) context.getSystemService("notification")).isNotificationPolicyAccessGranted() ? 1 : 0;
                        }
                        if (i2 == 34) {
                            if (i3 >= 31) {
                                return ((AlarmManager) context.getSystemService("alarm")).canScheduleExactAlarms() ? 1 : 0;
                            }
                            return 1;
                        } else if (e.c.a.a.a(context, str) != 0) {
                            return 0;
                        }
                    }
                }
            }
            return 1;
        }
    }

    private void g(String str, int i2) {
        Intent intent = new Intent(str);
        if (!str.equals("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS")) {
            intent.setData(Uri.parse("package:" + this.b.getPackageName()));
        }
        this.b.startActivityForResult(intent, i2);
        this.c++;
    }

    @Override // h.a.c.a.n
    public boolean a(int i2, String[] strArr, int[] iArr) {
        Map<Integer, Integer> map;
        int valueOf;
        int h2;
        Map<Integer, Integer> map2;
        int valueOf2;
        if (i2 != 24) {
            this.c = 0;
            return false;
        } else if (this.f302d == null) {
            return false;
        } else {
            for (int i3 = 0; i3 < strArr.length; i3++) {
                String str = strArr[i3];
                int f2 = o.f(str);
                if (f2 != 20) {
                    int i4 = iArr[i3];
                    if (f2 == 7) {
                        if (!this.f302d.containsKey(7)) {
                            this.f302d.put(7, Integer.valueOf(o.h(this.b, str, i4)));
                        }
                        if (!this.f302d.containsKey(14)) {
                            map = this.f302d;
                            valueOf = 14;
                            map.put(valueOf, Integer.valueOf(o.h(this.b, str, i4)));
                        }
                        o.i(this.b, f2);
                    } else if (f2 == 4) {
                        h2 = o.h(this.b, str, i4);
                        if (!this.f302d.containsKey(4)) {
                            map2 = this.f302d;
                            valueOf2 = 4;
                            map2.put(valueOf2, Integer.valueOf(h2));
                        }
                        o.i(this.b, f2);
                    } else if (f2 == 3) {
                        h2 = o.h(this.b, str, i4);
                        if (Build.VERSION.SDK_INT < 29 && !this.f302d.containsKey(4)) {
                            this.f302d.put(4, Integer.valueOf(h2));
                        }
                        if (!this.f302d.containsKey(5)) {
                            this.f302d.put(5, Integer.valueOf(h2));
                        }
                        map2 = this.f302d;
                        valueOf2 = Integer.valueOf(f2);
                        map2.put(valueOf2, Integer.valueOf(h2));
                        o.i(this.b, f2);
                    } else {
                        if (!this.f302d.containsKey(Integer.valueOf(f2))) {
                            map = this.f302d;
                            valueOf = Integer.valueOf(f2);
                            map.put(valueOf, Integer.valueOf(o.h(this.b, str, i4)));
                        }
                        o.i(this.b, f2);
                    }
                }
            }
            int length = this.c - iArr.length;
            this.c = length;
            if (length == 0) {
                this.a.a(this.f302d);
                return true;
            }
            return true;
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    @Override // h.a.c.a.k
    public boolean b(int i2, int i3, Intent intent) {
        int i4;
        int i5 = Build.VERSION.SDK_INT;
        if (i2 == 209 || i2 == 210 || i2 == 211 || i2 == 212 || i2 == 213 || i2 == 214) {
            boolean z = i3 == -1;
            int i6 = 23;
            if (i2 == 209) {
                i6 = 16;
                i4 = z;
            } else if (i2 == 210) {
                if (i5 < 30) {
                    return false;
                }
                i6 = 22;
                i4 = Environment.isExternalStorageManager();
            } else if (i2 == 211) {
                if (i5 < 23) {
                    return false;
                }
                i4 = Settings.canDrawOverlays(this.b);
            } else if (i2 == 212) {
                if (i5 < 26) {
                    return false;
                }
                i6 = 24;
                i4 = this.b.getPackageManager().canRequestPackageInstalls();
            } else if (i2 == 213) {
                if (i5 < 23) {
                    return false;
                }
                i6 = 27;
                i4 = ((NotificationManager) this.b.getSystemService("notification")).isNotificationPolicyAccessGranted();
            } else if (i2 != 214 || i5 < 31) {
                return false;
            } else {
                i6 = 34;
                i4 = ((AlarmManager) this.b.getSystemService("alarm")).canScheduleExactAlarms();
            }
            this.f302d.put(Integer.valueOf(i6), Integer.valueOf(i4));
            int i7 = this.c - 1;
            this.c = i7;
            if (i7 == 0) {
                this.a.a(this.f302d);
            }
            return true;
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void e(int i2, Context context, a aVar) {
        aVar.a(f(i2, context));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void h(List<Integer> list, Activity activity, b bVar, k kVar) {
        Map<Integer, Integer> map;
        int i2;
        Map<Integer, Integer> map2;
        int i3;
        int i4;
        String str;
        String str2;
        int i5 = Build.VERSION.SDK_INT;
        if (this.c > 0) {
            str2 = "A request for permissions is already running, please wait for it to finish before doing another request (note that you can request multiple permissions at the same time).";
        } else if (activity != null) {
            this.a = bVar;
            this.b = activity;
            this.f302d = new HashMap();
            this.c = 0;
            ArrayList arrayList = new ArrayList();
            for (Integer num : list) {
                if (f(num.intValue(), activity) != 1) {
                    List<String> b2 = o.b(activity, num.intValue());
                    if (b2 != null && !b2.isEmpty()) {
                        if (i5 >= 23 && num.intValue() == 16) {
                            i4 = 209;
                            str = "android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS";
                        } else if (i5 >= 30 && num.intValue() == 22) {
                            i4 = 210;
                            str = "android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION";
                        } else if (i5 >= 23 && num.intValue() == 23) {
                            i4 = 211;
                            str = "android.settings.action.MANAGE_OVERLAY_PERMISSION";
                        } else if (i5 >= 26 && num.intValue() == 24) {
                            i4 = 212;
                            str = "android.settings.MANAGE_UNKNOWN_APP_SOURCES";
                        } else if (i5 >= 23 && num.intValue() == 27) {
                            i4 = 213;
                            str = "android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS";
                        } else if (i5 < 31 || num.intValue() != 34) {
                            arrayList.addAll(b2);
                            this.c += b2.size();
                        } else {
                            i4 = 214;
                            str = "android.settings.REQUEST_SCHEDULE_EXACT_ALARM";
                        }
                        g(str, i4);
                    } else if (!this.f302d.containsKey(num)) {
                        if (num.intValue() != 16 || i5 >= 23) {
                            map2 = this.f302d;
                            i3 = 0;
                        } else {
                            map2 = this.f302d;
                            i3 = 2;
                        }
                        map2.put(num, i3);
                        if (num.intValue() != 22 || i5 >= 30) {
                            map = this.f302d;
                            i2 = 0;
                        } else {
                            map = this.f302d;
                            i2 = 2;
                        }
                        map.put(num, i2);
                    }
                } else if (!this.f302d.containsKey(num)) {
                    map = this.f302d;
                    i2 = 1;
                    map.put(num, i2);
                }
            }
            if (arrayList.size() > 0) {
                androidx.core.app.a.f(activity, (String[]) arrayList.toArray(new String[0]), 24);
            }
            if (this.c == 0) {
                this.a.a(this.f302d);
                return;
            }
            return;
        } else {
            Log.d("permissions_handler", "Unable to detect current Activity.");
            str2 = "Unable to detect current Android Activity.";
        }
        kVar.a("PermissionHandler.PermissionManager", str2);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void i(int i2, Activity activity, c cVar, k kVar) {
        if (activity == null) {
            Log.d("permissions_handler", "Unable to detect current Activity.");
            kVar.a("PermissionHandler.PermissionManager", "Unable to detect current Android Activity.");
            return;
        }
        List<String> b2 = o.b(activity, i2);
        if (b2 == null) {
            Log.d("permissions_handler", "No android specific permissions needed for: " + i2);
            cVar.a(false);
        } else if (!b2.isEmpty()) {
            cVar.a(androidx.core.app.a.g(activity, b2.get(0)));
        } else {
            Log.d("permissions_handler", "No permissions found in manifest for: " + i2 + " no need to show request rationale");
            cVar.a(false);
        }
    }
}
