package e.e;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import android.util.Log;
import java.nio.Buffer;
import java.nio.FloatBuffer;
/* loaded from: classes.dex */
public class e {

    /* renamed from: g  reason: collision with root package name */
    public static final float[] f293g;

    /* renamed from: h  reason: collision with root package name */
    public static final float[] f294h;
    private int a;
    private int b;
    private int c;

    /* renamed from: d  reason: collision with root package name */
    private int f295d;

    /* renamed from: e  reason: collision with root package name */
    private int f296e;

    /* renamed from: f  reason: collision with root package name */
    private int f297f;

    static {
        float[] fArr = new float[16];
        f293g = fArr;
        Matrix.setIdentityM(fArr, 0);
        float[] fArr2 = new float[16];
        f294h = fArr2;
        Matrix.setIdentityM(fArr2, 0);
        Matrix.translateM(fArr2, 0, 0.0f, 1.0f, 0.0f);
        Matrix.scaleM(fArr2, 0, 1.0f, -1.0f, 1.0f);
    }

    public e(int i2) {
        String str;
        if (i2 == 0) {
            this.f297f = 3553;
            str = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform sampler2D sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
        } else if (i2 != 1) {
            throw new RuntimeException("Unhandled type " + i2);
        } else {
            this.f297f = 36197;
            str = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
        }
        this.a = c("uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", str);
        int i3 = this.a;
        if (i3 == 0) {
            throw new RuntimeException("Unable to create program");
        }
        int glGetAttribLocation = GLES20.glGetAttribLocation(i3, "aPosition");
        this.f295d = glGetAttribLocation;
        b(glGetAttribLocation, "aPosition");
        int glGetAttribLocation2 = GLES20.glGetAttribLocation(this.a, "aTextureCoord");
        this.f296e = glGetAttribLocation2;
        b(glGetAttribLocation2, "aTextureCoord");
        int glGetUniformLocation = GLES20.glGetUniformLocation(this.a, "uMVPMatrix");
        this.b = glGetUniformLocation;
        b(glGetUniformLocation, "uMVPMatrix");
        int glGetUniformLocation2 = GLES20.glGetUniformLocation(this.a, "uTexMatrix");
        this.c = glGetUniformLocation2;
        b(glGetUniformLocation2, "uTexMatrix");
    }

    public static void a(String str) {
        int glGetError;
        if (GLES20.glGetError() == 0) {
            return;
        }
        String str2 = str + ": glError 0x" + Integer.toHexString(glGetError);
        Log.e("Texture2dProgram", str2);
        throw new RuntimeException(str2);
    }

    public static void b(int i2, String str) {
        if (i2 >= 0) {
            return;
        }
        throw new RuntimeException("Unable to locate '" + str + "' in program");
    }

    public static int c(String str, String str2) {
        int f2;
        int f3 = f(35633, str);
        if (f3 == 0 || (f2 = f(35632, str2)) == 0) {
            return 0;
        }
        int glCreateProgram = GLES20.glCreateProgram();
        a("glCreateProgram");
        if (glCreateProgram == 0) {
            Log.e("Texture2dProgram", "Could not create program");
        }
        GLES20.glAttachShader(glCreateProgram, f3);
        a("glAttachShader");
        GLES20.glAttachShader(glCreateProgram, f2);
        a("glAttachShader");
        GLES20.glLinkProgram(glCreateProgram);
        int[] iArr = new int[1];
        GLES20.glGetProgramiv(glCreateProgram, 35714, iArr, 0);
        if (iArr[0] != 1) {
            Log.e("Texture2dProgram", "Could not link program: ");
            Log.e("Texture2dProgram", GLES20.glGetProgramInfoLog(glCreateProgram));
            GLES20.glDeleteProgram(glCreateProgram);
            return 0;
        }
        return glCreateProgram;
    }

    public static int f(int i2, String str) {
        int glCreateShader = GLES20.glCreateShader(i2);
        a("glCreateShader type=" + i2);
        GLES20.glShaderSource(glCreateShader, str);
        GLES20.glCompileShader(glCreateShader);
        int[] iArr = new int[1];
        GLES20.glGetShaderiv(glCreateShader, 35713, iArr, 0);
        if (iArr[0] == 0) {
            Log.e("Texture2dProgram", "Could not compile shader " + i2 + ":");
            StringBuilder sb = new StringBuilder();
            sb.append(" ");
            sb.append(GLES20.glGetShaderInfoLog(glCreateShader));
            Log.e("Texture2dProgram", sb.toString());
            GLES20.glDeleteShader(glCreateShader);
            return 0;
        }
        return glCreateShader;
    }

    public int d() {
        int[] iArr = new int[1];
        GLES20.glGenTextures(1, iArr, 0);
        a("glGenTextures");
        int i2 = iArr[0];
        GLES20.glBindTexture(this.f297f, i2);
        a("glBindTexture " + i2);
        GLES20.glTexParameterf(this.f297f, 10241, 9728.0f);
        int i3 = this.f297f;
        GLES20.glTexParameterf(i3, 10240, i3 != 3553 ? 9729.0f : 9728.0f);
        GLES20.glTexParameteri(this.f297f, 10242, 33071);
        GLES20.glTexParameteri(this.f297f, 10243, 33071);
        a("glTexParameter");
        return i2;
    }

    public void e(float[] fArr, FloatBuffer floatBuffer, int i2, int i3, int i4, int i5, float[] fArr2, FloatBuffer floatBuffer2, int i6, int i7) {
        a("draw start");
        GLES20.glUseProgram(this.a);
        a("glUseProgram");
        GLES20.glActiveTexture(33984);
        GLES20.glBindTexture(this.f297f, i6);
        GLES20.glUniformMatrix4fv(this.b, 1, false, fArr, 0);
        a("glUniformMatrix4fv");
        GLES20.glUniformMatrix4fv(this.c, 1, false, fArr2, 0);
        a("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray(this.f295d);
        a("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer(this.f295d, i4, 5126, false, i5, (Buffer) floatBuffer);
        a("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray(this.f296e);
        a("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer(this.f296e, 2, 5126, false, i7, (Buffer) floatBuffer2);
        a("glVertexAttribPointer");
        GLES20.glDrawArrays(5, i2, i3);
        a("glDrawArrays");
        GLES20.glDisableVertexAttribArray(this.f295d);
        GLES20.glDisableVertexAttribArray(this.f296e);
        GLES20.glBindTexture(this.f297f, 0);
        GLES20.glUseProgram(0);
    }

    public void g(int i2, Bitmap bitmap) {
        GLES20.glBindTexture(this.f297f, i2);
        GLUtils.texImage2D(this.f297f, 0, bitmap, 0);
    }

    public void h() {
        Log.d("Texture2dProgram", "deleting program " + this.a);
        GLES20.glDeleteProgram(this.a);
        this.a = -1;
    }
}
