package e.e;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.util.Pair;
import e.e.c;
import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
/* loaded from: classes.dex */
public final class d implements AutoCloseable {

    /* renamed from: d  reason: collision with root package name */
    private final int f278d;

    /* renamed from: e  reason: collision with root package name */
    private final HandlerThread f279e;

    /* renamed from: f  reason: collision with root package name */
    private final Handler f280f;

    /* renamed from: g  reason: collision with root package name */
    int f281g;

    /* renamed from: h  reason: collision with root package name */
    final int f282h;

    /* renamed from: i  reason: collision with root package name */
    final int f283i;

    /* renamed from: j  reason: collision with root package name */
    final int f284j;
    MediaMuxer l;
    private e.e.c m;
    int[] o;
    int p;
    private boolean q;
    final C0025d k = new C0025d();
    final AtomicBoolean n = new AtomicBoolean(false);
    private final List<Pair<Integer, ByteBuffer>> r = new ArrayList();

    /* loaded from: classes.dex */
    class a implements Runnable {
        a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            try {
                d.this.e();
            } catch (Exception unused) {
            }
        }
    }

    /* loaded from: classes.dex */
    public static final class b {
        private final String a;
        private final FileDescriptor b;
        private final int c;

        /* renamed from: d  reason: collision with root package name */
        private final int f286d;

        /* renamed from: e  reason: collision with root package name */
        private final int f287e;

        /* renamed from: f  reason: collision with root package name */
        private boolean f288f;

        /* renamed from: g  reason: collision with root package name */
        private int f289g;

        /* renamed from: h  reason: collision with root package name */
        private int f290h;

        /* renamed from: i  reason: collision with root package name */
        private int f291i;

        /* renamed from: j  reason: collision with root package name */
        private int f292j;
        private Handler k;

        public b(String str, int i2, int i3, int i4) {
            this(str, null, i2, i3, i4);
        }

        private b(String str, FileDescriptor fileDescriptor, int i2, int i3, int i4) {
            this.f288f = true;
            this.f289g = 100;
            this.f290h = 1;
            this.f291i = 0;
            this.f292j = 0;
            if (i2 <= 0 || i3 <= 0) {
                throw new IllegalArgumentException("Invalid image size: " + i2 + "x" + i3);
            }
            this.a = str;
            this.b = fileDescriptor;
            this.c = i2;
            this.f286d = i3;
            this.f287e = i4;
        }

        public d a() {
            return new d(this.a, this.b, this.c, this.f286d, this.f292j, this.f288f, this.f289g, this.f290h, this.f291i, this.f287e, this.k);
        }

        public b b(int i2) {
            if (i2 > 0) {
                this.f290h = i2;
                return this;
            }
            throw new IllegalArgumentException("Invalid maxImage: " + i2);
        }

        public b c(int i2) {
            if (i2 >= 0 && i2 <= 100) {
                this.f289g = i2;
                return this;
            }
            throw new IllegalArgumentException("Invalid quality: " + i2);
        }
    }

    /* loaded from: classes.dex */
    class c extends c.AbstractC0024c {
        private boolean a;

        c() {
        }

        private void e(Exception exc) {
            if (this.a) {
                return;
            }
            this.a = true;
            d.this.k.a(exc);
        }

        @Override // e.e.c.AbstractC0024c
        public void a(e.e.c cVar) {
            e(null);
        }

        @Override // e.e.c.AbstractC0024c
        public void b(e.e.c cVar, ByteBuffer byteBuffer) {
            if (this.a) {
                return;
            }
            d dVar = d.this;
            if (dVar.o == null) {
                e(new IllegalStateException("Output buffer received before format info"));
                return;
            }
            if (dVar.p < dVar.f283i * dVar.f281g) {
                MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
                bufferInfo.set(byteBuffer.position(), byteBuffer.remaining(), 0L, 0);
                d dVar2 = d.this;
                dVar2.l.writeSampleData(dVar2.o[dVar2.p / dVar2.f281g], byteBuffer, bufferInfo);
            }
            d dVar3 = d.this;
            int i2 = dVar3.p + 1;
            dVar3.p = i2;
            if (i2 == dVar3.f283i * dVar3.f281g) {
                e(null);
            }
        }

        @Override // e.e.c.AbstractC0024c
        public void c(e.e.c cVar, MediaCodec.CodecException codecException) {
            e(codecException);
        }

        @Override // e.e.c.AbstractC0024c
        public void d(e.e.c cVar, MediaFormat mediaFormat) {
            if (this.a) {
                return;
            }
            if (d.this.o != null) {
                e(new IllegalStateException("Output format changed after muxer started"));
                return;
            }
            try {
                d.this.f281g = mediaFormat.getInteger("grid-rows") * mediaFormat.getInteger("grid-cols");
            } catch (ClassCastException | NullPointerException unused) {
                d.this.f281g = 1;
            }
            d dVar = d.this;
            dVar.o = new int[dVar.f283i];
            if (dVar.f282h > 0) {
                Log.d("HeifWriter", "setting rotation: " + d.this.f282h);
                d dVar2 = d.this;
                dVar2.l.setOrientationHint(dVar2.f282h);
            }
            int i2 = 0;
            while (true) {
                d dVar3 = d.this;
                if (i2 >= dVar3.o.length) {
                    dVar3.l.start();
                    d.this.n.set(true);
                    d.this.f();
                    return;
                }
                mediaFormat.setInteger("is-default", i2 == dVar3.f284j ? 1 : 0);
                d dVar4 = d.this;
                dVar4.o[i2] = dVar4.l.addTrack(mediaFormat);
                i2++;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: e.e.d$d  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static class C0025d {
        private boolean a;
        private Exception b;

        C0025d() {
        }

        synchronized void a(Exception exc) {
            if (!this.a) {
                this.a = true;
                this.b = exc;
                notifyAll();
            }
        }

        synchronized void b(long j2) {
            int i2 = (j2 > 0L ? 1 : (j2 == 0L ? 0 : -1));
            if (i2 < 0) {
                throw new IllegalArgumentException("timeoutMs is negative");
            }
            if (i2 == 0) {
                while (!this.a) {
                    try {
                        wait();
                    } catch (InterruptedException unused) {
                    }
                }
            } else {
                long currentTimeMillis = System.currentTimeMillis();
                while (!this.a && j2 > 0) {
                    try {
                        wait(j2);
                    } catch (InterruptedException unused2) {
                    }
                    j2 -= System.currentTimeMillis() - currentTimeMillis;
                }
            }
            if (!this.a) {
                this.a = true;
                this.b = new TimeoutException("timed out waiting for result");
            }
            Exception exc = this.b;
            if (exc != null) {
                throw exc;
            }
        }
    }

    @SuppressLint({"WrongConstant"})
    d(String str, FileDescriptor fileDescriptor, int i2, int i3, int i4, boolean z, int i5, int i6, int i7, int i8, Handler handler) {
        if (i7 >= i6) {
            throw new IllegalArgumentException("Invalid maxImages (" + i6 + ") or primaryIndex (" + i7 + ")");
        }
        MediaFormat.createVideoFormat("image/vnd.android.heic", i2, i3);
        this.f281g = 1;
        this.f282h = i4;
        this.f278d = i8;
        this.f283i = i6;
        this.f284j = i7;
        Looper looper = handler != null ? handler.getLooper() : null;
        if (looper == null) {
            HandlerThread handlerThread = new HandlerThread("HeifEncoderThread", -2);
            this.f279e = handlerThread;
            handlerThread.start();
            looper = handlerThread.getLooper();
        } else {
            this.f279e = null;
        }
        Handler handler2 = new Handler(looper);
        this.f280f = handler2;
        this.l = str != null ? new MediaMuxer(str, 3) : new MediaMuxer(fileDescriptor, 3);
        this.m = new e.e.c(i2, i3, z, i5, i8, handler2, new c());
    }

    private void b(int i2) {
        if (this.f278d == i2) {
            return;
        }
        throw new IllegalStateException("Not valid in input mode " + this.f278d);
    }

    private void c(boolean z) {
        if (this.q != z) {
            throw new IllegalStateException("Already started");
        }
    }

    private void d(int i2) {
        c(true);
        b(i2);
    }

    public void a(Bitmap bitmap) {
        d(2);
        synchronized (this) {
            e.e.c cVar = this.m;
            if (cVar != null) {
                cVar.b(bitmap);
            }
        }
    }

    @Override // java.lang.AutoCloseable
    public void close() {
        this.f280f.postAtFrontOfQueue(new a());
    }

    void e() {
        MediaMuxer mediaMuxer = this.l;
        if (mediaMuxer != null) {
            mediaMuxer.stop();
            this.l.release();
            this.l = null;
        }
        e.e.c cVar = this.m;
        if (cVar != null) {
            cVar.close();
            synchronized (this) {
                this.m = null;
            }
        }
    }

    @SuppressLint({"WrongConstant"})
    void f() {
        Pair<Integer, ByteBuffer> remove;
        if (!this.n.get()) {
            return;
        }
        while (true) {
            synchronized (this.r) {
                if (this.r.isEmpty()) {
                    return;
                }
                remove = this.r.remove(0);
            }
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            bufferInfo.set(((ByteBuffer) remove.second).position(), ((ByteBuffer) remove.second).remaining(), 0L, 16);
            this.l.writeSampleData(this.o[((Integer) remove.first).intValue()], (ByteBuffer) remove.second, bufferInfo);
        }
    }

    public void g() {
        c(false);
        this.q = true;
        this.m.j();
    }

    public void h(long j2) {
        c(true);
        synchronized (this) {
            e.e.c cVar = this.m;
            if (cVar != null) {
                cVar.k();
            }
        }
        this.k.b(j2);
        f();
        e();
    }
}
