package e.e;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.Image;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.util.Range;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.ArrayList;
/* loaded from: classes.dex */
public final class c implements AutoCloseable, SurfaceTexture.OnFrameAvailableListener {
    private Surface A;
    private e.e.b B;
    private e.e.a C;
    private int D;

    /* renamed from: d  reason: collision with root package name */
    MediaCodec f263d;

    /* renamed from: e  reason: collision with root package name */
    final AbstractC0024c f264e;

    /* renamed from: f  reason: collision with root package name */
    private final HandlerThread f265f;

    /* renamed from: g  reason: collision with root package name */
    final Handler f266g;

    /* renamed from: h  reason: collision with root package name */
    private final int f267h;

    /* renamed from: i  reason: collision with root package name */
    final int f268i;

    /* renamed from: j  reason: collision with root package name */
    final int f269j;
    final int k;
    final int l;
    final int m;
    final int n;
    private final int o;
    final boolean p;
    private int q;
    boolean r;
    private final Rect s;
    private final Rect t;
    private ByteBuffer u;
    e y;
    private SurfaceTexture z;
    private final ArrayList<ByteBuffer> v = new ArrayList<>();
    private final ArrayList<ByteBuffer> w = new ArrayList<>();
    final ArrayList<Integer> x = new ArrayList<>();
    private final float[] E = new float[16];

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements Runnable {
        a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            c.this.h();
        }
    }

    /* loaded from: classes.dex */
    class b implements Runnable {
        b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            c.this.l();
        }
    }

    /* renamed from: e.e.c$c  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static abstract class AbstractC0024c {
        public abstract void a(c cVar);

        public abstract void b(c cVar, ByteBuffer byteBuffer);

        public abstract void c(c cVar, MediaCodec.CodecException codecException);

        public abstract void d(c cVar, MediaFormat mediaFormat);
    }

    /* loaded from: classes.dex */
    class d extends MediaCodec.Callback {
        private boolean a;

        d() {
        }

        private void a(MediaCodec.CodecException codecException) {
            c.this.l();
            if (codecException == null) {
                c cVar = c.this;
                cVar.f264e.a(cVar);
                return;
            }
            c cVar2 = c.this;
            cVar2.f264e.c(cVar2, codecException);
        }

        @Override // android.media.MediaCodec.Callback
        public void onError(MediaCodec mediaCodec, MediaCodec.CodecException codecException) {
            if (mediaCodec != c.this.f263d) {
                return;
            }
            Log.e("HeifEncoder", "onError: " + codecException);
            a(codecException);
        }

        @Override // android.media.MediaCodec.Callback
        public void onInputBufferAvailable(MediaCodec mediaCodec, int i2) {
            c cVar = c.this;
            if (mediaCodec != cVar.f263d || cVar.r) {
                return;
            }
            cVar.x.add(Integer.valueOf(i2));
            c.this.h();
        }

        @Override // android.media.MediaCodec.Callback
        public void onOutputBufferAvailable(MediaCodec mediaCodec, int i2, MediaCodec.BufferInfo bufferInfo) {
            if (mediaCodec != c.this.f263d || this.a) {
                return;
            }
            if (bufferInfo.size > 0 && (bufferInfo.flags & 2) == 0) {
                ByteBuffer outputBuffer = mediaCodec.getOutputBuffer(i2);
                outputBuffer.position(bufferInfo.offset);
                outputBuffer.limit(bufferInfo.offset + bufferInfo.size);
                e eVar = c.this.y;
                if (eVar != null) {
                    eVar.e(bufferInfo.presentationTimeUs);
                }
                c cVar = c.this;
                cVar.f264e.b(cVar, outputBuffer);
            }
            this.a = ((bufferInfo.flags & 4) != 0) | this.a;
            mediaCodec.releaseOutputBuffer(i2, false);
            if (this.a) {
                a(null);
            }
        }

        @Override // android.media.MediaCodec.Callback
        public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
            if (mediaCodec != c.this.f263d) {
                return;
            }
            if (!"image/vnd.android.heic".equals(mediaFormat.getString("mime"))) {
                mediaFormat.setString("mime", "image/vnd.android.heic");
                mediaFormat.setInteger("width", c.this.f268i);
                mediaFormat.setInteger("height", c.this.f269j);
                c cVar = c.this;
                if (cVar.p) {
                    mediaFormat.setInteger("tile-width", cVar.k);
                    mediaFormat.setInteger("tile-height", c.this.l);
                    mediaFormat.setInteger("grid-rows", c.this.m);
                    mediaFormat.setInteger("grid-cols", c.this.n);
                }
            }
            c cVar2 = c.this;
            cVar2.f264e.d(cVar2, mediaFormat);
        }
    }

    /* loaded from: classes.dex */
    private class e {
        final boolean a;
        long b = -1;
        long c = -1;

        /* renamed from: d  reason: collision with root package name */
        long f272d = -1;

        /* renamed from: e  reason: collision with root package name */
        long f273e = -1;

        /* renamed from: f  reason: collision with root package name */
        long f274f = -1;

        /* renamed from: g  reason: collision with root package name */
        boolean f275g;

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class a implements Runnable {
            a() {
            }

            @Override // java.lang.Runnable
            public void run() {
                MediaCodec mediaCodec = c.this.f263d;
                if (mediaCodec != null) {
                    mediaCodec.signalEndOfInputStream();
                }
            }
        }

        e(boolean z) {
            this.a = z;
        }

        private void a() {
            c.this.f266g.post(new a());
            this.f275g = true;
        }

        private void b() {
            if (this.f275g) {
                return;
            }
            if (this.f272d < 0) {
                long j2 = this.b;
                if (j2 >= 0 && this.c >= j2) {
                    long j3 = this.f273e;
                    if (j3 < 0) {
                        a();
                        return;
                    }
                    this.f272d = j3;
                }
            }
            long j4 = this.f272d;
            if (j4 < 0 || j4 > this.f274f) {
                return;
            }
            a();
        }

        synchronized void c(long j2) {
            if (this.a) {
                if (this.b < 0) {
                    this.b = j2;
                }
            } else if (this.f272d < 0) {
                this.f272d = j2 / 1000;
            }
            b();
        }

        /* JADX WARN: Removed duplicated region for block: B:11:0x0013 A[Catch: all -> 0x001c, TryCatch #0 {, blocks: (B:3:0x0001, B:11:0x0013, B:12:0x0015), top: B:18:0x0001 }] */
        /*
            Code decompiled incorrectly, please refer to instructions dump.
        */
        synchronized boolean d(long j2, long j3) {
            boolean z;
            long j4 = this.b;
            if (j4 >= 0 && j2 > j4) {
                z = false;
                if (z) {
                    this.f273e = j3;
                }
                this.c = j2;
                b();
            }
            z = true;
            if (z) {
            }
            this.c = j2;
            b();
            return z;
        }

        synchronized void e(long j2) {
            this.f274f = j2;
            b();
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:71:0x01f7  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public c(int i2, int i3, boolean z, int i4, int i5, Handler handler, AbstractC0024c abstractC0024c) {
        MediaCodecInfo.CodecCapabilities capabilitiesForType;
        boolean z2;
        int i6;
        int i7;
        int i8;
        String str;
        int i9;
        boolean z3;
        if (i2 < 0 || i3 < 0 || i4 < 0 || i4 > 100) {
            throw new IllegalArgumentException("invalid encoder inputs");
        }
        int i10 = 512;
        int i11 = 1;
        boolean z4 = z & (i2 > 512 || i3 > 512);
        try {
            MediaCodec createEncoderByType = MediaCodec.createEncoderByType("image/vnd.android.heic");
            this.f263d = createEncoderByType;
            capabilitiesForType = createEncoderByType.getCodecInfo().getCapabilitiesForType("image/vnd.android.heic");
        } catch (Exception unused) {
            MediaCodec createEncoderByType2 = MediaCodec.createEncoderByType("video/hevc");
            this.f263d = createEncoderByType2;
            capabilitiesForType = createEncoderByType2.getCodecInfo().getCapabilitiesForType("video/hevc");
            z4 |= !capabilitiesForType.getVideoCapabilities().isSizeSupported(i2, i3);
            z2 = false;
        }
        if (!capabilitiesForType.getVideoCapabilities().isSizeSupported(i2, i3)) {
            this.f263d.release();
            this.f263d = null;
            throw new Exception();
        }
        z2 = true;
        this.f267h = i5;
        this.f264e = abstractC0024c;
        Looper looper = handler != null ? handler.getLooper() : null;
        if (looper == null) {
            HandlerThread handlerThread = new HandlerThread("HeifEncoderThread", -2);
            this.f265f = handlerThread;
            handlerThread.start();
            looper = handlerThread.getLooper();
        } else {
            this.f265f = null;
        }
        Handler handler2 = new Handler(looper);
        this.f266g = handler2;
        boolean z5 = i5 == 1 || i5 == 2;
        int i12 = z5 ? 2130708361 : 2135033992;
        this.f268i = i2;
        this.f269j = i3;
        this.p = z4;
        if (z4) {
            i11 = ((i2 + 512) - 1) / 512;
            i7 = ((i3 + 512) - 1) / 512;
            i6 = 512;
        } else {
            i10 = i2;
            i6 = i3;
            i7 = 1;
        }
        MediaFormat createVideoFormat = z2 ? MediaFormat.createVideoFormat("image/vnd.android.heic", i2, i3) : MediaFormat.createVideoFormat("video/hevc", i10, i6);
        if (z4) {
            createVideoFormat.setInteger("tile-width", i10);
            createVideoFormat.setInteger("tile-height", i6);
            createVideoFormat.setInteger("grid-cols", i11);
            createVideoFormat.setInteger("grid-rows", i7);
        }
        if (z2) {
            this.k = i2;
            this.l = i3;
            this.m = 1;
            this.n = 1;
        } else {
            this.k = i10;
            this.l = i6;
            this.m = i7;
            this.n = i11;
        }
        int i13 = this.m * this.n;
        this.o = i13;
        createVideoFormat.setInteger("i-frame-interval", 0);
        createVideoFormat.setInteger("color-format", i12);
        createVideoFormat.setInteger("frame-rate", i13);
        createVideoFormat.setInteger("capture-rate", i13 * 30);
        MediaCodecInfo.EncoderCapabilities encoderCapabilities = capabilitiesForType.getEncoderCapabilities();
        if (encoderCapabilities.isBitrateModeSupported(0)) {
            Log.d("HeifEncoder", "Setting bitrate mode to constant quality");
            Range<Integer> qualityRange = encoderCapabilities.getQualityRange();
            Log.d("HeifEncoder", "Quality range: " + qualityRange);
            createVideoFormat.setInteger("bitrate-mode", 0);
            i8 = (int) (((double) qualityRange.getLower().intValue()) + (((double) ((qualityRange.getUpper().intValue() - qualityRange.getLower().intValue()) * i4)) / 100.0d));
            str = "quality";
        } else {
            if (encoderCapabilities.isBitrateModeSupported(2)) {
                Log.d("HeifEncoder", "Setting bitrate mode to constant bitrate");
                createVideoFormat.setInteger("bitrate-mode", 2);
            } else {
                Log.d("HeifEncoder", "Setting bitrate mode to variable bitrate");
                createVideoFormat.setInteger("bitrate-mode", 1);
            }
            i8 = (int) ((((((i2 * i3) * 1.5d) * 8.0d) * 0.25d) * i4) / 100.0d);
            str = "bitrate";
        }
        createVideoFormat.setInteger(str, i8);
        this.f263d.setCallback(new d(), handler2);
        this.f263d.configure(createVideoFormat, (Surface) null, (MediaCrypto) null, 1);
        if (z5) {
            Surface createInputSurface = this.f263d.createInputSurface();
            this.A = createInputSurface;
            if (!z4 || z2) {
                i9 = i5;
                if (i9 != 2) {
                    z3 = false;
                    this.y = new e(z3);
                    if (z3) {
                        e.e.b bVar = new e.e.b(createInputSurface);
                        this.B = bVar;
                        bVar.f();
                        e.e.a aVar = new e.e.a(new e.e.e(i9 == 2 ? 0 : 1), i2, i3);
                        this.C = aVar;
                        this.D = aVar.c();
                        if (i9 == 1) {
                            SurfaceTexture surfaceTexture = new SurfaceTexture(this.D, true);
                            this.z = surfaceTexture;
                            surfaceTexture.setOnFrameAvailableListener(this);
                            this.z.setDefaultBufferSize(i2, i3);
                            new Surface(this.z);
                        }
                        this.B.g();
                    }
                }
            } else {
                i9 = i5;
            }
            z3 = true;
            this.y = new e(z3);
            if (z3) {
            }
        } else {
            for (int i14 = 0; i14 < 2; i14++) {
                this.v.add(ByteBuffer.allocateDirect(((this.f268i * this.f269j) * 3) / 2));
            }
        }
        this.t = new Rect(0, 0, this.k, this.l);
        this.s = new Rect();
    }

    private ByteBuffer a() {
        ByteBuffer remove;
        synchronized (this.v) {
            while (!this.r && this.v.isEmpty()) {
                try {
                    this.v.wait();
                } catch (InterruptedException unused) {
                }
            }
            remove = this.r ? null : this.v.remove(0);
        }
        return remove;
    }

    private void c(byte[] bArr) {
        ByteBuffer a2 = a();
        if (a2 == null) {
            return;
        }
        a2.clear();
        if (bArr != null) {
            a2.put(bArr);
        }
        a2.flip();
        synchronized (this.w) {
            this.w.add(a2);
        }
        this.f266g.post(new a());
    }

    private long d(int i2) {
        return ((i2 * 1000000) / this.o) + 132;
    }

    private static void e(ByteBuffer byteBuffer, Image image, int i2, int i3, Rect rect, Rect rect2) {
        int i4;
        int i5;
        if (rect.width() != rect2.width() || rect.height() != rect2.height()) {
            throw new IllegalArgumentException("src and dst rect size are different!");
        }
        if (i2 % 2 != 0 || i3 % 2 != 0 || rect.left % 2 != 0 || rect.top % 2 != 0 || rect.right % 2 != 0 || rect.bottom % 2 != 0 || rect2.left % 2 != 0 || rect2.top % 2 != 0 || rect2.right % 2 != 0 || rect2.bottom % 2 != 0) {
            throw new IllegalArgumentException("src or dst are not aligned!");
        }
        Image.Plane[] planes = image.getPlanes();
        for (int i6 = 0; i6 < planes.length; i6++) {
            ByteBuffer buffer = planes[i6].getBuffer();
            int pixelStride = planes[i6].getPixelStride();
            int min = Math.min(rect.width(), i2 - rect.left);
            int min2 = Math.min(rect.height(), i3 - rect.top);
            if (i6 > 0) {
                i4 = ((i2 * i3) * (i6 + 3)) / 4;
                i5 = 2;
            } else {
                i4 = 0;
                i5 = 1;
            }
            for (int i7 = 0; i7 < min2 / i5; i7++) {
                byteBuffer.position(((((rect.top / i5) + i7) * i2) / i5) + i4 + (rect.left / i5));
                buffer.position((((rect2.top / i5) + i7) * planes[i6].getRowStride()) + ((rect2.left * pixelStride) / i5));
                int i8 = 0;
                while (true) {
                    int i9 = min / i5;
                    if (i8 < i9) {
                        buffer.put(byteBuffer.get());
                        if (pixelStride > 1 && i8 != i9 - 1) {
                            buffer.position((buffer.position() + pixelStride) - 1);
                        }
                        i8++;
                    }
                }
            }
        }
    }

    private void f() {
        GLES20.glViewport(0, 0, this.k, this.l);
        for (int i2 = 0; i2 < this.m; i2++) {
            for (int i3 = 0; i3 < this.n; i3++) {
                int i4 = this.k;
                int i5 = i3 * i4;
                int i6 = this.l;
                int i7 = i2 * i6;
                this.s.set(i5, i7, i4 + i5, i6 + i7);
                this.C.a(this.D, e.e.e.f294h, this.s);
                e.e.b bVar = this.B;
                int i8 = this.q;
                this.q = i8 + 1;
                bVar.i(d(i8) * 1000);
                this.B.j();
            }
        }
    }

    private ByteBuffer g() {
        if (!this.r && this.u == null) {
            synchronized (this.w) {
                this.u = this.w.isEmpty() ? null : this.w.remove(0);
            }
        }
        if (this.r) {
            return null;
        }
        return this.u;
    }

    private void i(boolean z) {
        synchronized (this.v) {
            this.r = z | this.r;
            this.v.add(this.u);
            this.v.notifyAll();
        }
        this.u = null;
    }

    public void b(Bitmap bitmap) {
        if (this.f267h != 2) {
            throw new IllegalStateException("addBitmap is only allowed in bitmap input mode");
        }
        if (this.y.d(d(this.q) * 1000, d((this.q + this.o) - 1))) {
            synchronized (this) {
                e.e.b bVar = this.B;
                if (bVar == null) {
                    return;
                }
                bVar.f();
                this.C.d(this.D, bitmap);
                f();
                this.B.g();
            }
        }
    }

    @Override // java.lang.AutoCloseable
    public void close() {
        synchronized (this.v) {
            this.r = true;
            this.v.notifyAll();
        }
        this.f266g.postAtFrontOfQueue(new b());
    }

    void h() {
        while (true) {
            ByteBuffer g2 = g();
            if (g2 == null || this.x.isEmpty()) {
                return;
            }
            int intValue = this.x.remove(0).intValue();
            boolean z = this.q % this.o == 0 && g2.remaining() == 0;
            if (!z) {
                Image inputImage = this.f263d.getInputImage(intValue);
                int i2 = this.k;
                int i3 = this.q;
                int i4 = this.n;
                int i5 = (i3 % i4) * i2;
                int i6 = this.l;
                int i7 = ((i3 / i4) % this.m) * i6;
                this.s.set(i5, i7, i2 + i5, i6 + i7);
                e(g2, inputImage, this.f268i, this.f269j, this.s, this.t);
            }
            MediaCodec mediaCodec = this.f263d;
            int capacity = z ? 0 : mediaCodec.getInputBuffer(intValue).capacity();
            int i8 = this.q;
            this.q = i8 + 1;
            mediaCodec.queueInputBuffer(intValue, 0, capacity, d(i8), z ? 4 : 0);
            if (z || this.q % this.o == 0) {
                i(z);
            }
        }
    }

    public void j() {
        this.f263d.start();
    }

    public void k() {
        int i2 = this.f267h;
        if (i2 == 2) {
            this.y.c(0L);
        } else if (i2 == 0) {
            c(null);
        }
    }

    void l() {
        MediaCodec mediaCodec = this.f263d;
        if (mediaCodec != null) {
            mediaCodec.stop();
            this.f263d.release();
            this.f263d = null;
        }
        synchronized (this.v) {
            this.r = true;
            this.v.notifyAll();
        }
        synchronized (this) {
            e.e.a aVar = this.C;
            if (aVar != null) {
                aVar.e(false);
                this.C = null;
            }
            e.e.b bVar = this.B;
            if (bVar != null) {
                bVar.h();
                this.B = null;
            }
            SurfaceTexture surfaceTexture = this.z;
            if (surfaceTexture != null) {
                surfaceTexture.release();
                this.z = null;
            }
        }
    }

    @Override // android.graphics.SurfaceTexture.OnFrameAvailableListener
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        synchronized (this) {
            e.e.b bVar = this.B;
            if (bVar == null) {
                return;
            }
            bVar.f();
            surfaceTexture.updateTexImage();
            surfaceTexture.getTransformMatrix(this.E);
            if (this.y.d(surfaceTexture.getTimestamp(), d((this.q + this.o) - 1))) {
                f();
            }
            surfaceTexture.releaseTexImage();
            this.B.g();
        }
    }
}
