package com.example.r_upgrade.common;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.IBinder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONObject;
/* loaded from: classes.dex */
public class UpgradeService extends Service {
    private g b;
    private c c;

    /* renamed from: d  reason: collision with root package name */
    private UpgradeService f145d;

    /* renamed from: g  reason: collision with root package name */
    private ConnectivityManager.NetworkCallback f148g;
    private final Executor a = Executors.newSingleThreadExecutor();

    /* renamed from: e  reason: collision with root package name */
    private boolean f146e = true;

    /* renamed from: f  reason: collision with root package name */
    private final BroadcastReceiver f147f = new a();

    /* loaded from: classes.dex */
    class a extends BroadcastReceiver {
        a() {
        }

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            String stringExtra = intent.getStringExtra("packages");
            if (stringExtra == null || !stringExtra.equals(UpgradeService.this.getPackageName())) {
                return;
            }
            boolean z = false;
            if (intent != null && intent.getAction() != null && intent.getAction().equals("com.example.r_upgrade.RECEIVER_CANCEL")) {
                UpgradeService.this.c.k(intent.getIntExtra("id", 0));
            } else if (intent != null && intent.getAction() != null && intent.getAction().equals("com.example.r_upgrade.RECEIVER_PAUSE")) {
                UpgradeService.this.c.w(intent.getIntExtra("id", 0));
            } else if (intent != null && intent.getAction() != null && intent.getAction().equals("com.example.r_upgrade.RECEIVER_RESTART")) {
                int intExtra = intent.getIntExtra("id", 0);
                UpgradeService.this.c = new c(true, Long.valueOf(intExtra), null, null, null, UpgradeService.this.f145d, UpgradeService.this.b);
                UpgradeService.this.a.execute(UpgradeService.this.c);
            } else if (intent == null || intent.getAction() == null || !intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
            } else {
                NetworkInfo a = e.c.b.a.a((ConnectivityManager) context.getSystemService("connectivity"), intent);
                UpgradeService upgradeService = UpgradeService.this;
                if (a != null && a.isConnected()) {
                    z = true;
                }
                upgradeService.h(z);
            }
        }
    }

    /* loaded from: classes.dex */
    class b extends ConnectivityManager.NetworkCallback {
        b() {
        }

        @Override // android.net.ConnectivityManager.NetworkCallback
        public void onAvailable(Network network) {
            super.onAvailable(network);
            NetworkInfo networkInfo = ((ConnectivityManager) UpgradeService.this.getSystemService("connectivity")).getNetworkInfo(network);
            UpgradeService.this.h(networkInfo != null && networkInfo.isConnected());
        }

        @Override // android.net.ConnectivityManager.NetworkCallback
        public void onLost(Network network) {
            super.onLost(network);
            NetworkInfo networkInfo = ((ConnectivityManager) UpgradeService.this.getSystemService("connectivity")).getNetworkInfo(network);
            UpgradeService.this.h(networkInfo != null && networkInfo.isConnected());
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class c implements Runnable {

        /* renamed from: d  reason: collision with root package name */
        private String f149d;

        /* renamed from: e  reason: collision with root package name */
        private Long f150e;

        /* renamed from: f  reason: collision with root package name */
        private Map<String, Object> f151f;

        /* renamed from: g  reason: collision with root package name */
        private String f152g;

        /* renamed from: h  reason: collision with root package name */
        private UpgradeService f153h;
        private g n;
        private HttpURLConnection o;
        private HttpsURLConnection p;
        private Timer q;
        private boolean s;
        private boolean t;
        private boolean u;

        /* renamed from: i  reason: collision with root package name */
        private long f154i = 0;

        /* renamed from: j  reason: collision with root package name */
        private long f155j = 0;
        private long k = 0;
        private long l = System.currentTimeMillis();
        private File m = null;
        private boolean r = true;

        /* loaded from: classes.dex */
        class a extends TimerTask {
            a() {
            }

            @Override // java.util.TimerTask, java.lang.Runnable
            public void run() {
                c.this.v();
            }
        }

        c(boolean z, Long l, String str, Map<String, Object> map, String str2, UpgradeService upgradeService, g gVar) {
            this.f150e = l;
            this.f149d = str;
            this.f151f = map;
            this.f152g = str2 == null ? "release.apk" : str2;
            this.f153h = upgradeService;
            this.n = gVar;
            this.s = z;
            this.u = false;
        }

        /* JADX INFO: Access modifiers changed from: private */
        public void k(int i2) {
            if (!this.u && this.f150e.longValue() == i2) {
                l();
                HttpsURLConnection httpsURLConnection = this.p;
                if (httpsURLConnection != null) {
                    httpsURLConnection.disconnect();
                }
                HttpURLConnection httpURLConnection = this.o;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                this.r = false;
                q();
                boolean delete = this.m.delete();
                com.example.r_upgrade.common.c b = com.example.r_upgrade.common.c.b();
                b.a("r_upgrade.Service", "cancel: delete download file " + delete);
            }
        }

        private void l() {
            Timer timer = this.q;
            if (timer != null) {
                timer.cancel();
            }
        }

        private File m() {
            return Build.VERSION.SDK_INT > 28 ? this.f153h.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS) : Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS);
        }

        private InputStream n(String str) {
            String str2;
            URL url = new URL(str);
            if (!str.startsWith("https")) {
                HttpURLConnection httpURLConnection = (HttpURLConnection) url.openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setConnectTimeout(360000);
                httpURLConnection.setReadTimeout(360000);
                httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
                Map<String, Object> map = this.f151f;
                if (map != null && !map.isEmpty()) {
                    for (Map.Entry<String, Object> entry : this.f151f.entrySet()) {
                        httpURLConnection.setRequestProperty(entry.getKey(), (String) entry.getValue());
                    }
                }
                if (!this.t) {
                    httpURLConnection.setRequestProperty("range", "bytes=" + this.f155j + "-");
                }
                httpURLConnection.setDoInput(true);
                int responseCode = httpURLConnection.getResponseCode();
                com.example.r_upgrade.common.c b = com.example.r_upgrade.common.c.b();
                b.a("r_upgrade.Service", "run: code=" + responseCode);
                if (responseCode == 200 || responseCode == 206) {
                    httpURLConnection.connect();
                    InputStream inputStream = httpURLConnection.getInputStream();
                    if (this.t) {
                        this.f154i = p(httpURLConnection);
                        return inputStream;
                    }
                    return inputStream;
                } else if (responseCode == 301 || responseCode == 302) {
                    URL url2 = httpURLConnection.getURL();
                    com.example.r_upgrade.common.c b2 = com.example.r_upgrade.common.c.b();
                    b2.a("r_upgrade.Service", "redirect to: " + url2.toString());
                    return n(url2.toString());
                } else {
                    return null;
                }
            }
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection) url.openConnection();
            httpsURLConnection.setRequestMethod("GET");
            httpsURLConnection.setReadTimeout(360000);
            httpsURLConnection.setConnectTimeout(360000);
            Map<String, Object> map2 = this.f151f;
            if (map2 != null && !map2.isEmpty()) {
                for (Map.Entry<String, Object> entry2 : this.f151f.entrySet()) {
                    httpsURLConnection.setRequestProperty(entry2.getKey(), (String) entry2.getValue());
                }
            }
            if (this.t) {
                str2 = "redirect to: ";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("bytes=");
                str2 = "redirect to: ";
                sb.append(this.f155j);
                sb.append("-");
                httpsURLConnection.setRequestProperty("range", sb.toString());
            }
            httpsURLConnection.setSSLSocketFactory((SSLSocketFactory) SSLSocketFactory.getDefault());
            httpsURLConnection.setDoInput(true);
            int responseCode2 = httpsURLConnection.getResponseCode();
            com.example.r_upgrade.common.c b3 = com.example.r_upgrade.common.c.b();
            b3.a("r_upgrade.Service", "run: code=" + responseCode2);
            if (responseCode2 == 200 || responseCode2 == 206) {
                httpsURLConnection.connect();
                InputStream inputStream2 = httpsURLConnection.getInputStream();
                if (this.t) {
                    this.f154i = p(httpsURLConnection);
                }
                return inputStream2;
            } else if (responseCode2 == 301 || responseCode2 == 302) {
                URL url3 = httpsURLConnection.getURL();
                com.example.r_upgrade.common.c b4 = com.example.r_upgrade.common.c.b();
                b4.a("r_upgrade.Service", str2 + url3.toString());
                return n(url3.toString());
            } else {
                return null;
            }
        }

        private Map<String, Object> o(String str) {
            if (str == null || str.isEmpty()) {
                return null;
            }
            try {
                JSONObject jSONObject = new JSONObject(str);
                Iterator<String> keys = jSONObject.keys();
                HashMap hashMap = new HashMap();
                while (keys.hasNext()) {
                    String next = keys.next();
                    hashMap.put(next, jSONObject.get(next));
                }
                return hashMap;
            } catch (Exception e2) {
                e2.printStackTrace();
                return new HashMap();
            }
        }

        private long p(HttpURLConnection httpURLConnection) {
            List<String> list;
            String str;
            long contentLength = httpURLConnection.getContentLength();
            return (contentLength >= 0 || (list = httpURLConnection.getHeaderFields().get("content-Length")) == null || list.isEmpty() || (str = list.get(0)) == null) ? contentLength : Long.parseLong(str, 10);
        }

        private void q() {
            com.example.r_upgrade.common.c.b().a("r_upgrade.Service", "handlerDownloadCancel: ");
            l();
            Intent intent = new Intent();
            intent.setAction("com.example.r_upgrade.DOWNLOAD_STATUS");
            intent.putExtra("id", this.f150e);
            intent.putExtra("apk_name", this.f152g);
            intent.putExtra("path", this.m.getPath());
            intent.putExtra("status", com.example.r_upgrade.common.b.STATUS_CANCEL.a());
            intent.putExtra("packages", this.f153h.getPackageName());
            this.f153h.sendBroadcast(intent);
            this.n.b(this.f150e.longValue());
        }

        private void r() {
            com.example.r_upgrade.common.c.b().a("r_upgrade.Service", "handlerDownloadFailure: failure");
            Intent intent = new Intent("com.example.r_upgrade.DOWNLOAD_STATUS");
            intent.putExtra("id", this.f150e);
            intent.putExtra("apk_name", this.f152g);
            intent.putExtra("path", this.m.getPath());
            com.example.r_upgrade.common.b bVar = com.example.r_upgrade.common.b.STATUS_FAILED;
            intent.putExtra("status", bVar.a());
            this.n.h(this.f150e.longValue(), null, null, bVar.a());
            intent.putExtra("packages", this.f153h.getPackageName());
            this.f153h.sendBroadcast(intent);
        }

        /* JADX INFO: Access modifiers changed from: private */
        public void s() {
            com.example.r_upgrade.common.c.b().a("r_upgrade.Service", "handlerDownloadFinish: finish");
            l();
            Intent intent = new Intent();
            intent.setAction("com.example.r_upgrade.DOWNLOAD_STATUS");
            intent.putExtra("id", this.f150e);
            intent.putExtra("apk_name", this.f152g);
            intent.putExtra("path", this.m.getPath());
            com.example.r_upgrade.common.b bVar = com.example.r_upgrade.common.b.STATUS_SUCCESSFUL;
            intent.putExtra("status", bVar.a());
            intent.putExtra("packages", this.f153h.getPackageName());
            this.f153h.sendBroadcast(intent);
            this.n.h(this.f150e.longValue(), null, null, bVar.a());
            this.k = 0L;
            this.u = true;
        }

        /* JADX INFO: Access modifiers changed from: private */
        public void t() {
            com.example.r_upgrade.common.c b = com.example.r_upgrade.common.c.b();
            b.a("r_upgrade.Service", "handlerDownloadPause: downloadFile:" + this.m);
            l();
            Intent intent = new Intent();
            intent.setAction("com.example.r_upgrade.DOWNLOAD_STATUS");
            intent.putExtra("id", this.f150e);
            intent.putExtra("apk_name", this.f152g);
            File file = this.m;
            if (file != null) {
                intent.putExtra("path", file.getPath());
            }
            com.example.r_upgrade.common.b bVar = com.example.r_upgrade.common.b.STATUS_PAUSED;
            intent.putExtra("status", bVar.a());
            UpgradeService upgradeService = this.f153h;
            if (upgradeService != null) {
                intent.putExtra("packages", upgradeService.getPackageName());
                this.f153h.sendBroadcast(intent);
            }
            g gVar = this.n;
            if (gVar != null) {
                gVar.h(this.f150e.longValue(), Long.valueOf(this.f155j), Long.valueOf(this.f154i), bVar.a());
            }
        }

        private boolean u() {
            JSONObject jSONObject;
            boolean z = true;
            if (!this.s) {
                this.m = new File(m().getPath(), this.f152g);
                jSONObject = this.f151f != null ? new JSONObject(this.f151f) : null;
                this.n.i(this.f150e.longValue(), this.f149d, this.m.getPath(), this.f152g, jSONObject != null ? jSONObject.toString() : "", Long.valueOf(this.f155j), Long.valueOf(this.f154i), com.example.r_upgrade.common.b.STATUS_PENDING.a());
                return true;
            }
            Cursor rawQuery = this.n.getReadableDatabase().rawQuery("select * from version_manager where id=?", new String[]{String.valueOf(this.f150e)});
            if (!rawQuery.moveToNext()) {
                File m = m();
                if (!m.exists()) {
                    m.mkdir();
                }
                this.m = new File(m.getPath(), this.f152g);
                jSONObject = this.f151f != null ? new JSONObject(this.f151f) : null;
                this.n.i(this.f150e.longValue(), this.f149d, this.m.getPath(), this.f152g, jSONObject != null ? jSONObject.toString() : "", Long.valueOf(this.f155j), Long.valueOf(this.f154i), com.example.r_upgrade.common.b.STATUS_PENDING.a());
                rawQuery.close();
                return true;
            }
            File file = new File(rawQuery.getString(rawQuery.getColumnIndex("path")));
            this.m = file;
            if (file.exists()) {
                long j2 = rawQuery.getLong(rawQuery.getColumnIndex("current_length"));
                this.f155j = j2;
                this.k = j2;
                this.f154i = rawQuery.getLong(rawQuery.getColumnIndex("max_length"));
                z = false;
            } else {
                try {
                    boolean createNewFile = this.m.createNewFile();
                    com.example.r_upgrade.common.c b = com.example.r_upgrade.common.c.b();
                    b.a("r_upgrade.Service", "handlerDownloadPending: download file create " + createNewFile);
                } catch (IOException e2) {
                    e2.printStackTrace();
                }
                this.f155j = 0L;
                this.k = 0L;
            }
            this.f152g = rawQuery.getString(rawQuery.getColumnIndex("apk_name"));
            this.f149d = rawQuery.getString(rawQuery.getColumnIndex("url"));
            this.f151f = o(rawQuery.getString(rawQuery.getColumnIndex("header")));
            rawQuery.close();
            this.n.h(this.f150e.longValue(), Long.valueOf(this.f155j), Long.valueOf(this.f154i), com.example.r_upgrade.common.b.STATUS_PENDING.a());
            return z;
        }

        /* JADX INFO: Access modifiers changed from: private */
        public void v() {
            double d2;
            try {
                if (this.f155j - this.k > 0) {
                    double doubleValue = new BigDecimal(((((float) this.f155j) * 1.0f) / ((float) this.f154i)) * 100.0f).setScale(2, 4).doubleValue();
                    double currentTimeMillis = ((((float) (this.f155j - this.k)) * 1000.0f) / ((float) (System.currentTimeMillis() - this.l))) / 1024.0f;
                    Intent intent = new Intent();
                    intent.setAction("com.example.r_upgrade.DOWNLOAD_STATUS");
                    intent.putExtra("current_length", this.f155j);
                    com.example.r_upgrade.common.b bVar = com.example.r_upgrade.common.b.STATUS_RUNNING;
                    intent.putExtra("status", bVar.a());
                    intent.putExtra("percent", doubleValue);
                    intent.putExtra("max_length", this.f154i);
                    intent.putExtra("speed", currentTimeMillis);
                    intent.putExtra("plan_time", (this.f154i - this.f155j) / (1024.0d * currentTimeMillis));
                    intent.putExtra("path", this.m.getPath());
                    intent.putExtra("id", this.f150e);
                    intent.putExtra("apk_name", this.f152g);
                    intent.putExtra("packages", this.f153h.getPackageName());
                    this.f153h.sendBroadcast(intent);
                    this.n.h(this.f150e.longValue(), Long.valueOf(this.f155j), Long.valueOf(this.f154i), bVar.a());
                    com.example.r_upgrade.common.c.b().a("r_upgrade.Service", "handlerDownloadRunning: running queryTask: 下载中\nurl: " + this.f149d + "\n============>total:" + this.f154i + "，progress:" + this.f155j + "，" + String.format("%.2f", Double.valueOf(doubleValue)) + "% , " + String.format("%.2f", Double.valueOf(currentTimeMillis)) + "kb/s , 预计：" + String.format("%.0f", Double.valueOf(d2)) + "s");
                    this.k = this.f155j;
                    this.l = System.currentTimeMillis();
                }
            } catch (NumberFormatException e2) {
                e2.printStackTrace();
            }
        }

        /* JADX INFO: Access modifiers changed from: private */
        public void w(int i2) {
            if (this.u) {
                return;
            }
            if (i2 == -1 || this.f150e.longValue() == i2) {
                HttpsURLConnection httpsURLConnection = this.p;
                if (httpsURLConnection != null) {
                    httpsURLConnection.disconnect();
                }
                HttpURLConnection httpURLConnection = this.o;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                this.r = false;
                t();
            }
        }

        /* JADX WARN: Removed duplicated region for block: B:69:0x00ff  */
        /* JADX WARN: Removed duplicated region for block: B:71:0x00d5 A[EXC_TOP_SPLITTER, SYNTHETIC] */
        /* JADX WARN: Removed duplicated region for block: B:74:0x00df A[EXC_TOP_SPLITTER, SYNTHETIC] */
        /* JADX WARN: Removed duplicated region for block: B:77:0x00e9 A[EXC_TOP_SPLITTER, SYNTHETIC] */
        /* JADX WARN: Removed duplicated region for block: B:88:? A[RETURN, SYNTHETIC] */
        @Override // java.lang.Runnable
        /*
            Code decompiled incorrectly, please refer to instructions dump.
        */
        public void run() {
            RandomAccessFile randomAccessFile;
            Exception e2;
            FileOutputStream fileOutputStream;
            this.t = u();
            if (!this.m.exists() && !this.t) {
                this.t = true;
                this.f155j = 0L;
            }
            Timer timer = new Timer();
            this.q = timer;
            timer.schedule(new a(), 500L, 500L);
            InputStream inputStream = null;
            try {
                if (this.t) {
                    if (this.m.exists()) {
                        this.m.delete();
                    }
                    this.m.createNewFile();
                    fileOutputStream = new FileOutputStream(this.m);
                    randomAccessFile = null;
                } else {
                    RandomAccessFile randomAccessFile2 = new RandomAccessFile(this.m, "rwd");
                    try {
                        randomAccessFile2.seek(this.f155j);
                        randomAccessFile = randomAccessFile2;
                        fileOutputStream = null;
                    } catch (Exception e3) {
                        e2 = e3;
                        randomAccessFile = randomAccessFile2;
                        fileOutputStream = null;
                        this.q.cancel();
                        e2.printStackTrace();
                        if (0 != 0) {
                        }
                        if (fileOutputStream != null) {
                        }
                        if (randomAccessFile != null) {
                        }
                        try {
                            Thread.sleep(1000L);
                        } catch (InterruptedException e4) {
                            e4.printStackTrace();
                        }
                        if (this.r) {
                        }
                    }
                }
                try {
                    InputStream n = n(this.f149d);
                    if (n == null) {
                        r();
                        return;
                    }
                    com.example.r_upgrade.common.c.b().a("r_upgrade.Service", "run: maxLength:" + this.f154i);
                    byte[] bArr = new byte[1024];
                    while (true) {
                        int read = n.read(bArr);
                        if (read == -1 || !this.r) {
                            break;
                        }
                        if (this.t) {
                            fileOutputStream.write(bArr, 0, read);
                        } else {
                            randomAccessFile.write(bArr, 0, read);
                        }
                        this.f155j += read;
                    }
                    if (this.t) {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    } else {
                        randomAccessFile.close();
                    }
                    n.close();
                    if (this.r) {
                        s();
                    }
                } catch (Exception e5) {
                    e2 = e5;
                    this.q.cancel();
                    e2.printStackTrace();
                    if (0 != 0) {
                        try {
                            inputStream.close();
                        } catch (IOException e6) {
                            e6.printStackTrace();
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        } catch (IOException e7) {
                            e7.printStackTrace();
                        }
                    }
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        } catch (IOException e8) {
                            e8.printStackTrace();
                        }
                    }
                    Thread.sleep(1000L);
                    if (this.r) {
                        return;
                    }
                    r();
                }
            } catch (Exception e9) {
                randomAccessFile = null;
                e2 = e9;
                fileOutputStream = null;
            }
        }
    }

    private Map<String, Object> g(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(str);
            Iterator<String> keys = jSONObject.keys();
            HashMap hashMap = new HashMap();
            while (keys.hasNext()) {
                String next = keys.next();
                hashMap.put(next, jSONObject.get(next));
            }
            return hashMap;
        } catch (Exception e2) {
            e2.printStackTrace();
            return new HashMap();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void h(boolean z) {
        c cVar = this.c;
        if (cVar == null || cVar.u) {
            return;
        }
        if (z) {
            com.example.r_upgrade.common.c.b().a("r_upgrade.Service", "onReceive: 当前网络正在连接");
            if (this.f146e) {
                this.f146e = false;
                return;
            }
            c cVar2 = new c(true, Long.valueOf(this.c.f150e.longValue()), this.c.f149d, this.c.f151f, this.c.f152g, this.f145d, this.b);
            this.c = cVar2;
            this.a.execute(cVar2);
        } else if (this.f146e) {
            this.f146e = false;
        } else {
            this.c.s();
            this.c.w(-1);
            this.f146e = false;
            com.example.r_upgrade.common.c.b().a("r_upgrade.Service", "onReceive: 当前网络已断开");
        }
    }

    @Override // android.app.Service
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override // android.app.Service
    public void onCreate() {
        super.onCreate();
        this.f145d = this;
        this.b = g.c(this);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.example.r_upgrade.RECEIVER_CANCEL");
        intentFilter.addAction("com.example.r_upgrade.RECEIVER_RESTART");
        intentFilter.addAction("com.example.r_upgrade.RECEIVER_PAUSE");
        if (Build.VERSION.SDK_INT >= 24) {
            b bVar = new b();
            this.f148g = bVar;
            ((ConnectivityManager) getSystemService("connectivity")).registerDefaultNetworkCallback(bVar);
        } else {
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        }
        registerReceiver(this.f147f, intentFilter);
    }

    @Override // android.app.Service
    public void onDestroy() {
        unregisterReceiver(this.f147f);
        c cVar = this.c;
        if (cVar != null) {
            cVar.t();
        }
        super.onDestroy();
    }

    @Override // android.app.Service
    public int onStartCommand(Intent intent, int i2, int i3) {
        if (intent == null) {
            intent = null;
        } else {
            Bundle extras = intent.getExtras();
            String string = extras.getString("download_url");
            int i4 = extras.getInt("download_id");
            Map<String, Object> g2 = (extras.get("download_header") == null || !(extras.get("download_header") instanceof String)) ? (Map) extras.getSerializable("download_header") : g(extras.getString("download_header"));
            c cVar = new c(extras.getBoolean("download_restart"), Long.valueOf(i4), string, g2, extras.getString("download_apkName"), this.f145d, this.b);
            this.c = cVar;
            this.a.execute(cVar);
        }
        return super.onStartCommand(intent, i2, i3);
    }
}
