package androidx.core.graphics.drawable;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Shader;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.versionedparcelable.CustomVersionedParcelable;
import androidx.window.R;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
/* loaded from: classes.dex */
public class IconCompat extends CustomVersionedParcelable {
    static final PorterDuff.Mode k = PorterDuff.Mode.SRC_IN;
    public int a;
    Object b;
    public byte[] c;

    /* renamed from: d  reason: collision with root package name */
    public Parcelable f93d;

    /* renamed from: e  reason: collision with root package name */
    public int f94e;

    /* renamed from: f  reason: collision with root package name */
    public int f95f;

    /* renamed from: g  reason: collision with root package name */
    public ColorStateList f96g;

    /* renamed from: h  reason: collision with root package name */
    PorterDuff.Mode f97h;

    /* renamed from: i  reason: collision with root package name */
    public String f98i;

    /* renamed from: j  reason: collision with root package name */
    public String f99j;

    public IconCompat() {
        this.a = -1;
        this.c = null;
        this.f93d = null;
        this.f94e = 0;
        this.f95f = 0;
        this.f96g = null;
        this.f97h = k;
        this.f98i = null;
    }

    private IconCompat(int i2) {
        this.a = -1;
        this.c = null;
        this.f93d = null;
        this.f94e = 0;
        this.f95f = 0;
        this.f96g = null;
        this.f97h = k;
        this.f98i = null;
        this.a = i2;
    }

    static Bitmap a(Bitmap bitmap, boolean z) {
        int min = (int) (Math.min(bitmap.getWidth(), bitmap.getHeight()) * 0.6666667f);
        Bitmap createBitmap = Bitmap.createBitmap(min, min, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(createBitmap);
        Paint paint = new Paint(3);
        float f2 = min;
        float f3 = 0.5f * f2;
        float f4 = 0.9166667f * f3;
        if (z) {
            float f5 = 0.010416667f * f2;
            paint.setColor(0);
            paint.setShadowLayer(f5, 0.0f, f2 * 0.020833334f, 1023410176);
            canvas.drawCircle(f3, f3, f4, paint);
            paint.setShadowLayer(f5, 0.0f, 0.0f, 503316480);
            canvas.drawCircle(f3, f3, f4, paint);
            paint.clearShadowLayer();
        }
        paint.setColor(-16777216);
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        BitmapShader bitmapShader = new BitmapShader(bitmap, tileMode, tileMode);
        Matrix matrix = new Matrix();
        matrix.setTranslate((-(bitmap.getWidth() - min)) / 2, (-(bitmap.getHeight() - min)) / 2);
        bitmapShader.setLocalMatrix(matrix);
        paint.setShader(bitmapShader);
        canvas.drawCircle(f3, f3, f4, paint);
        canvas.setBitmap(null);
        return createBitmap;
    }

    public static IconCompat b(Resources resources, String str, int i2) {
        if (str != null) {
            if (i2 != 0) {
                IconCompat iconCompat = new IconCompat(2);
                iconCompat.f94e = i2;
                if (resources != null) {
                    try {
                        iconCompat.b = resources.getResourceName(i2);
                    } catch (Resources.NotFoundException unused) {
                        throw new IllegalArgumentException("Icon resource cannot be found");
                    }
                } else {
                    iconCompat.b = str;
                }
                iconCompat.f99j = str;
                return iconCompat;
            }
            throw new IllegalArgumentException("Drawable resource ID must not be 0");
        }
        throw new IllegalArgumentException("Package must not be null.");
    }

    private static int d(Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getResId();
        }
        try {
            return ((Integer) icon.getClass().getMethod("getResId", new Class[0]).invoke(icon, new Object[0])).intValue();
        } catch (IllegalAccessException e2) {
            Log.e("IconCompat", "Unable to get icon resource", e2);
            return 0;
        } catch (NoSuchMethodException e3) {
            Log.e("IconCompat", "Unable to get icon resource", e3);
            return 0;
        } catch (InvocationTargetException e4) {
            Log.e("IconCompat", "Unable to get icon resource", e4);
            return 0;
        }
    }

    private static String f(Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getResPackage();
        }
        try {
            return (String) icon.getClass().getMethod("getResPackage", new Class[0]).invoke(icon, new Object[0]);
        } catch (IllegalAccessException e2) {
            Log.e("IconCompat", "Unable to get icon package", e2);
            return null;
        } catch (NoSuchMethodException e3) {
            Log.e("IconCompat", "Unable to get icon package", e3);
            return null;
        } catch (InvocationTargetException e4) {
            Log.e("IconCompat", "Unable to get icon package", e4);
            return null;
        }
    }

    private static Uri h(Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getUri();
        }
        try {
            return (Uri) icon.getClass().getMethod("getUri", new Class[0]).invoke(icon, new Object[0]);
        } catch (IllegalAccessException e2) {
            Log.e("IconCompat", "Unable to get icon uri", e2);
            return null;
        } catch (NoSuchMethodException e3) {
            Log.e("IconCompat", "Unable to get icon uri", e3);
            return null;
        } catch (InvocationTargetException e4) {
            Log.e("IconCompat", "Unable to get icon uri", e4);
            return null;
        }
    }

    private static String n(int i2) {
        switch (i2) {
            case 1:
                return "BITMAP";
            case 2:
                return "RESOURCE";
            case 3:
                return "DATA";
            case 4:
                return "URI";
            case R.styleable.SplitPairRule_splitMinWidth /* 5 */:
                return "BITMAP_MASKABLE";
            case R.styleable.SplitPairRule_splitRatio /* 6 */:
                return "URI_MASKABLE";
            default:
                return "UNKNOWN";
        }
    }

    public int c() {
        int i2 = this.a;
        if (i2 != -1 || Build.VERSION.SDK_INT < 23) {
            if (i2 == 2) {
                return this.f94e;
            }
            throw new IllegalStateException("called getResId() on " + this);
        }
        return d((Icon) this.b);
    }

    public String e() {
        int i2 = this.a;
        if (i2 != -1 || Build.VERSION.SDK_INT < 23) {
            if (i2 == 2) {
                return TextUtils.isEmpty(this.f99j) ? ((String) this.b).split(":", -1)[0] : this.f99j;
            }
            throw new IllegalStateException("called getResPackage() on " + this);
        }
        return f((Icon) this.b);
    }

    public Uri g() {
        int i2 = this.a;
        if (i2 != -1 || Build.VERSION.SDK_INT < 23) {
            if (i2 == 4 || i2 == 6) {
                return Uri.parse((String) this.b);
            }
            throw new IllegalStateException("called getUri() on " + this);
        }
        return h((Icon) this.b);
    }

    public InputStream i(Context context) {
        StringBuilder sb;
        String str;
        Uri g2 = g();
        String scheme = g2.getScheme();
        if ("content".equals(scheme) || "file".equals(scheme)) {
            try {
                return context.getContentResolver().openInputStream(g2);
            } catch (Exception e2) {
                e = e2;
                sb = new StringBuilder();
                str = "Unable to load image from URI: ";
            }
        } else {
            try {
                return new FileInputStream(new File((String) this.b));
            } catch (FileNotFoundException e3) {
                e = e3;
                sb = new StringBuilder();
                str = "Unable to load image from path: ";
            }
        }
        sb.append(str);
        sb.append(g2);
        Log.w("IconCompat", sb.toString(), e);
        return null;
    }

    public void j() {
        Parcelable parcelable;
        this.f97h = PorterDuff.Mode.valueOf(this.f98i);
        switch (this.a) {
            case -1:
                parcelable = this.f93d;
                if (parcelable == null) {
                    throw new IllegalArgumentException("Invalid icon");
                }
                break;
            case 0:
            default:
                return;
            case 1:
            case R.styleable.SplitPairRule_splitMinWidth /* 5 */:
                parcelable = this.f93d;
                if (parcelable == null) {
                    byte[] bArr = this.c;
                    this.b = bArr;
                    this.a = 3;
                    this.f94e = 0;
                    this.f95f = bArr.length;
                    return;
                }
                break;
            case 2:
            case 4:
            case R.styleable.SplitPairRule_splitRatio /* 6 */:
                String str = new String(this.c, Charset.forName("UTF-16"));
                this.b = str;
                if (this.a == 2 && this.f99j == null) {
                    this.f99j = str.split(":", -1)[0];
                    return;
                }
                return;
            case 3:
                this.b = this.c;
                return;
        }
        this.b = parcelable;
    }

    public void k(boolean z) {
        this.f98i = this.f97h.name();
        switch (this.a) {
            case -1:
                if (z) {
                    throw new IllegalArgumentException("Can't serialize Icon created with IconCompat#createFromIcon");
                }
                break;
            case 0:
            default:
                return;
            case 1:
            case R.styleable.SplitPairRule_splitMinWidth /* 5 */:
                if (z) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ((Bitmap) this.b).compress(Bitmap.CompressFormat.PNG, 90, byteArrayOutputStream);
                    this.c = byteArrayOutputStream.toByteArray();
                    return;
                }
                break;
            case 2:
                this.c = ((String) this.b).getBytes(Charset.forName("UTF-16"));
                return;
            case 3:
                this.c = (byte[]) this.b;
                return;
            case 4:
            case R.styleable.SplitPairRule_splitRatio /* 6 */:
                this.c = this.b.toString().getBytes(Charset.forName("UTF-16"));
                return;
        }
        this.f93d = (Parcelable) this.b;
    }

    @Deprecated
    public Icon l() {
        return m(null);
    }

    /* JADX WARN: Code restructure failed: missing block: B:13:0x002c, code lost:
        if (r0 >= 26) goto L23;
     */
    /* JADX WARN: Code restructure failed: missing block: B:20:0x0069, code lost:
        if (r0 >= 26) goto L23;
     */
    /* JADX WARN: Code restructure failed: missing block: B:21:0x006b, code lost:
        r5 = android.graphics.drawable.Icon.createWithAdaptiveBitmap(r5);
     */
    /* JADX WARN: Code restructure failed: missing block: B:22:0x0070, code lost:
        r5 = a(r5, false);
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public Icon m(Context context) {
        Icon createWithResource;
        Bitmap bitmap;
        int i2 = Build.VERSION.SDK_INT;
        switch (this.a) {
            case -1:
                return (Icon) this.b;
            case 0:
            default:
                throw new IllegalArgumentException("Unknown type");
            case 1:
                Bitmap bitmap2 = (Bitmap) this.b;
                createWithResource = Icon.createWithBitmap(bitmap2);
                break;
            case 2:
                createWithResource = Icon.createWithResource(e(), this.f94e);
                break;
            case 3:
                createWithResource = Icon.createWithData((byte[]) this.b, this.f94e, this.f95f);
                break;
            case 4:
                createWithResource = Icon.createWithContentUri((String) this.b);
                break;
            case R.styleable.SplitPairRule_splitMinWidth /* 5 */:
                bitmap = (Bitmap) this.b;
                break;
            case R.styleable.SplitPairRule_splitRatio /* 6 */:
                if (i2 >= 30) {
                    createWithResource = Icon.createWithAdaptiveBitmapContentUri(g());
                    break;
                } else if (context == null) {
                    throw new IllegalArgumentException("Context is required to resolve the file uri of the icon: " + g());
                } else {
                    InputStream i3 = i(context);
                    if (i3 == null) {
                        throw new IllegalStateException("Cannot load adaptive icon from uri: " + g());
                    }
                    bitmap = BitmapFactory.decodeStream(i3);
                    break;
                }
        }
        ColorStateList colorStateList = this.f96g;
        if (colorStateList != null) {
            createWithResource.setTintList(colorStateList);
        }
        PorterDuff.Mode mode = this.f97h;
        if (mode != k) {
            createWithResource.setTintMode(mode);
        }
        return createWithResource;
    }

    public String toString() {
        int height;
        if (this.a == -1) {
            return String.valueOf(this.b);
        }
        StringBuilder sb = new StringBuilder("Icon(typ=");
        sb.append(n(this.a));
        switch (this.a) {
            case 1:
            case R.styleable.SplitPairRule_splitMinWidth /* 5 */:
                sb.append(" size=");
                sb.append(((Bitmap) this.b).getWidth());
                sb.append("x");
                height = ((Bitmap) this.b).getHeight();
                sb.append(height);
                break;
            case 2:
                sb.append(" pkg=");
                sb.append(this.f99j);
                sb.append(" id=");
                sb.append(String.format("0x%08x", Integer.valueOf(c())));
                break;
            case 3:
                sb.append(" len=");
                sb.append(this.f94e);
                if (this.f95f != 0) {
                    sb.append(" off=");
                    height = this.f95f;
                    sb.append(height);
                    break;
                }
                break;
            case 4:
            case R.styleable.SplitPairRule_splitRatio /* 6 */:
                sb.append(" uri=");
                sb.append(this.b);
                break;
        }
        if (this.f96g != null) {
            sb.append(" tint=");
            sb.append(this.f96g);
        }
        if (this.f97h != k) {
            sb.append(" mode=");
            sb.append(this.f97h);
        }
        sb.append(")");
        return sb.toString();
    }
}
