package androidx.core.app;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import java.util.Arrays;
/* loaded from: classes.dex */
public class a extends e.c.a.a {
    private static c c;

    /* renamed from: androidx.core.app.a$a  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    class RunnableC0005a implements Runnable {

        /* renamed from: d  reason: collision with root package name */
        final /* synthetic */ String[] f58d;

        /* renamed from: e  reason: collision with root package name */
        final /* synthetic */ Activity f59e;

        /* renamed from: f  reason: collision with root package name */
        final /* synthetic */ int f60f;

        RunnableC0005a(String[] strArr, Activity activity, int i2) {
            this.f58d = strArr;
            this.f59e = activity;
            this.f60f = i2;
        }

        @Override // java.lang.Runnable
        public void run() {
            int[] iArr = new int[this.f58d.length];
            PackageManager packageManager = this.f59e.getPackageManager();
            String packageName = this.f59e.getPackageName();
            int length = this.f58d.length;
            for (int i2 = 0; i2 < length; i2++) {
                iArr[i2] = packageManager.checkPermission(this.f58d[i2], packageName);
            }
            ((b) this.f59e).a(this.f60f, this.f58d, iArr);
        }
    }

    /* loaded from: classes.dex */
    public interface b {
        void a(int i2, String[] strArr, int[] iArr);
    }

    /* loaded from: classes.dex */
    public interface c {
        boolean a(Activity activity, String[] strArr, int i2);
    }

    /* loaded from: classes.dex */
    public interface d {
        void a(int i2);
    }

    public static void f(Activity activity, String[] strArr, int i2) {
        c cVar = c;
        if (cVar == null || !cVar.a(activity, strArr, i2)) {
            for (String str : strArr) {
                if (TextUtils.isEmpty(str)) {
                    throw new IllegalArgumentException("Permission request for permissions " + Arrays.toString(strArr) + " must not contain null or empty values");
                }
            }
            if (Build.VERSION.SDK_INT >= 23) {
                if (activity instanceof d) {
                    ((d) activity).a(i2);
                }
                activity.requestPermissions(strArr, i2);
            } else if (activity instanceof b) {
                new Handler(Looper.getMainLooper()).post(new RunnableC0005a(strArr, activity, i2));
            }
        }
    }

    public static boolean g(Activity activity, String str) {
        if (Build.VERSION.SDK_INT >= 23) {
            return activity.shouldShowRequestPermissionRationale(str);
        }
        return false;
    }
}
