package com.vuplex.webview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.hardware.HardwareBuffer;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.ActionMode;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.Surface;
import android.view.View;
import com.vuplex.webview.WebView;
import com.vuplex.webview.WebView3D;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
/* loaded from: classes.dex */
public class WebView3D extends WebView implements ImageReader.OnImageAvailableListener, SurfaceTexture.OnFrameAvailableListener {
    private static boolean t0;
    private boolean i0;
    private ReentrantReadWriteLock j0;
    private boolean k0;
    private AtomicInteger l0;
    private SurfaceTexture m0;
    private Surface n0;
    private AtomicBoolean o0;
    private Surface p0;
    private ReentrantReadWriteLock q0;
    private boolean r0;
    private ImageReader s0;

    private static native long createVulkanImage(Object obj);

    @Override // com.vuplex.webview.WebView
    protected boolean n() {
        return true;
    }

    @Override // com.vuplex.webview.WebView
    protected boolean o() {
        return true;
    }

    @Override // com.vuplex.webview.WebView
    protected boolean p() {
        return false;
    }

    @Override // com.vuplex.webview.WebView
    public void setScrollbarsEnabled(boolean z) {
    }

    @Override // com.vuplex.webview.WebView
    public void setVisible(boolean z) {
    }

    public WebView3D(String str, int i, int i2, int i3, boolean z, boolean z2, boolean z3, StringAndObjectCallback stringAndObjectCallback, Message message) {
        super(str, 0, 0, i2, i3, stringAndObjectCallback, message);
        this.j0 = new ReentrantReadWriteLock();
        this.l0 = new AtomicInteger(0);
        this.o0 = new AtomicBoolean(true);
        this.q0 = new ReentrantReadWriteLock();
        this.k0 = z;
        this.r0 = z2;
        this.O = z3;
        if (z2) {
            c(i2, i3);
        } else {
            a(i, i2, i3);
        }
    }

    @Override // android.graphics.SurfaceTexture.OnFrameAvailableListener
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        try {
            this.l0.incrementAndGet();
            if (this.k0) {
                return;
            }
            S();
        } catch (Exception e) {
            Log.e(WebView.TAG, "An unexpected exception occurred in onFrameAvailable", e);
        }
    }

    @Override // android.media.ImageReader.OnImageAvailableListener
    public void onImageAvailable(ImageReader imageReader) {
        String unsignedString;
        Image acquireNextImage = imageReader.acquireNextImage();
        if (acquireNextImage == null) {
            return;
        }
        HardwareBuffer hardwareBuffer = acquireNextImage.getHardwareBuffer();
        long createVulkanImage = createVulkanImage(hardwareBuffer);
        acquireNextImage.close();
        hardwareBuffer.close();
        unsignedString = C$r8$backportedMethods$utility$Long$2$toUnsignedStringWithRadix.toUnsignedString(createVulkanImage, 10);
        d("HandleTextureChanged", unsignedString);
    }

    public void render() {
        android.webkit.WebView webView;
        if (t0 && this.o0.get() && (webView = this.L) != null) {
            ((a) webView).a();
        }
        R();
        if ((this.k0 || this.o != null) && !this.r0) {
            S();
        }
    }

    @Override // com.vuplex.webview.WebView
    public void resize(int i, int i2) {
        if (this.r0) {
            c(i, i2);
        } else {
            synchronized (this.m0) {
                this.m0.setDefaultBufferSize(i, i2);
            }
        }
        super.resize(i, i2);
    }

    public static void setForceDrawEnabled(boolean z) {
        if (z) {
            Log.i(WebView.TAG, "Force draw was enabled via AndroidWebView.SetForceDrawEnabled()");
        }
        t0 = z;
    }

    @Override // com.vuplex.webview.WebView
    public void setRenderingEnabled(boolean z) {
        android.webkit.WebView webView;
        this.o0.set(z);
        if (!z || (webView = this.L) == null) {
            return;
        }
        ((a) webView).a();
    }

    public void setSurface(Surface surface) {
        this.q0.writeLock().lock();
        if (surface == null) {
            Log.i(WebView.TAG, "The application called AndroidWebView.SetSurface(null) to revert to the original surface.");
            this.p0 = this.n0;
        } else {
            Log.i(WebView.TAG, "The application called AndroidWebView.SetSurface() to set a custom surface.");
            this.p0 = surface;
        }
        this.q0.writeLock().unlock();
    }

    @Override // com.vuplex.webview.WebView
    protected android.webkit.WebView a() {
        a aVar = new a(WebView.f());
        aVar.setInitialScale(100);
        aVar.setScrollBarSize(0);
        aVar.setVerticalScrollBarEnabled(false);
        aVar.setHorizontalScrollBarEnabled(false);
        aVar.setFilterTouchesWhenObscured(true);
        aVar.setHapticFeedbackEnabled(false);
        if (Build.VERSION.SDK_INT >= 26) {
            aVar.setImportantForAutofill(8);
        }
        return aVar;
    }

    @Override // com.vuplex.webview.WebView
    protected void a(Canvas canvas) {
        ((a) this.L).a(canvas);
    }

    private void a(int i, int i2, int i3) {
        SurfaceTexture surfaceTexture = new SurfaceTexture(i);
        this.m0 = surfaceTexture;
        surfaceTexture.setOnFrameAvailableListener(this);
        this.m0.setDefaultBufferSize(i2, i3);
        this.q0.writeLock().lock();
        Surface surface = new Surface(this.m0);
        this.p0 = surface;
        this.n0 = surface;
        this.q0.writeLock().unlock();
    }

    private void R() {
        final View view = this.o;
        if (view == null) {
            return;
        }
        WebView.a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView3D$U4Jmr2K-EPhjgRqSzMF14phtR2M
            @Override // java.lang.Runnable
            public final void run() {
                WebView3D.this.a(view);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void a(View view) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.q0;
        reentrantReadWriteLock.readLock().lock();
        Surface surface = this.p0;
        reentrantReadWriteLock.readLock().unlock();
        if (surface == null || !this.o0.get()) {
            return;
        }
        try {
            Canvas lockHardwareCanvas = Build.VERSION.SDK_INT >= 23 ? surface.lockHardwareCanvas() : surface.lockCanvas(null);
            lockHardwareCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
            view.draw(lockHardwareCanvas);
            surface.unlockCanvasAndPost(lockHardwareCanvas);
        } catch (Exception e) {
            Log.e(WebView.TAG, "An exception occurred while rendering the fullscreen view.", e);
        }
    }

    private void c(int i, int i2) {
        ImageReader imageReader = this.s0;
        if (imageReader != null) {
            imageReader.setOnImageAvailableListener(null, null);
            this.s0.close();
        }
        if (Build.VERSION.SDK_INT >= 29) {
            this.s0 = ImageReader.newInstance(i, i2, 34, 1, 256L);
        } else {
            this.s0 = ImageReader.newInstance(i, i2, 34, 1);
        }
        this.s0.setOnImageAvailableListener(this, new Handler(Looper.getMainLooper()));
        Surface surface = this.s0.getSurface();
        this.p0 = surface;
        this.n0 = surface;
    }

    @Override // com.vuplex.webview.WebView
    protected boolean m() {
        return WebView.d0 != WebView.l.FALSE;
    }

    private void S() {
        if (this.m0 == null || !this.o0.get()) {
            return;
        }
        int andSet = this.l0.getAndSet(0);
        if (andSet <= 0) {
            return;
        }
        synchronized (this.m0) {
            for (int i = 0; i < andSet; i++) {
                this.m0.updateTexImage();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class a extends android.webkit.WebView {
        @Override // android.view.ViewGroup, android.view.View
        public PointerIcon onResolvePointerIcon(MotionEvent motionEvent, int i) {
            return null;
        }

        @Override // android.view.View
        public ActionMode startActionMode(ActionMode.Callback callback) {
            return null;
        }

        @Override // android.view.View
        public ActionMode startActionMode(ActionMode.Callback callback, int i) {
            return null;
        }

        public a(Context context) {
            super(context);
        }

        public void a(Canvas canvas) {
            super.onDraw(canvas);
        }

        public void a() {
            WebView3D.this.j0.readLock().lock();
            boolean z = WebView3D.this.i0;
            WebView3D.this.j0.readLock().unlock();
            if (z) {
                return;
            }
            WebView.a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView3D$a$XGmJUbp7p1XzRzSREcY2UQqhj7Y
                @Override // java.lang.Runnable
                public final void run() {
                    WebView3D.a.this.b();
                }
            });
        }

        /* JADX INFO: Access modifiers changed from: private */
        public /* synthetic */ void b() {
            WebView3D.this.j0.writeLock().lock();
            WebView3D.this.i0 = true;
            WebView3D.this.j0.writeLock().unlock();
            try {
                onDraw(null);
            } catch (Exception unused) {
            }
            WebView3D.this.j0.writeLock().lock();
            WebView3D.this.i0 = false;
            WebView3D.this.j0.writeLock().unlock();
        }

        @Override // android.webkit.WebView, android.view.View
        protected void onDraw(Canvas canvas) {
            ReentrantReadWriteLock reentrantReadWriteLock = WebView3D.this.q0;
            if (reentrantReadWriteLock == null) {
                return;
            }
            reentrantReadWriteLock.readLock().lock();
            Surface surface = WebView3D.this.p0;
            reentrantReadWriteLock.readLock().unlock();
            if (surface != null && WebView3D.this.o0.get()) {
                try {
                    Canvas lockHardwareCanvas = Build.VERSION.SDK_INT >= 23 ? surface.lockHardwareCanvas() : surface.lockCanvas(null);
                    lockHardwareCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    lockHardwareCanvas.translate(-getScrollX(), -getScrollY());
                    super.onDraw(lockHardwareCanvas);
                    surface.unlockCanvasAndPost(lockHardwareCanvas);
                } catch (Exception unused) {
                }
            }
        }

        @Override // android.view.View
        public boolean onFilterTouchEventForSecurity(MotionEvent motionEvent) {
            if (motionEvent.getPointerId(0) == 1776) {
                return super.onFilterTouchEventForSecurity(motionEvent);
            }
            return false;
        }

        @Override // android.webkit.WebView, android.view.View
        public boolean onHoverEvent(MotionEvent motionEvent) {
            if (motionEvent.getPointerId(0) == 1776) {
                return super.onHoverEvent(motionEvent);
            }
            return false;
        }

        @Override // android.webkit.WebView, android.view.View
        public boolean onTouchEvent(MotionEvent motionEvent) {
            if (motionEvent.getPointerId(0) == 1776) {
                return super.onTouchEvent(motionEvent);
            }
            return false;
        }

        @Override // android.webkit.WebView, android.view.View
        public boolean onGenericMotionEvent(MotionEvent motionEvent) {
            if (motionEvent.getPointerId(0) == 1776) {
                return super.onGenericMotionEvent(motionEvent);
            }
            return false;
        }
    }
}
