package com.vuplex.webview;

import android.app.DownloadManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.net.Uri;
import android.net.http.SslError;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Message;
import android.os.SystemClock;
import android.print.PrintAttributes;
import android.print.VuplexPdfPrinter;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.DownloadListener;
import android.webkit.GeolocationPermissions;
import android.webkit.HttpAuthHandler;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebViewDatabase;
import android.widget.FrameLayout;
import androidx.core.view.InputDeviceCompat;
import com.unity3d.player.UnityPlayer;
import com.unity3d.splash.BuildConfig;
import com.vuplex.webview.b;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
/* loaded from: classes.dex */
public class WebView implements DownloadListener, WebView.FindListener, com.vuplex.webview.g {
    private static boolean P = false;
    private static boolean Q = false;
    private static boolean R = false;
    private static String S = null;
    private static String T = null;
    public static final String TAG = "3D WebView";
    private static boolean U;
    private static boolean V;
    private static String W;
    private static boolean X;
    private static boolean Y;
    private static boolean Z;
    private static boolean a0;
    private static boolean b0;
    private static ViewGroup c0;
    protected static l d0;
    private static Method e0;
    private static final HashMap<String, com.vuplex.webview.d> f0;
    private static boolean g0;
    private static ArrayList<WebView> h0;
    private boolean B;
    private StringAndObjectCallback C;
    private Message E;
    private boolean G;
    private StringAndBooleanDelegateCallback H;
    private StringAndBooleanDelegateCallback I;
    private long J;
    private String K;
    protected android.webkit.WebView L;
    private com.vuplex.webview.f M;
    protected int N;
    protected boolean O;
    private StringAndObjectCallback a;
    private String b;
    private boolean e;
    private boolean f;
    protected boolean h;
    private com.vuplex.webview.b i;
    private BroadcastReceiver j;
    private FileSelectionCallback k;
    private String l;
    private boolean m;
    protected View o;
    private String p;
    protected int q;
    private boolean r;
    private j s;
    private ValueCallback<Uri[]> t;
    private boolean z;
    private String c = "none";
    private int d = 1;
    private boolean g = true;
    private boolean n = true;
    private boolean u = true;
    private boolean v = true;
    private boolean w = true;
    private boolean x = true;
    private NumberFormat y = NumberFormat.getInstance(Locale.ROOT);
    private HashMap<String, JSONObject> A = new HashMap<>();
    private k D = k.LOAD_IN_ORIGINAL_WEBVIEW;
    private float F = 1.0f;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public enum k {
        LOAD_IN_ORIGINAL_WEBVIEW,
        LOAD_IN_NEW_WEBVIEW,
        NOTIFY_WITHOUT_LOADING
    }

    /* JADX INFO: Access modifiers changed from: protected */
    /* loaded from: classes.dex */
    public enum l {
        UNSET,
        TRUE,
        FALSE
    }

    private static native String gtifvs(String str);

    private static native boolean iet(String str);

    protected boolean n() {
        return false;
    }

    protected boolean p() {
        return true;
    }

    public void setRenderingEnabled(boolean z) {
    }

    static {
        System.loadLibrary("VuplexWebViewAndroid");
        Log.i(TAG, String.format("Using Vuplex 3D WebView for Android %s %s", "v4.8", d("6342b0fc-0034-4424-a882-13df9bd2c13e")));
        d0 = l.UNSET;
        f0 = new d();
        g0 = true;
        h0 = new ArrayList<>();
    }

    public WebView(String str, int i2, int i3, int i4, int i5, StringAndObjectCallback stringAndObjectCallback, Message message) {
        if (e("6342b0fc-0034-4424-a882-13df9bd2c13e")) {
            throw new Exception("Your trial of 3D WebView for Android has expired. Please purchase a license to continue using it.");
        }
        this.p = str;
        this.N = i4;
        this.q = i5;
        this.C = stringAndObjectCallback;
        this.E = message;
        q();
        b(i2, i3, i4, i5);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void y() {
        this.L.bringToFront();
    }

    public void bringToFront() {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$ePstBSzzrcw6BSaq7IGDOW-iLsw
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.y();
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void a(BooleanCallback booleanCallback) {
        booleanCallback.callback(this.L.canGoBack());
    }

    public void canGoBack(final BooleanCallback booleanCallback) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$ftU4ihhX4yZdtCEPG6YaxpunC0A
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.a(booleanCallback);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void b(BooleanCallback booleanCallback) {
        booleanCallback.callback(this.L.canGoForward());
    }

    public void canGoForward(final BooleanCallback booleanCallback) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$PeCUstDEOPGIaEHfdu-h-EBjf9k
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.b(booleanCallback);
            }
        });
    }

    public void captureScreenshot(final ByteArrayCallback byteArrayCallback) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$trjmmd3dcsFqkHkpnOcevuswItM
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.a(byteArrayCallback);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void a(ByteArrayCallback byteArrayCallback) {
        Bitmap d2 = d();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        d2.compress(Bitmap.CompressFormat.PNG, 100, byteArrayOutputStream);
        byteArrayCallback.callback(new ByteArrayCallbackResult(byteArrayOutputStream.toByteArray()));
    }

    public static void clearAllData() {
        a($$Lambda$WebView$5cQ9Vg96NjzUvBAoivyEgKSNNc.INSTANCE);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ void z() {
        Context f2 = f();
        WebViewDatabase.getInstance(f2).clearFormData();
        WebStorage.getInstance().deleteAllData();
        if (Build.VERSION.SDK_INT >= 22) {
            CookieManager.getInstance().removeAllCookies(null);
            CookieManager.getInstance().flush();
        } else {
            CookieSyncManager createInstance = CookieSyncManager.createInstance(f2);
            createInstance.startSync();
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.removeAllCookie();
            cookieManager.removeSessionCookie();
            createInstance.stopSync();
            createInstance.sync();
        }
        if (h0.size() > 0) {
            h0.get(0).getNativeWebView().clearCache(true);
        } else {
            V = true;
        }
    }

    public void clearFindMatches() {
        this.l = null;
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$YuDCFSPVieSATlDOL7oibB7fJ-U
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.A();
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void A() {
        this.L.clearMatches();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void B() {
        this.L.clearHistory();
    }

    public void clearHistory() {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$5HXo-LJ74t060vjkb15gmYYvhLQ
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.B();
            }
        });
    }

    public void click(int i2, int i3, boolean z) {
        movePointer(i2, i3, false);
        pointerDown(i2, i3, 0, 1, z);
        pointerUp(i2, i3, 0, 1);
        movePointer(i2, i3, true);
    }

    public void createPdf(final StringCallback stringCallback) {
        final File file = new File(f().getCacheDir().getAbsolutePath(), "/Vuplex.WebView/pdfs");
        final String str = UUID.randomUUID().toString() + ".pdf";
        final VuplexPdfPrinter vuplexPdfPrinter = new VuplexPdfPrinter(new PrintAttributes.Builder().setMediaSize(PrintAttributes.MediaSize.ISO_A4).setResolution(new PrintAttributes.Resolution("pdf", "pdf", 600, 600)).setMinMargins(PrintAttributes.Margins.NO_MARGINS).build());
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$iVp4bYbzB2txhQ7ccE0w-FYrguA
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.a(vuplexPdfPrinter, file, str, stringCallback);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements VuplexPdfPrinter.b {
        final /* synthetic */ StringCallback a;

        a(WebView webView, StringCallback stringCallback) {
            this.a = stringCallback;
        }

        @Override // android.print.VuplexPdfPrinter.b
        public void a(String str) {
            this.a.callback(str);
        }

        @Override // android.print.VuplexPdfPrinter.b
        public void a() {
            this.a.callback(BuildConfig.FLAVOR);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void a(VuplexPdfPrinter vuplexPdfPrinter, File file, String str, StringCallback stringCallback) {
        vuplexPdfPrinter.print(this.L.createPrintDocumentAdapter("PDF Creation"), file, str, new a(this, stringCallback));
    }

    public static void deleteCookies(String str, String str2) {
        Uri parse;
        List<String> b2 = b(str, str2);
        String[] a2 = a(Uri.parse(str));
        HashMap hashMap = new HashMap();
        for (String str3 : a2) {
            hashMap.put(str3, b(parse.getScheme() + "://" + str3, str2));
        }
        for (String str4 : b2) {
            String str5 = null;
            int length = a2.length;
            int i2 = 0;
            while (true) {
                if (i2 >= length) {
                    break;
                }
                String str6 = a2[i2];
                if (((List) hashMap.get(str6)).contains(str4)) {
                    str5 = str6;
                    break;
                }
                i2++;
            }
            String str7 = str4.split("=", 2)[0] + "=";
            if (str5 != null) {
                str7 = str7 + "; domain=" + str5;
            }
            CookieManager.getInstance().setCookie(str, str7);
        }
    }

    public void destroy() {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$b7pvza9tuYS-tedULoWd-69GaIc
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.C();
            }
        });
        com.vuplex.webview.b bVar = this.i;
        if (bVar != null) {
            bVar.c();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void C() {
        h0.remove(this);
        j();
        this.L.destroy();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class b implements ValueCallback<String> {
        final /* synthetic */ StringCallback a;

        b(WebView webView, StringCallback stringCallback) {
            this.a = stringCallback;
        }

        @Override // android.webkit.ValueCallback
        /* renamed from: a */
        public void onReceiveValue(String str) {
            if (str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
                str = str.substring(1, str.length() - 1).replace("\\\"", "\"").replace("\\\\", "\\");
            }
            this.a.callback(str);
        }
    }

    public void executeJavaScript(final String str, StringCallback stringCallback) {
        final b bVar = stringCallback == null ? null : new b(this, stringCallback);
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$nMAbejPsg-m6xFuO7PGpHXLQKJ8
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.a(str, bVar);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void a(String str, ValueCallback valueCallback) {
        this.L.evaluateJavascript(str, valueCallback);
    }

    public void find(final String str, final boolean z) {
        String str2 = this.l;
        if (str2 != null && str2.equals(str)) {
            a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$HsvOyTRruVlRECcPU7O8fptj9ec
                @Override // java.lang.Runnable
                public final void run() {
                    WebView.this.c(z);
                }
            });
            return;
        }
        this.l = str;
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$Cq-s2LTAf1wZmj6BasqLZ3Zu4Ag
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.j(str);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void c(boolean z) {
        this.L.findNext(z);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void j(String str) {
        this.L.findAllAsync(str);
    }

    public void flingScroll(final float f2, final float f3) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$MjfnLOvcKx9ZYAV5RUJhy0Sy4UQ
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.a(f2, f3);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void a(float f2, float f3) {
        this.L.flingScroll((int) (f2 * 30.0f), (int) (f3 * 30.0f));
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ void D() {
        CookieManager.getInstance().flush();
    }

    public static void flushCookies() {
        a($$Lambda$WebView$B6zb6qrIzJxox4TvL04SMBWpc.INSTANCE);
    }

    public static String getCookies(String str, String str2) {
        List<String> b2 = b(str, str2);
        ArrayList arrayList = new ArrayList();
        for (String str3 : b2) {
            String[] split = str3.split("=", 2);
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("Name", split[0]);
                jSONObject.put("Value", split[1]);
                arrayList.add(jSONObject);
            } catch (JSONException e2) {
                Log.e(TAG, "JSONException while creating the cookie object: " + e2);
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("Items", new JSONArray((Collection) arrayList));
        } catch (JSONException e3) {
            Log.e(TAG, "JSONException while creating the cookie response: " + e3);
        }
        return jSONObject2.toString();
    }

    public android.webkit.WebView getNativeWebView() {
        return this.L;
    }

    public void getRawTextureData(final ByteArrayCallback byteArrayCallback) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$ONJBzDenL0QOFFp-3oz4RjKRxXc
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.b(byteArrayCallback);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void b(ByteArrayCallback byteArrayCallback) {
        Bitmap d2 = d();
        Matrix matrix = new Matrix();
        matrix.postScale(1.0f, -1.0f, d2.getWidth() / 2, d2.getHeight() / 2);
        Bitmap createBitmap = Bitmap.createBitmap(d2, 0, 0, d2.getWidth(), d2.getHeight(), matrix, false);
        ByteBuffer allocate = ByteBuffer.allocate(createBitmap.getWidth() * createBitmap.getHeight() * 4);
        createBitmap.copyPixelsToBuffer(allocate);
        byteArrayCallback.callback(new ByteArrayCallbackResult(allocate.array()));
    }

    public static void globallySetUserAgent(boolean z) {
        final String g2 = z ? null : g();
        W = g2;
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$8w3Mj0FkQD1z4H5Vrh0EfDlqoZg
            @Override // java.lang.Runnable
            public final void run() {
                WebView.k(g2);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ void k(String str) {
        Iterator<WebView> it = h0.iterator();
        while (it.hasNext()) {
            it.next().L.getSettings().setUserAgentString(str);
        }
    }

    public static void globallySetUserAgent(final String str) {
        W = str;
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$0pOeigaOVrwt_aCe5m04Ls-66YE
            @Override // java.lang.Runnable
            public final void run() {
                WebView.l(str);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ void l(String str) {
        Iterator<WebView> it = h0.iterator();
        while (it.hasNext()) {
            it.next().L.getSettings().setUserAgentString(str);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void E() {
        this.L.goBack();
    }

    public void goBack() {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$Lo67s5l--ZKaSix_VnUSQmowOR8
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.E();
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void F() {
        this.L.goForward();
    }

    public void goForward() {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$Iv6kuVA97ei7TF9AOz_eSEjALC4
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.F();
            }
        });
    }

    @Override // com.vuplex.webview.g
    public void handleBridgeMessage(String str) {
        try {
            if (str.contains("vuplex.webview.pageTransparencyDetermined")) {
                if (this.g) {
                    b(new JSONObject(str).getBoolean("value"));
                }
            } else {
                a(str);
            }
        } catch (Exception e2) {
            Log.e(TAG, "Exception occurred", e2);
        }
    }

    public static boolean isWebViewAvailable() {
        try {
            android.webkit.WebView.setWebContentsDebuggingEnabled(true);
            return true;
        } catch (Exception e2) {
            return !e2.getMessage().contains("MissingWebViewPackageException");
        }
    }

    public void loadHtml(String str) {
        loadHtml(str, null);
    }

    public void loadHtml(final String str, final String str2) {
        final String replace = str2 == null ? str.replace("%", "%25").replace("#", "%23").replace("\n", "%0A") : str;
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$q9UiIqwTeIMYKyiThF9q_49yblY
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.a(str2, replace, str);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void a(String str, String str2, String str3) {
        if (str == null) {
            this.L.loadData(str2, "text/html; charset=utf-8", "UTF-8");
        } else {
            this.L.loadDataWithBaseURL(str, str3, "text/html; charset=utf-8", "UTF-8", str);
        }
    }

    public void loadUrl(String str) {
        loadUrl(str, null);
    }

    public void loadUrl(String str, final Map<String, String> map) {
        final String i2 = i(str);
        if (g(i2)) {
            loadHtml(com.vuplex.webview.e.a(i2), i2);
        } else {
            a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$1csIB2Cuwvp-B_6NuCgXr19y3ow
                @Override // java.lang.Runnable
                public final void run() {
                    WebView.this.a(map, i2);
                }
            });
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void a(Map map, String str) {
        if (map == null) {
            if (e().startsWith("91.") && !str.startsWith("file:")) {
                c(String.format("window.location = '%s';", str));
                return;
            } else {
                this.L.loadUrl(str);
                return;
            }
        }
        this.L.loadUrl(str, map);
    }

    public void movePointer(int i2, int i3, boolean z) {
        if (z) {
            i2 = 0;
            i3 = 0;
        }
        if (b() && !Q) {
            this.i.a(c(i2), c(i3), "mouseMoved", this.c, 0);
        } else {
            a(this.B ? 2 : 7, i2, i3, this.d);
        }
    }

    @Override // android.webkit.WebView.FindListener
    public void onFindResultReceived(int i2, int i3, boolean z) {
        if (z) {
            d("HandleFindResult", String.format("%d,%d", Integer.valueOf(i3), Integer.valueOf(i2)));
        }
    }

    @Override // android.webkit.DownloadListener
    public void onDownloadStart(String str, String str2, String str3, String str4, long j2) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse(str));
        request.setMimeType(str4);
        request.addRequestHeader("Cookie", CookieManager.getInstance().getCookie(str));
        request.addRequestHeader("User-Agent", str2);
        request.setDescription("Downloading file...");
        String guessFileName = URLUtil.guessFileName(str, str3, str4);
        request.setTitle(guessFileName);
        request.allowScanningByMediaScanner();
        request.setNotificationVisibility(0);
        request.setDestinationInExternalFilesDir(f(), Environment.DIRECTORY_DOWNLOADS, guessFileName);
        String valueOf = String.valueOf(((DownloadManager) f().getSystemService("download")).enqueue(request));
        String str5 = f().getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS) + "/" + guessFileName;
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("ContentType", str4);
            jSONObject.put("FilePath", str5);
            jSONObject.put("Id", valueOf);
            jSONObject.put("Progress", 0);
            jSONObject.put("Type", 0);
            jSONObject.put("Url", str);
            this.A.put(valueOf, jSONObject);
            a(jSONObject);
        } catch (JSONException e2) {
            Log.e(TAG, "An unexpected exception occurred while forming a download message.", e2);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void G() {
        this.L.onPause();
    }

    public void pause() {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$dRInnK4tcqqsZJURs4U8mHe-XO4
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.G();
            }
        });
    }

    public static void pauseAll() {
        Iterator<WebView> it = h0.iterator();
        while (it.hasNext()) {
            it.next().pause();
        }
        a($$Lambda$WebView$GKRJPLGgf4Fr9GoKcDoqtydDLuY.INSTANCE);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ void H() {
        if (h0.size() > 0) {
            h0.get(0).L.pauseTimers();
        }
    }

    public void pointerDown(int i2, int i3, int i4, int i5, boolean z) {
        this.B = true;
        if (!z) {
            a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$hieZoPXzOYc0oABuO13dXl3RZpE
                @Override // java.lang.Runnable
                public final void run() {
                    WebView.this.I();
                }
            });
        }
        if (b() && !Q) {
            int c2 = c(i2);
            int c3 = c(i3);
            String a2 = a(i4);
            this.c = a2;
            this.i.a(c2, c3, "mouseMoved", a2, 0);
            this.i.a(c2, c3, "mousePressed", a2, i5);
            return;
        }
        int b2 = b(i4);
        this.d = b2;
        a(0, i2, i3, b2);
        a(11, i2, i3, this.d);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void I() {
        this.L.requestFocus();
    }

    public void pointerUp(int i2, int i3, int i4, int i5) {
        this.B = false;
        if (b() && !Q) {
            this.i.a(c(i2), c(i3), "mouseReleased", a(i4), i5);
            this.c = "none";
            return;
        }
        a(12, i2, i3, this.d);
        a(1, i2, i3, 0);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void a(String str, byte[] bArr) {
        this.L.postUrl(str, bArr);
    }

    public void postUrl(final String str, final byte[] bArr) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$TIVlu5yN8XXnVRYjQ-G_X9LLdDw
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.a(str, bArr);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void J() {
        this.L.reload();
    }

    public void reload() {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$WQW8c2mkYIUP1EceAr4SbgVsbbE
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.J();
            }
        });
    }

    public void resize(final int i2, final int i3) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$9BZXBwu8ZgkjANRxGEQEpLBjlK8
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.b(i2, i3);
            }
        });
    }

    public void resume() {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$FUfWFL9dpRpVxnMGh-VNe-l2IPQ
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.K();
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void K() {
        this.L.onResume();
        ValueCallback<Uri[]> valueCallback = this.t;
        if (valueCallback != null) {
            valueCallback.onReceiveValue(null);
            this.t = null;
        }
    }

    public static void resumeAll() {
        Iterator<WebView> it = h0.iterator();
        while (it.hasNext()) {
            it.next().resume();
        }
        a($$Lambda$WebView$pCJJrz7UQX4qmP5RhNWBKyQXFo.INSTANCE);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ void L() {
        if (h0.size() > 0) {
            h0.get(0).L.resumeTimers();
        }
    }

    public void scroll(int i2, int i3) {
        this.L.scrollBy(c(i2), c(i3));
    }

    public void scroll(int i2, int i3, int i4, int i5) {
        a(8, i4, i5, 0, i2, i3);
    }

    public void sendKey(String str) {
        boolean z = false;
        if (b() && !P) {
            HashMap<String, com.vuplex.webview.d> hashMap = f0;
            if (hashMap.containsKey(str)) {
                com.vuplex.webview.d dVar = hashMap.get(str);
                this.i.a(0, dVar.d(), dVar.a(), dVar.b(), dVar.c());
                return;
            }
            if (str.length() == 2 && Character.isSurrogatePair(str.charAt(0), str.charAt(1))) {
                z = true;
            }
            if (z) {
                this.i.b(str);
                return;
            } else {
                this.i.a(str);
                return;
            }
        }
        if (str.equals("Enter") || str.equals("\n")) {
            str = "\\n";
        } else if (str.equals("Backspace")) {
            str = "\b";
        } else if (str.equals("\\")) {
            str = "\\\\";
        } else if (str.equals("'")) {
            str = "\\'";
        }
        c(String.format("_vuplexInternal.keyboardInputManager.sendKey('%s');", str));
    }

    public static void setAlternativeKeyboardInputSystemEnabled(boolean z) {
        P = z;
    }

    public static void setAlternativePointerInputSystemEnabled(boolean z) {
        Q = z;
    }

    public void setAuthRequestedHandler(StringAndObjectCallback stringAndObjectCallback) {
        this.a = stringAndObjectCallback;
    }

    public static void setAutoplayEnabled(final boolean z) {
        R = z;
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$sqMXAZCSqoT3KJNhx4inaDniJBU
            @Override // java.lang.Runnable
            public final void run() {
                WebView.d(z);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ void d(boolean z) {
        Iterator<WebView> it = h0.iterator();
        while (it.hasNext()) {
            it.next().L.getSettings().setMediaPlaybackRequiresUserGesture(z);
        }
    }

    public static void setCameraAndMicrophoneEnabled(boolean z) {
        setCameraEnabled(z);
        setMicrophoneEnabled(z);
    }

    public static void setCameraEnabled(boolean z) {
        U = z;
    }

    public void setConsoleMessageEventsEnabled(boolean z) {
        this.e = z;
    }

    public static void setCookie(String str) {
        try {
            JSONObject jSONObject = new JSONObject(str);
            String string = jSONObject.getString("Name");
            String string2 = jSONObject.getString("Value");
            String string3 = jSONObject.getString("Domain");
            if (!string3.startsWith(".")) {
                string3 = "." + string3;
            }
            String string4 = jSONObject.getString("Path");
            boolean z = jSONObject.getBoolean("Secure");
            boolean z2 = jSONObject.getBoolean("HttpOnly");
            long j2 = jSONObject.getLong("ExpirationDate");
            ArrayList arrayList = new ArrayList();
            arrayList.add(String.format("%s=%s", string, string2));
            String str2 = "https://" + string3 + string4;
            if (z) {
                arrayList.add("Secure");
            }
            if (z2) {
                arrayList.add("HttpOnly");
            }
            if (j2 != 0) {
                arrayList.add("Expires=" + new Date(j2 * 1000).toGMTString());
            }
            CookieManager.getInstance().setCookie(str2, TextUtils.join("; ", arrayList));
        } catch (JSONException e2) {
            Log.e(TAG, "A JSONException occurred while setting the cookie: " + e2);
        }
    }

    public void setDeepLinkingEnabled(boolean z) {
        this.f = z;
    }

    public void setDefaultBackgroundEnabled(boolean z) {
        this.g = z;
        b(!z);
        q();
    }

    public void setDownloadsEnabled(final boolean z) {
        if (z == (this.j != null)) {
            return;
        }
        if (z) {
            this.j = new c();
            f().registerReceiver(this.j, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
        } else {
            f().unregisterReceiver(this.j);
            this.j = null;
        }
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$t01A8a62jnes8iei3P7UH7AQzQ0
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.e(z);
            }
        });
    }

    /* loaded from: classes.dex */
    class c extends BroadcastReceiver {
        c() {
        }

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            String valueOf = String.valueOf(intent.getLongExtra("extra_download_id", -1L));
            JSONObject jSONObject = (JSONObject) WebView.this.A.get(valueOf);
            if (jSONObject == null) {
                return;
            }
            WebView.this.A.remove(valueOf);
            try {
                jSONObject.put("Type", 1);
                jSONObject.put("Progress", 1);
                WebView.this.a(jSONObject);
            } catch (JSONException e) {
                Log.e(WebView.TAG, "An unexpected exception occurred while forming a download message.", e);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void e(boolean z) {
        this.L.setDownloadListener(z ? this : null);
    }

    public static void setDrmEnabled(boolean z) {
        X = z;
    }

    public void setFileSelectionHandler(FileSelectionCallback fileSelectionCallback) {
        this.k = fileSelectionCallback;
    }

    public void setFocused(final boolean z) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$zkLvaOvsljaP4aNJTXgx5Mlb4ms
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.f(z);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void f(boolean z) {
        if (z) {
            this.L.requestFocus();
            this.L.evaluateJavascript("_vuplexInternal.focusManager.setFocused(true);", null);
            return;
        }
        this.L.clearFocus();
        this.L.evaluateJavascript("_vuplexInternal.focusManager.setFocused(false);", null);
    }

    public void setFocusedInputFieldEventsEnabled(boolean z) {
        this.m = z;
        q();
    }

    public void setForceDark(final int i2) {
        if (Build.VERSION.SDK_INT >= 29) {
            a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$B8jVdmaujkz7QHLLRzI6wC-VfZw
                @Override // java.lang.Runnable
                public final void run() {
                    WebView.this.d(i2);
                }
            });
        } else {
            Log.w(TAG, "AndroidWebView.SetForceDark() was called but will be ignored because that API is only available on Android API level >= 29.");
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void d(int i2) {
        this.L.getSettings().setForceDark(i2);
    }

    public void setFullscreenEnabled(boolean z) {
        if (this.n == z) {
            return;
        }
        this.n = z;
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$hCPW3vht9ZFlks3kEhIxnFGKt6Q
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.M();
            }
        });
    }

    public static void setGeolocationEnabled(boolean z) {
        Y = z;
    }

    public static void setIgnoreCertificateErrors(boolean z) {
        Z = z;
    }

    public void setInitialScale(float f2) {
        a(f2, false);
    }

    public void setMediaPlaybackRequiresUserGesture(final boolean z) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$s-BdCpSX5BqgofKp89pd5oskJ-I
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.g(z);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void g(boolean z) {
        this.L.getSettings().setMediaPlaybackRequiresUserGesture(z);
    }

    public static void setMicrophoneEnabled(boolean z) {
        a0 = z;
    }

    public static void setMidiSysexEnabled(boolean z) {
        b0 = z;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void e(int i2) {
        this.L.getSettings().setMixedContentMode(i2);
    }

    public void setMixedContentMode(final int i2) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$CRkn-n0pD7EgzlkytMdH2lnW3JU
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.e(i2);
            }
        });
    }

    public void setNativeFileSelectionEnabled(boolean z) {
        this.u = z;
    }

    public void setNativeJavaScriptDialogsEnabled(boolean z) {
        this.v = z;
    }

    public void setNativeOnScreenKeyboardEnabled(final boolean z) {
        this.w = z;
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$bgve_-pJax94jcYGNc4Ti3Ja-Qg
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.h(z);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void h(boolean z) {
        this.L.setFocusable(z);
        this.L.setFocusableInTouchMode(z);
    }

    public static void setNativeParentView(ViewGroup viewGroup) {
        Log.i(TAG, "The application called AndroidWebView.SetNativeParentView() to override the parent view. (This message is logged to aid Vuplex Support.)");
        c0 = viewGroup;
    }

    public void setNativeZoomEnabled(boolean z) {
        this.x = z;
        q();
        if (z) {
            return;
        }
        c("_vuplexInternal.viewportMetaTagManager.overrideViewportMetaTag()");
    }

    public void setPopupMode(int i2) {
        this.D = k.values()[i2];
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$XS_ArVWCvLAM1K1Sk4Jmq-_PG4o
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.N();
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void N() {
        k kVar = this.D;
        this.L.getSettings().setSupportMultipleWindows(kVar == k.LOAD_IN_NEW_WEBVIEW || kVar == k.NOTIFY_WITHOUT_LOADING);
    }

    public void setRect(final int i2, final int i3, final int i4, final int i5) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$sSFL6XxxZGIpLXAPPqRBEFkrWC4
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.c(i2, i3, i4, i5);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void c(int i2, int i3, int i4, int i5) {
        this.L.setX(i2);
        this.L.setY(i3);
        b(i4, i5);
    }

    public static void setRemoteDebuggingEnabled(boolean z) {
        d0 = z ? l.TRUE : l.FALSE;
    }

    public void setScriptAlertHandler(StringAndBooleanDelegateCallback stringAndBooleanDelegateCallback) {
        this.H = stringAndBooleanDelegateCallback;
    }

    public void setScriptConfirmHandler(StringAndBooleanDelegateCallback stringAndBooleanDelegateCallback) {
        this.I = stringAndBooleanDelegateCallback;
    }

    public void setScrollbarsEnabled(boolean z) {
        this.L.setVerticalScrollBarEnabled(z);
        this.L.setHorizontalScrollBarEnabled(z);
    }

    public static void setStorageEnabled(boolean z) {
        g0 = z;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void f(int i2) {
        this.L.getSettings().setTextZoom(i2);
    }

    public void setTextZoom(final int i2) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$xrPaA1p0fHTDhMGrmPooF-Ci6-0
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.f(i2);
            }
        });
    }

    public void setUserAgent(final boolean z) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$jDIDcz0CulOvXiWRtiDykSNiOR4
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.i(z);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void i(boolean z) {
        this.L.getSettings().setUserAgentString(z ? null : g());
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void m(String str) {
        this.L.getSettings().setUserAgentString(str);
    }

    public void setUserAgent(final String str) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$FdJ2EdIQ7oKmToaAsc6-lVlnDN4
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.m(str);
            }
        });
    }

    public void setVisible(final boolean z) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$n612t9kG5jdm_YBhcB7LLeZqL14
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.j(z);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void j(boolean z) {
        if (z) {
            this.L.bringToFront();
            return;
        }
        j();
        a(false);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void O() {
        this.L.stopLoading();
    }

    public void stopLoad() {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$WpfkkxGTC1RrZMH-E9bdlXeWTFA
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.O();
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void a(float f2) {
        this.L.zoomBy(f2);
    }

    public void zoomBy(final float f2) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$KKT4IfCQL2PMrUhwZE8ZzMLjLmQ
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.a(f2);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void P() {
        a(this.F + 0.1f, true);
    }

    public void zoomIn() {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$D2kDJftdGPqC68WTrCjDqK3DbB4
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.P();
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void Q() {
        a(Math.max(this.F - 0.1f, 0.1f), true);
    }

    public void zoomOut() {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$CI21HbCNN35xCbjrfxsWodhfjb0
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.Q();
            }
        });
    }

    /* loaded from: classes.dex */
    private class j {
        public final String a;
        public final String b;

        public j(WebView webView, String str, String str2) {
            this.a = str;
            this.b = str2;
        }
    }

    /* loaded from: classes.dex */
    class d extends HashMap<String, com.vuplex.webview.d> {
        d() {
            put("Alt", new com.vuplex.webview.d("Alt", 18));
            put("Control", new com.vuplex.webview.d("Control", 17));
            put("CapsLock", new com.vuplex.webview.d("CapsLock", 20));
            put("Meta", new com.vuplex.webview.d("Meta", 91));
            put("NumLock", new com.vuplex.webview.d("NumLock", 144));
            put("ScrollLock", new com.vuplex.webview.d("ScrollLock", 145));
            put("Enter", new com.vuplex.webview.d("Enter", 13, "\r"));
            put("Tab", new com.vuplex.webview.d("Tab", 9));
            put("ArrowDown", new com.vuplex.webview.d("ArrowDown", 40));
            put("ArrowLeft", new com.vuplex.webview.d("ArrowLeft", 37));
            put("ArrowRight", new com.vuplex.webview.d("ArrowRight", 39));
            put("ArrowUp", new com.vuplex.webview.d("ArrowUp", 38));
            put("End", new com.vuplex.webview.d("End", 35));
            put("Home", new com.vuplex.webview.d("Home", 36));
            put("PageDown", new com.vuplex.webview.d("PageDown", 34));
            put("PageUp", new com.vuplex.webview.d("PageUp", 33));
            put("Backspace", new com.vuplex.webview.d("Backspace", 8));
            put("Clear", new com.vuplex.webview.d("Clear", 12));
            put("CrSel", new com.vuplex.webview.d("CrSel", 247));
            put("Delete", new com.vuplex.webview.d("Delete", 46));
            put("EraseEof", new com.vuplex.webview.d("EraseEof", 249));
            put("ExSel", new com.vuplex.webview.d("ExSel", 248));
            put("Insert", new com.vuplex.webview.d("Insert", 45));
            put("Accept", new com.vuplex.webview.d("Accept", 30));
            put("Attn", new com.vuplex.webview.d("Attn", 240));
            put("Attn", new com.vuplex.webview.d("Attn", 240));
            put("ContextMenu", new com.vuplex.webview.d("ContextMenu", 93));
            put("Escape", new com.vuplex.webview.d("Escape", 27));
            put("Execute", new com.vuplex.webview.d("Execute", 43));
            put("Finish", new com.vuplex.webview.d("Finish", 241));
            put("Help", new com.vuplex.webview.d("Help", 47));
            put("Pause", new com.vuplex.webview.d("Pause", 19));
            put("Play", new com.vuplex.webview.d("Play", 250));
            put("Select", new com.vuplex.webview.d("Select", 41));
            put("PrintScreen", new com.vuplex.webview.d("PrintScreen", 44));
            put("Standby", new com.vuplex.webview.d("Standby", 95));
            put("Alphanumeric", new com.vuplex.webview.d("Alphanumeric", 240));
            put("Convert", new com.vuplex.webview.d("Convert", 28));
            put("FinalMode", new com.vuplex.webview.d("FinalMode", 24));
            put("ModeChange", new com.vuplex.webview.d("ModeChange", 31));
            put("NonConvert", new com.vuplex.webview.d("NonConvert", 29));
            put("Process", new com.vuplex.webview.d("Process", 229));
            put("F1", new com.vuplex.webview.d("F1", 112));
            put("F2", new com.vuplex.webview.d("F2", 113));
            put("F3", new com.vuplex.webview.d("F3", 114));
            put("F4", new com.vuplex.webview.d("F4", 115));
            put("F5", new com.vuplex.webview.d("F5", 116));
            put("F6", new com.vuplex.webview.d("F6", 117));
            put("F7", new com.vuplex.webview.d("F7", 118));
            put("F8", new com.vuplex.webview.d("F8", 119));
            put("F9", new com.vuplex.webview.d("F9", 120));
            put("F10", new com.vuplex.webview.d("F10", 121));
            put("F11", new com.vuplex.webview.d("F11", 122));
            put("F12", new com.vuplex.webview.d("F12", 123));
            put("F13", new com.vuplex.webview.d("F13", 124));
            put("F14", new com.vuplex.webview.d("F14", 125));
            put("F15", new com.vuplex.webview.d("F15", 126));
            put("F16", new com.vuplex.webview.d("F16", 127));
            put("F17", new com.vuplex.webview.d("F17", 128));
            put("F18", new com.vuplex.webview.d("F18", 129));
            put("F19", new com.vuplex.webview.d("F19", 130));
            put("F20", new com.vuplex.webview.d("F20", 131));
            put("MediaPlayPause", new com.vuplex.webview.d("MediaPlayPause", 179));
            put("MediaStop", new com.vuplex.webview.d("MediaStop", 178));
            put("MediaTrackNext", new com.vuplex.webview.d("MediaTrackNext", 176));
            put("MediaTrackPrevious", new com.vuplex.webview.d("MediaTrackPrevious", 177));
            put("AudioVolumeDown", new com.vuplex.webview.d("AudioVolumeDown", 174));
            put("AudioVolumeMute", new com.vuplex.webview.d("AudioVolumeMute", 173));
            put("AudioVolumeUp", new com.vuplex.webview.d("AudioVolumeUp", 175));
            put("LaunchMail", new com.vuplex.webview.d("LaunchMail", 180));
            put("LaunchMediaPlayer", new com.vuplex.webview.d("LaunchMediaPlayer", 181));
            put("LaunchApplication1", new com.vuplex.webview.d("LaunchApplication1", 182));
            put("LaunchApplication2", new com.vuplex.webview.d("LaunchApplication2", 183));
            put("BrowserBack", new com.vuplex.webview.d("BrowserBack", 166));
            put("BrowserFavorites", new com.vuplex.webview.d("BrowserFavorites", 171));
            put("BrowserForward", new com.vuplex.webview.d("BrowserForward", 167));
            put("BrowserHome", new com.vuplex.webview.d("BrowserHome", 172));
            put("BrowserRefresh", new com.vuplex.webview.d("BrowserRefresh", 168));
            put("BrowserSearch", new com.vuplex.webview.d("BrowserSearch", 170));
            put("BrowserStop", new com.vuplex.webview.d("BrowserStop", 169));
            put("Decimal", new com.vuplex.webview.d("Decimal", 110));
            put("Multiply", new com.vuplex.webview.d("Multiply", 106));
            put("Add", new com.vuplex.webview.d("Add", 107));
            put("Divide", new com.vuplex.webview.d("Divide", 111));
            put("Subtract", new com.vuplex.webview.d("Subtract", 109));
            put("Separator", new com.vuplex.webview.d("Separator", 108));
        }
    }

    private static String d(String str) {
        return gtifvs(str);
    }

    private static boolean e(String str) {
        return iet(str);
    }

    private void a(boolean z) {
        if (this.L.getParent() != null) {
            return;
        }
        h().addView(this.L, 0);
        if (z) {
            this.L.bringToFront();
        }
    }

    private int b(int i2) {
        if (i2 != 0) {
            if (i2 != 1) {
                if (i2 != 2) {
                    Log.w(TAG, "Unrecognized mouse button: " + i2);
                    return 1;
                }
                return 4;
            }
            return 2;
        }
        return 1;
    }

    private String a(int i2) {
        if (i2 != 0) {
            if (i2 != 1) {
                if (i2 != 2) {
                    Log.w(TAG, "Unrecognized mouseButton enum value: " + i2);
                    return "left";
                }
                return "middle";
            }
            return "right";
        }
        return "left";
    }

    protected android.webkit.WebView a() {
        h hVar = new h(this, f());
        hVar.getSettings().setBuiltInZoomControls(true);
        hVar.getSettings().setDisplayZoomControls(false);
        return hVar;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public boolean b() {
        com.vuplex.webview.b bVar = this.i;
        return bVar != null && bVar.f();
    }

    private void a(int i2, int i3, int i4, int i5) {
        a(i2, i3, i4, i5, 0, 0);
    }

    private void a(final int i2, final int i3, final int i4, final int i5, final int i6, final int i7) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$rjI0fV6kJQvM2dPadxXuTwtnvmg
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.b(i2, i3, i4, i6, i7, i5);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void b(int i2, int i3, int i4, int i5, int i6, int i7) {
        int i8;
        float f2;
        if (i2 == 0) {
            this.J = SystemClock.uptimeMillis();
        }
        MotionEvent.PointerProperties pointerProperties = new MotionEvent.PointerProperties();
        pointerProperties.id = 1776;
        pointerProperties.toolType = 3;
        MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
        pointerCoords.x = i3;
        pointerCoords.y = i4;
        pointerCoords.pressure = 1.0f;
        pointerCoords.size = 1.0f;
        if (i2 == 8) {
            float f3 = 176.0f;
            if (Build.VERSION.SDK_INT >= 26) {
                ViewConfiguration viewConfiguration = ViewConfiguration.get(f());
                float scaledVerticalScrollFactor = viewConfiguration.getScaledVerticalScrollFactor();
                i8 = i5;
                f3 = viewConfiguration.getScaledHorizontalScrollFactor();
                f2 = scaledVerticalScrollFactor;
            } else {
                TypedValue typedValue = new TypedValue();
                Context f4 = f();
                if (f4.getTheme().resolveAttribute(16842829, typedValue, true)) {
                    f3 = typedValue.getDimension(f4.getResources().getDisplayMetrics());
                    i8 = i5;
                    f2 = f3;
                } else {
                    i8 = i5;
                    f2 = 176.0f;
                }
            }
            pointerCoords.setAxisValue(10, (-i8) / f3);
            pointerCoords.setAxisValue(9, (-i6) / f2);
        }
        MotionEvent obtain = MotionEvent.obtain(this.J, SystemClock.uptimeMillis(), i2, 1, new MotionEvent.PointerProperties[]{pointerProperties}, new MotionEvent.PointerCoords[]{pointerCoords}, 0, i7, 1.0f, 1.0f, 0, 0, InputDeviceCompat.SOURCE_MOUSE, 0);
        if (i2 == 11 || i2 == 12) {
            a(obtain, i7);
        }
        boolean z = Arrays.binarySearch(new int[]{0, 1, 2}, i2) >= 0;
        View view = this.o;
        if (view == null) {
            view = this.L;
        }
        if (z) {
            view.dispatchTouchEvent(obtain);
        } else {
            view.dispatchGenericMotionEvent(obtain);
        }
    }

    protected void a(Canvas canvas) {
        ((h) this.L).a(canvas);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(JSONObject jSONObject) {
        d("HandleDownloadProgressChanged", jSONObject.toString());
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(String str, String str2) {
        d("HandleLoadFailed", String.format("%s,%s", str, str2));
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void c() {
        h("HandleLoadStarted");
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(String str) {
        d("HandleMessageEmitted", str);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void b(String str) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("Type", "LOAD");
            jSONObject.put("Url", str);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("urlAction", jSONObject);
            jSONObject2.put("type", "vuplex.webview.urlChanged");
            a(jSONObject2.toString());
        } catch (JSONException e2) {
            Log.e(TAG, "An unexpected exception occurred while emitting the UrlChanged event: " + e2);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void c(String str) {
        executeJavaScript(str, null);
    }

    private Bitmap d() {
        Bitmap createBitmap = Bitmap.createBitmap(this.N, this.q, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(createBitmap);
        canvas.translate(-this.L.getScrollX(), -this.L.getScrollY());
        a(canvas);
        return createBitmap;
    }

    static String e() {
        if (S == null) {
            Matcher matcher = Pattern.compile("Chrome/([0-9.]*) ").matcher(WebSettings.getDefaultUserAgent(f()));
            S = matcher.find() ? matcher.group(1) : "110.0.0.0";
        }
        return S;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public static Context f() {
        return UnityPlayer.currentActivity;
    }

    private static List<String> b(String str, String str2) {
        String cookie = CookieManager.getInstance().getCookie(str);
        if (cookie == null) {
            return new ArrayList();
        }
        String[] split = cookie.split("; ");
        if (str2 == null) {
            return Arrays.asList(split);
        }
        ArrayList arrayList = new ArrayList();
        for (String str3 : split) {
            if (str3.startsWith(str2 + "=")) {
                arrayList.add(str3);
            }
        }
        return arrayList;
    }

    static String g() {
        if (T == null) {
            T = String.format("Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36", e());
        }
        return T;
    }

    private static String[] a(Uri uri) {
        String[] split = uri.getHost().split("\\.");
        if (split.length <= 2) {
            return new String[0];
        }
        if (split[0].matches("\\d+")) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        for (int i2 = 1; i2 < split.length - 1; i2++) {
            arrayList.add(0, TextUtils.join(".", (String[]) Arrays.copyOfRange(split, i2, split.length)));
        }
        return (String[]) arrayList.toArray(new String[0]);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static ViewGroup h() {
        ViewGroup viewGroup = c0;
        return viewGroup != null ? viewGroup : (ViewGroup) UnityPlayer.currentActivity.getWindow().getDecorView().getRootView();
    }

    private int c(int i2) {
        return (int) (i2 / this.F);
    }

    void i() {
        String str = "about:blank#" + UUID.randomUUID().toString();
        this.L.loadUrl(str);
        new e(str).execute(new Void[0]);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class e extends AsyncTask<Void, Void, Void> {
        final /* synthetic */ String a;

        e(String str) {
            this.a = str;
        }

        /* JADX INFO: Access modifiers changed from: protected */
        @Override // android.os.AsyncTask
        /* renamed from: a */
        public Void doInBackground(Void... voidArr) {
            try {
                a(null, 100);
            } catch (Exception e) {
                Log.e(WebView.TAG, "An unexpected error occurred while connecting to a page", e);
            }
            return null;
        }

        /* JADX INFO: Access modifiers changed from: private */
        /* JADX WARN: Code restructure failed: missing block: B:11:0x0031, code lost:
            r4.b.i = r1;
         */
        /*
            Code decompiled incorrectly, please refer to instructions dump.
        */
        public void a(com.vuplex.webview.h hVar, int i) {
            if (hVar == null) {
                try {
                    com.vuplex.webview.h hVar2 = new com.vuplex.webview.h();
                    hVar2.b();
                    hVar = hVar2;
                } catch (Exception e) {
                    Log.e(WebView.TAG, "An exception occurred while polling for an unconnected page.", e);
                }
            }
            Iterator<com.vuplex.webview.b> it = hVar.c().iterator();
            while (true) {
                if (!it.hasNext()) {
                    break;
                }
                com.vuplex.webview.b next = it.next();
                if (this.a.equals(next.e()) && !next.f()) {
                    break;
                }
            }
            if (WebView.this.i != null) {
                WebView.this.i.a(new a());
                WebView.this.i.a(new b());
                WebView.this.r = true;
                WebView.this.h("HandleInitFinished");
                if (WebView.this.K != null) {
                    String str = WebView.this.K;
                    WebView.this.K = null;
                    WebView.this.loadUrl(str);
                    return;
                }
                return;
            }
            b(hVar, i);
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class a implements b.d {
            a() {
            }

            @Override // com.vuplex.webview.b.d
            public void a(int i) {
                WebView.this.i.a(i, WebView.this.b);
            }
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class b implements b.c {
            b() {
            }

            @Override // com.vuplex.webview.b.c
            public void a() {
                WebView.this.i.d();
            }
        }

        private void b(com.vuplex.webview.h hVar, int i) {
            if (i <= 1) {
                Log.e(WebView.TAG, "Connecting to the page failed and no connection attempts are remaining.");
            } else {
                new Timer().schedule(new c(i, hVar), 100L);
            }
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class c extends TimerTask {
            final /* synthetic */ int a;
            final /* synthetic */ com.vuplex.webview.h b;

            c(int i, com.vuplex.webview.h hVar) {
                this.a = i;
                this.b = hVar;
            }

            @Override // java.util.TimerTask, java.lang.Runnable
            public void run() {
                Log.d(WebView.TAG, String.format("Couldn't connect to the page. Trying again with %s attempts remaining", Integer.valueOf(this.a)));
                e.this.a(this.b, this.a - 1);
            }
        }
    }

    private void b(final int i2, final int i3, final int i4, final int i5) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$Rano5yo1PZkxWFpp9KwCn5JTP9o
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.a(this, i2, i3, i4, i5);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void a(WebView webView, int i2, int i3, int i4, int i5) {
        boolean m2 = m();
        if (m2) {
            android.webkit.WebView.setWebContentsDebuggingEnabled(true);
        }
        this.L = a();
        h0.add(webView);
        this.L.setX(i2);
        this.L.setY(i3);
        b(i4, i5);
        if (V) {
            this.L.clearCache(true);
            V = false;
        }
        b(true);
        this.L.setFindListener(webView);
        WebSettings settings = this.L.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setUserAgentString(W);
        settings.setAllowUniversalAccessFromFileURLs(true);
        settings.setMixedContentMode(2);
        settings.setAllowFileAccess(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setDomStorageEnabled(g0);
        settings.setAppCacheEnabled(g0);
        settings.setSavePassword(g0);
        settings.setSaveFormData(g0);
        if (!g0) {
            settings.setCacheMode(2);
        }
        CookieManager.getInstance().setAcceptCookie(g0);
        int i6 = Build.VERSION.SDK_INT;
        if (i6 >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies(this.L, g0);
        }
        if (U || a0) {
            settings.setMediaPlaybackRequiresUserGesture(false);
        } else {
            settings.setMediaPlaybackRequiresUserGesture(!R);
        }
        this.L.setWebViewClient(i6 >= 26 ? new n(this, null) : new m(this, null));
        M();
        com.vuplex.webview.f fVar = new com.vuplex.webview.f(webView);
        this.M = fVar;
        this.L.addJavascriptInterface(fVar, "_vuplexBridge");
        a(p());
        boolean z = this.E != null;
        if (!m2) {
            h("HandleInitFinished");
        } else if (z) {
            this.h = true;
        } else {
            i();
        }
        if (z) {
            ((WebView.WebViewTransport) this.E.obj).setWebView(this.L);
            this.E.sendToTarget();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public boolean f(String str) {
        WebBackForwardList copyBackForwardList = this.L.copyBackForwardList();
        int currentIndex = copyBackForwardList.getCurrentIndex();
        return currentIndex > 1 && copyBackForwardList.getItemAtIndex(currentIndex - 1).getUrl().split("#")[0].equals(str.split("#")[0]);
    }

    boolean g(String str) {
        if (str == null) {
            return false;
        }
        try {
            String path = new URL(str).getPath();
            if (path != null) {
                return path.endsWith(".pdf");
            }
            return false;
        } catch (MalformedURLException unused) {
            return false;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void c(String str, String str2) {
        Log.w(TAG, String.format("The web page tried to show a dialog popup using the JavaScript window.%s() API, but 3D WebView is unable to show those native popups when XR is enabled. If you want to display these popups in your application, you can use the AndroidWebView.%s event to achieve that.", str, str2));
    }

    private void j() {
        ViewGroup viewGroup = (ViewGroup) this.L.getParent();
        if (viewGroup != null) {
            viewGroup.removeView(this.L);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* renamed from: a */
    public void b(int i2, int i3) {
        this.N = i2;
        this.q = i3;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(i2, i3);
        layoutParams.setMargins(0, 0, 0, 0);
        this.L.setLayoutParams(layoutParams);
        this.L.measure(View.MeasureSpec.makeMeasureSpec(i2, 1073741824), View.MeasureSpec.makeMeasureSpec(i3, 1073741824));
        if (p()) {
            return;
        }
        k();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void k() {
        View view = this.o;
        if (view == null) {
            return;
        }
        int i2 = this.N;
        int i3 = this.q;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(i2, i3);
        layoutParams.setMargins(0, 0, 0, 0);
        view.setLayoutParams(layoutParams);
        view.measure(View.MeasureSpec.makeMeasureSpec(i2, 1073741824), View.MeasureSpec.makeMeasureSpec(i3, 1073741824));
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public static void a(Runnable runnable) {
        UnityPlayer.currentActivity.runOnUiThread(runnable);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void h(String str) {
        d(str, BuildConfig.FLAVOR);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void d(String str, String str2) {
        UnityPlayer.UnitySendMessage(this.p, str, str2);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public String a(ConsoleMessage.MessageLevel messageLevel) {
        int i2 = f.a[messageLevel.ordinal()];
        return (i2 == 1 || i2 == 2) ? "DEBUG" : i2 != 3 ? i2 != 4 ? "LOG" : "WARNING" : "ERROR";
    }

    private static boolean a(MotionEvent motionEvent, int i2) {
        try {
            if (e0 == null) {
                e0 = MotionEvent.class.getMethod("setActionButton", Integer.TYPE);
            }
            e0.invoke(motionEvent, Integer.valueOf(i2));
            return true;
        } catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
            Log.e(TAG, "Cannot set action button on MotionEvent", e2);
            return false;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* renamed from: l */
    public void M() {
        this.L.setWebChromeClient(this.n ? new i(this, null) : new g(this, null));
    }

    private void b(boolean z) {
        this.L.setBackgroundColor(z ? 0 : -1);
    }

    private void a(final float f2, final boolean z) {
        a(new Runnable() { // from class: com.vuplex.webview.-$$Lambda$WebView$rnhcu2EhMiSOZzHLe5Ko2-0FqC4
            @Override // java.lang.Runnable
            public final void run() {
                WebView.this.b(f2, z);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void b(float f2, boolean z) {
        this.F = f2;
        this.G = z;
        this.L.setInitialScale((int) (f2 * 100.0f));
    }

    protected boolean m() {
        return d0 == l.TRUE;
    }

    protected boolean o() {
        return !this.x;
    }

    private String i(String str) {
        if ((str.startsWith("file:") || str.startsWith("jar:")) && str.contains("!/assets/")) {
            return "file:///android_asset/" + str.substring(str.indexOf("!/assets/") + 9);
        }
        return str;
    }

    private void q() {
        Object[] objArr = new Object[7];
        objArr[0] = "if(typeof Object.assign!=\"function\"){Object.defineProperty(Object,\"assign\",{value:function e(t){\"use strict\";if(t==null){throw new TypeError(\"Cannot convert undefined or null to object\")}var n=Object(t);for(var r=1;r<arguments.length;r++){var i=arguments[r];if(i!=null){for(var o in i){if(Object.prototype.hasOwnProperty.call(i,o)){n[o]=i[o]}}}}return n},writable:true,configurable:true})}var _vuplexSystem;(function(e){var s={};var u={};function t(e,t,n){u[e]={deps:t,factory:n}}e.register=t;function n(e,t){s[e]=t}e.registerExternal=n;function c(e){if(e in s)return s[e];return r(e)}e.require=c;function l(e){var t=c(e);return Promise.resolve(t)}function r(e){if(!(e in u))throw new Error(\"Cannot resolve '\"+e+\"'\");var t=u[e];var n={};s[e]=n;function r(e,t){n[e]=t}var i=t.factory(r,{id:e,import:l});for(var o=0;o<t.deps.length;o++){var a=t.deps[o];i.setters[o](c(a))}i.execute();return n}})(_vuplexSystem||(_vuplexSystem={}));var __extends=this&&this.__extends||function(){var r=function(e,t){r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)if(Object.prototype.hasOwnProperty.call(t,n))e[n]=t[n]};return r(e,t)};return function(e,t){if(typeof t!==\"function\"&&t!==null)throw new TypeError(\"Class extends value \"+String(t)+\" is not a constructor or null\");r(e,t);function n(){this.constructor=e}e.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}();var __awaiter=this&&this.__awaiter||function(e,a,n,s){function u(t){return t instanceof n?t:new n(function(e){e(t)})}return new(n||(n=Promise))(function(t,n){function r(e){try{o(s.next(e))}catch(e){n(e)}}function i(e){try{o(s[\"throw\"](e))}catch(e){n(e)}}function o(e){e.done?t(e.value):u(e.value).then(r,i)}o((s=s.apply(e,a||[])).next())})};var __generator=this&&this.__generator||function(e,n){var r={label:0,sent:function(){if(a[0]&1)throw a[1];return a[1]},trys:[],ops:[]},i,o,a,t;return t={next:s(0),throw:s(1),return:s(2)},typeof Symbol===\"function\"&&(t[Symbol.iterator]=function(){return this}),t;function s(t){return function(e){return u([t,e])}}function u(t){if(i)throw new TypeError(\"Generator is already executing.\");while(r)try{if(i=1,o&&(a=t[0]&2?o[\"return\"]:t[0]?o[\"throw\"]||((a=o[\"return\"])&&a.call(o),0):o.next)&&!(a=a.call(o,t[1])).done)return a;if(o=0,a)t=[t[0]&2,a.value];switch(t[0]){case 0:case 1:a=t;break;case 4:r.label++;return{value:t[1],done:false};case 5:r.label++;o=t[1];t=[0];continue;case 7:t=r.ops.pop();r.trys.pop();continue;default:if(!(a=r.trys,a=a.length>0&&a[a.length-1])&&(t[0]===6||t[0]===2)){r=0;continue}if(t[0]===3&&(!a||t[1]>a[0]&&t[1]<a[3])){r.label=t[1];break}if(t[0]===6&&r.label<a[1]){r.label=a[1];a=t;break}if(a&&r.label<a[2]){r.label=a[2];r.ops.push(t);break}if(a[2])r.ops.pop();r.trys.pop();continue}t=n.call(e,r)}catch(e){t=[6,e];o=0}finally{i=a=0}if(t[0]&5)throw t[1];return{value:t[0]?t[1]:void 0,done:true}}};_vuplexSystem.register(\"utils/EventEmitter\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){n=function(){function e(){this._listeners={}}e.prototype.addListener=function(e,t){if(!this._listeners[e]){this._listeners[e]=[]}if(this._listeners[e].indexOf(t)===-1){this._listeners[e].push(t)}};e.prototype.emit=function(t){var e=[];for(var n=1;n<arguments.length;n++){e[n-1]=arguments[n]}if(!this._listeners[t]){return}for(var r=0,i=this._listeners[t];r<i.length;r++){var o=i[r];try{o.apply(void 0,e)}catch(e){console.error(\"An error occurred while invoking the '\"+t+\"' event handler.\",e)}}};e.prototype.removeListener=function(e,t){if(!this._listeners[e]){return}var n=this._listeners[e].indexOf(t);if(n!==-1){this._listeners[e].splice(n,1)}};return e}();e(\"default\",n)}}});_vuplexSystem.register(\"IBridge\",[],function(e,t){\"use strict\";var n=t&&t.id;return{setters:[],execute:function(){}}});_vuplexSystem.register(\"BaseBridge\",[\"utils/EventEmitter\"],function(e,t){\"use strict\";var n,r;var i=t&&t.id;return{setters:[function(e){n=e}],execute:function(){r=function(){function e(){this._eventEmitter=new n.default;this._eventResponseResolveFunctions={}}e.prototype.addEventListener=function(e,t){this._eventEmitter.addListener(e,t)};e.prototype.removeEventListener=function(e,t){this._eventEmitter.removeListener(e,t)};e.prototype.postMessageWithResponse=function(n){var r=this;var i;do{i=Math.random().toString()}while(i in this._eventResponseResolveFunctions);return new window.Promise(function(e,t){r._eventResponseResolveFunctions[i]=e;n=Object.assign({responseId:i},n);setTimeout(t,1e3);r.postMessage(n)}).then(function(e){delete r._eventResponseResolveFunctions[i];return e}).catch(function(){delete r._eventResponseResolveFunctions[i];throw new Error(\"The native module didn't respond to the event in time.\")})};e.prototype._emit=function(e,t){this._eventEmitter.emit(e,t)};e.prototype._respondToEvent=function(e){var t=e.responseId,n=e.value;var r=this._eventResponseResolveFunctions[t];if(r){r(n)}};return e}();e(\"default\",r)}}});_vuplexSystem.register(\"android/AndroidBridge\",[\"BaseBridge\"],function(e,t){\"use strict\";var n,r;var i=t&&t.id;return{setters:[function(e){n=e}],execute:function(){r=function(e){__extends(t,e);function t(){return e!==null&&e.apply(this,arguments)||this}t.prototype.postMessage=function(e){var t=typeof e===\"string\"?e:JSON.stringify(e);window._vuplexBridge.postMessage(t)};return t}(n.default);e(\"default\",r)}}});_vuplexSystem.register(\"IFrameBridge\",[\"BaseBridge\"],function(e,t){\"use strict\";var n,r;var i=t&&t.id;return{setters:[function(e){n=e}],execute:function(){r=function(e){__extends(t,e);function t(){return e!==null&&e.apply(this,arguments)||this}t.prototype.postMessage=function(e){};return t}(n.default);e(\"default\",r)}}});_vuplexSystem.register(\"MessageType\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){(function(e){e[\"FocusedInputFieldChanged\"]=\"vuplex.webview.focusedInputFieldChanged\";e[\"PageTransparencyDetermined\"]=\"vuplex.webview.pageTransparencyDetermined\";e[\"TitleChanged\"]=\"vuplex.webview.titleChanged\";e[\"TransparencyBlockedWarning\"]=\"vuplex.webview.transparencyBlockedWarning\";e[\"UrlChanged\"]=\"vuplex.webview.urlChanged\"})(n||(n={}));e(\"default\",n)}}});_vuplexSystem.register(\"utils/flattenPrototypes\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(e,t){var n,r;while(t.constructor.name!==\"Object\"){for(var i=0,o=Object.getOwnPropertyNames(t);i<o.length;i++){var a=o[i];var s=Object.getOwnPropertyDescriptor(t,a);if(s.get||s.set){(n=s.get)===null||n===void 0?void 0:n.bind(e);(r=s.set)===null||r===void 0?void 0:r.bind(e)}else{var u=t[a];if(typeof u===\"function\"&&a!==\"constructor\"){e[a]=u.bind(e)}}}t=Object.getPrototypeOf(t)}}e(\"default\",r);return{setters:[],execute:function(){}}});_vuplexSystem.register(\"UrlActionType\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){(function(e){e[\"Load\"]=\"LOAD\";e[\"PushState\"]=\"PUSH_STATE\";e[\"ReplaceState\"]=\"REPLACE_STATE\";e[\"HashChange\"]=\"HASH_CHANGE\"})(n||(n={}));e(\"default\",n)}}});_vuplexSystem.register(\"FocusedInputFieldType\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){(function(e){e[\"Text\"]=\"TEXT\";e[\"IFrame\"]=\"IFRAME\";e[\"None\"]=\"NONE\"})(n||(n={}));e(\"default\",n)}}});_vuplexSystem.register(\"isTextInputOrTextarea\",[],function(e,t){\"use strict\";var r;var n=t&&t.id;function i(e,t){if(e instanceof t.HTMLInputElement){var n=r[e.type.toLowerCase()];return!n}return e instanceof t.HTMLTextAreaElement}e(\"default\",i);return{setters:[],execute:function(){r={button:true,checkbox:true,color:true,file:true,hidden:true,image:true,radio:true,range:true,reset:true,submit:true}}}});_vuplexSystem.register(\"getActiveElement\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(e){return i(e.document.activeElement)}e(\"default\",r);function i(e){if(e===null||e===void 0?void 0:e.shadowRoot){return i(e.shadowRoot.activeElement)}return e}return{setters:[],execute:function(){}}});_vuplexSystem.register(\"focusedElementIsEditable\",[\"isTextInputOrTextarea\",\"getActiveElement\"],function(e,t){\"use strict\";var n,r;var i=t&&t.id;function o(e){var t=r.default(e);return t&&(n.default(t,e)||t.isContentEditable)}e(\"default\",o);return{setters:[function(e){n=e},function(e){r=e}],execute:function(){}}});_vuplexSystem.register(\"checkIfPageBackgroundIsSet\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(e){var t=[e.document.body,e.document.documentElement].filter(function(e){return e});for(var n=0,r=t;n<r.length;n++){var i=r[n];var o=s(e,i);if(o.backgroundIsSet){return o}}return{backgroundIsSet:false}}e(\"default\",r);function a(e,t,n){var r=\"<\"+e.tagName.toLowerCase()+\">\";return\"The page's \"+r+\" element \"+t+' is set to \"'+n+'\".'}function s(e,t){var n=e.getComputedStyle(t);var r=n.background,i=n.backgroundImage,o=n.backgroundColor;if(i!==\"none\"){return{backgroundIsSet:true,details:a(t,\"backgroundImage\",i)}}if(r&&r.indexOf(\"rgba(0, 0, 0, 0) none\")!==0){return{backgroundIsSet:true,details:a(t,\"background\",r)}}if(!(!o||o.indexOf(\"rgba(0, 0, 0, 0)\")===0||o===\"transparent\")){return{backgroundIsSet:true,details:a(t,\"backgroundColor\",o)}}return{backgroundIsSet:false}}return{setters:[],execute:function(){}}});_vuplexSystem.register(\"BrowserAgent\",[\"utils/EventEmitter\",\"IFrameBridge\",\"MessageType\",\"utils/flattenPrototypes\",\"UrlActionType\",\"FocusedInputFieldType\",\"focusedElementIsEditable\",\"getActiveElement\",\"checkIfPageBackgroundIsSet\"],function(e,t){\"use strict\";var n,i,a,s,u,c,l,d,o,r;var f=t&&t.id;return{setters:[function(e){n=e},function(e){i=e},function(e){a=e},function(e){s=e},function(e){u=e},function(e){c=e},function(e){l=e},function(e){d=e},function(e){o=e}],execute:function(){r=function(n){__extends(r,n);function r(e,t){var o=n.call(this)||this;o._consoleApiPatched=false;o._consoleMessageEventsEnabled=false;o._defaultBackgroundEnabled=true;o._focusedInputField=null;o._focusedInputFieldIntervalToken=0;o._isInIframe=parent!==window;o._checkFocusedInputField=function(){var e=d.default(o._window);var t=e instanceof HTMLIFrameElement;var n=l.default(o._window);var r=n||t?e:null;if(o._focusedInputField!==r){if(o._focusedInputField){o._focusedInputField.removeEventListener(\"click\",o._handleFocusedInputFieldClicked)}if(r){r.addEventListener(\"click\",o._handleFocusedInputFieldClicked)}var i=t?c.default.IFrame:n?c.default.Text:c.default.None;o._focusedInputField=r;o._bridge.postMessage({type:a.default.FocusedInputFieldChanged,value:i})}};o._handleFocusedInputFieldClicked=function(){o._bridge.postMessage({type:a.default.FocusedInputFieldChanged,value:c.default.Text})};o._consoleMessageEventsEnabled=!!(t===null||t===void 0?void 0:t.enableConsoleMessageEvents);o._windowReference=t===null||t===void 0?void 0:t.window;o._patchConsoleApiIfNeeded();if((t===null||t===void 0?void 0:t.defaultBackgroundEnabled)!==undefined){o._defaultBackgroundEnabled=t.defaultBackgroundEnabled}s.default(o,r.prototype);if(o._isInIframe){o._bridge=new i.default}else{o._bridge=e}if(o._document.readyState===\"loading\"||!o._document.head){o._document.addEventListener(\"DOMContentLoaded\",function(){o._performPostDomLoadInitialization(t===null||t===void 0?void 0:t.enableFocusedInputFieldEvents)})}else{o._performPostDomLoadInitialization(t===null||t===void 0?void 0:t.enableFocusedInputFieldEvents)}if(o._isInMainFrame){o._emitTitleChangeIfNeeded();o._window.setInterval(o._emitTitleChangeIfNeeded.bind(o),200);o._emitUrlChange(u.default.Load);o._watchForUrlChanges()}return o}r.prototype.setConsoleMessageEventsEnabled=function(e){this._consoleMessageEventsEnabled=e;this._patchConsoleApiIfNeeded()};r.prototype.setDefaultBackgroundEnabled=function(e){this._defaultBackgroundEnabled=e;if(!e){this._warnIfTransparencyIsBlocked()}};r.prototype.setFocusedInputFieldEventsEnabled=function(e){if(e&&!this._focusedInputFieldIntervalToken){this._focusedInputFieldIntervalToken=this._window.setInterval(this._checkFocusedInputField,200)}};Object.defineProperty(r.prototype,\"_document\",{get:function(){return this._window.document},enumerable:false,configurable:true});Object.defineProperty(r.prototype,\"_window\",{get:function(){return this._windowReference||window},enumerable:false,configurable:true});r.prototype._emitTitleChangeIfNeeded=function(){var e=this._document.title,t=e===void 0?\"\":e;if(this._title===t){return}this._title=t;this._bridge.postMessage({type:a.default.TitleChanged,value:t})};r.prototype._emitTransparentMetaTagStatus=function(){this._bridge.postMessage({type:a.default.PageTransparencyDetermined,value:this._transparencyEnabledViaMetaTag()})};r.prototype._emitUrlChange=function(e){try{var t=this._document.URL;if(t.indexOf(\"chrome-error://\")===0){return}if(t.indexOf(\"about:\")===0){return}if(t.indexOf(\"ms-local-stream://\")===0){return}if(t.indexOf(\".pdf?file=\")!==-1){return}this._bridge.postMessage({type:a.default.UrlChanged,urlAction:{Url:t,Title:this._document.title,Type:e}})}catch(e){console.error(\"An error occurred while handling the URL change.\",e)}};Object.defineProperty(r.prototype,\"_isInMainFrame\",{get:function(){return parent===window},enumerable:false,configurable:true});r.prototype._onHashChange=function(){this._emitUrlChange(u.default.HashChange)};r.prototype._onPushState=function(){this._emitUrlChange(u.default.PushState)};r.prototype._onReplaceState=function(){this._emitUrlChange(u.default.ReplaceState)};r.prototype._transparencyEnabledViaMetaTag=function(){var e=this._document.head.getElementsByTagName(\"meta\");var t=Array.prototype.filter.call(e,function(e){return e.getAttribute(\"name\")===\"transparent\"})[0];return!!t&&t.getAttribute(\"content\")===\"true\"};r.prototype._patchConsoleApiIfNeeded=function(){if(this._consoleApiPatched||!this._consoleMessageEventsEnabled){return}this._consoleApiPatched=true;this._patchConsoleMethod(\"log\",\"LOG\");this._patchConsoleMethod(\"info\",\"LOG\");this._patchConsoleMethod(\"debug\",\"DEBUG\");this._patchConsoleMethod(\"error\",\"ERROR\");this._patchConsoleMethod(\"warn\",\"WARNING\")};r.prototype._patchConsoleMethod=function(e,r){var i=this;var o=this._window.console[e].bind(this._window.console);this._window.console[e]=function(){var e=[];for(var t=0;t<arguments.length;t++){e[t]=arguments[t]}if(i._consoleMessageEventsEnabled){try{var n=e.map(function(e){return typeof e===\"object\"&&!(e instanceof i._window.Error)?JSON.stringify(e):e}).join(\", \");i._bridge.postMessage({type:\"vuplex.webview.consoleMessageLogged\",level:r,message:n})}catch(e){}}o.apply(void 0,e)}};r.prototype._performPostDomLoadInitialization=function(e){if(this._isInMainFrame){this._emitTransparentMetaTagStatus();this._warnIfTransparencyIsBlocked()}if(e){this.setFocusedInputFieldEventsEnabled(true)}};r.prototype._warnIfTransparencyIsBlocked=function(){var e=this._transparencyEnabledViaMetaTag()||!this._defaultBackgroundEnabled;if(!e){return}var t=o.default(this._window),n=t.backgroundIsSet,r=t.details;if(n){this._bridge.postMessage({type:a.default.TransparencyBlockedWarning,value:r})}};r.prototype._watchForUrlChanges=function(){var r=this;var i=this._window.history.pushState;this._window.history.pushState=function(){var e=[];for(var t=0;t<arguments.length;t++){e[t]=arguments[t]}var n=i.apply(r._window.history,e);r._onPushState();return n};var o=this._window.history.replaceState;this._window.history.replaceState=function(){var e=[];for(var t=0;t<arguments.length;t++){e[t]=arguments[t]}var n=o.apply(r._window.history,e);r._onReplaceState();return n};this._window.addEventListener(\"hashchange\",this._onHashChange.bind(this));this._window.addEventListener(\"yt-navigate-finish\",this._onPushState.bind(this))};return r}(n.default);e(\"default\",r)}}});_vuplexSystem.register(\"initBrowserAgent\",[\"BrowserAgent\"],function(e,t){\"use strict\";var i;var n=t&&t.id;function r(e,t){var n;var r=((n=t===null||t===void 0?void 0:t.browserAgentOptions)===null||n===void 0?void 0:n.window)||window;if(r.vuplex&&r._vuplexInternal){return}r.vuplex=e;r._vuplexInternal={browserAgent:new i.default(e,t===null||t===void 0?void 0:t.browserAgentOptions)};if(t===null||t===void 0?void 0:t.optionalComponents){Object.assign(r._vuplexInternal,t===null||t===void 0?void 0:t.optionalComponents)}r.dispatchEvent(new Event(\"vuplexready\"))}e(\"default\",r);return{setters:[function(e){i=e}],execute:function(){}}});_vuplexSystem.register(\"IFramePostMessageDomain\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){(function(e){e[\"IFrameBridgeDownstream\"]=\"vuplex.iframeBridgeDownstream\";e[\"IFrameBridgeUpstream\"]=\"vuplex.iframeBridgeUpstream\"})(n||(n={}));e(\"default\",n)}}});_vuplexSystem.register(\"optional/KeyboardInputManager\",[\"isTextInputOrTextarea\",\"IFramePostMessageDomain\",\"focusedElementIsEditable\"],function(e,t){\"use strict\";var a,r,p,i,n;var o=t&&t.id;return{setters:[function(e){a=e},function(e){r=e},function(e){p=e}],execute:function(){i=\"vuplex.webview.sendKey\";n=function(){function e(e){var n=this;this._textInputEventsEnabled=false;this._handleIFrameMessage=function(e){if(!e.data){return}var t=e.data.message;if(e.data.domain===r.default.IFrameBridgeDownstream&&t.type===i){n.sendKey(t.input)}};this._window=(e===null||e===void 0?void 0:e.window)||window;this._textInputEventsEnabled=!!(e===null||e===void 0?void 0:e.enableTextInputEvents);this._window.addEventListener(\"message\",this._handleIFrameMessage)}e.prototype.sendKey=function(e){if(this._document.activeElement instanceof this._window.HTMLIFrameElement){this._document.activeElement.contentWindow.postMessage({domain:r.default.IFrameBridgeDownstream,message:{type:i,input:e}},\"*\");return}if(e===\"Backspace\"){e=\"\\b\"}else if(e===\"Enter\"){e=\"\\n\"}var t=Array.from(e).length;if(t===1){this._dispatchCharacter(e);return}if(p.default(this._window)&&(e===\"ArrowLeft\"||e===\"ArrowRight\")){this._dispatchCharacter(e);return}switch(e){case\"ArrowUp\":this._window.scrollBy(0,-50);break;case\"ArrowDown\":this._window.scrollBy(0,50);break;case\"ArrowLeft\":this._window.scrollBy(-50,0);break;case\"ArrowRight\":this._window.scrollBy(50,0);break}};Object.defineProperty(e.prototype,\"_document\",{get:function(){return this._window.document},enumerable:false,configurable:true});e.prototype._dispatchCharacter=function(e){if(e===\"\\n\"&&this._document.activeElement instanceof this._window.HTMLInputElement){var t=this._getFocusedForm();if(t){var n=t.dispatchEvent(new Event(\"submit\",{cancelable:true}));if(n){t.submit()}}else{this._dispatchKeyPressEvents(this._document.activeElement,\"\\r\")}return}if(this._document.activeElement){this._dispatchKeyPressEvents(this._document.activeElement,e)}var r=this._document.activeElement;if(!p.default(this._window)){return}var i=this._getSelection(r),o=i.selectionStart,a=i.selectionEnd;var s=this._getTextValue(r);if(e===\"\\b\"){var u=o===a&&o===0;if(u){return}var c=o!==a;if(c){var l=this._spliceString(s,o,a-o,\"\");this._setTextValue(r,l);this._setSelection(r,o,o)}else{var l=this._spliceString(s,o-1,1,\"\");this._setTextValue(r,l);var d=o-1;this._setSelection(r,d,d)}}else if(e===\"ArrowLeft\"){if(o===a){var f=Math.max(o-1,0);this._setSelection(r,f,f)}else{this._setSelection(r,o,o)}}else if(e===\"ArrowRight\"){if(o===a){var f=Math.min(a+1,s.length);this._setSelection(r,f,f)}else{this._setSelection(r,a,a)}}else{var l=this._spliceString(s,o,a-o,e);this._setTextValue(r,l);var d=o+1;this._setSelection(r,d,d)}};e.prototype._dispatchKeyboardEvent=function(e,t,n){var r=n.charCodeAt(0);var i=new KeyboardEvent(t,{key:n,keyCode:r,bubbles:true,cancelable:true});Object.defineProperty(i,\"keyCode\",{value:r,writable:false});e.dispatchEvent(i)};e.prototype._dispatchKeyPressEvents=function(e,t){this._dispatchKeyboardEvent(e,\"keydown\",t);this._dispatchKeyboardEvent(e,\"keypress\",t);if(this._textInputEventsEnabled){var n=this._document.createEvent(\"TextEvent\");n.initTextEvent(\"textInput\",true,true,this._window,t,0,\"en-US\");e.dispatchEvent(n)}this._dispatchKeyboardEvent(e,\"keyup\",t)};e.prototype._getFocusedForm=function(){var e=this._document.activeElement||null;while(e){if(e instanceof this._window.HTMLFormElement){return e}e=e.parentElement}return null};e.prototype._getSelection=function(e){if(a.default(e,this._window)){return{selectionStart:e.selectionStart||0,selectionEnd:e.selectionEnd||0}}var t=this._window.getSelection();if(t&&t.rangeCount){var n=t.getRangeAt(0);if(n.commonAncestorContainer.parentNode==e){return{selectionStart:n.startOffset,selectionEnd:n.endOffset}}}return{selectionStart:0,selectionEnd:0}};e.prototype._getTextValue=function(e){if(a.default(e,this._window)){return e.value}return e.innerText||\"\"};e.prototype._setSelection=function(e,t,n){if(a.default(e,this._window)){e.setSelectionRange(t,n);return}var r=this._document.createRange();var i=this._window.getSelection();var o=e.childNodes[0];r.setStart(o,t);r.setStart(o,n);if(i){i.removeAllRanges();i.addRange(r)}};e.prototype._setTextValue=function(e,t){if(e instanceof this._window.HTMLInputElement){Object.getOwnPropertyDescriptor(this._window.HTMLInputElement.prototype,\"value\").set.call(e,t)}else if(e instanceof this._window.HTMLTextAreaElement){Object.getOwnPropertyDescriptor(this._window.HTMLTextAreaElement.prototype,\"value\").set.call(e,t)}else{e.innerText=t}e.dispatchEvent(new Event(\"input\",{bubbles:true}))};e.prototype._spliceString=function(e,t,n,r){return e.slice(0,t)+r+e.slice(t+Math.abs(n))};return e}();e(\"default\",n)}}});_vuplexSystem.register(\"utils/arrayFrom\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(e){var t=[];for(var n=0;n<e.length;n++){t.push(e[n])}return t}e(\"default\",r);return{setters:[],execute:function(){}}});_vuplexSystem.register(\"optional/SelectElementManager\",[\"utils/arrayFrom\"],function(e,t){\"use strict\";var v,o,h,n;var r=t&&t.id;function g(e,t,n,r){var i=document.createElement(\"vuplex-dropdown-option\");i.innerText=e.innerText;var o=window.getComputedStyle(t);var a=o.font,s=o.fontSize,u=o.fontWeight;var c=\"#1e1e1e\";var l={font:a,fontSize:s,fontWeight:u,display:\"block\",padding:\"6px 10px\",color:c,cursor:\"default\"};Object.assign(i.style,l);var d={backgroundColor:\"#1275ff\",color:\"white\"};i.onclick=function(){Object.assign(i.style,d);t.value=e.value;t.dispatchEvent(new Event(\"input\",{bubbles:true}));t.dispatchEvent(new Event(\"change\",{bubbles:true}))};i.onmouseenter=function(){Object.assign(i.style,d)};i.onmouseleave=function(){Object.assign(i.style,{backgroundColor:\"unset\",color:c})};if(r){i.setAttribute(\"selected\",\"true\");var f=function(){i.removeAttribute(\"selected\");n.removeEventListener(\"mousemove\",f)};n.addEventListener(\"mousemove\",f)}return i}function a(p){return __awaiter(this,void 0,void 0,function(){function t(){if(document.body.contains(i)){document.body.removeChild(i)}r.removeEventListener(\"change\",t);r.blur()}var r,n,i,o,a,s,u,c,l,d,f;return __generator(this,function(e){switch(e.label){case 0:r=p.target;n=r.style.display;r.style.display=\"none\";return[4,new Promise(function(e){return setTimeout(e,10)})];case 1:e.sent();r.style.display=n;i=document.createElement(\"vuplex-dropdown-container\");Object.assign(i.style,{position:\"fixed\",top:0,right:0,bottom:0,left:0,zIndex:2147483648});document.body.appendChild(i);i.onclick=t;r.addEventListener(\"change\",t);i.onmousedown=function(e){return e.stopPropagation()};i.onmouseup=function(e){return e.stopPropagation()};o=document.createElement(\"vuplex-dropdown\");a=r.getBoundingClientRect();s=navigator.userAgent.indexOf(\"Firefox\")===-1?0:1;u={left:a.left-s+\"px\",width:a.width+\"px\",top:a.top+a.height+\"px\",position:\"absolute\",backgroundColor:\"white\",display:\"block\",boxShadow:\"0 4px 10px rgba(0, 0, 0, .2)\",border:\"1px solid #bcbcbc\",zIndex:2147483648,maxHeight:h+\"px\",overflow:\"scroll\",textAlign:\"left\"};Object.assign(o.style,u);i.appendChild(o);c=v.default(r.querySelectorAll(\"option\"));l=c.find(function(e){return e.value===r.value});c.forEach(function(e){var t=e===l;var n=g(e,r,o,t);o.appendChild(n);if(t){d=n}});i.addEventListener(\"wheel\",function(e){var t=e.target===o||o.contains(e.target);if(!t){e.preventDefault()}});f=o.getBoundingClientRect().height;if(f>h&&d.offsetTop>h){o.scrollTo(0,d.offsetTop)}return[2]}})})}return{setters:[function(e){v=e}],execute:function(){o=\"vuplex\";h=300;n=function(){function e(){setInterval(this._checkIfSelectElementsWereAddedOrRemoved.bind(this),250)}e.prototype._checkIfSelectElementsWereAddedOrRemoved=function(){var e=document.querySelectorAll(\"select:not([multiple]):not([disabled])\");var t=v.default(e);for(var n=0,r=t;n<r.length;n++){var i=r[n];if(!i.getAttributeNS(o,\"managed\")){i.setAttributeNS(o,\"managed\",\"true\");i.addEventListener(\"click\",a)}}};return e}();e(\"default\",n)}}});_vuplexSystem.register(\"optional/ViewportMetaTagManager\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){n=function(){function e(e,t){var r=this;if(t===void 0){t=false}this.overrideViewportMetaTag=function(){var e=document.querySelector(\"meta[name=viewport]\");var t=!!e;if(!e){e=document.createElement(\"meta\");e.setAttribute(\"name\",\"viewport\")}var n=r._allowZoom?\"\":\", minimum-scale=1.0, maximum-scale=1.0, user-scalable=0\";e.setAttribute(\"content\",\"viewport-fit=cover, width=device-width, initial-scale=1.0\"+n);if(!t){document.head.appendChild(e)}};this._allowZoom=t;if(e){if(document.readyState===\"loading\"){document.addEventListener(\"DOMContentLoaded\",this.overrideViewportMetaTag)}else{this.overrideViewportMetaTag()}}}return e}();e(\"default\",n)}}});_vuplexSystem.register(\"android/enableInputTypeWorkaround\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(){setInterval(i,200)}e(\"default\",r);function i(){var e=document.activeElement;if(e instanceof HTMLInputElement&&(e.type===\"email\"||e.type===\"number\")){e.type=\"text\"}}return{setters:[],execute:function(){}}});_vuplexSystem.register(\"android/enableAnchorTargetAttributeRemoval\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(){setInterval(i,500)}e(\"default\",r);function i(){var e=document.querySelectorAll(\"a[target=_blank]\");e.forEach(function(e){return e.removeAttribute(\"target\")})}return{setters:[],execute:function(){}}});_vuplexSystem.register(\"optional/FocusManager\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){n=function(){function e(e){if(e===void 0){e=window}this._activeElementDuringLastBlur=null;this._window=e}e.prototype.setFocused=function(e){if(e){var t=this._activeElementDuringLastBlur||this._document.activeElement;if(t instanceof this._window.HTMLElement){t.focus();this._activeElementDuringLastBlur=null}return}var n=this._document.activeElement;this._activeElementDuringLastBlur=n;if(n instanceof this._window.HTMLElement){n.blur()}};Object.defineProperty(e.prototype,\"_document\",{get:function(){return this._window.document},enumerable:false,configurable:true});return e}();e(\"default\",n)}}});_vuplexSystem.register(\"android/index\",[\"android/AndroidBridge\",\"initBrowserAgent\",\"optional/KeyboardInputManager\",\"optional/SelectElementManager\",\"optional/ViewportMetaTagManager\",\"android/enableInputTypeWorkaround\",\"android/enableAnchorTargetAttributeRemoval\",\"optional/FocusManager\"],function(e,t){\"use strict\";var n,r,i,o,a,s,u,c;var l=t&&t.id;return{setters:[function(e){n=e},function(e){r=e},function(e){i=e},function(e){o=e},function(e){a=e},function(e){s=e},function(e){u=e},function(e){c=e}],execute:function(){window.__initVuplex=function(e){var t=new n.default;r.default(t,{browserAgentOptions:e,optionalComponents:{focusManager:new c.default,keyboardInputManager:new i.default,selectElementManager:(e===null||e===void 0?void 0:e.enableSelectElementManager)?new o.default:undefined,viewportMetaTagManager:new a.default(!!(e===null||e===void 0?void 0:e.overrideViewportMetaTag))}});if(e===null||e===void 0?void 0:e.enableInputTypeWorkaround){s.default()}if(e===null||e===void 0?void 0:e.removeAnchorTargetAttributes){u.default()}}}}});_vuplexSystem.require(\"android/index\");";
        objArr[1] = this.g ? "true" : "false";
        objArr[2] = o() ? "true" : "false";
        objArr[3] = this.m ? "true" : "false";
        objArr[4] = P ? "true" : "false";
        objArr[5] = n() ? "true" : "false";
        objArr[6] = Q ? "true" : "false";
        this.b = String.format("%s;window.__initVuplex({ defaultBackgroundEnabled: %s, overrideViewportMetaTag: %s, enableFocusedInputFieldEvents: %s, enableInputTypeWorkaround: %s, enableSelectElementManager: %s, removeAnchorTargetAttributes: %s });", objArr);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class h extends android.webkit.WebView {
        public h(WebView webView, Context context) {
            super(context);
        }

        public void a(Canvas canvas) {
            super.onDraw(canvas);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class g extends WebChromeClient {
        private g() {
        }

        /* synthetic */ g(WebView webView, a aVar) {
            this();
        }

        @Override // android.webkit.WebChromeClient
        public Bitmap getDefaultVideoPoster() {
            return Bitmap.createBitmap(10, 10, Bitmap.Config.ARGB_8888);
        }

        @Override // android.webkit.WebChromeClient
        public void onCloseWindow(android.webkit.WebView webView) {
            WebView.this.h("HandleCloseRequested");
        }

        @Override // android.webkit.WebChromeClient
        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            try {
                if (WebView.this.e) {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("type", "vuplex.webview.consoleMessageLogged");
                    jSONObject.put("message", consoleMessage.message());
                    jSONObject.put("level", WebView.this.a(consoleMessage.messageLevel()));
                    String sourceId = consoleMessage.sourceId();
                    if (sourceId.length() > 0) {
                        jSONObject.put("source", sourceId);
                    }
                    jSONObject.put("line", consoleMessage.lineNumber());
                    WebView.this.a(jSONObject.toString());
                    return false;
                }
                return false;
            } catch (JSONException e2) {
                Log.e(WebView.TAG, "An unexpected error occurred while handling onConsoleMessage: " + e2);
                return false;
            }
        }

        @Override // android.webkit.WebChromeClient
        public boolean onCreateWindow(android.webkit.WebView webView, boolean z, boolean z2, Message message) {
            int i = f.b[WebView.this.D.ordinal()];
            if (i == 1) {
                Message obtainMessage = webView.getHandler().obtainMessage();
                webView.requestFocusNodeHref(obtainMessage);
                String string = obtainMessage.getData().getString("url");
                if (string == null) {
                    string = BuildConfig.FLAVOR;
                }
                WebView.this.C.callback(string, message);
                return true;
            } else if (i != 2) {
                Log.e(WebView.TAG, String.format("Unexpected popup mode: %s", WebView.this.D));
                return false;
            } else {
                android.webkit.WebView webView2 = new android.webkit.WebView(WebView.f());
                webView2.setWebViewClient(new a(webView2));
                ((WebView.WebViewTransport) message.obj).setWebView(webView2);
                message.sendToTarget();
                return true;
            }
        }

        /* loaded from: classes.dex */
        class a extends WebViewClient {
            final /* synthetic */ android.webkit.WebView a;

            a(android.webkit.WebView webView) {
                this.a = webView;
            }

            @Override // android.webkit.WebViewClient
            public boolean shouldOverrideUrlLoading(android.webkit.WebView webView, String str) {
                WebView.this.C.callback(str, null);
                this.a.destroy();
                return true;
            }
        }

        @Override // android.webkit.WebChromeClient
        public void onGeolocationPermissionsShowPrompt(String str, GeolocationPermissions.Callback callback) {
            callback.invoke(str, WebView.Y, false);
        }

        /* loaded from: classes.dex */
        class b implements BooleanCallback {
            final /* synthetic */ JsResult a;

            b(g gVar, JsResult jsResult) {
                this.a = jsResult;
            }

            @Override // com.vuplex.webview.BooleanCallback
            public void callback(boolean z) {
                this.a.confirm();
            }
        }

        @Override // android.webkit.WebChromeClient
        public boolean onJsAlert(android.webkit.WebView webView, String str, String str2, JsResult jsResult) {
            if (WebView.this.H != null) {
                WebView.this.H.callback(str2, new b(this, jsResult));
                return true;
            }
            if (WebView.this.v) {
                WebView webView2 = WebView.this;
                if (!webView2.O) {
                    return false;
                }
                webView2.c("alert", "ScriptAlerted");
            }
            jsResult.cancel();
            return true;
        }

        @Override // android.webkit.WebChromeClient
        public boolean onJsBeforeUnload(android.webkit.WebView webView, String str, String str2, JsResult jsResult) {
            if (!WebView.this.v || WebView.this.O) {
                jsResult.confirm();
                return true;
            }
            return false;
        }

        /* loaded from: classes.dex */
        class c implements BooleanCallback {
            final /* synthetic */ JsResult a;

            c(g gVar, JsResult jsResult) {
                this.a = jsResult;
            }

            @Override // com.vuplex.webview.BooleanCallback
            public void callback(boolean z) {
                if (z) {
                    this.a.confirm();
                } else {
                    this.a.cancel();
                }
            }
        }

        @Override // android.webkit.WebChromeClient
        public boolean onJsConfirm(android.webkit.WebView webView, String str, String str2, JsResult jsResult) {
            if (WebView.this.I != null) {
                WebView.this.I.callback(str2, new c(this, jsResult));
                return true;
            }
            if (WebView.this.v) {
                WebView webView2 = WebView.this;
                if (!webView2.O) {
                    return false;
                }
                webView2.c("confirm", "ScriptConfirmRequested");
            }
            jsResult.cancel();
            return true;
        }

        @Override // android.webkit.WebChromeClient
        public boolean onJsPrompt(android.webkit.WebView webView, String str, String str2, String str3, JsPromptResult jsPromptResult) {
            if (!WebView.this.v || WebView.this.O) {
                jsPromptResult.cancel();
                return true;
            }
            return false;
        }

        @Override // android.webkit.WebChromeClient
        public void onPermissionRequest(PermissionRequest permissionRequest) {
            String[] resources;
            ArrayList arrayList = new ArrayList();
            for (String str : permissionRequest.getResources()) {
                if (str != "android.webkit.resource.AUDIO_CAPTURE" || !WebView.a0) {
                    if (str != "android.webkit.resource.PROTECTED_MEDIA_ID" || !WebView.X) {
                        if (str != "android.webkit.resource.VIDEO_CAPTURE" || !WebView.U) {
                            if (str == "android.webkit.resource.MIDI_SYSEX" && WebView.b0) {
                                arrayList.add(str);
                            }
                        } else {
                            arrayList.add(str);
                        }
                    } else {
                        arrayList.add(str);
                    }
                } else {
                    arrayList.add(str);
                }
            }
            if (arrayList.size() > 0) {
                permissionRequest.grant((String[]) arrayList.toArray(new String[0]));
            } else {
                permissionRequest.deny();
            }
        }

        @Override // android.webkit.WebChromeClient
        public void onProgressChanged(android.webkit.WebView webView, int i) {
            if (WebView.this.z) {
                WebView webView2 = WebView.this;
                webView2.d("HandleLoadProgressUpdate", webView2.y.format(i / 100.0d));
            }
        }

        @Override // android.webkit.WebChromeClient
        public boolean onShowFileChooser(android.webkit.WebView webView, ValueCallback<Uri[]> valueCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            return a(valueCallback, fileChooserParams) || b(valueCallback, fileChooserParams);
        }

        /* JADX INFO: Access modifiers changed from: private */
        public Uri[] a(Uri[] uriArr) {
            ArrayList arrayList = new ArrayList();
            for (Uri uri : uriArr) {
                try {
                    InputStream openInputStream = UnityPlayer.currentActivity.getContentResolver().openInputStream(uri);
                    File a2 = a(uri);
                    a(openInputStream, a2);
                    arrayList.add(Uri.fromFile(a2));
                } catch (IOException e2) {
                    Log.e(WebView.TAG, "IOException while trying to open the file from the file picker: " + e2);
                }
            }
            return (Uri[]) arrayList.toArray(new Uri[0]);
        }

        private File a(Uri uri) {
            String str;
            Cursor query = UnityPlayer.currentActivity.getContentResolver().query(uri, null, null, null, null, null);
            if (query == null || !query.moveToFirst()) {
                str = "tempfile";
            } else {
                str = query.getString(query.getColumnIndex("_display_name"));
                query.close();
            }
            File file = new File(WebView.f().getCacheDir().getAbsolutePath() + "/Vuplex.WebView/FileSelection");
            if (!file.exists()) {
                file.mkdirs();
            }
            File file2 = new File(file, str);
            if (file2.exists()) {
                file2.delete();
            }
            file2.createNewFile();
            return file2;
        }

        private boolean a(ValueCallback<Uri[]> valueCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            if (WebView.this.k == null) {
                return false;
            }
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("AcceptFilters", new JSONArray((Collection) Arrays.asList(fileChooserParams.getAcceptTypes())));
                d dVar = new d(this, valueCallback);
                e eVar = new e(this, valueCallback);
                jSONObject.put("MultipleAllowed", fileChooserParams.getMode() == 1);
                WebView.this.k.callback(jSONObject.toString(), dVar, eVar);
                return true;
            } catch (JSONException e2) {
                Log.e(WebView.TAG, "An exception occurred while emitting the FileSelectionRequested event.", e2);
                valueCallback.onReceiveValue(null);
                return false;
            }
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class d implements Callback<String[]> {
            final /* synthetic */ ValueCallback a;

            d(g gVar, ValueCallback valueCallback) {
                this.a = valueCallback;
            }

            @Override // com.vuplex.webview.Callback
            /* renamed from: a */
            public void callback(String[] strArr) {
                Uri[] uriArr = new Uri[strArr.length];
                for (int i = 0; i < strArr.length; i++) {
                    uriArr[i] = Uri.fromFile(new File(strArr[i]));
                }
                this.a.onReceiveValue(uriArr);
            }
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class e implements BooleanCallback {
            final /* synthetic */ ValueCallback a;

            e(g gVar, ValueCallback valueCallback) {
                this.a = valueCallback;
            }

            @Override // com.vuplex.webview.BooleanCallback
            public void callback(boolean z) {
                this.a.onReceiveValue(null);
            }
        }

        private boolean b(ValueCallback<Uri[]> valueCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            Intent createIntent;
            Uri uri;
            if (WebView.this.u) {
                if (WebView.this.t != null) {
                    WebView.this.t.onReceiveValue(null);
                }
                WebView.this.t = valueCallback;
                if (fileChooserParams.isCaptureEnabled()) {
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("_display_name", "photo.jpg");
                    contentValues.put("mime_type", "image/jpg");
                    contentValues.put("relative_path", Environment.DIRECTORY_DCIM);
                    uri = WebView.f().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
                    createIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                    createIntent.addFlags(2);
                    createIntent.putExtra("output", uri);
                } else {
                    createIntent = fileChooserParams.createIntent();
                    if (fileChooserParams.getMode() == 1) {
                        createIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
                    }
                    String[] acceptTypes = fileChooserParams.getAcceptTypes();
                    if (acceptTypes.length > 1) {
                        createIntent.setType("*/*");
                        createIntent.putExtra("android.intent.extra.MIME_TYPES", acceptTypes);
                    }
                    uri = null;
                }
                HelperActivity.intentToStart = createIntent;
                HelperActivity.resultCallback = new f(uri);
                try {
                    UnityPlayer.currentActivity.startActivityForResult(new Intent(WebView.f(), HelperActivity.class), 0);
                    return true;
                } catch (ActivityNotFoundException e2) {
                    Log.e(WebView.TAG, "An unexpected error occurred while launching the file picker activity: " + e2);
                    valueCallback.onReceiveValue(null);
                    return false;
                }
            }
            return false;
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class f implements com.vuplex.webview.a<Integer, Intent> {
            final /* synthetic */ Uri a;

            f(Uri uri) {
                this.a = uri;
            }

            @Override // com.vuplex.webview.a
            public void a(Integer num, Intent intent) {
                ClipData clipData;
                if (WebView.this.t == null) {
                    return;
                }
                ValueCallback valueCallback = WebView.this.t;
                Uri[] uriArr = null;
                WebView.this.t = null;
                if (num.intValue() != -1) {
                    valueCallback.onReceiveValue(null);
                    return;
                }
                Uri uri = this.a;
                if (uri != null) {
                    valueCallback.onReceiveValue(new Uri[]{uri});
                    return;
                }
                Uri[] parseResult = WebChromeClient.FileChooserParams.parseResult(num.intValue(), intent);
                if (parseResult == null && (clipData = intent.getClipData()) != null && clipData.getItemCount() > 0) {
                    parseResult = new Uri[clipData.getItemCount()];
                    for (int i = 0; i < clipData.getItemCount(); i++) {
                        parseResult[i] = clipData.getItemAt(i).getUri();
                    }
                }
                if (parseResult != null) {
                    uriArr = g.this.a(parseResult);
                } else {
                    Log.e(WebView.TAG, "file selection failed because contentUris is null");
                }
                valueCallback.onReceiveValue(uriArr);
            }
        }

        private void a(InputStream inputStream, File file) {
            try {
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] bArr = new byte[4096];
                while (true) {
                    int read = inputStream.read(bArr);
                    if (read != -1) {
                        fileOutputStream.write(bArr, 0, read);
                    } else {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                        return;
                    }
                }
            } finally {
                inputStream.close();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static /* synthetic */ class f {
        static final /* synthetic */ int[] a;
        static final /* synthetic */ int[] b;

        static {
            int[] iArr = new int[k.values().length];
            b = iArr;
            try {
                iArr[k.LOAD_IN_NEW_WEBVIEW.ordinal()] = 1;
            } catch (NoSuchFieldError unused) {
            }
            try {
                b[k.NOTIFY_WITHOUT_LOADING.ordinal()] = 2;
            } catch (NoSuchFieldError unused2) {
            }
            int[] iArr2 = new int[ConsoleMessage.MessageLevel.values().length];
            a = iArr2;
            try {
                iArr2[ConsoleMessage.MessageLevel.DEBUG.ordinal()] = 1;
            } catch (NoSuchFieldError unused3) {
            }
            try {
                a[ConsoleMessage.MessageLevel.TIP.ordinal()] = 2;
            } catch (NoSuchFieldError unused4) {
            }
            try {
                a[ConsoleMessage.MessageLevel.ERROR.ordinal()] = 3;
            } catch (NoSuchFieldError unused5) {
            }
            try {
                a[ConsoleMessage.MessageLevel.WARNING.ordinal()] = 4;
            } catch (NoSuchFieldError unused6) {
            }
            try {
                a[ConsoleMessage.MessageLevel.LOG.ordinal()] = 5;
            } catch (NoSuchFieldError unused7) {
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class i extends g {
        private i() {
            super(WebView.this, null);
        }

        /* synthetic */ i(WebView webView, a aVar) {
            this();
        }

        @Override // android.webkit.WebChromeClient
        public void onHideCustomView() {
            View view = WebView.this.o;
            if (view == null) {
                return;
            }
            ViewGroup viewGroup = (ViewGroup) view.getParent();
            if (viewGroup != null) {
                viewGroup.removeView(WebView.this.o);
            }
            WebView.this.o = null;
        }

        @Override // android.webkit.WebChromeClient
        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
            WebView.this.o = view;
            WebView.h().addView(view, 0);
            if (!WebView.this.p()) {
                WebView.this.k();
            } else {
                view.bringToFront();
            }
            view.setFocusable(WebView.this.w);
            view.setFocusableInTouchMode(WebView.this.w);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class m extends WebViewClient {
        private m() {
        }

        /* synthetic */ m(WebView webView, a aVar) {
            this();
        }

        @Override // android.webkit.WebViewClient
        public void onPageStarted(android.webkit.WebView webView, String str, Bitmap bitmap) {
            try {
                WebView.this.s = null;
                if (str.startsWith("about:blank#")) {
                    return;
                }
                WebView.this.b(str);
                WebView.this.z = true;
                WebView.this.c();
            } catch (Exception e) {
                Log.e(WebView.TAG, "An exception occurred during page start", e);
            }
        }

        @Override // android.webkit.WebViewClient
        public void onPageFinished(android.webkit.WebView webView, String str) {
            try {
                boolean z = WebView.this.z;
                WebView.this.z = false;
                if (WebView.this.r && !str.startsWith("about:blank#")) {
                    WebView.this.r = false;
                    WebView.this.L.clearHistory();
                }
                if (WebView.this.f(str)) {
                    return;
                }
                if (!WebView.this.b()) {
                    WebView webView2 = WebView.this;
                    webView2.c(webView2.b);
                }
                if (WebView.this.s != null) {
                    WebView webView3 = WebView.this;
                    webView3.a(webView3.s.a, WebView.this.s.b);
                } else if (z) {
                    WebView.this.h("HandleLoadFinished");
                }
            } catch (Exception e) {
                Log.e(WebView.TAG, "An exception occurred while reading the JavaScript file.", e);
            }
        }

        @Override // android.webkit.WebViewClient
        public void onReceivedError(android.webkit.WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
            if (webResourceRequest.isForMainFrame()) {
                String charSequence = webResourceError.getDescription().toString();
                String uri = webResourceRequest.getUrl().toString();
                Log.w(WebView.TAG, String.format("Page load failed with error code: %s, url: %s", charSequence, uri));
                WebView webView2 = WebView.this;
                webView2.s = new j(webView2, charSequence, uri);
            }
        }

        @Override // android.webkit.WebViewClient
        public void onReceivedHttpAuthRequest(android.webkit.WebView webView, HttpAuthHandler httpAuthHandler, String str, String str2) {
            if (WebView.this.a != null) {
                WebView.this.a.callback(str, httpAuthHandler);
            }
        }

        @Override // android.webkit.WebViewClient
        public void onReceivedHttpError(android.webkit.WebView webView, WebResourceRequest webResourceRequest, WebResourceResponse webResourceResponse) {
            if (webResourceRequest.isForMainFrame()) {
                Log.w(WebView.TAG, String.format("Server responded with HTTP error status code: %d, url: %s", Integer.valueOf(webResourceResponse.getStatusCode()), webResourceRequest.getUrl().toString()));
            }
        }

        @Override // android.webkit.WebViewClient
        public void onReceivedSslError(android.webkit.WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
            Log.w(WebView.TAG, "Received SSL error: " + sslError);
            if (WebView.Z) {
                sslErrorHandler.proceed();
                return;
            }
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
            WebView.this.a(a(sslError), sslError.getUrl().toString());
        }

        @Override // android.webkit.WebViewClient
        public void onScaleChanged(android.webkit.WebView webView, float f, float f2) {
            WebView.this.F = f2;
        }

        @Override // android.webkit.WebViewClient
        public boolean shouldOverrideUrlLoading(android.webkit.WebView webView, WebResourceRequest webResourceRequest) {
            return a(webView, webResourceRequest.getUrl().toString(), webResourceRequest.isForMainFrame());
        }

        @Override // android.webkit.WebViewClient
        public boolean shouldOverrideUrlLoading(android.webkit.WebView webView, String str) {
            return a(webView, str, true);
        }

        private String a(SslError sslError) {
            int primaryError = sslError.getPrimaryError();
            if (primaryError != 0) {
                if (primaryError != 1) {
                    if (primaryError != 2) {
                        if (primaryError != 3) {
                            if (primaryError != 4) {
                                if (primaryError != 5) {
                                    Log.e(WebView.TAG, "Unknown SSL error code: " + sslError.getPrimaryError());
                                    return "SSL_UNKNOWN";
                                }
                                return "SSL_INVALID";
                            }
                            return "SSL_DATE_INVALID";
                        }
                        return "SSL_UNTRUSTED";
                    }
                    return "SSL_IDMISMATCH";
                }
                return "SSL_EXPIRED";
            }
            return "SSL_NOTYETVALID";
        }

        private boolean a(android.webkit.WebView webView, String str, boolean z) {
            if ((str.startsWith("http:") || str.startsWith("https:") || str.startsWith("data:") || str.startsWith("file:") || str.startsWith("about:")) ? false : true) {
                if (WebView.this.f) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse(str));
                    try {
                        WebView.f().startActivity(intent);
                        return true;
                    } catch (ActivityNotFoundException unused) {
                        Log.w(WebView.TAG, "No activity not found for URL with custom URI scheme: " + str);
                    }
                }
                WebView.this.b(str);
                WebView.this.c();
                WebView.this.a("net::ERR_UNKNOWN_URL_SCHEME", str);
                return true;
            }
            if (WebView.this.F != 1.0f && WebView.this.G) {
                WebView.this.setInitialScale(1.0f);
            }
            WebView webView2 = WebView.this;
            if (webView2.h) {
                webView2.K = str;
                WebView webView3 = WebView.this;
                webView3.h = false;
                webView3.i();
                return true;
            } else if (z && (str.startsWith("file:") || str.startsWith("jar:") || WebView.this.g(str))) {
                WebView.this.loadUrl(str);
                return true;
            } else {
                return false;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class n extends m {
        private n() {
            super(WebView.this, null);
        }

        /* synthetic */ n(WebView webView, a aVar) {
            this();
        }

        @Override // android.webkit.WebViewClient
        public boolean onRenderProcessGone(android.webkit.WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
            Log.e(WebView.TAG, "onRenderProcessGone() was called, which indicates that the browser process was terminated. didCrash: " + renderProcessGoneDetail.didCrash());
            WebView.this.d("HandleTerminated", renderProcessGoneDetail.didCrash() ? "CRASHED" : "KILLED");
            return true;
        }
    }
}
