package com.unity3d.splash.services.core.cache;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import androidx.browser.trusted.sharing.ShareTarget;
import com.unity3d.splash.services.core.api.Request;
import com.unity3d.splash.services.core.device.Device;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.request.IWebRequestProgressListener;
import com.unity3d.splash.services.core.request.NetworkIOException;
import com.unity3d.splash.services.core.request.WebRequest;
import com.unity3d.splash.services.core.webview.WebViewApp;
import com.unity3d.splash.services.core.webview.WebViewEventCategory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
/* loaded from: classes.dex */
class CacheThreadHandler extends Handler {
    private WebRequest _currentRequest = null;
    private boolean _canceled = false;
    private boolean _active = false;

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Removed duplicated region for block: B:133:0x0303 A[EXC_TOP_SPLITTER, SYNTHETIC] */
    /* JADX WARN: Type inference failed for: r0v13, types: [com.unity3d.splash.services.core.webview.WebViewApp, java.lang.Exception] */
    /* JADX WARN: Type inference failed for: r0v17, types: [com.unity3d.splash.services.core.webview.WebViewApp, java.lang.Exception] */
    /* JADX WARN: Type inference failed for: r0v21, types: [com.unity3d.splash.services.core.webview.WebViewApp, java.lang.Exception] */
    /* JADX WARN: Type inference failed for: r0v25, types: [com.unity3d.splash.services.core.webview.WebViewApp, java.lang.Exception] */
    /* JADX WARN: Type inference failed for: r0v29, types: [com.unity3d.splash.services.core.webview.WebViewApp, java.lang.Exception] */
    /* JADX WARN: Type inference failed for: r0v33, types: [com.unity3d.splash.services.core.webview.WebViewApp, java.lang.Exception] */
    /* JADX WARN: Type inference failed for: r0v58, types: [com.unity3d.splash.services.core.webview.WebViewApp, java.lang.Exception] */
    /* JADX WARN: Type inference failed for: r1v0, types: [boolean] */
    /* JADX WARN: Type inference failed for: r1v1 */
    /* JADX WARN: Type inference failed for: r1v7 */
    /* JADX WARN: Type inference failed for: r4v0, types: [java.lang.String] */
    /* JADX WARN: Type inference failed for: r4v42, types: [java.lang.String] */
    /* JADX WARN: Type inference failed for: r6v1 */
    /* JADX WARN: Type inference failed for: r6v10, types: [boolean] */
    /* JADX WARN: Type inference failed for: r6v11, types: [boolean] */
    /* JADX WARN: Type inference failed for: r6v12, types: [boolean] */
    /* JADX WARN: Type inference failed for: r6v13, types: [boolean] */
    /* JADX WARN: Type inference failed for: r6v2 */
    /* JADX WARN: Type inference failed for: r6v3 */
    /* JADX WARN: Type inference failed for: r6v34, types: [long] */
    /* JADX WARN: Type inference failed for: r6v35 */
    /* JADX WARN: Type inference failed for: r6v36 */
    /* JADX WARN: Type inference failed for: r6v37 */
    /* JADX WARN: Type inference failed for: r6v38 */
    /* JADX WARN: Type inference failed for: r6v39 */
    /* JADX WARN: Type inference failed for: r6v4 */
    /* JADX WARN: Type inference failed for: r6v5 */
    /* JADX WARN: Type inference failed for: r6v6 */
    /* JADX WARN: Type inference failed for: r6v7 */
    /* JADX WARN: Type inference failed for: r6v9, types: [boolean] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private void downloadFile(String str, String str2, int i, int i2, final int i3, HashMap hashMap, boolean z) {
        int i4;
        StringBuilder sb;
        ?? r6;
        char c;
        char c2;
        WebRequest webRequest;
        int i5;
        ?? r62;
        WebRequest webRequest2;
        int i6;
        ?? r63;
        WebRequest webRequest3;
        int i7;
        ?? r64;
        WebRequest webRequest4;
        int i8;
        ?? r65;
        WebRequest webRequest5;
        int i9;
        ?? r66;
        Throwable th;
        char c3;
        int i10;
        WebRequest webRequest6;
        FileOutputStream fileOutputStream;
        WebRequest webRequest7;
        int i11;
        char c4;
        boolean z2;
        boolean z3;
        boolean z4;
        boolean z5;
        boolean z6;
        String str3 = str2;
        ?? r1 = z;
        if (this._canceled || str == null || str3 == null) {
            return;
        }
        final File file = new File(str3);
        if (r1 != 0) {
            StringBuilder sb2 = new StringBuilder("Unity Ads cache: resuming download ");
            sb2.append(str);
            sb2.append(" to ");
            sb2.append(str3);
            sb2.append(" at ");
            r6 = file.length();
            sb2.append((long) r6);
            str3 = " bytes";
            sb = sb2;
            i4 = "Unity Ads cache: resuming download ";
        } else {
            StringBuilder sb3 = new StringBuilder("Unity Ads cache: start downloading ");
            sb3.append(str);
            sb3.append(" to ");
            sb = sb3;
            i4 = "Unity Ads cache: start downloading ";
        }
        sb.append(str3);
        DeviceLog.debug(sb.toString());
        if (!Device.isActiveNetworkConnected()) {
            DeviceLog.debug("Unity Ads cache: download cancelled, no internet connection available");
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.CACHE, CacheEvent.DOWNLOAD_ERROR, CacheError.NO_INTERNET, str);
            return;
        }
        this._active = true;
        long elapsedRealtime = SystemClock.elapsedRealtime();
        FileOutputStream fileOutputStream2 = null;
        try {
            try {
                FileOutputStream fileOutputStream3 = new FileOutputStream(file, (boolean) r1);
                try {
                    WebRequest webRequest8 = getWebRequest(str, i, i2, hashMap);
                    this._currentRequest = webRequest8;
                    webRequest8.setProgressListener(new IWebRequestProgressListener() { // from class: com.unity3d.splash.services.core.cache.CacheThreadHandler.1
                        private long lastProgressEventTime = System.currentTimeMillis();

                        @Override // com.unity3d.splash.services.core.request.IWebRequestProgressListener
                        public void onRequestProgress(String str4, long j, long j2) {
                            if (i3 <= 0 || System.currentTimeMillis() - this.lastProgressEventTime <= i3) {
                                return;
                            }
                            this.lastProgressEventTime = System.currentTimeMillis();
                            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.CACHE, CacheEvent.DOWNLOAD_PROGRESS, str4, Long.valueOf(j), Long.valueOf(j2));
                        }

                        @Override // com.unity3d.splash.services.core.request.IWebRequestProgressListener
                        public void onRequestStart(String str4, long j, int i12, Map map) {
                            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.CACHE, CacheEvent.DOWNLOAD_STARTED, str4, Long.valueOf(file.length()), Long.valueOf(j + file.length()), Integer.valueOf(i12), Request.getResponseHeadersMap(map));
                        }
                    });
                    this._currentRequest.makeStreamRequest(fileOutputStream3);
                    this._active = false;
                    fileOutputStream = fileOutputStream3;
                    c = 1;
                    c2 = 2;
                } catch (NetworkIOException e) {
                    e = e;
                    fileOutputStream = fileOutputStream3;
                    webRequest5 = null;
                    i9 = 3;
                    z6 = false;
                    c = 1;
                    c2 = 2;
                } catch (FileNotFoundException e2) {
                    e = e2;
                    fileOutputStream = fileOutputStream3;
                    webRequest4 = null;
                    i8 = 3;
                    z5 = false;
                    c = 1;
                    c2 = 2;
                } catch (IOException e3) {
                    e = e3;
                    fileOutputStream = fileOutputStream3;
                    webRequest = null;
                    i5 = 3;
                    z4 = false;
                    c = 1;
                    c2 = 2;
                } catch (IllegalStateException e4) {
                    e = e4;
                    fileOutputStream = fileOutputStream3;
                    webRequest3 = null;
                    i7 = 3;
                    z3 = false;
                    c = 1;
                    c2 = 2;
                } catch (MalformedURLException e5) {
                    e = e5;
                    fileOutputStream = fileOutputStream3;
                    webRequest2 = null;
                    i6 = 3;
                    z2 = false;
                    c = 1;
                    c2 = 2;
                } catch (Throwable th2) {
                    th = th2;
                    fileOutputStream = fileOutputStream3;
                    webRequest7 = null;
                    i11 = 3;
                    c4 = 0;
                    c = 1;
                    c2 = 2;
                }
            } catch (Throwable th3) {
                th = th3;
                th = th;
                webRequest6 = r1;
                i10 = i4;
                c3 = r6;
                this._currentRequest = webRequest6;
                if (fileOutputStream2 != null) {
                    try {
                        fileOutputStream2.close();
                    } catch (Exception e6) {
                        DeviceLog.exception("Error closing stream", e6);
                        ?? currentApp = WebViewApp.getCurrentApp();
                        WebViewEventCategory webViewEventCategory = WebViewEventCategory.CACHE;
                        CacheEvent cacheEvent = CacheEvent.DOWNLOAD_ERROR;
                        Object[] objArr = new Object[i10];
                        objArr[c3] = CacheError.FILE_IO_ERROR;
                        objArr[c] = str;
                        objArr[c2] = currentApp.getMessage();
                        currentApp.sendEvent(webViewEventCategory, cacheEvent, objArr);
                    }
                }
                throw th;
            }
            try {
                postProcessDownload(elapsedRealtime, str, file, 1L, this._currentRequest.getContentLength(), this._currentRequest.isCanceled(), this._currentRequest.getResponseCode(), this._currentRequest.getResponseHeaders());
                this._currentRequest = null;
                try {
                    fileOutputStream.close();
                } catch (Exception e7) {
                    DeviceLog.exception("Error closing stream", e7);
                    ?? currentApp2 = WebViewApp.getCurrentApp();
                    currentApp2.sendEvent(WebViewEventCategory.CACHE, CacheEvent.DOWNLOAD_ERROR, CacheError.FILE_IO_ERROR, str, currentApp2.getMessage());
                }
            } catch (NetworkIOException e8) {
                e = e8;
                webRequest5 = null;
                i9 = 3;
                z6 = false;
                fileOutputStream2 = fileOutputStream;
                r66 = z6;
                DeviceLog.exception("Network error", e);
                this._active = r66;
                WebViewApp currentApp3 = WebViewApp.getCurrentApp();
                WebViewEventCategory webViewEventCategory2 = WebViewEventCategory.CACHE;
                CacheEvent cacheEvent2 = CacheEvent.DOWNLOAD_ERROR;
                Object[] objArr2 = new Object[i9];
                objArr2[r66] = CacheError.NETWORK_ERROR;
                objArr2[c] = str;
                objArr2[c2] = e.getMessage();
                currentApp3.sendEvent(webViewEventCategory2, cacheEvent2, objArr2);
                this._currentRequest = webRequest5;
                if (fileOutputStream2 != null) {
                    try {
                        fileOutputStream2.close();
                    } catch (Exception e9) {
                        DeviceLog.exception("Error closing stream", e9);
                        ?? currentApp4 = WebViewApp.getCurrentApp();
                        WebViewEventCategory webViewEventCategory3 = WebViewEventCategory.CACHE;
                        CacheEvent cacheEvent3 = CacheEvent.DOWNLOAD_ERROR;
                        Object[] objArr3 = new Object[i9];
                        objArr3[r66] = CacheError.FILE_IO_ERROR;
                        objArr3[c] = str;
                        objArr3[c2] = currentApp4.getMessage();
                        currentApp4.sendEvent(webViewEventCategory3, cacheEvent3, objArr3);
                    }
                }
            } catch (FileNotFoundException e10) {
                e = e10;
                webRequest4 = null;
                i8 = 3;
                z5 = false;
                fileOutputStream2 = fileOutputStream;
                r65 = z5;
                DeviceLog.exception("Couldn't create target file", e);
                this._active = r65;
                WebViewApp currentApp5 = WebViewApp.getCurrentApp();
                WebViewEventCategory webViewEventCategory4 = WebViewEventCategory.CACHE;
                CacheEvent cacheEvent4 = CacheEvent.DOWNLOAD_ERROR;
                Object[] objArr4 = new Object[i8];
                objArr4[r65] = CacheError.FILE_IO_ERROR;
                objArr4[c] = str;
                objArr4[c2] = e.getMessage();
                currentApp5.sendEvent(webViewEventCategory4, cacheEvent4, objArr4);
                this._currentRequest = webRequest4;
                if (fileOutputStream2 != null) {
                    try {
                        fileOutputStream2.close();
                    } catch (Exception e11) {
                        DeviceLog.exception("Error closing stream", e11);
                        ?? currentApp6 = WebViewApp.getCurrentApp();
                        WebViewEventCategory webViewEventCategory5 = WebViewEventCategory.CACHE;
                        CacheEvent cacheEvent5 = CacheEvent.DOWNLOAD_ERROR;
                        Object[] objArr5 = new Object[i8];
                        objArr5[r65] = CacheError.FILE_IO_ERROR;
                        objArr5[c] = str;
                        objArr5[c2] = currentApp6.getMessage();
                        currentApp6.sendEvent(webViewEventCategory5, cacheEvent5, objArr5);
                    }
                }
            } catch (IllegalStateException e12) {
                e = e12;
                webRequest3 = null;
                i7 = 3;
                z3 = false;
                fileOutputStream2 = fileOutputStream;
                r64 = z3;
                DeviceLog.exception("Illegal state", e);
                this._active = r64;
                WebViewApp currentApp7 = WebViewApp.getCurrentApp();
                WebViewEventCategory webViewEventCategory6 = WebViewEventCategory.CACHE;
                CacheEvent cacheEvent6 = CacheEvent.DOWNLOAD_ERROR;
                Object[] objArr6 = new Object[i7];
                objArr6[r64] = CacheError.ILLEGAL_STATE;
                objArr6[c] = str;
                objArr6[c2] = e.getMessage();
                currentApp7.sendEvent(webViewEventCategory6, cacheEvent6, objArr6);
                this._currentRequest = webRequest3;
                if (fileOutputStream2 != null) {
                    try {
                        fileOutputStream2.close();
                    } catch (Exception e13) {
                        DeviceLog.exception("Error closing stream", e13);
                        ?? currentApp8 = WebViewApp.getCurrentApp();
                        WebViewEventCategory webViewEventCategory7 = WebViewEventCategory.CACHE;
                        CacheEvent cacheEvent7 = CacheEvent.DOWNLOAD_ERROR;
                        Object[] objArr7 = new Object[i7];
                        objArr7[r64] = CacheError.FILE_IO_ERROR;
                        objArr7[c] = str;
                        objArr7[c2] = currentApp8.getMessage();
                        currentApp8.sendEvent(webViewEventCategory7, cacheEvent7, objArr7);
                    }
                }
            } catch (MalformedURLException e14) {
                e = e14;
                webRequest2 = null;
                i6 = 3;
                z2 = false;
                fileOutputStream2 = fileOutputStream;
                r63 = z2;
                DeviceLog.exception("Malformed URL", e);
                this._active = r63;
                WebViewApp currentApp9 = WebViewApp.getCurrentApp();
                WebViewEventCategory webViewEventCategory8 = WebViewEventCategory.CACHE;
                CacheEvent cacheEvent8 = CacheEvent.DOWNLOAD_ERROR;
                Object[] objArr8 = new Object[i6];
                objArr8[r63] = CacheError.MALFORMED_URL;
                objArr8[c] = str;
                objArr8[c2] = e.getMessage();
                currentApp9.sendEvent(webViewEventCategory8, cacheEvent8, objArr8);
                this._currentRequest = webRequest2;
                if (fileOutputStream2 != null) {
                    try {
                        fileOutputStream2.close();
                    } catch (Exception e15) {
                        DeviceLog.exception("Error closing stream", e15);
                        ?? currentApp10 = WebViewApp.getCurrentApp();
                        WebViewEventCategory webViewEventCategory9 = WebViewEventCategory.CACHE;
                        CacheEvent cacheEvent9 = CacheEvent.DOWNLOAD_ERROR;
                        Object[] objArr9 = new Object[i6];
                        objArr9[r63] = CacheError.FILE_IO_ERROR;
                        objArr9[c] = str;
                        objArr9[c2] = currentApp10.getMessage();
                        currentApp10.sendEvent(webViewEventCategory9, cacheEvent9, objArr9);
                    }
                }
            } catch (IOException e16) {
                e = e16;
                webRequest = null;
                i5 = 3;
                z4 = false;
                fileOutputStream2 = fileOutputStream;
                r62 = z4;
                DeviceLog.exception("Couldn't request stream", e);
                this._active = r62;
                WebViewApp currentApp11 = WebViewApp.getCurrentApp();
                WebViewEventCategory webViewEventCategory10 = WebViewEventCategory.CACHE;
                CacheEvent cacheEvent10 = CacheEvent.DOWNLOAD_ERROR;
                Object[] objArr10 = new Object[i5];
                objArr10[r62] = CacheError.FILE_IO_ERROR;
                objArr10[c] = str;
                objArr10[c2] = e.getMessage();
                currentApp11.sendEvent(webViewEventCategory10, cacheEvent10, objArr10);
                this._currentRequest = webRequest;
                if (fileOutputStream2 != null) {
                    try {
                        fileOutputStream2.close();
                    } catch (Exception e17) {
                        DeviceLog.exception("Error closing stream", e17);
                        ?? currentApp12 = WebViewApp.getCurrentApp();
                        WebViewEventCategory webViewEventCategory11 = WebViewEventCategory.CACHE;
                        CacheEvent cacheEvent11 = CacheEvent.DOWNLOAD_ERROR;
                        Object[] objArr11 = new Object[i5];
                        objArr11[r62] = CacheError.FILE_IO_ERROR;
                        objArr11[c] = str;
                        objArr11[c2] = currentApp12.getMessage();
                        currentApp12.sendEvent(webViewEventCategory11, cacheEvent11, objArr11);
                    }
                }
            } catch (Throwable th4) {
                th = th4;
                webRequest7 = null;
                i11 = 3;
                c4 = 0;
                th = th;
                fileOutputStream2 = fileOutputStream;
                webRequest6 = webRequest7;
                i10 = i11;
                c3 = c4;
                this._currentRequest = webRequest6;
                if (fileOutputStream2 != null) {
                }
                throw th;
            }
        } catch (NetworkIOException e18) {
            e = e18;
            webRequest5 = null;
            i9 = 3;
            r66 = 0;
            c = 1;
            c2 = 2;
        } catch (FileNotFoundException e19) {
            e = e19;
            webRequest4 = null;
            i8 = 3;
            r65 = 0;
            c = 1;
            c2 = 2;
        } catch (IllegalStateException e20) {
            e = e20;
            webRequest3 = null;
            i7 = 3;
            r64 = 0;
            c = 1;
            c2 = 2;
        } catch (MalformedURLException e21) {
            e = e21;
            webRequest2 = null;
            i6 = 3;
            r63 = 0;
            c = 1;
            c2 = 2;
        } catch (IOException e22) {
            e = e22;
            webRequest = null;
            i5 = 3;
            r62 = 0;
            c = 1;
            c2 = 2;
        } catch (Throwable th5) {
            th = th5;
            r1 = 0;
            i4 = 3;
            r6 = 0;
            c = 1;
            c2 = 2;
            th = th;
            webRequest6 = r1;
            i10 = i4;
            c3 = r6;
            this._currentRequest = webRequest6;
            if (fileOutputStream2 != null) {
            }
            throw th;
        }
    }

    private WebRequest getWebRequest(String str, int i, int i2, HashMap hashMap) {
        HashMap hashMap2 = new HashMap();
        if (hashMap != null) {
            hashMap2.putAll(hashMap);
        }
        return new WebRequest(str, ShareTarget.METHOD_GET, hashMap2, i, i2);
    }

    private void postProcessDownload(long j, String str, File file, long j2, long j3, boolean z, int i, Map map) {
        long elapsedRealtime = SystemClock.elapsedRealtime() - j;
        if (!file.setReadable(true, false)) {
            DeviceLog.debug("Unity Ads cache: could not set file readable!");
        }
        if (z) {
            DeviceLog.debug("Unity Ads cache: downloading of " + str + " stopped");
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.CACHE, CacheEvent.DOWNLOAD_STOPPED, str, Long.valueOf(j2), Long.valueOf(j3), Long.valueOf(elapsedRealtime), Integer.valueOf(i), Request.getResponseHeadersMap(map));
            return;
        }
        DeviceLog.debug("Unity Ads cache: File " + file.getName() + " of " + j2 + " bytes downloaded in " + elapsedRealtime + "ms");
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.CACHE, CacheEvent.DOWNLOAD_END, str, Long.valueOf(j2), Long.valueOf(j3), Long.valueOf(elapsedRealtime), Integer.valueOf(i), Request.getResponseHeadersMap(map));
    }

    @Override // android.os.Handler
    public void handleMessage(Message message) {
        HashMap hashMap;
        Bundle data = message.getData();
        String string = data.getString("source");
        data.remove("source");
        String string2 = data.getString("target");
        data.remove("target");
        int i = data.getInt("connectTimeout");
        data.remove("connectTimeout");
        int i2 = data.getInt("readTimeout");
        data.remove("readTimeout");
        int i3 = data.getInt("progressInterval");
        data.remove("progressInterval");
        boolean z = data.getBoolean("append", false);
        data.remove("append");
        if (data.size() > 0) {
            DeviceLog.debug("There are headers left in data, reading them");
            HashMap hashMap2 = new HashMap();
            for (String str : data.keySet()) {
                hashMap2.put(str, Arrays.asList(data.getStringArray(str)));
            }
            hashMap = hashMap2;
        } else {
            hashMap = null;
        }
        File file = new File(string2);
        if ((z && !file.exists()) || (!z && file.exists())) {
            this._active = false;
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.CACHE, CacheEvent.DOWNLOAD_ERROR, CacheError.FILE_STATE_WRONG, string, string2, Boolean.valueOf(z), Boolean.valueOf(file.exists()));
        } else if (message.what == 1) {
            downloadFile(string, string2, i, i2, i3, hashMap, z);
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public void setCancelStatus(boolean z) {
        WebRequest webRequest;
        this._canceled = z;
        if (!z || (webRequest = this._currentRequest) == null) {
            return;
        }
        this._active = false;
        webRequest.cancel();
    }
}
