package com.onevcat.uniwebview;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.DialogInterface;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.webkit.CookieManager;
import android.webkit.MimeTypeMap;
import android.webkit.URLUtil;
import android.widget.EditText;
import android.widget.Toast;
import com.unity3d.splash.BuildConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
/* loaded from: classes.dex */
public final class W {
    public final Activity a;
    public final String b;
    public final c2 c;
    public final Function0 d;
    public boolean e;
    public final HashMap f;
    public final V g;

    public W(Activity activity, String name, c2 messageSender, C0069t customizeHeaders) {
        Intrinsics.checkNotNullParameter(activity, "activity");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(messageSender, "messageSender");
        Intrinsics.checkNotNullParameter(customizeHeaders, "customizeHeaders");
        this.a = activity;
        this.b = name;
        this.c = messageSender;
        this.d = customizeHeaders;
        this.e = true;
        this.f = new HashMap();
        this.g = new V(this);
    }

    public final void a(String url, String str, String str2, boolean z) {
        String str3;
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(url, "url");
        C0030g c0030g = null;
        if (StringsKt.startsWith$default(url, "data:", false, 2, (Object) null)) {
            try {
                C0048m a = U.a(url);
                if (a != null) {
                    C0033h c0033h = new C0033h(url, a.b);
                    if (str2 == null && (str2 = a.a) == null) {
                        str2 = BuildConfig.FLAVOR;
                    }
                    String extensionFromMimeType = MimeTypeMap.getSingleton().getExtensionFromMimeType(str2);
                    if (extensionFromMimeType == null) {
                        str3 = AbstractC0057p.a(StringCompanionObject.INSTANCE);
                    } else {
                        str3 = AbstractC0057p.a(StringCompanionObject.INSTANCE) + '.' + extensionFromMimeType;
                    }
                    c0030g = new C0030g(c0033h, str3, z);
                }
            } catch (Exception e) {
                C0045l c0045l = C0045l.b;
                String message = "Failed to parse data url: " + url + ". Error: " + e;
                c0045l.getClass();
                Intrinsics.checkNotNullParameter(message, "message");
                c0045l.a(EnumC0042k.CRITICAL, message);
            }
        } else if (URLUtil.isValidUrl(url)) {
            String fileName = URLUtil.guessFileName(url, str, str2);
            C0036i c0036i = new C0036i(url);
            Intrinsics.checkNotNullExpressionValue(fileName, "fileName");
            c0030g = new C0030g(c0036i, fileName, z);
        }
        if (c0030g != null) {
            a(c0030g);
            return;
        }
        Activity activity = this.a;
        Toast.makeText(activity, activity.getResources().getString(R.string.INVALID_URL), 1).show();
    }

    public final void b(C0030g c0030g) {
        AbstractC0039j abstractC0039j = c0030g.a;
        if (abstractC0039j instanceof C0036i) {
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse(c0030g.a()));
            request.allowScanningByMediaScanner();
            request.setNotificationVisibility(1);
            request.setDescription(c0030g.b);
            request.setTitle(c0030g.b);
            request.setDestinationInExternalFilesDir(this.a, Environment.DIRECTORY_DOWNLOADS, c0030g.b);
            request.addRequestHeader("Cookie", CookieManager.getInstance().getCookie(c0030g.a()));
            for (Map.Entry entry : ((Map) this.d.invoke()).entrySet()) {
                request.addRequestHeader((String) entry.getKey(), (String) entry.getValue());
            }
            Object systemService = this.a.getSystemService("download");
            if (systemService instanceof DownloadManager) {
                this.f.put(Long.valueOf(((DownloadManager) systemService).enqueue(request)), c0030g);
                Activity activity = this.a;
                Toast.makeText(activity, activity.getResources().getString(R.string.DOWNLOAD_STARTED), 1).show();
                if (c0030g.c) {
                    this.c.a(this.b, d2.FileDownloadStarted, new Y1(c0030g.a(), "0", c0030g.b, null));
                }
            }
        } else if (abstractC0039j instanceof C0033h) {
            C0033h c0033h = (C0033h) abstractC0039j;
            String a = c0030g.a();
            if (c0030g.c) {
                this.c.a(this.b, d2.FileDownloadStarted, new Y1(a, "0", c0030g.b, null));
            }
            try {
                File file = new File(this.a.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS), c0030g.b);
                FilesKt.writeBytes(file, c0033h.b);
                if (c0030g.c) {
                    String absolutePath = file.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue(absolutePath, "file.absolutePath");
                    this.c.a(this.b, d2.FileDownloadFinished, new Y1(a, "0", absolutePath, null));
                }
            } catch (Exception e) {
                C0045l c0045l = C0045l.b;
                String message = "Failed to download base64 data: " + a + ". Error: " + e;
                c0045l.getClass();
                Intrinsics.checkNotNullParameter(message, "message");
                c0045l.a(EnumC0042k.CRITICAL, message);
            }
        }
    }

    public final void a() {
        if (Build.VERSION.SDK_INT >= 33) {
            this.a.registerReceiver(this.g, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"), 2);
        } else {
            this.a.registerReceiver(this.g, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
        }
    }

    public final void a(final C0030g c0030g) {
        if (!this.e) {
            b(c0030g);
            return;
        }
        final EditText editText = new EditText(this.a);
        editText.setSingleLine();
        editText.setText(c0030g.b);
        AlertDialog.Builder cancelable = new AlertDialog.Builder(this.a).setTitle(c0030g.a()).setMessage(this.a.getResources().getString(R.string.DOWNLOAD_DESCRIPTION)).setIcon(17301659).setCancelable(true);
        Intrinsics.checkNotNullExpressionValue(cancelable, "Builder(activity)\n      …     .setCancelable(true)");
        AbstractC0012a.a(cancelable, editText).setPositiveButton(17039370, new DialogInterface.OnClickListener() { // from class: com.onevcat.uniwebview.-$$Lambda$Ou4U07V__20MOJIly3Pdi_sHSc0
            @Override // android.content.DialogInterface.OnClickListener
            public final void onClick(DialogInterface dialogInterface, int i) {
                W.a(editText, c0030g, this, dialogInterface, i);
            }
        }).setNegativeButton(17039360, $$Lambda$ddrYKJLOF6vQvBQGibCVv77__Wo.INSTANCE).create().show();
    }

    public static final void a(EditText input, C0030g task, W this$0, DialogInterface dialogInterface, int i) {
        Intrinsics.checkNotNullParameter(input, "$input");
        Intrinsics.checkNotNullParameter(task, "$task");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        String obj = input.getText().toString();
        dialogInterface.dismiss();
        task.getClass();
        Intrinsics.checkNotNullParameter(obj, "<set-?>");
        task.b = obj;
        this$0.b(task);
    }

    public static final void a(DialogInterface dialogInterface, int i) {
        dialogInterface.dismiss();
    }
}
