package com.onevcat.uniwebview;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Build;
import android.text.method.PasswordTransformationMethod;
import android.webkit.HttpAuthHandler;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebViewDatabase;
import android.widget.EditText;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import kotlin.jvm.internal.Intrinsics;
/* loaded from: classes.dex */
public final class J extends WebViewClient {
    public final Context a;
    public final V1 b;
    public boolean c;
    public boolean d;
    public boolean e;
    public int f;
    public final LinkedHashMap g;
    public final C0063r h;
    public final LinkedHashSet i;
    public boolean j;

    public J(Context context, InterfaceC0066s responderDelegate, V1 loadingObserver) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(responderDelegate, "responderDelegate");
        Intrinsics.checkNotNullParameter(loadingObserver, "loadingObserver");
        this.a = context;
        this.b = loadingObserver;
        this.d = true;
        this.f = 200;
        this.g = new LinkedHashMap();
        this.h = new C0063r(context, responderDelegate);
        this.i = new LinkedHashSet();
        this.j = true;
    }

    public final void a(final WebView webView, final HttpAuthHandler httpAuthHandler, final String str, final String str2) {
        final EditText editText = new EditText(this.a);
        editText.setHint(this.a.getResources().getString(R.string.USERNAME));
        final EditText editText2 = new EditText(this.a);
        editText2.setHint(this.a.getResources().getString(R.string.PASSWORD));
        editText2.setTransformationMethod(PasswordTransformationMethod.getInstance());
        AlertDialog.Builder message = new AlertDialog.Builder(this.a).setTitle(this.a.getResources().getString(R.string.AUTH_REQUIRE_TITLE)).setMessage(str);
        Intrinsics.checkNotNullExpressionValue(message, "Builder(context)\n       …        .setMessage(host)");
        AbstractC0012a.a(message, editText, editText2).setCancelable(false).setPositiveButton(this.a.getString(17039370), new DialogInterface.OnClickListener() { // from class: com.onevcat.uniwebview.-$$Lambda$bcnYs-gc8LpZG9lkNGWM63haQHY
            @Override // android.content.DialogInterface.OnClickListener
            public final void onClick(DialogInterface dialogInterface, int i) {
                J.a(editText, editText2, this, str, str2, webView, httpAuthHandler, dialogInterface, i);
            }
        }).setNegativeButton(this.a.getString(17039360), new DialogInterface.OnClickListener() { // from class: com.onevcat.uniwebview.-$$Lambda$eiJJ2nquwti9OFpApNfZCLPyFa8
            @Override // android.content.DialogInterface.OnClickListener
            public final void onClick(DialogInterface dialogInterface, int i) {
                J.a(httpAuthHandler, dialogInterface, i);
            }
        }).create().show();
    }

    @Override // android.webkit.WebViewClient
    public final void onPageFinished(WebView webView, String str) {
        super.onPageFinished(webView, str);
        if (this.d) {
            if (this.e) {
                C0045l c0045l = C0045l.b;
                String message = "WebClient onReceivedError for url: " + str + ", Error Code: -1202, Error: SSL error";
                c0045l.getClass();
                Intrinsics.checkNotNullParameter(message, "message");
                c0045l.a(EnumC0042k.CRITICAL, message);
                this.b.a(X1.a(str, -1202, "SSL error"));
            } else if (this.c) {
                C0045l c0045l2 = C0045l.b;
                String message2 = "WebClient onReceivedError for url: " + str + ", Error Code: -999, Error: Operation cancelled";
                c0045l2.getClass();
                Intrinsics.checkNotNullParameter(message2, "message");
                c0045l2.a(EnumC0042k.INFO, message2);
                this.b.a(X1.a(str, -999, "Operation cancelled"));
            } else {
                C0045l c0045l3 = C0045l.b;
                String message3 = "WebClient onPageFinished: " + str + ", HTTP Status Code: " + this.f;
                c0045l3.getClass();
                Intrinsics.checkNotNullParameter(message3, "message");
                c0045l3.a(EnumC0042k.INFO, message3);
                this.b.a(str, this.f);
            }
        }
    }

    @Override // android.webkit.WebViewClient
    public final void onPageStarted(WebView webView, String str, Bitmap bitmap) {
        super.onPageStarted(webView, str, bitmap);
        C0045l c0045l = C0045l.b;
        c0045l.a(EnumC0042k.INFO, AbstractC0060q.a("WebClient onPageStarted: ", str, c0045l, "message"));
        this.b.a(str);
    }

    @Override // android.webkit.WebViewClient
    public final void onReceivedError(WebView webView, int i, String str, String str2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return;
        }
        super.onReceivedError(webView, i, str, str2);
        C0045l c0045l = C0045l.b;
        String message = "WebClient onReceivedError. URL: " + str2 + "; Error Code: " + i;
        c0045l.getClass();
        Intrinsics.checkNotNullParameter(message, "message");
        c0045l.a(EnumC0042k.INFO, message);
        this.d = false;
        this.b.a(X1.a(str2, i, str));
    }

    /* JADX WARN: Removed duplicated region for block: B:21:0x003b  */
    /* JADX WARN: Removed duplicated region for block: B:22:0x003f  */
    @Override // android.webkit.WebViewClient
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public final void onReceivedHttpAuthRequest(WebView webView, HttpAuthHandler httpAuthHandler, String str, String str2) {
        String str3;
        if (httpAuthHandler == null) {
            return;
        }
        String str4 = null;
        if (httpAuthHandler.useHttpAuthUsernamePassword() && webView != null) {
            String[] httpAuthUsernamePassword = Build.VERSION.SDK_INT >= 26 ? WebViewDatabase.getInstance(this.a).getHttpAuthUsernamePassword(str, str2) : webView.getHttpAuthUsernamePassword(str, str2);
            if (httpAuthUsernamePassword != null && httpAuthUsernamePassword.length == 2) {
                str4 = httpAuthUsernamePassword[0];
                str3 = httpAuthUsernamePassword[1];
                if (str4 == null && str3 != null) {
                    httpAuthHandler.proceed(str4, str3);
                    return;
                } else if (this.j) {
                    httpAuthHandler.cancel();
                    return;
                } else {
                    a(webView, httpAuthHandler, str, str2);
                    return;
                }
            }
        }
        str3 = null;
        if (str4 == null) {
        }
        if (this.j) {
        }
    }

    @Override // android.webkit.WebViewClient
    public final void onReceivedHttpError(WebView webView, WebResourceRequest webResourceRequest, WebResourceResponse webResourceResponse) {
        super.onReceivedHttpError(webView, webResourceRequest, webResourceResponse);
        C0045l c0045l = C0045l.b;
        C0045l c0045l2 = C0045l.b;
        StringBuilder sb = new StringBuilder("WebClient onReceivedHttpError. Error Code: ");
        sb.append(webResourceResponse != null ? Integer.valueOf(webResourceResponse.getStatusCode()) : null);
        sb.append(", url: ");
        sb.append(webResourceRequest);
        sb.append("?.url");
        String message = sb.toString();
        c0045l2.getClass();
        Intrinsics.checkNotNullParameter(message, "message");
        c0045l2.a(EnumC0042k.INFO, message);
        if (webResourceResponse == null || webResourceRequest == null || !webResourceRequest.isForMainFrame()) {
            return;
        }
        this.f = webResourceResponse.getStatusCode();
    }

    @Override // android.webkit.WebViewClient
    public final void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
        C0045l c0045l = C0045l.b;
        StringBuilder sb = new StringBuilder("WebClient onReceivedSslError. Error url: ");
        sb.append(sslError != null ? sslError.getUrl() : null);
        sb.append(", Error type: ");
        sb.append(sslError != null ? Integer.valueOf(sslError.getPrimaryError()) : null);
        String message = sb.toString();
        c0045l.getClass();
        Intrinsics.checkNotNullParameter(message, "message");
        EnumC0042k enumC0042k = EnumC0042k.CRITICAL;
        c0045l.a(enumC0042k, message);
        if (sslError == null) {
            Intrinsics.checkNotNullParameter("Receiving SSL error callback with `null` error. This should not happen.", "message");
            c0045l.a(enumC0042k, "Receiving SSL error callback with `null` error. This should not happen.");
            this.e = true;
            if (sslErrorHandler != null) {
                sslErrorHandler.cancel();
                return;
            }
            return;
        }
        Intrinsics.checkNotNullParameter("Trying to process SSL error...", "message");
        EnumC0042k enumC0042k2 = EnumC0042k.VERBOSE;
        c0045l.a(enumC0042k2, "Trying to process SSL error...");
        try {
            String host = new URI(sslError.getUrl()).getHost();
            SslCertificate certificate = sslError.getCertificate();
            if (certificate.getIssuedBy() != null && certificate.getIssuedTo() != null) {
                if (!this.i.contains(host)) {
                    String message2 = "Domain '" + host + "' is not in exception list. Refuse proceeding url.";
                    Intrinsics.checkNotNullParameter(message2, "message");
                    c0045l.a(enumC0042k2, message2);
                    this.e = true;
                    if (sslErrorHandler != null) {
                        sslErrorHandler.cancel();
                        return;
                    }
                    return;
                }
                String message3 = "Found domain '" + host + "' in exception list. Processing url.";
                Intrinsics.checkNotNullParameter(message3, "message");
                c0045l.a(enumC0042k2, message3);
                if (sslErrorHandler != null) {
                    sslErrorHandler.proceed();
                    return;
                }
                return;
            }
            Intrinsics.checkNotNullParameter("Cannot get correct certificate issuer. SSL challenge failed.", "message");
            c0045l.a(enumC0042k2, "Cannot get correct certificate issuer. SSL challenge failed.");
            this.e = true;
            if (sslErrorHandler != null) {
                sslErrorHandler.cancel();
            }
        } catch (Exception e) {
            C0045l c0045l2 = C0045l.b;
            String message4 = "Exception during handling SSL error: " + e;
            c0045l2.getClass();
            Intrinsics.checkNotNullParameter(message4, "message");
            c0045l2.a(EnumC0042k.CRITICAL, message4);
            if (sslErrorHandler != null) {
                sslErrorHandler.cancel();
            }
        }
    }

    @Override // android.webkit.WebViewClient
    public final boolean onRenderProcessGone(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
        C0045l c0045l;
        String message;
        if (renderProcessGoneDetail == null) {
            c0045l = C0045l.b;
            message = "onRenderProcessGone is triggered. Detail: null";
        } else if (Build.VERSION.SDK_INT >= 26) {
            c0045l = C0045l.b;
            message = "onRenderProcessGone is triggered. didCrash: " + renderProcessGoneDetail.didCrash() + ", priority: " + renderProcessGoneDetail.rendererPriorityAtExit();
        } else {
            c0045l = C0045l.b;
            message = "onRenderProcessGone is triggered.";
        }
        c0045l.getClass();
        Intrinsics.checkNotNullParameter(message, "message");
        c0045l.a(EnumC0042k.CRITICAL, message);
        this.b.a();
        return true;
    }

    @Override // android.webkit.WebViewClient
    public final boolean shouldOverrideUrlLoading(WebView webView, String str) {
        if (str == null) {
            return false;
        }
        if (this.h.a(str, false, webView instanceof C0078w ? ((C0078w) webView).getName() : null)) {
            return true;
        }
        this.f = 200;
        this.d = true;
        this.c = false;
        this.e = false;
        if (!this.g.isEmpty()) {
            C0045l c0045l = C0045l.b;
            String message = "Adding customize header to request. " + this.g;
            c0045l.getClass();
            Intrinsics.checkNotNullParameter(message, "message");
            c0045l.a(EnumC0042k.DEBUG, message);
            if (webView != null) {
                webView.loadUrl(str, this.g);
            }
            return true;
        }
        return false;
    }

    public static final void a(EditText userText, EditText passwordText, J this$0, String str, String str2, WebView webView, HttpAuthHandler handler, DialogInterface dialogInterface, int i) {
        Intrinsics.checkNotNullParameter(userText, "$userText");
        Intrinsics.checkNotNullParameter(passwordText, "$passwordText");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(handler, "$handler");
        String obj = userText.getText().toString();
        String obj2 = passwordText.getText().toString();
        if (Build.VERSION.SDK_INT >= 26) {
            WebViewDatabase.getInstance(this$0.a).setHttpAuthUsernamePassword(str, str2, obj, obj2);
        } else if (webView != null) {
            webView.setHttpAuthUsernamePassword(str, str2, obj, obj2);
        }
        handler.proceed(obj, obj2);
    }

    public static final void a(HttpAuthHandler handler, DialogInterface dialogInterface, int i) {
        Intrinsics.checkNotNullParameter(handler, "$handler");
        handler.cancel();
    }

    @Override // android.webkit.WebViewClient
    public final void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        super.onReceivedError(webView, webResourceRequest, webResourceError);
        C0045l c0045l = C0045l.b;
        String message = "WebClient onReceivedError. Request: " + webResourceRequest + "; Error: " + webResourceError;
        c0045l.getClass();
        Intrinsics.checkNotNullParameter(message, "message");
        EnumC0042k enumC0042k = EnumC0042k.INFO;
        c0045l.a(enumC0042k, message);
        if (webResourceRequest != null) {
            String message2 = "WebClient request detail: " + webResourceRequest.getUrl();
            Intrinsics.checkNotNullParameter(message2, "message");
            c0045l.a(enumC0042k, message2);
        }
        if (webResourceError != null) {
            String message3 = "WebClient error detail: " + ((Object) webResourceError.getDescription());
            Intrinsics.checkNotNullParameter(message3, "message");
            c0045l.a(enumC0042k, message3);
        }
        if (webResourceError == null || webResourceRequest == null || !webResourceRequest.isForMainFrame()) {
            return;
        }
        this.d = false;
        this.b.a(X1.a(webResourceRequest.getUrl().toString(), webResourceError.getErrorCode(), webResourceError.getDescription().toString()));
    }
}
