package com.onevcat.uniwebview;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import com.unity3d.splash.BuildConfig;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
/* renamed from: com.onevcat.uniwebview.r  reason: case insensitive filesystem */
/* loaded from: classes.dex */
public final class C0063r {
    public final Context a;
    public final InterfaceC0066s b;
    public final C0045l c;
    public final Set d;
    public boolean e;

    public C0063r(Context context, InterfaceC0066s delegate) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        this.a = context;
        this.b = delegate;
        C0045l c0045l = C0045l.b;
        this.c = C0045l.b;
        this.d = SetsKt.mutableSetOf("uniwebview");
    }

    public final boolean a(String str, boolean z) {
        if (str == null || z || !this.e || ((C0078w) this.b).getHitTestResult().getType() == 0) {
            return false;
        }
        C0045l c0045l = this.c;
        c0045l.getClass();
        Intrinsics.checkNotNullParameter("UniWebView is opening links in external browser.", "message");
        c0045l.a(EnumC0042k.DEBUG, "UniWebView is opening links in external browser.");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse(str));
        a(intent);
        return true;
    }

    /* JADX WARN: Removed duplicated region for block: B:72:0x024d  */
    /* JADX WARN: Removed duplicated region for block: B:84:0x0293  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public final boolean a(String url, boolean z, String str) {
        Intent intent;
        Intent intent2;
        Intent intent3;
        Intent intent4;
        Intent intent5;
        Intrinsics.checkNotNullParameter(url, "url");
        if (str != null) {
            U1 u1 = UniWebViewInterface.Companion;
            C c = new C(str, url);
            u1.getClass();
            E a = U1.a(c);
            if (a != null) {
                try {
                    if (!a.b.getBoolean("result")) {
                        return true;
                    }
                } catch (Exception e) {
                    C0045l c0045l = C0045l.b;
                    String message = "Exception during parsing result for `ShouldUniWebViewHandleRequest`: " + e + ". Result from managed code: " + a.a;
                    c0045l.getClass();
                    Intrinsics.checkNotNullParameter(message, "message");
                    c0045l.a(EnumC0042k.CRITICAL, message);
                }
            }
        }
        Locale ROOT = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(ROOT, "ROOT");
        String url2 = url.toLowerCase(ROOT);
        Intrinsics.checkNotNullExpressionValue(url2, "this as java.lang.String).toLowerCase(locale)");
        Intent intent6 = null;
        if (StringsKt.startsWith$default(url2, "file:", false, 2, (Object) null)) {
            C0078w c0078w = (C0078w) this.b;
            if (c0078w.getSettings().getAllowFileAccess()) {
                C0045l c0045l2 = C0045l.b;
                c0045l2.getClass();
                Intrinsics.checkNotNullParameter("Loading a local file. The local file loading will never be overridden.", "message");
                c0045l2.a(EnumC0042k.DEBUG, "Loading a local file. The local file loading will never be overridden.");
                return false;
            }
            C0045l c0045l3 = C0045l.b;
            c0045l3.getClass();
            Intrinsics.checkNotNullParameter("Local file loading is disabled. To enable loading from a `file://` URL, call `SetAllowFileAccess` with true.", "message");
            c0045l3.a(EnumC0042k.INFO, "Local file loading is disabled. To enable loading from a `file://` URL, call `SetAllowFileAccess` with true.");
            c0078w.c.a(c0078w.b, d2.PageErrorReceived, new Y1(BuildConfig.FLAVOR, "-1", "Local file loading is disabled.", null));
            return true;
        } else if (StringsKt.startsWith$default(url2, "uniwebviewinternal://", false, 2, (Object) null)) {
            if (StringsKt.contains$default((CharSequence) url2, (CharSequence) "__uniwebview_internal_video_end", false, 2, (Object) null)) {
                ((C0078w) this.b).d.onHideCustomView();
            }
            C0045l c0045l4 = this.c;
            c0045l4.getClass();
            Intrinsics.checkNotNullParameter("Url handled internally in UniWebView", "message");
            c0045l4.a(EnumC0042k.DEBUG, "Url handled internally in UniWebView");
            return true;
        } else {
            Intrinsics.checkNotNullParameter(url2, "url");
            C0045l c0045l5 = this.c;
            c0045l5.a(EnumC0042k.VERBOSE, AbstractC0060q.a("Checking url could match with a defined url scheme: ", url2, c0045l5, "message"));
            Set set = this.d;
            if (!(set instanceof Collection) || !set.isEmpty()) {
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    if (StringsKt.startsWith$default(url2, ((String) it.next()) + "://", false, 2, (Object) null)) {
                        C0045l c0045l6 = this.c;
                        c0045l6.a(EnumC0042k.VERBOSE, AbstractC0060q.a("Found url matching scheme: ", url2, c0045l6, "message"));
                        C0045l c0045l7 = this.c;
                        String message2 = "Url handled by defined scheme. Redirected to Unity. ".concat(url);
                        c0045l7.getClass();
                        Intrinsics.checkNotNullParameter(message2, "message");
                        c0045l7.a(EnumC0042k.DEBUG, message2);
                        C0078w c0078w2 = (C0078w) this.b;
                        c0078w2.getClass();
                        Intrinsics.checkNotNullParameter(url, "url");
                        c0078w2.c.a(c0078w2.b, d2.MessageReceived, url);
                        return true;
                    }
                }
            }
            C0045l c0045l8 = this.c;
            c0045l8.a(EnumC0042k.VERBOSE, AbstractC0060q.a("Did not find a matched scheme for: ", url2, c0045l8, "message"));
            if (StringsKt.startsWith$default(url2, "sms:", false, 2, (Object) null)) {
                C0045l c0045l9 = this.c;
                c0045l9.getClass();
                Intrinsics.checkNotNullParameter("Received sms url...", "message");
                c0045l9.a(EnumC0042k.DEBUG, "Received sms url...");
                intent = new Intent("android.intent.action.VIEW", Uri.parse(url));
                intent.addCategory("android.intent.category.DEFAULT");
                intent.addCategory("android.intent.category.BROWSABLE");
            } else {
                intent = null;
            }
            if (!a(intent)) {
                if (StringsKt.startsWith$default(url2, "tel:", false, 2, (Object) null)) {
                    C0045l c0045l10 = this.c;
                    c0045l10.getClass();
                    Intrinsics.checkNotNullParameter("Received tel url...", "message");
                    c0045l10.a(EnumC0042k.DEBUG, "Received tel url...");
                    intent2 = new Intent("android.intent.action.DIAL", Uri.parse(url));
                } else {
                    intent2 = null;
                }
                if (!a(intent2)) {
                    if (StringsKt.startsWith$default(url2, "mailto:", false, 2, (Object) null)) {
                        C0045l c0045l11 = this.c;
                        c0045l11.getClass();
                        Intrinsics.checkNotNullParameter("Received mailto url...", "message");
                        c0045l11.a(EnumC0042k.DEBUG, "Received mailto url...");
                        intent3 = new Intent("android.intent.action.SENDTO", Uri.parse(url));
                    } else {
                        intent3 = null;
                    }
                    if (!a(intent3)) {
                        if (StringsKt.startsWith$default(url2, "intent:", false, 2, (Object) null)) {
                            C0045l c0045l12 = this.c;
                            c0045l12.getClass();
                            Intrinsics.checkNotNullParameter("Received intent url...", "message");
                            c0045l12.a(EnumC0042k.DEBUG, "Received intent url...");
                            try {
                                intent4 = Intent.parseUri(url, 1);
                                if (this.a.getPackageManager().resolveActivity(intent4, 65536) == null) {
                                    String str2 = intent4.getPackage();
                                    if (str2 != null) {
                                        Intent intent7 = new Intent("android.intent.action.VIEW");
                                        intent7.setData(Uri.parse("market://details?id=".concat(str2)));
                                        intent4 = intent7;
                                    }
                                }
                            } catch (Exception e2) {
                                C0045l c0045l13 = this.c;
                                String message3 = "Parsing intent url error: " + e2 + ".message";
                                c0045l13.getClass();
                                Intrinsics.checkNotNullParameter(message3, "message");
                                c0045l13.a(EnumC0042k.CRITICAL, message3);
                            }
                            if (!a(intent4)) {
                                if (StringsKt.startsWith$default(url2, "market:", false, 2, (Object) null)) {
                                    C0045l c0045l14 = this.c;
                                    c0045l14.getClass();
                                    Intrinsics.checkNotNullParameter("Received market url...", "message");
                                    c0045l14.a(EnumC0042k.DEBUG, "Received market url...");
                                    try {
                                        intent5 = Intent.parseUri(url, 1);
                                    } catch (Exception e3) {
                                        C0045l c0045l15 = this.c;
                                        String message4 = "Parsing market url error. " + e3.getMessage();
                                        c0045l15.getClass();
                                        Intrinsics.checkNotNullParameter(message4, "message");
                                        c0045l15.a(EnumC0042k.CRITICAL, message4);
                                    }
                                    if (!a(intent5)) {
                                        if (a(url, z)) {
                                            return true;
                                        }
                                        List<String> listOf = CollectionsKt.listOf((Object[]) new String[]{"http:", "https:", "file:", "about:blank"});
                                        if (!(listOf instanceof Collection) || !listOf.isEmpty()) {
                                            for (String str3 : listOf) {
                                                if (StringsKt.startsWith$default(url2, str3, false, 2, (Object) null)) {
                                                    break;
                                                }
                                            }
                                        }
                                        Intent intent8 = new Intent("android.intent.action.VIEW", Uri.parse(url));
                                        List<ResolveInfo> queryIntentActivities = this.a.getPackageManager().queryIntentActivities(intent8, 0);
                                        Intrinsics.checkNotNullExpressionValue(queryIntentActivities, "context.packageManager.q…tentActivities(intent, 0)");
                                        if (!queryIntentActivities.isEmpty()) {
                                            intent6 = intent8;
                                        }
                                        if (a(intent6)) {
                                            C0045l c0045l16 = this.c;
                                            String message5 = "Url handled by a third party app: ".concat(url);
                                            c0045l16.getClass();
                                            Intrinsics.checkNotNullParameter(message5, "message");
                                            c0045l16.a(EnumC0042k.DEBUG, message5);
                                            return true;
                                        }
                                        C0045l c0045l17 = this.c;
                                        String message6 = "Url is opening without overridden: ".concat(url);
                                        c0045l17.getClass();
                                        Intrinsics.checkNotNullParameter(message6, "message");
                                        c0045l17.a(EnumC0042k.DEBUG, message6);
                                        return false;
                                    }
                                }
                                intent5 = null;
                                if (!a(intent5)) {
                                }
                            }
                        }
                        intent4 = null;
                        if (!a(intent4)) {
                        }
                    }
                }
            }
            C0045l c0045l18 = this.c;
            c0045l18.getClass();
            Intrinsics.checkNotNullParameter("Url handled by intent.", "message");
            c0045l18.a(EnumC0042k.DEBUG, "Url handled by intent.");
            return true;
        }
    }

    public final boolean a(Intent intent) {
        if (intent == null) {
            return false;
        }
        try {
            this.a.startActivity(intent);
            return true;
        } catch (Exception unused) {
            C0045l c0045l = this.c;
            String message = "No Activity found to handle Intent: " + intent.getData();
            c0045l.getClass();
            Intrinsics.checkNotNullParameter(message, "message");
            c0045l.a(EnumC0042k.CRITICAL, message);
            return false;
        }
    }
}
